/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.Random;
import java.util.TreeMap;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MBulletEnemy;
import metal.shared.MChromosoom;
import metal.shared.MDna;
import metal.shared.MMath;
import metal.shared.MPoint;
import robocode.HitByBulletEvent;

public class MChassisDna3 {
    static double FLATTENER_FACTOR;
    static final int MAX_FULL_LEAD_HITS = 1;
    static double MIN_DIST;
    public TreeMap bullets = new TreeMap();
    static int c;
    private static MPoint centre;
    static double dir;
    static MDna[] dnas;
    private static MPoint enemyPoint;
    private static double firePower;
    private static double fireTime;
    static boolean first;
    int fullLeadHits;
    static int i;
    static boolean isFlattening;
    private static MPoint nextPoint;
    static double planedDist;
    private static Random rand;
    static int speedCounter;
    static long timeSinceReverse;

    static {
        rand = new Random();
        centre = null;
        nextPoint = null;
        enemyPoint = null;
        firePower = 0.0;
        fireTime = 0.0;
        dnas = new MDna[30];
        i = 0;
        first = true;
        c = 0;
        speedCounter = 0;
        MIN_DIST = 60.0;
        timeSinceReverse = 0L;
        dir = 1.0;
        FLATTENER_FACTOR = 0.9;
        planedDist = 0.0;
    }

    public MChassisDna3() {
        MBotData.print("SYSTEM:  Chassis    ... OK");
        centre = new MPoint(MBotData.self.getBattleFieldWidth() / 2.0, MBotData.self.getBattleFieldHeight() / 2.0);
        if (first) {
            MChassisDna3.init();
            first = false;
        }
    }

    public static void go(MPoint toPoint) {
        double dist = MBotData.getLocation().distance(toPoint);
        double ang = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        if (MMath.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        MBotData.self.setTurnRight(ang + MMath.random(-1.0, 1.0));
        MBotData.self.setAhead(dist);
    }

    public static void go2(MPoint toPoint) {
        double angle = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        double turnAngle = MMath.atan(MMath.tan(angle));
        MBotData.self.setTurnRight(turnAngle);
        MBotData.self.setAhead(MBotData.getLocation().distance(toPoint) * (double)(angle == turnAngle ? 1 : -1));
        MBotData.self.setMaxVelocity(Math.abs(MBotData.self.getTurnRemaining()) > 30.0 ? 0.0 : 8.0);
    }

    private static void init() {
        int i = 0;
        while (i < dnas.length) {
            MChassisDna3.dnas[i] = new MDna();
            ++i;
        }
    }

    private static void initDNA() {
        int i = 0;
        while (i < dnas.length) {
            dnas[i].mergeDna(dnas[i].furtilize());
            ++i;
        }
    }

    private static void kiss() {
        MBotData.self.setMaxVelocity(8.0);
        MChassisDna3.go(MBotData.enemy);
    }

    public static void move() {
        ++timeSinceReverse;
        try {
            MChassisDna3.movement();
        }
        catch (Exception e) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED");
            e.printStackTrace();
        }
    }

    private static void movement() {
        double L = 0.0;
        double angle = 0.0;
        double distAngle = 0.0;
        double moveAngle = 0.0;
        double distance = MBotData.enemy.distance;
        boolean isCentered = false;
        boolean isVerticle = false;
        int index = 10;
        if (MMath.abs(MBotData.enemy.last.last.last.energyDiff - 1.55) < 1.46) {
            firePower = MBotData.enemy.last.last.last.energyDiff;
            fireTime = (1.0 + firePower / 5.0) / MBotData.self.getGunCoolingRate();
            fireTime = MBotData.enemy.last.last.time - 1.0 + fireTime;
            double coolTime = 0.0;
            int indexD = (int)MMath.clamp(100.0, 0.0, MBotData.enemy.last.last.last.distance / MBullet.getSpeed(firePower) / 5.0);
            index = (int)MMath.clamp(30.0, 0.0, indexD);
            double travelTimeAdjustment = 5.0 / (MBotData.enemy.distance / MBullet.getSpeed(firePower));
            if (Math.random() < 0.3 + travelTimeAdjustment) {
                coolTime = MBotData.self.getTime() + (long)((1.0 + firePower / 5.0) / MBotData.self.getGunCoolingRate()) - 1L;
            }
            if (!isFlattening || (double)MBotData.self.getTime() == coolTime - 7.0 && Math.random() < 0.3 + travelTimeAdjustment || (double)MBotData.self.getTime() == coolTime || Math.random() < (FLATTENER_FACTOR - travelTimeAdjustment) / (MBotData.enemy.distance / MBullet.getSpeed(firePower))) {
                // empty if block
            }
        }
        if (MMath.abs(MBotData.self.getDistanceRemaining()) < MIN_DIST || MMath.abs(MBotData.self.getDistanceRemaining()) > 250.0) {
            if (MMath.abs(MBotData.enemy.last.last.energyDiff - 1.55) < 1.46 || MBotData.enemy.distance < 200.0) {
                angle = MMath.abs((MBotData.enemy.bearing + 360.0) % 90.0);
                isCentered = MBotData.getLocation().distance(centre) < centre.distance(0.0, 0.0) / 2.0;
                isVerticle = angle < 22.5 || angle > 157.5 || isCentered;
                distAngle = 2.0 * Math.toDegrees(Math.asin(4.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                if (isVerticle) {
                    distAngle = Math.toDegrees(Math.asin(8.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                }
                MChromosoom crom = dnas[index].getFittest();
                MIN_DIST = 60.0;
                distAngle = MMath.atan(MMath.tan(distAngle) + (MIN_DIST / 2.0 - 4.0) / distance);
                if (distance < 200.0) {
                    // empty if block
                }
                distance += 30.0;
                do {
                    moveAngle += distAngle * crom.value * crom.dir * dir * 0.1;
                    L = distance;
                    if (isVerticle) {
                        L /= MMath.cos(moveAngle);
                    }
                    distance -= 10.0;
                    nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + moveAngle, -L);
                } while (MPoint.getWallDistance(nextPoint) < 30.0);
                planedDist = nextPoint.distance(MBotData.getLocation());
                if (++i == 0) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness - 1.0);
                } else if (i == -1) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness - 0.2);
                } else if (i == 1) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness - 0.5);
                } else if (i == -2) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness - 0.7);
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness - 0.5);
                } else if (i == 2) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness - 0.7);
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness - 0.5);
                } else if (i == -3) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna3.i)).append((String)"").toString()).fitness - 0.2);
                } else if (i == 3) {
                    MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna3.i).append((String)"").toString()).fitness - 0.1);
                }
                ++MChassisDna3.dnas[index].counter;
                ++c;
                timeSinceReverse = 0L;
            } else if (MBotData.self.getDistanceRemaining() == 0.0) {
                nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + Math.toDegrees(Math.random() * 0.04 - 0.02), -MBotData.enemy.distance);
                MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? 0.0 : 8.0);
                ++i;
            }
            if (nextPoint != null) {
                MChassisDna3.go(nextPoint);
            }
        }
        MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? 0.0 : 6.0 + Math.random() * 2.0);
        ++speedCounter;
    }

    public void update(HitByBulletEvent e) {
        if (!isFlattening && MBotData.enemy.distance > 200.0 && (double)(MBotData.self.getTime() - timeSinceReverse) > MBotData.enemy.distance / e.getVelocity()) {
            isFlattening = ++this.fullLeadHits >= 1;
        }
        try {
            MBulletEnemy b = (MBulletEnemy)MBotData.enemy.bullets.get((e.getVelocity() + "     ").substring(0, 5));
            double dist = b.getDistance();
            double bearing = -e.getBearing();
            int indexD = (int)MMath.clamp(100.0, 0.0, dist / e.getVelocity() / 5.0);
            int index = (int)MMath.clamp(30.0, 0.0, indexD);
            int i = (int)Math.rint(bearing / 40.0) % 4;
            double d = b.power = b.power < 1.0 ? 1.0 : b.power;
            if (i == 0) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 4.0 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).dir *= -1.0;
            } else if (i == -1) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).fitness - 1.5 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).dir *= -1.0;
            } else if (i == 1) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 1.4 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).dir *= -1.0;
            } else if (i == -2) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).fitness - 1.4 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).dir *= -1.0;
            } else if (i == 2) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 1.8 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).dir *= -1.0;
            } else if (i == -3) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).fitness - 1.3 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-i)).append((String)"").toString()).dir *= -1.0;
            } else if (i == 3) {
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 1.2 * b.power);
                MChassisDna3.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).dir *= -1.0;
            }
            dnas[index].mutate(i + "");
            dnas[index].mutate(-i + "");
            MBotData.enemy.bullets.remove(b.toString());
        }
        catch (Exception ex) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED TIME: " + MBotData.self.getTime());
            MBotData.err("SYSTEM:   Err: No bullets matched! " + ex.toString());
        }
    }
}

