/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Data;

import java.awt.Graphics2D;
import nosteel.Basics.Draw;
import nosteel.Basics.Vector;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ScanData {
    public Vector vMyPos;
    public long time;
    public double absBearing;
    public double distance;
    public double heading;
    public double velocity;
    public double energy;
    public Vector vDirToHim;
    public Vector vHisPos;
    public Vector vHisMovement;

    public ScanData(ScannedRobotEvent event, Vector myPos, double myHeadingRad, long time_) {
        this.vMyPos = myPos;
        this.time = time_;
        this.absBearing = Utils.normalAbsoluteAngle((double)(event.getBearingRadians() + myHeadingRad));
        this.distance = event.getDistance();
        this.heading = Utils.normalAbsoluteAngle((double)event.getHeadingRadians());
        this.velocity = event.getVelocity();
        this.energy = event.getEnergy();
        this.determineHisPosition();
        this.determineHisMovement();
    }

    private void determineHisPosition() {
        this.vDirToHim = new Vector();
        this.vDirToHim.y = Math.cos(this.absBearing) * this.distance;
        this.vDirToHim.x = Math.sin(this.absBearing) * this.distance;
        this.vHisPos = this.vMyPos.add(this.vDirToHim);
    }

    private void determineHisMovement() {
        this.vHisMovement = new Vector();
        this.vHisMovement.x = Math.sin(this.heading) * this.velocity;
        this.vHisMovement.y = Math.cos(this.heading) * this.velocity;
    }

    public void printScanData() {
        System.out.println(String.format("Scan Data at turn: %d", this.time));
        this.vMyPos.print("MyPos");
        System.out.println(String.format("absBearing: %.1f distance %.1f", this.absBearing, this.distance));
        System.out.println(String.format("heading: %.1f velocity %.1f", this.heading, this.velocity));
        System.out.println(String.format("energy: %.1f", this.energy));
        this.vDirToHim.print("DirToHim");
        this.vHisPos.print("HisPos");
        this.vHisMovement.print("HisMovement");
    }

    public void drawScan(Graphics2D g) {
        Draw.drawPoint(g, this.vHisPos, 4);
    }
}

