/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Stats;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import nosteel.Basics.Draw;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Stats.Statistic;

public class AnalyseMovementLinearity
extends Statistic {
    private List<Vector> linearMovement = new ArrayList<Vector>();
    private final int LINEAR_ERROR = 100;
    private double linearityRatio;

    public AnalyseMovementLinearity(DataList s, Aiming t) {
        super(s, t, AnalyseMovementLinearity.class.getName());
    }

    public double getLinearityRatio() {
        return this.linearityRatio;
    }

    private void checkLinearMovement(String target) {
        double bigWindows = 0.0;
        double smallWindows = 0.0;
        boolean detected = false;
        this.linearMovement.clear();
        ArrayList<Vector> window = new ArrayList<Vector>();
        ListIterator<ScanData> itData = this.scans.getEnemyData(target).getScanIterator(EnemyData.END_OF_LIST);
        block0: while (itData.hasPrevious()) {
            ScanData e = itData.previous();
            Vector v = new Vector(e.vHisPos.x, e.vHisPos.y);
            window.add(v);
            if (this.linearMovement.size() == 0) {
                this.linearMovement.add(v);
            }
            if (window.size() < 3) continue;
            double error = this.calcLinearRegression(window);
            if (error > 100.0) {
                this.linearMovement.add((Vector)window.get(0));
                if (window.size() < 4) {
                    smallWindows += 1.0;
                }
                detected = false;
                int max = window.size();
                for (int k = 0; k < max; ++k) {
                    window.remove(0);
                    error = this.calcLinearRegression(window);
                    if (error < 100.0 || Double.isNaN(error)) continue block0;
                }
                continue;
            }
            if (window.size() <= 4 || detected) continue;
            bigWindows += 1.0;
            detected = true;
        }
        this.linearMovement.add((Vector)window.get(0));
        this.linearMovement.add((Vector)window.get(window.size() - 1));
        this.linearityRatio = bigWindows / (bigWindows + smallWindows);
    }

    private double calcLinearRegression(List<Vector> data) {
        double firstX = data.get((int)0).x;
        boolean xChanges = false;
        return 0.0;
    }

    private double calcPolynominalRegression(int order, List<Vector> data) {
        return 0.0;
    }

    @Override
    public void analyse() {
        String target = this.aiming.getTargetName();
        if (target == null) {
            return;
        }
        if (this.scans.getEnemyData(target).getNumOfScans() <= 3) {
            return;
        }
        this.checkLinearMovement(target);
    }

    @Override
    public void draw(Graphics2D g) {
        Vector vOld = null;
        for (Vector v : this.linearMovement) {
            if (vOld != null) {
                Draw.drawLineBetweenVectors(g, vOld, v);
                Draw.drawPoint(g, vOld, 10);
            }
            vOld = v;
        }
        if (vOld != null) {
            Draw.drawPoint(g, vOld, 4);
        }
    }

    @Override
    public void print() {
    }
}

