/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.Opponent;
import pa3k.Position;
import pa3k.Range;
import pa3k.SelfTracking;
import pa3k.State;
import robocode.AdvancedRobot;

class Change {
    protected double lkh = 0.0;
    protected State newState;
    protected Range lastOpponentSpeedChange;
    protected Range lastOpponentHitDelay;
    protected Range lastEnergyDropDelay;
    protected Range lastEnergyDrop;
    protected boolean reverseDir;
    protected boolean facingWall;
    protected Range[] ranges;

    public Change(State state) {
        this.newState = state;
        this.reverseDir = false;
    }

    public boolean checkConsitency(State state) {
        int n = state.getSpeed();
        return this.newState.getSpeed() <= n + 1 && this.newState.getSpeed() >= n - 2;
    }

    public boolean isChangingDirection() {
        return this.reverseDir;
    }

    public Change(State state, boolean bl) {
        this.newState = state;
        this.reverseDir = bl;
    }

    public void increaseLikelihood() {
        this.lkh += 1.0;
    }

    public boolean isApplicable(long l, boolean bl, long l2, long l3, double d) {
        if (this.facingWall != bl) {
            return false;
        }
        return this.ranges[0].test(l);
    }

    public double getLikelihood() {
        return this.lkh;
    }

    public State getTargetState() {
        return this.newState;
    }

    public void setValues(AdvancedRobot advancedRobot, Opponent opponent, long l, SelfTracking selfTracking) {
        this.lastOpponentSpeedChange = new Range((double)opponent.getLastSpeedChange(l - 1L) - 0.5, 10000.0);
        this.lastEnergyDropDelay = new Range(selfTracking.lastEnergyDrop(l));
        this.facingWall = true;
        Position position = new Position(opponent.getLastPosition());
        position.modify(1L, 140.0, opponent.getLastHeading());
        if (position.isInBattlefield()) {
            this.facingWall = false;
        }
        this.lastOpponentHitDelay = new Range(0L);
        this.lastEnergyDrop = new Range(0L);
        this.ranges = new Range[1];
        this.ranges[0] = this.lastOpponentSpeedChange;
    }

    public boolean isSpecialCaseOf(Change change) {
        if (this.newState != change.newState) {
            return false;
        }
        if (this.reverseDir != change.reverseDir) {
            return false;
        }
        if (this.facingWall != change.facingWall) {
            return false;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i].isSpecialCaseOf(change.ranges[i])) continue;
            return false;
        }
        return true;
    }

    public double cmp(Change change) {
        if (this.newState != change.newState) {
            return 0.0;
        }
        if (this.reverseDir != change.reverseDir) {
            return 0.0;
        }
        if (this.facingWall != change.facingWall) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.ranges.length; ++i) {
            d += this.ranges[i].cmp(change.ranges[i]);
        }
        return d / (double)this.ranges.length;
    }

    public void generalizeWith(Change change) {
        this.lkh += change.lkh;
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].generalizeWith(change.ranges[i]);
        }
    }

    public String toString() {
        String string = "-> " + this.newState + (this.reverseDir ? " reverse dir " : "");
        for (int i = 0; i < this.ranges.length; ++i) {
            string = string + " " + this.ranges[i];
        }
        if (this.facingWall) {
            string = string + " FW";
        }
        return string + " (" + this.lkh + ")";
    }
}

