/*
 * Decompiled with CFR 0.152.
 */
package infovk.s_schwarzm16;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class silverbird
extends AdvancedRobot {
    double Heading_alt = 0.0;
    double Energy_alt = 100.0;
    double x = 0.0;
    double y = 0.0;
    double XZ = 100.0;
    double YZ = 100.0;
    double V_alt;
    boolean Hit = false;
    boolean EnemyEnergyLoss = false;
    boolean PatternKnown = false;
    public static LinkedList<Point2D> s = new LinkedList();
    Point2D Vel_u_headdiff = new Point2D.Double(10.0, 5.0);
    public static int BINS = 47;
    public static double[] _surfStats = new double[BINS];
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public ArrayList _enemyWaves;
    public ArrayList<Integer> _surfDirections;
    public ArrayList<Double> _surfAbsBearings;
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 160.0;

    public void run() {
        this.setBodyColor(Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.execute();
        while (true) {
            s.add(this.Vel_u_headdiff);
            if (s.size() > 500) {
                s.remove(0);
            }
            this.Hit = false;
            this.EnemyEnergyLoss = false;
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        int f_start;
        double angleToEnemy = this.getHeadingRadians() + event.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(36.0 / event.getDistance()), Rules.RADAR_TURN_RATE_RADIANS);
        this.setTurnRadarRightRadians(radarTurn += radarTurn < 0.0 ? -extraTurn : extraTurn);
        double Heading = event.getHeadingRadians();
        double XG = this.getX() + event.getDistance() * Math.sin(event.getBearingRadians() + this.getHeadingRadians());
        double YG = this.getY() + event.getDistance() * Math.cos(event.getBearingRadians() + this.getHeadingRadians());
        double X = this.getX();
        double Y = this.getY();
        double v = event.getVelocity();
        double FIREPOWER = 2.0;
        double Heading_diff = Heading - this.Heading_alt;
        double Heading_neu = Heading;
        double Heading_neu_p = Heading;
        int i = 0;
        FIREPOWER = event.getDistance() < 300.0 ? 3.0 : (event.getDistance() < 500.0 ? 2.0 : 1.0);
        if (this.getEnergy() <= 3.0) {
            FIREPOWER = 0.1;
        }
        this.PatternKnown = false;
        this.Vel_u_headdiff = new Point2D.Double(Heading_diff, this.V_alt);
        double PatternStart = 0.0;
        double smallest_diff = 100.0;
        for (int f = f_start = 0; f < s.size() - 7; ++f) {
            double ListDiff = 0.0;
            int g = f;
            int h = 0;
            while (g < f + 7) {
                double ListDiff_y;
                double ListDiff_x = Math.abs(s.get(s.size() - 7 + h).getX() * s.get(s.size() - 7 + h).getX() - Math.pow(s.get(g).getX(), 2.0));
                ListDiff = ListDiff_x + (ListDiff_y = Math.abs(Math.pow(s.get(s.size() - 7 + h).getY(), 2.0) - Math.pow(s.get(g).getY(), 2.0))) + ListDiff;
                if (ListDiff > 0.5) {
                    ListDiff = 100.0;
                    break;
                }
                ++g;
                ++h;
            }
            if (Math.abs(ListDiff) < smallest_diff) {
                PatternStart = f + 7;
                smallest_diff = ListDiff;
            }
            if (!(ListDiff <= 0.01)) continue;
            PatternStart = f + 7;
            smallest_diff = ListDiff;
            break;
        }
        if (smallest_diff < 2.0) {
            this.PatternKnown = true;
        }
        if (this.PatternKnown) {
            for (int j = (int)PatternStart; j <= s.size() - 5; ++j) {
                double dist = Math.hypot((XG += s.get(j).getY() * Math.sin(Heading_neu_p) * Math.cos(s.get(j).getX()) - s.get(j).getY() * Math.cos(Heading_neu_p) * Math.sin(s.get(j).getX())) - X, (YG += s.get(j).getY() * Math.sin(Heading_neu_p) * Math.sin(s.get(j).getX()) + s.get(j).getY() * Math.cos(Heading_neu_p) * Math.cos(s.get(j).getX())) - Y);
                if (Math.abs(dist) <= Rules.getBulletSpeed((double)FIREPOWER) * ((double)j - PatternStart) + 5.0) {
                    this.setFire(FIREPOWER);
                    break;
                }
                Heading_neu_p += s.get(j).getX();
            }
        } else {
            for (i = 0; i <= 100; ++i) {
                double dist = Math.hypot((XG += v * Math.sin(Heading_neu) * Math.cos(Heading_diff) - v * Math.cos(Heading_neu) * Math.sin(Heading_diff)) - X, (YG += v * Math.sin(Heading_neu) * Math.sin(Heading_diff) + v * Math.cos(Heading_neu) * Math.cos(Heading_diff)) - Y);
                if (Math.abs(dist) <= Rules.getBulletSpeed((double)FIREPOWER) * (double)i + 5.0) {
                    this.setFire(FIREPOWER);
                    break;
                }
                Heading_neu += Heading_diff;
            }
        }
        Heading_neu = Heading;
        this.x = XG;
        this.y = YG;
        double Winkel = Utils.normalAbsoluteAngle((double)Math.atan2(XG - X, YG - Y));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Winkel - this.getGunHeadingRadians())));
        this.Heading_alt = Heading;
        this.V_alt = v;
        double Energy = event.getEnergy();
        if (Energy < this.Energy_alt) {
            this.EnemyEnergyLoss = true;
        }
        this.Energy_alt = Energy;
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(event.getBearingRadians());
        double absBearing = event.getBearingRadians() + this.getHeadingRadians();
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - event.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = silverbird.bulletVelocity(bulletPower);
            ew.distanceTraveled = silverbird.bulletVelocity(bulletPower);
            ew.direction = this._surfDirections.get(2);
            ew.directAngle = this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = event.getEnergy();
        this._enemyLocation = silverbird.vectorVerschieben(this._myLocation, absBearing, event.getDistance());
        this.updateWaves();
        if (event.getDistance() > 150.0) {
            this.surfen();
        } else {
            silverbird.IntelligentesFahren(this, this.wallSmoothing(this._myLocation, silverbird.absoluteBearing(this._enemyLocation, this._myLocation) + 1.25, 1));
        }
    }

    public void onHitWall(HitWallEvent event) {
        this.setBack(200.0);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.Hit = true;
    }

    public void updateWaves() {
        for (int x = 0; x < this._enemyWaves.size(); ++x) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (!(ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0)) continue;
            this._enemyWaves.remove(x);
            --x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        for (int x = 0; x < this._enemyWaves.size(); ++x) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (!(distance > ew.bulletVelocity) || !(distance < closestDistance)) continue;
            surfWave = ew;
            closestDistance = distance;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = silverbird.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / silverbird.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)silverbird.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = silverbird.getFactorIndex(ew, targetLocation);
        for (int x = 0; x < BINS; ++x) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            for (int x = 0; x < this._enemyWaves.size(); ++x) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (!(Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0) || !(Math.abs(silverbird.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001)) continue;
                hitWave = ew;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, silverbird.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + silverbird.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = silverbird.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = silverbird.vectorVerschieben(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 250);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = silverbird.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void surfen() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = silverbird.absoluteBearing(surfWave.fireLocation, this._myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._myLocation, goAngle - 1.25, -1) : this.wallSmoothing(this._myLocation, goAngle + 1.25, 1);
        silverbird.IntelligentesFahren(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(silverbird.vectorVerschieben(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double vectorVerschieben(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void IntelligentesFahren(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        g.drawRect((int)this.x - 18, (int)this.y - 18, 36, 36);
        g.drawLine((int)this.x, (int)this.y, (int)this.getX(), (int)this.getY());
        g.setColor(Color.red);
        for (int i = 0; i < this._enemyWaves.size(); ++i) {
            EnemyWave w = (EnemyWave)this._enemyWaves.get(i);
            int radius = (int)w.distanceTraveled;
            Point2D.Double center = w.fireLocation;
            if (!((double)(radius - 40) < center.distance(this._myLocation))) continue;
            g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }
}

