/*
 * Decompiled with CFR 0.152.
 */
package jlm;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class javaDisturbance
extends AdvancedRobot {
    static final int memSize = 100;
    static final double PI = Math.PI;
    static final byte MAX_FACTOR_VISITS = 5;
    static double bulletMissed = 0.0;
    static double bulletHit = 0.0;
    static double bh;
    static Point2D.Double bfCenter;
    ArrayList tankList;
    Tanks myData0;
    Tanks myData1;
    Tanks myData2;
    Tanks newData;
    Tanks oldData;
    Tanks lookingFor;
    Tanks target;
    wholeTank wTarget;
    wholeTank oldDataWholeTank;
    double weaveDir;
    double movementDir;
    Point2D.Double simulatedLocation;
    double skippedTurns;
    double radarDirection;
    double firePower;
    byte lastBinHit;
    int binsVisited;
    boolean OnceThisTurn;
    double bw;
    public Rectangle2D.Double battleFieldRect;
    public Rectangle2D.Double battleFieldRect2;
    public boolean fileWrite;
    short binDisplay;
    Point2D.Double middleBinOnHit;
    Point2D.Double MPEP;
    Point2D.Double MNEP;
    double mVB;
    ArrayList bulletList;
    Bullets bulletData;

    public void run() {
        wholeTank wt;
        this.bw = this.getBattleFieldWidth();
        bh = this.getBattleFieldHeight();
        bfCenter = new Point2D.Double(this.bw / (double)2, bh / (double)2);
        this.battleFieldRect = new Rectangle2D.Double(24.0, 24.0, this.bw - 48.0, bh - 48.0);
        this.battleFieldRect2 = new Rectangle2D.Double(0.0, 0.0, this.bw, bh);
        this.setColors(Color.darkGray, Color.darkGray, Color.gray);
        this.tankList = new ArrayList();
        int i = 0;
        while (i < this.getOthers() + 1) {
            wt = new wholeTank();
            if (i == 0) {
                wt.name = this.getName();
            }
            wt.alive = true;
            wt.statBuffers = new byte[2][10][9][9][3][25];
            wt.factorsRestored = false;
            wt.dataList = new ArrayList();
            int j = 0;
            while (j < 6) {
                this.newData = new Tanks();
                this.newData.waveSpeed = 0.0;
                this.newData.energy = 100.0;
                this.newData.speed = 0.0;
                this.newData.direction = 1.0;
                this.newData.scanTime = 0L;
                this.newData.absBearing = 0.0;
                this.newData.heading = 0.0;
                this.newData.distance = 5000.0;
                this.newData.location = new Point2D.Double(300.0, 300.0);
                if (i == 0) {
                    this.newData.name = this.getName();
                }
                wt.dataList.add(this.newData);
                ++j;
            }
            this.tankList.add(wt);
            this.wTarget = wt;
            ++i;
        }
        this.lookingFor = this.newData;
        this.target = this.newData;
        this.bulletList = new ArrayList();
        this.bulletData = new Bullets();
        this.radarDirection = Math.signum(Utils.normalRelativeAngle((double)(this.absbearing(this.getX(), this.getY(), this.getBattleFieldWidth() / (double)2, this.getBattleFieldHeight() / (double)2) - this.getRadarHeadingRadians())));
        if (this.radarDirection == 0.0) {
            this.radarDirection = 1.0;
        }
        this.setTurnRightRadians(0.4 * this.radarDirection);
        this.setTurnGunRightRadians(1.5707963267948966 * this.radarDirection);
        this.setTurnRadarRightRadians(this.radarDirection * Math.PI * (double)2);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.lookingFor = this.getLookingFor();
            this.target = this.getTarget();
            this.myData0 = this.getOldData(this.getName(), 0);
            this.myData1 = this.getOldData(this.getName(), -1);
            this.updateSelf();
            this.updateBullets();
            this.upDateWaves();
            this.antiGravMove(this.getX(), this.getY());
            this.doRadar();
            this.chooseFirePower(3);
            this.aim();
            if (this.getGunHeat() == 0.0 && this.wTarget.alive && this.myData0.energy > this.firePower) {
                i = 1;
                while (i < this.tankList.size()) {
                    wt = (wholeTank)this.tankList.get(i);
                    Tanks currentData = (Tanks)wt.dataList.get(wt.dataList.size() - 1);
                    currentData.bulletFired = true;
                    ++i;
                }
                this.setFire(this.firePower);
            }
            this.OnceThisTurn = false;
            this.execute();
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        bulletMissed += 1.0;
    }

    public void onBulletHit(BulletHitEvent e) {
        bulletHit += 1.0;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.skippedTurns += 1.0;
        this.out.println("skipped Turns Total   =  " + this.skippedTurns);
    }

    public void onWin(WinEvent e) {
        if (this.fileWrite) {
            int i = 1;
            while (i < this.tankList.size()) {
                wholeTank wt = (wholeTank)this.tankList.get(i);
                this.saveFactors(wt);
                this.out.println(" HitRate = " + bulletHit / (bulletMissed + bulletHit));
                ++i;
            }
        }
    }

    public void onDeath(DeathEvent e) {
        if (this.fileWrite) {
            int i = 1;
            while (i < this.tankList.size()) {
                wholeTank wt = (wholeTank)this.tankList.get(i);
                this.saveFactors(wt);
                this.out.println(" HitRate = " + bulletHit / (bulletMissed + bulletHit));
                ++i;
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        int i = 1;
        while (i < this.tankList.size()) {
            wholeTank wt = (wholeTank)this.tankList.get(i);
            if (wt.name == e.getName()) {
                wt.alive = false;
            }
            ++i;
        }
        if (this.target.name == e.getName()) {
            this.target = this.getTarget();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.myData0.location = new Point2D.Double(this.getX(), this.getY());
        this.oldData = this.getOldData(e.getName(), 0);
        if (!this.oldDataWholeTank.factorsRestored && this.fileWrite && !this.OnceThisTurn) {
            this.restoreFactors(this.oldDataWholeTank);
            this.OnceThisTurn = true;
        }
        this.newData = new Tanks();
        this.newData.name = e.getName();
        this.newData.energy = e.getEnergy();
        this.newData.scanTime = this.getTime() - 1L;
        this.newData.speed = e.getVelocity();
        this.newData.distance = e.getDistance();
        this.newData.bearing = e.getBearingRadians();
        this.newData.heading = e.getHeadingRadians();
        this.newData.headingDelta = Utils.normalRelativeAngle((double)(e.getHeadingRadians() - this.oldData.heading));
        this.newData.absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.newData.deltaAbsBearing = Utils.normalRelativeAngle((double)(this.newData.absBearing - this.oldData.absBearing));
        this.newData.location = this.project(this.myData0.location, this.newData.absBearing, this.newData.distance);
        this.newData.direction = this.newData.speed != 0.0 ? (double)((int)Math.signum(this.newData.speed * Math.sin(e.getHeadingRadians() - this.newData.absBearing))) : this.oldData.direction;
        this.newData.fireLocation = this.myData0.location;
        this.newData.waveSpeed = this.bulletVelocity(this.firePower);
        this.newData.bulletFired = false;
        this.newData.distanceTraveled = 0.0 - this.newData.waveSpeed;
        double maxPositiveEscapeAngle = this.maxEscapeAngle(this.bulletVelocity(this.firePower));
        this.newData.binWidth = maxPositiveEscapeAngle / 12.0;
        this.newData.buffer = this.setSegmentation(this.newData, this.oldData, this.oldDataWholeTank);
        long sinceScanned = this.getTime() - 1L - this.oldData.scanTime;
        if (sinceScanned < 1L) {
            sinceScanned = 1L;
        }
        this.updateTanks(this.newData);
        double bulletPower = this.oldData.energy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09) {
            if (sinceScanned > 1L) {
                this.oldData = this.getOldData(e.getName(), -Math.round(sinceScanned / (long)2) + 3);
            }
            Bullets bd = new Bullets();
            bd.name = e.getName();
            bd.fireTime = this.oldData.scanTime;
            bd.bulletVelocity = this.bulletVelocity(bulletPower);
            bd.distanceTraveled = 0.0;
            bd.fireLocation = this.oldData.location;
            bd.directAngle = Utils.normalAbsoluteAngle((double)(this.oldData.absBearing - Math.PI));
            this.bulletList.add(bd);
        }
        if (this.lookingFor.name == null) {
            this.lookingFor = this.newData;
        }
        if (this.target.name == null) {
            this.target = this.newData;
        }
    }

    public byte[] setSegmentation(Tanks current, Tanks lastTick, wholeTank wt) {
        int distanceIndex = Math.min(9, (int)(current.distance / 96.0));
        byte lateralVelocityIndex = (byte)Math.abs((double)Math.round(current.speed * Math.sin(current.heading - (this.getHeadingRadians() + current.bearing))) * current.direction);
        byte direction = (byte)current.direction;
        if (direction < 1) {
            direction = 0;
        }
        byte advancingVelocityIndex = (byte)Math.round(-Math.cos(current.heading - current.absBearing) * Math.abs(current.speed) / (double)2 + (double)4);
        int bearingAccelIndex = 1;
        int delta = (int)Math.round((double)5 * current.distance * (Math.abs(current.deltaAbsBearing) - Math.abs(lastTick.deltaAbsBearing)));
        if (delta < 0) {
            bearingAccelIndex = 0;
        } else if (delta > 0) {
            bearingAccelIndex = 2;
        }
        return wt.statBuffers[direction][distanceIndex][lateralVelocityIndex][advancingVelocityIndex][bearingAccelIndex];
    }

    public void upDateWaves() {
        int i = 1;
        while (i < this.tankList.size()) {
            wholeTank wt = (wholeTank)this.tankList.get(i);
            int x = 1;
            while (x < wt.dataList.size()) {
                Tanks tankData = (Tanks)wt.dataList.get(x);
                Tanks currentData = (Tanks)wt.dataList.get(wt.dataList.size() - 1);
                if (tankData.waveSpeed != 0.0) {
                    tankData.distanceTraveled += tankData.waveSpeed;
                    if (tankData.distanceTraveled > tankData.fireLocation.distance(currentData.location) - 18.0) {
                        if (this.getTime() > 17L && wt.alive) {
                            byte binHit = this.currentBin(tankData, currentData);
                            if (tankData.buffer[binHit] < 5) {
                                if (binHit < 25 && binHit >= 0) {
                                    byte by = binHit;
                                    tankData.buffer[by] = (byte)(tankData.buffer[by] + 2);
                                }
                                if (binHit - 1 < 25 && binHit - 1 >= 0) {
                                    int n = binHit - 1;
                                    tankData.buffer[n] = (byte)(tankData.buffer[n] + 1);
                                }
                                if (binHit + 1 < 25 && binHit + 1 >= 0) {
                                    int n = binHit + 1;
                                    tankData.buffer[n] = (byte)(tankData.buffer[n] + 1);
                                }
                            } else {
                                byte ii = 0;
                                while (ii < 25) {
                                    if (ii != binHit && tankData.buffer[ii] > 0) {
                                        byte by = ii;
                                        tankData.buffer[by] = (byte)(tankData.buffer[by] - 1);
                                    }
                                    if (ii != binHit && ii != binHit - 1 && ii != binHit + 1 && tankData.buffer[ii] > 0) {
                                        byte by = ii;
                                        tankData.buffer[by] = (byte)(tankData.buffer[by] - 1);
                                    }
                                    ii = (byte)(ii + 1);
                                }
                            }
                            if (wt.name == this.wTarget.name) {
                                this.middleBinOnHit = tankData.location;
                                this.MPEP = this.project(tankData.fireLocation, Utils.normalRelativeAngle((double)(tankData.absBearing - this.maxEscapeAngle(tankData.waveSpeed) * tankData.direction)), currentData.distance);
                                this.MNEP = this.project(tankData.fireLocation, Utils.normalRelativeAngle((double)(tankData.absBearing - this.maxEscapeAngle(tankData.waveSpeed) * tankData.direction * -1.0)), currentData.distance);
                            }
                        }
                        tankData.waveSpeed = 0.0;
                    }
                }
                ++x;
            }
            ++i;
        }
    }

    public void aim() {
        if (this.target.name != null) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.target.absBearing - this.getGunHeadingRadians() + this.mostVisitedBearingOffset())));
        }
    }

    public byte currentBin(Tanks tankData, Tanks currentData) {
        byte bin = (byte)Math.round(Utils.normalRelativeAngle((double)(this.absoluteBearing(tankData.fireLocation, currentData.location) - tankData.absBearing)) / (tankData.direction * tankData.binWidth) + 12.0);
        if (bin >= 0 && bin <= 24) {
            this.lastBinHit = bin;
        }
        return (byte)Math.max(0, Math.min(24, bin));
    }

    double mostVisitedBearingOffset() {
        return this.target.direction * this.target.binWidth * (double)(this.mostVisitedBin() - 12);
    }

    private final int mostVisitedBin() {
        int mostVisited = 12;
        if (this.getTime() < 28L) {
            mostVisited = this.lastBinHit;
        }
        Tanks target1B4 = this.getOldData(this.target.name, -1);
        this.target.buffer = this.setSegmentation(this.target, target1B4, this.wTarget);
        this.binsVisited = 0;
        int i = 0;
        while (i < 25) {
            if (this.target.buffer[i] > this.target.buffer[mostVisited]) {
                mostVisited = i;
            }
            if (this.target.buffer[i] > 0) {
                ++this.binsVisited;
            }
            i = (byte)(i + 1);
        }
        this.binDisplay = (short)mostVisited;
        return mostVisited;
    }

    void restoreFactors(wholeTank wt) {
        try {
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(this.getDataFile(wt.name)));
            zipin.getNextEntry();
            ObjectInputStream in = new ObjectInputStream(zipin);
            wt.statBuffers = (byte[][][][][][])in.readObject();
            in.close();
            wt.factorsRestored = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void saveFactors(wholeTank wt) {
        try {
            ZipOutputStream zipout = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(wt.name)));
            zipout.putNextEntry(new ZipEntry("aimFactors"));
            ObjectOutputStream out2 = new ObjectOutputStream(zipout);
            out2.writeObject(wt.statBuffers);
            out2.flush();
            zipout.closeEntry();
            out2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void chooseFirePower(double power) {
        double distanceIndex = Math.min(9.0, this.target.distance / 96.0);
        this.firePower = (double)3 / ((distanceIndex + 1.0) / 2.9);
    }

    public void antiGravMove(double myX, double myY) {
        boolean close = false;
        Point2D.Double gravForce = new Point2D.Double(0.0, 0.0);
        Point2D.Double gravLocation = new Point2D.Double();
        int i = 1;
        while (i < this.tankList.size()) {
            wholeTank wt = (wholeTank)this.tankList.get(i);
            this.oldData = (Tanks)wt.dataList.get(wt.dataList.size() - 1);
            if (wt.alive) {
                long sinceScanned = this.getTime() - 1L - this.oldData.scanTime;
                if (sinceScanned == 0L) {
                    sinceScanned = 1L;
                }
                gravLocation = sinceScanned > 1L ? this.project(this.oldData.location, this.oldData.heading, 8L * sinceScanned) : this.oldData.location;
                if (this.oldData.distance < 160.0) {
                    close = true;
                }
                double tankGravForce = (this.oldData.energy / (double)4 + 75.0) * 10.0;
                if (this.getOthers() == 2 && this.oldData.name == this.target.name) {
                    tankGravForce /= (double)2;
                }
                gravForce = this.addGravPoints(gravForce.x, gravForce.y, myX, myY, gravLocation, tankGravForce, 1.45);
            }
            ++i;
        }
        int x = 0;
        while (x < this.bulletList.size()) {
            this.bulletData = (Bullets)this.bulletList.get(x);
            Point2D.Double bulletPosition = this.project(this.bulletData.fireLocation, this.bulletData.directAngle, this.bulletData.distanceTraveled);
            double bulletGravForce = 250.0 - this.myData0.location.distance(this.bulletData.fireLocation) / (double)4 + 6.0;
            gravForce = this.addGravPoints(gravForce.x, gravForce.y, myX, myY, bulletPosition, bulletGravForce, 2);
            if (bulletPosition.distance(this.myData0.location) < 150.0) {
                close = true;
            }
            ++x;
        }
        gravForce = this.addWallForces(gravForce.x, gravForce.y, myX, myY);
        double goAngle = this.absbearing(myX, myY, myX - gravForce.x, myY - gravForce.y);
        goAngle = this.wallSmoothing(this.myData0.location, goAngle, this.myData0.direction);
        if (!close) {
            if (this.getTime() % (long)5 == 0L) {
                this.weaveDir *= -1.0;
                this.setMaxVelocity(Math.random() * 15.0 + (double)2);
            }
            goAngle += 0.15 * this.weaveDir;
        } else {
            this.setMaxVelocity(8.0);
        }
        this.setBackAsFront(this, goAngle);
    }

    public Point2D.Double addGravPoints(double forceX, double forceY, double meX, double meY, Point2D.Double location, double tankForce, double tankForceRate) {
        GravPoint p = new GravPoint(location.x, location.y, -tankForce);
        double force = p.power / Math.pow(this.getRange(meX, meY, p.x, p.y), tankForceRate);
        double ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(meY - p.y, meX - p.x));
        Point2D.Double gravForces = new Point2D.Double(forceX += Math.sin(ang) * force, forceY += Math.cos(ang) * force);
        return gravForces;
    }

    public Point2D.Double addWallForces(double forceX, double forceY, double meX, double meY) {
        double wallForce = 8 * this.getOthers();
        double wallForceRate = 1.1;
        forceX += wallForce / Math.pow(this.getRange(meX, meY, this.getBattleFieldWidth(), meY), wallForceRate);
        forceY += wallForce / Math.pow(this.getRange(meX, meY, meX, this.getBattleFieldHeight()), wallForceRate);
        Point2D.Double wallForces = new Point2D.Double(forceX -= wallForce / Math.pow(this.getRange(meX, meY, 0.0, meY), wallForceRate), forceY -= wallForce / Math.pow(this.getRange(meX, meY, meX, 0.0), wallForceRate));
        return wallForces;
    }

    public double setSide(double goAngle) {
        double angle = Math.abs(Utils.normalRelativeAngle((double)(goAngle - this.myData0.heading)));
        if (Math.abs(angle) > 1.5707963267948966) {
            goAngle = Utils.normalAbsoluteAngle((double)(goAngle - Math.PI));
        }
        return goAngle;
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, double orientation) {
        while (!this.battleFieldRect.contains(this.project(botLocation, angle, 140.0))) {
            angle += orientation * 0.05;
        }
        return angle;
    }

    public double wallSmoothing2(double angle) {
        if (!this.battleFieldRect.contains(this.project(this.myData0.location, angle, 140.0))) {
            double turnDir = Math.signum(Utils.normalRelativeAngle((double)(this.absbearing(this.getX(), this.getY(), this.bw / (double)2, bh / (double)2) - this.getHeadingRadians())));
            if (turnDir == 0.0) {
                turnDir = 1.0;
            }
            angle = this.myData0.heading + 0.175 * turnDir;
        }
        return angle;
    }

    public void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(30.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(30.0);
        }
    }

    public void doRadar() {
        double radarTurn = Math.PI;
        double offset = 0.39269908169872414;
        if (this.lookingFor.name == null || this.getTime() - this.lookingFor.scanTime > 8L) {
            radarTurn = this.radarDirection * Math.PI * (double)2;
        } else {
            double angle = this.lookingFor.absBearing;
            this.radarDirection = Math.signum(Utils.normalRelativeAngle((double)(angle - this.getRadarHeadingRadians())));
            if (this.radarDirection == 0.0) {
                this.radarDirection = 1.0;
            }
            offset = (30.0 - this.radarDirection) / this.lookingFor.distance;
            radarTurn = Utils.normalRelativeAngle((double)(angle - this.getRadarHeadingRadians() + (offset *= this.radarDirection)));
        }
        this.setTurnRadarRightRadians(radarTurn);
    }

    public void updateBullets() {
        int x = 0;
        while (x < this.bulletList.size()) {
            this.bulletData = (Bullets)this.bulletList.get(x);
            this.bulletData.distanceTraveled += this.bulletData.bulletVelocity;
            if (this.bulletData.distanceTraveled > this.myData0.location.distance(this.bulletData.fireLocation) + 50.0) {
                this.bulletList.remove(x);
                --x;
            }
            ++x;
        }
    }

    public Tanks getLookingFor() {
        this.lookingFor = this.getOldData(this.lookingFor.name, 0);
        wholeTank Lf = this.oldDataWholeTank;
        int i = 1;
        while (i < this.tankList.size()) {
            wholeTank wt = new wholeTank();
            wt = (wholeTank)this.tankList.get(i);
            if (wt.alive) {
                this.oldData = new Tanks();
                this.oldData = (Tanks)wt.dataList.get(wt.dataList.size() - 1);
                boolean bl = false;
                if (this.oldData.scanTime < this.lookingFor.scanTime) {
                    bl = true;
                }
                if (bl | Lf.alive ^ true) {
                    this.lookingFor = this.oldData;
                }
                if (this.oldData.scanTime == this.lookingFor.scanTime && this.getOthers() > 1 && Math.abs(Utils.normalRelativeAngle((double)(this.oldData.absBearing - this.getRadarHeadingRadians()))) > Math.abs(Utils.normalRelativeAngle((double)(this.lookingFor.absBearing - this.getRadarHeadingRadians())))) {
                    this.lookingFor = this.oldData;
                }
            }
            ++i;
        }
        return this.lookingFor;
    }

    public Tanks getTarget() {
        this.target = (Tanks)this.wTarget.dataList.get(this.wTarget.dataList.size() - 1);
        int q = 1;
        while (q < this.tankList.size()) {
            wholeTank wt2 = (wholeTank)this.tankList.get(q);
            Tanks aTank = (Tanks)wt2.dataList.get(wt2.dataList.size() - 1);
            boolean bl = false;
            if (aTank.distance * 1.2 + aTank.energy * 2.5 < this.target.distance + this.target.energy * 2.5) {
                bl = true;
            }
            if (bl & wt2.alive | this.wTarget.alive ^ true) {
                this.target = aTank;
                this.wTarget = wt2;
            }
            ++q;
        }
        return this.target;
    }

    public void updateTanks(Tanks nd) {
        boolean foundTank = false;
        int openSpot = -5;
        int i = 0;
        while (i < this.tankList.size()) {
            wholeTank wt = (wholeTank)this.tankList.get(i);
            if (wt.name == nd.name) {
                if (nd.name != this.getName()) {
                    this.interpolate(wt, nd);
                }
                foundTank = true;
            }
            if (wt.name == null) {
                openSpot = i;
            }
            if (i >= this.tankList.size() - 1 && !foundTank) {
                wt = (wholeTank)this.tankList.get(openSpot);
                wt.name = nd.name;
                wt.dataList.add(nd);
                break;
            }
            int x = 0;
            while (x < wt.dataList.size()) {
                Tanks temp = (Tanks)wt.dataList.get(x);
                if (temp.scanTime + 100L < this.getTime() && wt.dataList.size() > 5) {
                    wt.dataList.remove(x);
                    --x;
                }
                ++x;
            }
            ++i;
        }
    }

    public void updateSelf() {
        this.newData = new Tanks();
        this.newData.name = this.getName();
        this.newData.energy = this.getEnergy();
        this.newData.scanTime = this.getTime();
        this.newData.speed = this.getVelocity();
        this.newData.heading = this.getHeadingRadians();
        this.newData.location = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(this.absoluteBearing(this.myData0.location, bfCenter) - this.myData0.heading);
        this.newData.direction = lateralVelocity >= 0.0 ? 1 : -1;
        wholeTank wt = (wholeTank)this.tankList.get(0);
        wt.dataList.add(this.newData);
    }

    public wholeTank getWholeTank(String aName) {
        wholeTank wt = new wholeTank();
        boolean foundData = false;
        boolean openSpot = true;
        int i = 0;
        while (i < this.tankList.size()) {
            wt = (wholeTank)this.tankList.get(i);
            if (wt.name == aName) {
                foundData = true;
                return wt;
            }
            ++i;
        }
        if (!foundData) {
            int ii = 0;
            while (ii < this.tankList.size()) {
                wt = (wholeTank)this.tankList.get(ii);
                if (wt.name == null) {
                    return wt;
                }
                ++ii;
            }
        }
        return wt;
    }

    public Tanks getOldData(String aName, int indexAge) {
        this.oldDataWholeTank = new wholeTank();
        this.oldDataWholeTank = this.getWholeTank(aName);
        this.oldData = new Tanks();
        indexAge = Math.max(1 + this.oldDataWholeTank.dataList.size() * -1, indexAge);
        indexAge = Math.min(0, indexAge);
        this.oldData = (Tanks)this.oldDataWholeTank.dataList.get(this.oldDataWholeTank.dataList.size() - 1 + indexAge);
        return this.oldData;
    }

    public Point2D.Double predictPosition(Tanks t, double direction) {
        Point2D.Double predictedPosition = t.location;
        double predictedVelocity = t.speed;
        double predictedHeading = t.absBearing + 1.5707963267948966;
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.absoluteBearing(t.fireLocation, predictedPosition) + direction * 1.5707963267948966 - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveDir = direction;
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? (double)2 * moveDir : moveDir;
            predictedVelocity = this.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = this.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(t.fireLocation) < t.distanceTraveled + (double)counter * t.waveSpeed + t.waveSpeed)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    void goTo(double x, double y) {
        double dist = 100.0;
        double angle = this.absbearing(this.getX(), this.getY(), x, y);
        angle = this.wallSmoothing(this.myData0.location, angle, this.myData0.direction);
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeadingRadians() - angle);
        if (ang > 1.5707963267948966) {
            ang -= Math.PI;
            dir = -1;
        } else if (ang < -1.5707963267948966) {
            ang += Math.PI;
            dir = -1;
        } else {
            dir = 1;
        }
        Point2D.Double loc = new Point2D.Double(this.getX(), this.getY());
        this.setTurnLeftRadians(ang);
        return dir;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public void interpolate(wholeTank wt, Tanks nd) {
        nd.speed = Math.round(nd.speed);
        this.oldData = this.getOldData(wt.name, 0);
        Point2D.Double lastLocation = new Point2D.Double();
        lastLocation = this.oldData.location;
        double timeDelta = this.getTime() - 1L - this.oldData.scanTime;
        if (timeDelta < 1.0) {
            timeDelta = 1.0;
        }
        if (timeDelta > 1.0) {
            double V = this.oldData.speed;
            boolean braking = true;
            double i = 1.0;
            while (i < timeDelta + 1.0) {
                double portion = i / timeDelta;
                Tanks missed = new Tanks();
                missed.name = nd.name;
                missed.scanTime = this.oldData.scanTime + (long)i;
                missed.headingDelta = nd.headingDelta / timeDelta;
                missed.heading = Utils.normalRelativeAngle((double)this.linearInterpolate(nd.heading - nd.headingDelta, nd.heading, portion));
                missed.absBearing = this.linearInterpolate(this.oldData.absBearing, nd.absBearing, portion);
                missed.distance = this.linearInterpolate(this.oldData.distance, nd.distance, portion);
                missed.energy = this.linearInterpolate(this.oldData.energy, nd.energy, portion);
                missed.direction = this.oldData.direction;
                double deltaSpeed = nd.speed - this.oldData.speed;
                double moveDir = Math.signum(deltaSpeed);
                if (Math.signum(nd.speed) == Math.signum(this.oldData.speed) && Math.abs(nd.speed) > Math.abs(this.oldData.speed) || this.oldData.speed == 0.0) {
                    boolean bl = false;
                    if (timeDelta - (Math.abs(nd.speed) - Math.abs(this.oldData.speed)) < i) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (Math.abs(nd.speed) == 8.0) {
                        bl2 = true;
                    }
                    if (bl | bl2) {
                        V += moveDir;
                    }
                } else {
                    double delay = Math.abs(deltaSpeed);
                    double delay2 = Math.round(this.limit(0.0, Math.abs(this.oldData.speed) * 0.5, 4) + 0.5);
                    if (timeDelta - (delay -= Math.min((double)Math.round(this.limit(0.0, delay * 0.5, 4) + 0.5), delay2)) < i + 1.0) {
                        double Vc;
                        if (braking && Math.abs(V) > 1.5) {
                            Vc = (double)2 * moveDir;
                            missed.direction = this.oldData.direction;
                        } else {
                            braking = false;
                            Vc = moveDir;
                            missed.direction = nd.direction;
                        }
                        V += Vc;
                    }
                }
                missed.speed = this.limit(-8.0, V, 8.0);
                Point2D.Double loc = new Point2D.Double();
                lastLocation = missed.location = (loc = this.project(lastLocation, missed.heading, missed.speed));
                if (i == timeDelta) {
                    missed.speed = nd.speed;
                }
                wt.dataList.add(missed);
                i += 1.0;
            }
        } else {
            wt.dataList.add(nd);
        }
    }

    public double linearInterpolate(double y1, double y2, double mu) {
        return y1 * (1.0 - mu) + y2 * mu;
    }

    public Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    static int minMax(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    public double bulletVelocity(double _firePower) {
        return 20.0 - (double)3 * _firePower;
    }

    public double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public Point2D.Double guessPosition(long when, Tanks who) {
        double diff = when - who.scanTime;
        double guessedY = who.location.y + Math.cos(who.heading) * who.speed * diff;
        double guessedX = who.location.x + Math.sin(who.heading) * who.speed * diff;
        return new Point2D.Double(guessedX, guessedY);
    }

    public void onPaint(Graphics2D g) {
        this.drawGraph1(g);
        this.escapePoints(g);
        this.paintMemoryLocations(g);
        this.paintBulletWaves(g);
        this.paintEnemyBullets(g);
    }

    public void paintEnemyBullets(Graphics2D g) {
        int x = 0;
        while (x < this.bulletList.size()) {
            this.bulletData = (Bullets)this.bulletList.get(x);
            Point2D.Double bulletPosition = this.project(this.bulletData.fireLocation, this.bulletData.directAngle, this.bulletData.distanceTraveled);
            int radius = 4;
            g.setColor(Color.green);
            g.drawOval((int)(bulletPosition.x - (double)radius), (int)(bulletPosition.y - (double)radius), radius * 2, radius * 2);
            ++x;
        }
    }

    public void paintBulletWaves(Graphics2D g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this.bulletList.size()) {
            this.bulletData = (Bullets)this.bulletList.get(i);
            Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
            int radius = (int)this.bulletData.distanceTraveled;
            double dist = this.bulletData.distanceTraveled;
            Point2D.Double center = this.bulletData.fireLocation;
            if ((double)(radius - 40) < center.distance(this.myData0.location)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
                g.setColor(Color.yellow);
                Point2D.Double position = this.project(center, this.bulletData.directAngle + 0.7, dist);
                g.setColor(Color.red);
            }
            ++i;
        }
    }

    public void escapePoints(Graphics2D g) {
        int radius = 6;
        g.setColor(Color.green);
        g.drawOval((int)(this.MPEP.x - (double)radius), (int)(this.MPEP.y - (double)radius), radius * 2, radius * 2);
        g.setColor(Color.red);
        radius = 8;
        g.drawOval((int)(this.MNEP.x - (double)radius), (int)(this.MNEP.y - (double)radius), radius * 2, radius * 2);
        g.setColor(Color.orange);
        radius = 7;
        g.drawOval((int)(this.middleBinOnHit.x - (double)radius), (int)(this.middleBinOnHit.y - (double)radius), radius * 2, radius * 2);
        Point2D.Double m1 = this.project(this.myData0.location, this.getGunHeadingRadians(), this.target.distance);
        Point2D.Double m2 = this.project(this.myData0.location, this.getGunHeadingRadians(), this.target.distance - 60.0);
        g.drawLine((int)m2.x, (int)m2.y, (int)m1.x, (int)m1.y);
    }

    public void Graph(Graphics2D g, int posX, int posY, int bin, int binValue) {
        g.fillRect(posX, posY, 7, binValue);
        if (bin % 2 == 0) {
            String s = Integer.toString(bin, 10);
            g.drawString(s, posX, posY - 13);
        }
    }

    public void drawGraph1(Graphics2D g) {
        int posX = 14;
        int posY = 18;
        String s = Short.toString(this.binDisplay);
        g.drawString(s, 42, 80);
        g.drawString("Bin Hit:", 1, 80);
        if (this.target.name != null) {
            g.drawString(this.wTarget.name + " Aiming", 1, 90);
        }
        int b = 0;
        while (b < 25) {
            if (b < 12) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.red);
            }
            if (b == 12) {
                g.setColor(Color.orange);
            }
            posX = 200 - 8 * b + 14;
            byte binValue = 0;
            if (this.target.name != null) {
                binValue = this.target.buffer[b];
            }
            this.Graph(g, posX, posY, b, binValue * 10);
            ++b;
        }
    }

    public void paintMyWaves(Graphics2D g) {
        g.setColor(Color.red);
        int i = 1;
        while (i < this.tankList.size()) {
            wholeTank wt = (wholeTank)this.tankList.get(i);
            int x = 0;
            while (x < wt.dataList.size()) {
                Tanks tankData = (Tanks)wt.dataList.get(x);
                if (tankData.waveSpeed != 0.0) {
                    int radius = (int)tankData.distanceTraveled;
                    Point2D.Double center = tankData.fireLocation;
                    g.drawOval((int)(((Point2D)center).getX() - (double)radius), (int)(((Point2D)center).getY() - (double)radius), radius * 2, radius * 2);
                }
                ++x;
            }
            ++i;
        }
    }

    public void paintMemoryLocations(Graphics2D d) {
        if (this.getTime() < 10L) {
            return;
        }
        d.setColor(Color.gray);
        int radius = 16;
        int i = 0;
        while (i < this.tankList.size()) {
            wholeTank wt = (wholeTank)this.tankList.get(i);
            int x = 0;
            while (x < wt.dataList.size()) {
                Tanks temp = (Tanks)wt.dataList.get(x);
                if (temp.location != null) {
                    int rad = 250;
                    Point2D.Double t1 = this.project(temp.location, temp.heading + 1.5707963267948966, 17.0);
                    Point2D.Double t2 = this.project(temp.location, temp.heading - 1.5707963267948966, 17.0);
                    Point2D.Double t3 = this.project(temp.location, temp.heading + 1.5707963267948966, 10.0);
                    Point2D.Double t4 = this.project(temp.location, temp.heading - 1.5707963267948966, 10.0);
                    d.drawLine((int)t1.x, (int)t1.y, (int)t3.x, (int)t3.y);
                    d.drawLine((int)t2.x, (int)t2.y, (int)t4.x, (int)t4.y);
                }
                ++x;
            }
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.weaveDir = 1.0;
        this.skippedTurns = 0.0;
        this.lastBinHit = (byte)12;
        this.binsVisited = 0;
        this.fileWrite = true;
        this.middleBinOnHit = new Point2D.Double(-10.0, -10.0);
        this.MPEP = new Point2D.Double(-10.0, -10.0);
        this.MNEP = new Point2D.Double(-10.0, -10.0);
    }

    public javaDisturbance() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class wholeTank {
        private static final byte DIRECTION = 2;
        private static final byte DISTANCE_INDEXES = 10;
        private static final byte VELOCITY_INDEXES = 9;
        private static final byte DIRECTIONAL_VELOCITY_INDEX = 9;
        private static final byte BULLET_TIME = 8;
        private static final byte WALL_DISTANCE = 3;
        private static final byte BEARING_ACCEL = 3;
        private static final byte DELTA_VELOCITY_INDEXES = 5;
        private static final byte HEADING_DIFF = 8;
        private static final byte ABS_BEARING = 8;
        private static final byte BINS = 25;
        private static final byte MIDDLE_BIN = 12;
        String name;
        boolean alive;
        double hit;
        ArrayList dataList;
        public boolean factorsRestored;
        public byte[][][][][][] statBuffers;

        wholeTank() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Tanks {
        String name;
        public long scanTime;
        public double energy;
        public Point2D.Double location;
        public double heading;
        public double headingDelta;
        public double speed;
        public double deltaVelocity;
        public double bearing;
        public double absBearing;
        public double deltaAbsBearing;
        public double distance;
        public double direction;
        public byte[] buffer;
        public Point2D.Double fireLocation;
        public double waveSpeed;
        public double distanceTraveled;
        public boolean bulletFired;
        public double binWidth;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Bullets {
        String name;
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GravPoint {
        public double x;
        public double y;
        public double power;

        public GravPoint(double pX, double pY, double pPower) {
            this.x = pX;
            this.y = pY;
            this.power = pPower;
        }
    }
}

