/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode.opponent;

import gtf.robocode.Reading;
import gtf.robocode.opponent.CircularOpponent;
import gtf.robocode.opponent.Opponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpponentManager
implements Iterable<Opponent> {
    private Map<String, Opponent> nameMap = new HashMap<String, Opponent>();
    private Set<Opponent> opponents = new HashSet<Opponent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReading(String name, Reading reading) {
        Opponent opponent;
        OpponentManager opponentManager = this;
        synchronized (opponentManager) {
            opponent = this.nameMap.get(name);
            if (opponent == null) {
                opponent = new CircularOpponent(name);
                this.nameMap.put(name, opponent);
                this.opponents.add(opponent);
            }
        }
        opponent.addReading(reading);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        OpponentManager opponentManager = this;
        synchronized (opponentManager) {
            Opponent opponent = this.nameMap.remove(name);
            this.opponents.remove(opponent);
        }
    }

    @Override
    public Iterator<Opponent> iterator() {
        return this.opponents.iterator();
    }
}

