/*
 * Decompiled with CFR 0.152.
 */
package marcinek;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class TopGun
extends AdvancedRobot {
    int back = 20;
    int oposite = 1;

    public void run() {
        this.setBodyColor(Color.darkGray);
        this.setBulletColor(Color.yellow);
        this.setGunColor(Color.red);
        this.setRadarColor(Color.white);
        this.setScanColor(Color.gray);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Math.PI * 2);
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.setTurnRightRadians(e.getBearingRadians() < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
        this.setAhead(80.0);
        this.execute();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double robotX = this.getX() + e.getDistance() * Math.sin(this.getHeadingRadians() + e.getBearingRadians());
        double robotY = this.getY() + e.getDistance() * Math.cos(this.getHeadingRadians() + e.getBearingRadians());
        double firePower = 3.0 - 2.9 * (e.getDistance() / 1200.0);
        if (this.getEnergy() < 20.0) {
            firePower /= 2.0;
        }
        double fireSpeed = Rules.getBulletSpeed((double)firePower);
        double fireX = robotX;
        double fireY = robotY;
        double turn = 1.0;
        while (turn * fireSpeed < Point2D.Double.distance(this.getX(), this.getY(), fireX, fireY)) {
            fireX += Math.sin(e.getHeadingRadians()) * e.getVelocity();
            fireY += Math.cos(e.getHeadingRadians()) * e.getVelocity();
            turn += 1.0;
        }
        fireX = Math.min(Math.max(18.0, fireX), this.getBattleFieldWidth() - 18.0);
        fireY = Math.min(Math.max(18.0, fireY), this.getBattleFieldHeight() - 18.0);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(fireX - this.getX(), fireY - this.getY())) - this.getGunHeadingRadians())));
        if (Math.abs(this.getGunTurnRemainingRadians()) < Rules.GUN_TURN_RATE_RADIANS) {
            this.setFire(firePower);
        }
        this.setTurnRightRadians(e.getBearingRadians() - 1.5707963267948966 + (this.getDistanceRemaining() > 0.0 && e.getDistance() > 500.0 ? Math.PI / (4.0 * Math.random()) : -Math.PI / (4.0 * Math.random())));
        --this.back;
        if (this.back < 0) {
            this.back = (int)(50.0 * Math.random());
            this.oposite *= -1;
        }
        this.setAhead((double)this.oposite * (this.getDistanceRemaining() > 0.0 ? this.getDistanceRemaining() * 100.0 : Math.random() * 1000.0));
        this.execute();
    }
}

