/*
 * Decompiled with CFR 0.152.
 */
package lucasslf;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import lucasslf.GFTUtils;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Dodger
extends AdvancedRobot {
    public static final double HALF_PI = 1.5707963267948966;
    public static final double WALKING_STICK = 160.0;
    public static final double WALL_MARGIN = 19.0;
    public static final double S = 19.0;
    public static final double W = 19.0;
    public static final double N = 581.0;
    public static final double E = 781.0;
    public static int readings = 0;
    private ScannedRobot lastScannedRobot = new ScannedRobot();
    private static int BALDES = 43;
    private static int SEG_HEADING_DIFFERENCE = 19;
    private static int SEG_DISTANCE = 13;
    private static int SEG_VELOCITY = 17;
    private static int SEG_BULLET_POWER = 4;
    private long lastHitTime = 0L;
    private long lastChange = 0L;
    private boolean shouldSurf = true;
    private static double[][][][][][] baldeDeFatores = new double[SEG_BULLET_POWER][SEG_HEADING_DIFFERENCE][SEG_VELOCITY][SEG_VELOCITY][SEG_DISTANCE][BALDES];
    private static double[][][][] surfStats = new double[SEG_VELOCITY][SEG_VELOCITY][SEG_DISTANCE][BALDES];
    private List<OndaDeTiro> ondas = new Vector<OndaDeTiro>();
    private List<OndaDoInimigo> ondasDoInimigo = new Vector<OndaDoInimigo>();
    private List<Double> velocities = new ArrayList<Double>();
    private List<Double> distances = new ArrayList<Double>();
    private static List<Integer> surfDirections = new Vector<Integer>();
    private static List<Double> surfAbsBearings = new Vector<Double>();
    private Point2D localizacao;
    private static GFGun gun;
    private Surf surfer;
    private static GFTMovement alternativeMovement;
    public static Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;

    static {
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        WALL_STICK = 160.0;
    }

    public Dodger() {
        gun = new GFGun(this);
        this.surfer = new Surf(this);
        alternativeMovement = new GFTMovement(this);
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.BLUE, Color.red, Color.WHITE);
        this.setBulletColor(Color.RED);
        while (true) {
            if (Math.abs(this.getRadarTurnRemaining()) < 1.0E-6 && this.getOthers() > 0) {
                if (this.getTime() > 9L) {
                    this.out.println("Lost radar lock");
                }
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            if (this.lastScannedRobot.time + 1L < this.getTime()) {
                this.localizacao = new Point2D.Double(this.getX(), this.getY());
                this.surfer.doSurfing();
            }
            this.execute();
        }
    }

    public Point2D getLocalizacao() {
        return this.localizacao;
    }

    public void atualizarOndasDoInimigo() {
        int i = 0;
        while (i < this.ondasDoInimigo.size()) {
            OndaDoInimigo onda = this.ondasDoInimigo.get(i);
            onda.atualizaDistanciaPercorrida(this.getTime());
            if (onda.getDistanciaPercorrida() > this.localizacao.distance(onda.getPosicaoInicial()) + 50.0) {
                this.ondasDoInimigo.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        this.lastScannedRobot.energy -= damage;
        this.checkBulletOndas(e.getBullet());
    }

    private void checkBulletOndas(Bullet b) {
        int i = 0;
        while (i < this.ondas.size()) {
            OndaDeTiro onda = this.ondas.get(i);
            if (onda.checkBullet(b)) {
                this.ondas.remove(onda);
                --i;
                break;
            }
            ++i;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.ondasDoInimigo.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            OndaDoInimigo ondaAtingida = null;
            int x = 0;
            while (x < this.ondasDoInimigo.size()) {
                OndaDoInimigo o = this.ondasDoInimigo.get(x);
                if (Math.abs(o.getDistanciaPercorrida() - this.localizacao.distance(o.getPosicaoInicial())) < 50.0 && Math.abs(20.0 - e.getBullet().getPower() * 3.0 - o.getBulletSpeed()) < 0.001) {
                    ondaAtingida = o;
                    break;
                }
                ++x;
            }
            if (ondaAtingida != null) {
                this.logHit(ondaAtingida, hitBulletLocation);
                this.ondasDoInimigo.remove(this.ondasDoInimigo.lastIndexOf(ondaAtingida));
            }
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        int i = 0;
        while (i < this.ondas.size()) {
            OndaDeTiro onda = this.ondas.get(i);
            if (onda.checkBulletMiss(e.getBullet())) {
                this.ondas.remove(onda);
                --i;
                break;
            }
            ++i;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.out.println("HIt: " + e.getTime());
        this.lastScannedRobot.energy += 3.0 * e.getBullet().getPower();
        if (e.getTime() - this.lastHitTime < 60L && e.getTime() - this.lastChange > 100L) {
            this.out.println("tomou tiro demais, mudando movimenta\ufffd\ufffdo.");
            this.shouldSurf = !this.shouldSurf;
            this.lastChange = e.getTime();
        }
        this.lastHitTime = e.getTime();
        if (!this.ondasDoInimigo.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            OndaDoInimigo ondaAtingida = null;
            int x = 0;
            while (x < this.ondasDoInimigo.size()) {
                OndaDoInimigo o = this.ondasDoInimigo.get(x);
                if (Math.abs(o.getDistanciaPercorrida() - this.localizacao.distance(o.getPosicaoInicial())) < 50.0 && Math.round((20.0 - e.getBullet().getPower() * 3.0) * 10.0) == Math.round(o.getBulletSpeed() * 10.0)) {
                    ondaAtingida = o;
                    break;
                }
                ++x;
            }
            if (ondaAtingida != null) {
                this.logHit(ondaAtingida, hitBulletLocation);
                this.ondasDoInimigo.remove(this.ondasDoInimigo.lastIndexOf(ondaAtingida));
            }
        }
    }

    private void checkHitOndasDeTiro(Point2D posicaoInimigo, long time) {
        int i = 0;
        while (i < this.ondas.size()) {
            OndaDeTiro onda = this.ondas.get(i);
            if (onda.checkHit(posicaoInimigo, time)) {
                this.ondas.remove(onda);
                --i;
            }
            ++i;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double absoluteBearing = this.getHeading() + e.getBearing();
        double bearingFromGun = Utils.normalRelativeAngleDegrees((double)(absoluteBearing - this.getGunHeading()));
        double ex = this.getX() + Math.sin(enemyAbsoluteBearing) * e.getDistance();
        double ey = this.getY() + Math.cos(enemyAbsoluteBearing) * e.getDistance();
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        this.localizacao = new Point2D.Double(this.getX(), this.getY());
        surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        surfAbsBearings.add(0, new Double(enemyAbsoluteBearing + Math.PI));
        this.velocities.add(0, this.getVelocity());
        this.distances.add(0, e.getDistance());
        Point2D.Double posicaoInimigo = new Point2D.Double(ex, ey);
        this.atualizarOndasDoInimigo();
        this.checkHitOndasDeTiro(posicaoInimigo, e.getTime());
        if (this.lastScannedRobot.energy > e.getEnergy() && this.lastScannedRobot.energy - e.getEnergy() <= 3.0) {
            double energiaPerdida = this.lastScannedRobot.energy - e.getEnergy();
            OndaDoInimigo ondaDoInimigo = new OndaDoInimigo(posicaoInimigo, surfAbsBearings.get(2), e.getTime() - 1L, energiaPerdida, surfDirections.get(2), this.distances.get(2), e.getVelocity(), this.velocities.get(1), this.velocities.get(2));
            this.ondasDoInimigo.add(ondaDoInimigo);
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRadarHeadingRadians())) * 2.0);
        if (!this.shouldSurf || Math.random() < 50.0) {
            alternativeMovement.onScannedRobot(e);
        } else {
            this.surfer.doSurfing();
        }
        gun.onScannedRobot(e);
        this.lastScannedRobot = new ScannedRobot();
        this.lastScannedRobot.energy = e.getEnergy();
        this.lastScannedRobot.name = e.getName();
        this.lastScannedRobot.bearing = bearingFromGun;
        this.lastScannedRobot.time = e.getTime();
        this.lastScannedRobot.velocity = e.getVelocity();
        this.lastScannedRobot.localizacaoInimigo = posicaoInimigo;
    }

    public void logHit(OndaDoInimigo o, Point2D targetLocation) {
        int index = DodgerUtils.getFactorIndex(o, targetLocation);
        int x = 0;
        while (x < BALDES) {
            double value = 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            double[] dArray = surfStats[o.getSegLastVelocity()][o.getSegVelocity()][o.getSegDistanciaInicial()];
            int n = x++;
            dArray[n] = dArray[n] + value;
        }
    }

    static class DodgerUtils {
        DodgerUtils() {
        }

        public static int getFactorIndex(OndaDoInimigo o, Point2D targetLocation) {
            double offsetAngle = DodgerUtils.absoluteBearing(o.getPosicaoInicial(), targetLocation) - o.getAnguloInicial();
            double factor = Utils.normalRelativeAngle((double)offsetAngle) / o.maxEscapeAngle() * (double)o.getDirecao();
            return (int)DodgerUtils.limit(0.0, factor * (double)((BALDES - 1) / 2) + (double)((BALDES - 1) / 2), BALDES - 1);
        }

        public static double rollingAvg(double value, double newEntry, double n, double weighting) {
            return (value * n + newEntry * weighting) / (n + weighting);
        }

        public static double absoluteBearing(Point2D source, Point2D target) {
            return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
        }

        public static double limit(double min, double value, double max) {
            return Math.max(min, Math.min(value, max));
        }
    }

    class GFGun {
        private Dodger r;

        public GFGun(Dodger r) {
            this.r = r;
        }

        public void onScannedRobot(ScannedRobotEvent e) {
            double enemyAbsoluteBearing = Dodger.this.getHeadingRadians() + e.getBearingRadians();
            int direcaoInimigo = 0;
            if (e.getVelocity() != 0.0) {
                direcaoInimigo = Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) * e.getVelocity() < 0.0 ? -1 : 1;
            }
            boolean rammer = e.getDistance() < 200.0;
            double power = rammer ? 3.0 : Math.min(2.0, Math.min(Dodger.this.getEnergy() / 16.0, e.getEnergy() / 2.0));
            double headingDifference = e.getHeading() - Dodger.this.getHeading();
            int segHeadingDifference = (int)(headingDifference + 360.0) / 40;
            int segDistanciaIndice = (int)e.getDistance() / 100;
            int segBulletPower = (int)power;
            int segLastEnemyVelocity = (int)(((Dodger)Dodger.this).lastScannedRobot.velocity + 8.0);
            int segEnemyVelocity = (int)(e.getVelocity() + 8.0);
            int melhorIndice = (BALDES - 1) / 2;
            double[] aux = baldeDeFatores[segBulletPower][segHeadingDifference][segLastEnemyVelocity][segEnemyVelocity][segDistanciaIndice];
            int i = 0;
            while (i < BALDES) {
                if (aux[melhorIndice] < aux[i]) {
                    melhorIndice = i;
                }
                ++i;
            }
            OndaDeTiro onda = new OndaDeTiro(new Point2D.Double(this.r.getX(), this.r.getY()), enemyAbsoluteBearing, power, direcaoInimigo, aux, e.getTime(), melhorIndice, "Segmenta\ufffd\ufffdo: " + segHeadingDifference + " " + segLastEnemyVelocity + " " + segEnemyVelocity + " " + segDistanciaIndice);
            double fator = 2.0 * (double)melhorIndice / ((double)BALDES - 1.0) - 1.0;
            double angleOffset = (double)direcaoInimigo * fator * onda.maxEscapeAngle();
            double gunAdjust = Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - Dodger.this.getGunHeadingRadians() + angleOffset));
            Dodger.this.setTurnGunRightRadians(gunAdjust);
            if (Dodger.this.getGunHeat() == 0.0) {
                onda.setBala(Dodger.this.setFireBullet(power));
            }
            Dodger.this.ondas.add(onda);
        }
    }

    class GFTMovement {
        private static final double BATTLE_FIELD_WIDTH = 800.0;
        private static final double BATTLE_FIELD_HEIGHT = 600.0;
        private static final double WALL_MARGIN = 18.0;
        private static final double MAX_TRIES = 125.0;
        private static final double REVERSE_TUNER = 0.421075;
        private static final double DEFAULT_EVASION = 1.2;
        private static final double WALL_BOUNCE_TUNER = 0.699484;
        private AdvancedRobot robot;
        private Rectangle2D fieldRectangle = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        private double enemyFirePower = 3.0;
        private double direction = 0.4;

        GFTMovement(AdvancedRobot _robot) {
            this.robot = _robot;
        }

        public void onScannedRobot(ScannedRobotEvent e) {
            Point2D robotDestination;
            double enemyAbsoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
            double enemyDistance = e.getDistance();
            Point2D.Double robotLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
            Point2D enemyLocation = GFTUtils.project(robotLocation, enemyAbsoluteBearing, enemyDistance);
            double tries = 0.0;
            while (!this.fieldRectangle.contains(robotDestination = GFTUtils.project(enemyLocation, enemyAbsoluteBearing + Math.PI + this.direction, enemyDistance * (1.2 - tries / 100.0))) && tries < 125.0) {
                tries += 1.0;
            }
            if (Math.random() < GFTUtils.bulletVelocity(this.enemyFirePower) / 0.421075 / enemyDistance || tries > enemyDistance / GFTUtils.bulletVelocity(this.enemyFirePower) / 0.699484) {
                this.direction = -this.direction;
            }
            double angle = GFTUtils.absoluteBearing(robotLocation, robotDestination) - this.robot.getHeadingRadians();
            this.robot.setAhead(Math.cos(angle) * 100.0);
            this.robot.setTurnRightRadians(Math.tan(angle));
        }
    }

    class OndaDeTiro {
        private Point2D posicaoInicial;
        private double anguloInicial;
        private double power;
        private int direcaoInimigo;
        private double[] refBaldeFatores;
        private long time;
        private Bullet bala;
        private int indiceUtilizado;
        private String segmentacao;

        public OndaDeTiro(Point2D posicaoInicial, double anguloInicial, double power, int direcaoInimigo, double[] refBaldeFatores, long time, int indiceUtilizado, String segmentacao) {
            this.posicaoInicial = posicaoInicial;
            this.anguloInicial = anguloInicial;
            this.power = power;
            this.direcaoInimigo = direcaoInimigo;
            this.refBaldeFatores = refBaldeFatores;
            this.time = time;
            this.indiceUtilizado = indiceUtilizado;
            this.segmentacao = segmentacao;
        }

        public double getBulletSpeed() {
            return 20.0 - this.power * 3.0;
        }

        public double maxEscapeAngle() {
            return Math.asin(8.0 / this.getBulletSpeed());
        }

        public boolean checkHit(Point2D localInimigo, long currentTime) {
            if (this.posicaoInicial.distance(localInimigo) <= (double)(currentTime - this.time) * this.getBulletSpeed()) {
                double desiredDirection = Math.atan2(localInimigo.getX() - this.posicaoInicial.getX(), localInimigo.getY() - this.posicaoInicial.getY());
                double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.anguloInicial));
                double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * (double)this.direcaoInimigo;
                int index = (int)Math.round((double)((BALDES - 1) / 2) * (guessFactor + 1.0));
                this.refBaldeFatores[index] = DodgerUtils.rollingAvg(this.refBaldeFatores[index], 1.0, Math.min(readings++, 200), 1.0);
                int i = 0;
                while (i < this.refBaldeFatores.length) {
                    if (i != index) {
                        this.refBaldeFatores[index] = DodgerUtils.rollingAvg(this.refBaldeFatores[index], 0.0, Math.min(readings++, 200), 1.0);
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public boolean checkBullet(Bullet b) {
            if (this.bala != null && this.bala.equals((Object)b)) {
                int n = this.indiceUtilizado;
                this.refBaldeFatores[n] = this.refBaldeFatores[n] + 2.0;
                return true;
            }
            return false;
        }

        public boolean checkBulletMiss(Bullet b) {
            if (this.bala != null && this.bala.equals((Object)b)) {
                int n = this.indiceUtilizado;
                this.refBaldeFatores[n] = this.refBaldeFatores[n] - 2.0;
                return true;
            }
            return false;
        }

        public Bullet getBala() {
            return this.bala;
        }

        public void setBala(Bullet bala) {
            this.bala = bala;
        }
    }

    class OndaDoInimigo {
        private Point2D posicaoInicial;
        private double anguloInicial;
        private int direcao;
        private long fireTime;
        private double bulletPower;
        private double distanciaInicial;
        private double distanciaPercorrida;
        private double enemyVelocity;
        private double myVelocity;
        private double myLastVelocity;

        public OndaDoInimigo(Point2D posicaoInicial, double anguloInicial, long fireTime, double bulletPower, int direcao, double distanciaInicial, double enemyVelocity, double myVelocity, double myLastVelocity) {
            this.posicaoInicial = posicaoInicial;
            this.anguloInicial = anguloInicial;
            this.fireTime = fireTime;
            this.bulletPower = bulletPower;
            this.distanciaPercorrida = (double)(Dodger.this.getTime() - fireTime) * this.getBulletSpeed();
            this.direcao = direcao;
            this.distanciaInicial = distanciaInicial;
            this.enemyVelocity = enemyVelocity;
            this.myVelocity = myVelocity;
            this.myLastVelocity = myLastVelocity;
        }

        public int getSegVelocity() {
            return (int)(this.myVelocity + 8.0);
        }

        public int getSegLastVelocity() {
            return (int)(this.myLastVelocity + 8.0);
        }

        public int getSegDistanciaInicial() {
            return (int)this.distanciaInicial / 100;
        }

        public double getEnemyVelocity() {
            return this.enemyVelocity;
        }

        public double getBulletSpeed() {
            return 20.0 - this.bulletPower * 3.0;
        }

        public double maxEscapeAngle() {
            return Math.asin(8.0 / this.getBulletSpeed());
        }

        public double getDistanciaPercorrida() {
            return this.distanciaPercorrida;
        }

        public Point2D getPosicaoInicial() {
            return this.posicaoInicial;
        }

        public double getAnguloInicial() {
            return this.anguloInicial;
        }

        public int getDirecao() {
            return this.direcao;
        }

        public void atualizaDistanciaPercorrida(long time) {
            this.distanciaPercorrida = (double)(time - this.fireTime) * this.getBulletSpeed();
        }

        public double getDistanciaInicial() {
            return this.distanciaInicial;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OndaDoInimigo [posicaoInicial=");
            builder.append(this.posicaoInicial);
            builder.append(", fireTime=");
            builder.append(this.fireTime);
            builder.append(", distanciaPercorrida=");
            builder.append(this.distanciaPercorrida);
            builder.append(", enemyVelocity=");
            builder.append(this.enemyVelocity);
            builder.append("SEGMENTS:").append(this.getSegLastVelocity()).append(" ").append(this.getSegVelocity()).append(" ").append(this.getSegDistanciaInicial());
            builder.append("]");
            return builder.toString();
        }
    }

    class ScannedRobot {
        public String name = "";
        public double energy = 0.0;
        public double bearing = 0.0;
        public long time = 0L;
        public double velocity = 0.0;
        public Point2D localizacaoInimigo;

        ScannedRobot() {
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.time + " " + this.energy + " " + this.bearing;
        }
    }

    class Surf {
        Dodger r;

        public Surf(Dodger r) {
            this.r = r;
        }

        public Point2D predictPosition(OndaDoInimigo surfWave, int direction) {
            Point2D predictedPosition = (Point2D)this.r.getLocalizacao().clone();
            double predictedVelocity = Dodger.this.getVelocity();
            double predictedHeading = Dodger.this.getHeadingRadians();
            int counter = 0;
            boolean intercepted = false;
            do {
                double moveAngle = this.wallSmoothing(predictedPosition, DodgerUtils.absoluteBearing(surfWave.getPosicaoInicial(), predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
                double moveDir = 1.0;
                if (Math.cos(moveAngle) < 0.0) {
                    moveAngle += Math.PI;
                    moveDir = -1.0;
                }
                moveAngle = Utils.normalRelativeAngle((double)moveAngle);
                double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
                predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + DodgerUtils.limit(-maxTurning, moveAngle, maxTurning)));
                predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
                predictedVelocity = DodgerUtils.limit(-8.0, predictedVelocity, 8.0);
                predictedPosition = this.project(predictedPosition, predictedHeading, predictedVelocity);
                ++counter;
                if (!(predictedPosition.distance(surfWave.getPosicaoInicial()) < surfWave.getDistanciaPercorrida() + (double)counter * surfWave.getBulletSpeed() + surfWave.getBulletSpeed())) continue;
                intercepted = true;
            } while (!intercepted && counter < 500);
            return predictedPosition;
        }

        public double checkDanger(OndaDoInimigo surfWave, int direction) {
            int index = DodgerUtils.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
            return surfStats[surfWave.getSegLastVelocity()][surfWave.getSegVelocity()][surfWave.getSegDistanciaInicial()][index];
        }

        public OndaDoInimigo getClosestSurfableWave() {
            double closestDistance = 50000.0;
            OndaDoInimigo surfWave = null;
            int x = 0;
            while (x < Dodger.this.ondasDoInimigo.size()) {
                OndaDoInimigo ew = (OndaDoInimigo)Dodger.this.ondasDoInimigo.get(x);
                double distance = Dodger.this.localizacao.distance(ew.getPosicaoInicial()) - ew.getDistanciaPercorrida();
                if (distance > ew.getBulletSpeed() && distance < closestDistance) {
                    surfWave = ew;
                    closestDistance = distance;
                }
                ++x;
            }
            return surfWave;
        }

        public OndaDoInimigo getClosestToHitSurfableWave() {
            OndaDoInimigo surfWave = null;
            long longestTimeToHit = 50000L;
            int x = 0;
            while (x < Dodger.this.ondasDoInimigo.size()) {
                OndaDoInimigo ew = (OndaDoInimigo)Dodger.this.ondasDoInimigo.get(x);
                double distance = Dodger.this.localizacao.distance(ew.getPosicaoInicial()) - ew.getDistanciaPercorrida();
                long timeToHit = (long)(distance / ew.getBulletSpeed());
                if (timeToHit < longestTimeToHit) {
                    surfWave = ew;
                    longestTimeToHit = timeToHit;
                }
                ++x;
            }
            return surfWave;
        }

        public void doSurfing() {
            OndaDoInimigo surfWave = this.getClosestToHitSurfableWave();
            if (surfWave == null) {
                return;
            }
            double dangerLeft = this.checkDanger(surfWave, -1);
            double dangerRight = this.checkDanger(surfWave, 1);
            double goAngle = DodgerUtils.absoluteBearing(surfWave.getPosicaoInicial(), Dodger.this.localizacao);
            goAngle = dangerLeft < dangerRight ? this.wallSmoothing(Dodger.this.localizacao, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(Dodger.this.localizacao, goAngle + 1.5707963267948966, 1);
            this.setBackAsFront(goAngle);
        }

        public void setBackAsFront(double goAngle) {
            double angle = Utils.normalRelativeAngle((double)(goAngle - this.r.getHeadingRadians()));
            if (Math.abs(angle) > 1.5707963267948966) {
                if (angle < 0.0) {
                    this.r.setTurnRightRadians(Math.PI + angle);
                } else {
                    this.r.setTurnLeftRadians(Math.PI - angle);
                }
                this.r.setBack(100.0);
            } else {
                if (angle < 0.0) {
                    this.r.setTurnLeftRadians(-1.0 * angle);
                } else {
                    this.r.setTurnRightRadians(angle);
                }
                this.r.setAhead(100.0);
            }
        }

        public double wallSmoothing(Point2D botLocation, double angle, int orientation) {
            while (!_fieldRect.contains(this.project(botLocation, angle, WALL_STICK))) {
                angle += (double)orientation * 0.05;
            }
            angle = this.smoothWest(581.0 - botLocation.getY(), angle - 1.5707963267948966, orientation) + 1.5707963267948966;
            angle = this.smoothWest(781.0 - botLocation.getX(), angle + Math.PI, orientation) - Math.PI;
            angle = this.smoothWest(botLocation.getY() - 19.0, angle + 1.5707963267948966, orientation) - 1.5707963267948966;
            angle = this.smoothWest(botLocation.getX() - 19.0, angle, orientation);
            angle = this.smoothWest(botLocation.getY() - 19.0, angle + 1.5707963267948966, orientation) - 1.5707963267948966;
            angle = this.smoothWest(781.0 - botLocation.getX(), angle + Math.PI, orientation) - Math.PI;
            angle = this.smoothWest(581.0 - botLocation.getY(), angle - 1.5707963267948966, orientation) + 1.5707963267948966;
            return angle;
        }

        double smoothWest(double dist, double angle, int oDir) {
            if (dist < -160.0 * Math.sin(angle)) {
                return Math.acos((double)oDir * dist / 160.0) - (double)oDir * 1.5707963267948966;
            }
            return angle;
        }

        public Point2D project(Point2D sourceLocation, double angle, double length) {
            return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        }
    }
}

