/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Deque;
import pa3k.AngleUtils;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.SelfTracking;
import robocode.Bullet;
import robocode.Rules;
import robocode.util.Utils;

public class BulletTracking {
    protected double energy;
    protected Position source;
    protected long time;
    protected Position target;
    protected double targetVelocity;
    protected double targetHeading;
    protected Opponent owner;
    protected Position positiveEscapePosition;
    protected Position negativeEscapePosition;
    protected double positiveAngle;
    protected double middleAngle;
    protected double negativeAngle;
    protected Bullet bullet;
    protected Opponent targetOpponent;
    protected double firingAngle;
    protected boolean evaded;
    protected double aimingRatio = -1.0;
    protected double distance = -1.0;
    protected boolean towardWall;

    public BulletTracking clone() {
        BulletTracking copy = new BulletTracking(this.energy, this.time);
        copy.source = this.source;
        copy.target = this.target;
        copy.targetVelocity = this.targetVelocity;
        copy.targetHeading = this.targetHeading;
        copy.owner = this.owner;
        copy.positiveEscapePosition = this.positiveEscapePosition;
        copy.negativeEscapePosition = this.negativeEscapePosition;
        copy.positiveAngle = this.positiveAngle;
        copy.middleAngle = this.middleAngle;
        copy.negativeAngle = this.negativeAngle;
        copy.bullet = this.bullet;
        copy.targetOpponent = this.targetOpponent;
        copy.firingAngle = this.firingAngle;
        copy.evaded = this.evaded;
        copy.towardWall = this.towardWall;
        return copy;
    }

    public BulletTracking(double energy, Position source, Opponent target, long currentTime) {
        this.source = new Position(source);
        this.targetOpponent = target;
        this.time = currentTime;
        this.towardWall = false;
        try {
            this.target = new Position(target.getLastPosition(currentTime));
            this.targetVelocity = target.getLastVelocity(currentTime);
            this.targetHeading = target.getLastHeading(currentTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.energy = energy;
        this.bullet = null;
        this.evaded = false;
        this.computeEscapes(null);
    }

    public BulletTracking(double energy, long time) {
        this.energy = energy;
        this.time = time;
        this.bullet = null;
        this.evaded = false;
        this.towardWall = false;
    }

    public void setValues(Position source, SelfTracking st, Opponent owner) throws Exception {
        this.source = new Position(source);
        try {
            this.target = new Position(st.getLastPosition(1));
            this.targetVelocity = st.getLastVelocity(1);
            this.targetHeading = st.getLastHeading(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.owner = owner;
        this.targetOpponent = null;
        this.computeEscapes(st);
    }

    public void setValues(Bullet bullet, long time) {
        this.time = time;
        this.bullet = bullet;
        this.owner = null;
        this.computeEscapes(null);
    }

    private void computeEscapes(SelfTracking st) {
        assert (this.time != 0L);
        double maxVelocity = 8.0;
        Position projection = this.target;
        if (this.targetOpponent != null) {
            projection = this.targetOpponent.projectPosition(this.source, this.getVelocity(), this.time, -1);
            this.negativeEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), -1, maxVelocity, -1);
            this.positiveEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), 1, maxVelocity, -1);
        } else {
            projection = st.projectPosition(this.source, this.getVelocity(), 1);
            this.negativeEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), -1, maxVelocity, 1);
            this.positiveEscapePosition = this.target.computeEscapePosition(this.targetVelocity, this.targetHeading, this.source, this.getVelocity(), 1, maxVelocity, 1);
        }
        if (projection.isWallCorrected()) {
            this.towardWall = true;
        }
        this.positiveAngle = this.source.getDirectionTo(this.positiveEscapePosition);
        this.negativeAngle = this.source.getDirectionTo(this.negativeEscapePosition);
        this.middleAngle = this.source.getDirectionTo(projection);
        assert (!Double.isNaN(this.positiveAngle));
        assert (!Double.isNaN(this.middleAngle));
        assert (!Double.isNaN(this.negativeAngle));
        if (AngleUtils.difference(this.positiveAngle, this.negativeAngle) > 0.0) {
            if (AngleUtils.difference(this.middleAngle, this.negativeAngle) < 0.0) {
                this.middleAngle = Utils.normalAbsoluteAngle((double)(this.negativeAngle + 0.03));
            } else if (AngleUtils.difference(this.positiveAngle, this.middleAngle) < 0.0) {
                this.middleAngle = Utils.normalAbsoluteAngle((double)(this.positiveAngle - 0.03));
            }
        } else if (AngleUtils.difference(this.middleAngle, this.negativeAngle) > 0.0) {
            this.middleAngle = Utils.normalAbsoluteAngle((double)(this.negativeAngle - 0.03));
        } else if (AngleUtils.difference(this.positiveAngle, this.middleAngle) > 0.0) {
            this.middleAngle = Utils.normalAbsoluteAngle((double)(this.positiveAngle + 0.03));
        }
    }

    public double getAngleAdvance() {
        int width = 25;
        if (AngleUtils.difference(this.positiveAngle, this.negativeAngle) > 0.0) {
            return Math.atan2(width, this.source.distance(this.target));
        }
        return Math.atan2(width, this.source.distance(this.target)) * -1.0;
    }

    public double getRandomHitProbability() {
        double d = AngleUtils.difference(this.positiveAngle, this.negativeAngle);
        if (Math.abs(d) < 0.005) {
            return 1.0;
        }
        double p = this.getAngleAdvance() / d;
        if (p > 1.0) {
            p = 1.0;
        }
        if (p <= 0.0) {
            p = 1.0;
        }
        return p;
    }

    public double getVelocity() {
        return Rules.getBulletSpeed((double)this.energy);
    }

    public double getAimingRatio(Position position) {
        return this.getAimingRatio(this.source.getDirectionTo(position));
    }

    public double getAimingRatio() {
        if (this.aimingRatio == -1.0) {
            this.aimingRatio = this.getAimingRatio(this.firingAngle);
        }
        return this.aimingRatio;
    }

    public double getAimingRatio(double firingAngle) {
        double negAiming = AngleUtils.difference(firingAngle, this.negativeAngle) / AngleUtils.difference(this.middleAngle, this.negativeAngle);
        double posAiming = AngleUtils.difference(firingAngle, this.middleAngle) / AngleUtils.difference(this.positiveAngle, this.middleAngle);
        if (negAiming < 0.0) {
            return 0.0;
        }
        if (posAiming > 1.0) {
            return 1.0;
        }
        if (posAiming < 0.0) {
            return negAiming / 2.0;
        }
        return posAiming / 2.0 + 0.5;
    }

    public static BulletTracking remove(Deque<BulletTracking> queue, Bullet b) {
        BulletTracking bt2 = null;
        for (BulletTracking bt2 : queue) {
            if (bt2.getBullet() != b) continue;
            queue.remove(bt2);
            break;
        }
        return bt2;
    }

    public long getETA(Position p) {
        return this.time + Math.round(this.source.distance(p) / this.getVelocity()) - 1L;
    }

    public double getEnergy() {
        return this.energy;
    }

    public Opponent getOwner() {
        return this.owner;
    }

    public long getTime() {
        return this.time;
    }

    public Position getSource() {
        return this.source;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public Opponent getTargetOpponent() {
        return this.targetOpponent;
    }

    public void onPaint(Graphics2D g) {
        g.drawLine((int)this.source.x, (int)this.source.y, (int)this.negativeEscapePosition.x, (int)this.negativeEscapePosition.y);
        g.drawLine((int)this.source.x, (int)this.source.y, (int)this.positiveEscapePosition.x, (int)this.positiveEscapePosition.y);
    }

    public double getDamage() {
        return Rules.getBulletDamage((double)this.energy);
    }

    public Position getPositiveEscapePosition() {
        return this.positiveEscapePosition;
    }

    public double getFiringAngle() {
        return this.firingAngle;
    }

    public void setFiringAngle(double firingAngle) {
        this.firingAngle = firingAngle;
        if (AngleUtils.difference(this.positiveAngle, this.negativeAngle) > 0.0) {
            if (AngleUtils.difference(firingAngle, this.negativeAngle) < 0.0) {
                this.firingAngle = this.negativeAngle + 0.03;
            } else if (AngleUtils.difference(this.positiveAngle, firingAngle) < 0.0) {
                this.firingAngle = this.positiveAngle - 0.03;
            }
        } else if (AngleUtils.difference(firingAngle, this.negativeAngle) > 0.0) {
            this.firingAngle = this.negativeAngle - 0.03;
        } else if (AngleUtils.difference(this.positiveAngle, firingAngle) > 0.0) {
            this.firingAngle = this.positiveAngle + 0.03;
        }
    }

    public Position getNegativeEscapePosition() {
        return this.negativeEscapePosition;
    }

    public Position getTarget() {
        return this.target;
    }

    public double getPositiveAngle() {
        return this.positiveAngle;
    }

    public double getMiddleAngle() {
        return this.middleAngle;
    }

    public double getNegativeAngle() {
        return this.negativeAngle;
    }

    public String toString() {
        return "Source " + this.source + "@" + this.time + "(" + this.energy + ") -> " + this.negativeAngle + ", " + this.middleAngle + ", " + this.positiveAngle;
    }

    public void setEvaded() {
        this.evaded = true;
    }

    public boolean getEvaded() {
        return this.evaded;
    }

    public double getDistance() {
        if (this.distance == -1.0) {
            this.distance = this.source.distance(this.target);
        }
        return this.distance;
    }

    public double[] getEscapeBins() {
        assert (this.owner != null);
        return this.owner.getOpponentAiming().getEscapeBins(this);
    }

    public boolean isTowardWall() {
        return this.towardWall;
    }

    public void paint(int level, long now) {
        Log.paintCircle(level, this.source, (int)(Rules.getBulletSpeed((double)this.energy) * (double)(now - this.time)), new Color(255, 255, 255, 100), 0);
    }
}

