/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import pedersen.core.Combatant;
import pedersen.core.Conversions;
import pedersen.core.SnapshotImpl;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.debug.GraphicalDebugger;
import pedersen.debug.TracerBank;
import pedersen.debug.profiling.Stopwatches;
import pedersen.divination.CombatWaveBase;
import pedersen.divination.WaveInboundBank;
import pedersen.divination.WaveOutboundBank;
import pedersen.misc.Arena;
import pedersen.misc.Host;
import pedersen.misc.Metrics;
import pedersen.misc.Persistence;
import pedersen.opponent.OpponentLibrary;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.opponent.TargetFactory;
import pedersen.systems.FireControl;
import pedersen.tactics.grail.Grid;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.movement.MovementMethodSetBuilder;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public abstract class Foundation
extends AdvancedRobot
implements Debuggable {
    private final Color chassis;
    private final Color turret;
    private final Color radar;
    private int turnSkipCount = 0;
    private boolean recalibrate = false;
    private static boolean operational = false;
    private static final boolean killswitch = true;

    protected Foundation(Color newChassis, Color newTurret, Color newRadar) {
        this.chassis = newChassis;
        this.turret = newTurret;
        this.radar = newRadar;
    }

    public void run() {
        this.battleSetup();
        while (true) {
            this.processTurn();
        }
    }

    private void roundSetup() {
        this.setColors(this.chassis, this.turret, this.radar);
        Debug.singleton.setPrintStream(this.out);
        Persistence.singleton = new Persistence(this.getDataDirectory());
        TargetBank.singleton.deactivateAllTargets();
        Grid.singleton.roundTeardown();
        WaveInboundBank.singleton.roundTeardown();
        WaveOutboundBank.singleton.roundTeardown();
        WaveInboundBank.singleton.purge();
        WaveOutboundBank.singleton.purge();
        Combatant.getCombatant().roundSetup();
        this.recalibrateCombatantNextTurn();
    }

    private void battleSetup() {
        Debug.singleton.setPrintStream(this.out);
        Persistence.singleton = new Persistence(this.getDataDirectory());
        Host.singleton = new Host(this);
        Arena.init(Host.singleton.getBattleFieldWidth(), Host.singleton.getBattleFieldHeight());
        boolean bl = operational = Host.singleton.getRounds() == 35L;
        if (!operational) {
            Debug.line("This bot will only participate in 35 round battles.");
        }
        GraphicalDebugger.singleton.init(Host.singleton.getBattleFieldHeight());
        if (Host.singleton.isFirstRound()) {
            OpponentLibrary.singleton.setup();
        }
    }

    protected void processTurn() {
        Stopwatches.foundationTurnProcess.start();
        Host.singleton.initializeTurn(this);
        if (Host.singleton.isFirstTurn()) {
            this.roundSetup();
        }
        try {
            if (this.recalibrate) {
                Combatant.getCombatant().recalibrate(this);
                this.recalibrate = false;
            }
            ++Metrics.turnsProcessed;
            this.turnSetup();
            if (operational) {
                Combatant.getCombatant().operate(this);
            }
            this.turnTeardown();
            Host.singleton.applyInstructions(this);
            this.execute();
        }
        catch (Exception ex) {
            ++Metrics.exceptionsThrown;
            ex.printStackTrace();
        }
        Stopwatches.foundationTurnProcess.stop();
    }

    private void turnSetup() {
    }

    private void turnTeardown() {
        Stopwatches.foundationTurnPostProcess.start();
        long time = Host.singleton.getTurn();
        Stopwatches.foundationTurnPostProcessInboundWave.start();
        WaveInboundBank.singleton.process(time + 1L);
        Stopwatches.foundationTurnPostProcessInboundWave.stop();
        Stopwatches.foundationTurnPostProcessOutboundWave.start();
        WaveOutboundBank.singleton.process(time + 1L);
        Stopwatches.foundationTurnPostProcessOutboundWave.stop();
        ++this.turnSkipCount;
        while (this.turnSkipCount > 0) {
            TargetBank.singleton.projectPositions();
            --this.turnSkipCount;
        }
        Stopwatches.foundationTurnPostProcess.stop();
    }

    public abstract MovementMethodSetBuilder getMovementMethods();

    public abstract MovementMethodSet getMovementMethods(int var1);

    public abstract List getDefensiveTargetingMethods();

    public abstract List getOffensiveTargetingMethods();

    public abstract FireControl getFireControl();

    public void onCustomEvent(CustomEvent event) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        Metrics.incrementBulletHitBulletCount();
    }

    public void onBulletHit(BulletHitEvent event) {
        Host.singleton.initializeTurn(this);
        double firepower = event.getBullet().getPower();
        Metrics.bulletHitTarget(firepower);
        Target vaultEntry = TargetBank.singleton.findByName(event.getName());
        if (vaultEntry != null) {
            vaultEntry.receiveBulletDamage(Conversions.getBulletDamageFromFirepower(firepower));
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        Host.singleton.initializeTurn(this);
        double firepower = event.getBullet().getPower();
        Metrics.bulletHitCombatant(firepower);
        Combatant.getCombatant().onHitByBullet();
        this.recalibrateCombatantNextTurn();
        Target vaultEntry = TargetBank.singleton.findByName(event.getName());
        if (vaultEntry != null) {
            vaultEntry.dealBulletDamage(Conversions.getBulletDamageFromFirepower(firepower));
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        ++this.turnSkipCount;
        ++Metrics.turnsSkipped;
    }

    public void onHitWall(HitWallEvent e) {
        Host.singleton.initializeTurn(this);
        Metrics.collisionWithWall();
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobot) {
        Host.singleton.initializeTurn(this);
        double absoluteBearing = Host.singleton.getChassisHeading() + scannedRobot.getBearingRadians();
        double scannedRobotX = Host.singleton.getChassisX() + Math.sin(absoluteBearing) * scannedRobot.getDistance();
        double scannedRobotY = Host.singleton.getChassisY() + Math.cos(absoluteBearing) * scannedRobot.getDistance();
        String contactName = scannedRobot.getName();
        Target vaultEntry = TargetBank.singleton.findByName(contactName);
        if (vaultEntry == null) {
            vaultEntry = TargetFactory.produce(contactName, this);
            TargetBank.singleton.add(vaultEntry);
        }
        SnapshotImpl radarScan = new SnapshotImpl(Host.singleton.getRound(), Host.singleton.getTurn(), scannedRobotX, scannedRobotY, scannedRobot.getHeadingRadians(), scannedRobot.getVelocity(), scannedRobot.getEnergy());
        vaultEntry.update(radarScan);
        Combatant.getCombatant().scan(vaultEntry, this);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        Host.singleton.initializeTurn(this);
        String contactName = event.getName();
        Target vaultEntry = TargetBank.singleton.findByName(contactName);
        if (vaultEntry != null) {
            Combatant.getCombatant().retire(vaultEntry, this);
            vaultEntry.deactivate();
        }
        this.recalibrateCombatantNextTurn();
        if (Host.singleton.isEveryoneDead()) {
            this.roundTeardown(false);
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        Host.singleton.initializeTurn(this);
        Metrics.collisionWithRobot();
    }

    public void onWin(WinEvent event) {
        WaveOutboundBank.singleton.cancelAll();
    }

    public void onDeath(DeathEvent event) {
        WaveInboundBank.singleton.cancelAll();
        WaveOutboundBank.singleton.cancelAll();
        this.roundTeardown(true);
    }

    private void roundTeardown(boolean complete) {
        if (complete) {
            TargetBank.singleton.roundTearDown();
            Combatant.getCombatant().roundTeardown();
            Grid.singleton.purge();
            WaveInboundBank.singleton.roundTeardown();
            WaveOutboundBank.singleton.roundTeardown();
            TracerBank.singleton.roundTeardown();
        }
        Metrics.place(Host.singleton.getActiveEnemyCount());
        if (Host.singleton.isLastRound()) {
            this.battleTeardown();
        }
    }

    private void battleTeardown() {
        OpponentLibrary.singleton.teardown();
        TargetBank.singleton.teardown();
        Debug.singleton.teardown();
    }

    private void recalibrateCombatantNextTurn() {
        this.recalibrate = true;
    }

    public void onPaint(Graphics2D console) {
        try {
            Host.singleton.initializeTurn(this);
        }
        catch (Exception ex) {
            Debug.exception("Foundation.onPaint (or aggregate)", ex);
        }
    }

    public void debug() {
        Metrics.getStatistics();
        OpponentLibrary.singleton.debug();
        TargetFactory.debug();
        TargetBank.singleton.debug();
        WaveInboundBank.singleton.debug();
        WaveOutboundBank.singleton.debug();
        Debug.debug("Firing angles associated with waves: " + CombatWaveBase.totalFiringAngles);
    }
}

