/*
 * Decompiled with CFR 0.152.
 */
package AIR;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class iRobot
extends AdvancedRobot {
    static Point2D hostileLocation;
    static double hostileVelocity;
    static double bearingDirection;
    static double direction;
    static double hostileFirePower;
    static int hits;
    static double tries;
    private int lastScan = 20;
    static double hostileAbsoluteBearing;
    static final double A = 800.0;
    static final double B = 0.5;
    static final double C = 0.75;
    static final int DISTANCE = 5;
    static final int VELOCITY = 5;
    static final int FACTORS = 33;
    static final int MIDDLE = 16;
    static int[][][] aimFactors;

    static {
        direction = 0.3;
        aimFactors = new int[5][5][33];
    }

    public void run() {
        this.setBodyColor(Color.black);
        this.setGunColor(Color.black);
        this.setScanColor(Color.black);
        this.setRadarColor(Color.white);
        this.setBulletColor(Color.red);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.scanning();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Point2D robotDestination;
        hostileAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        Wave wave = new Wave();
        wave.location = new Point2D.Double(this.getX(), this.getY());
        double hostileDistance = e.getDistance();
        hostileLocation = iRobot.project(wave.location, hostileAbsoluteBearing, hostileDistance);
        this.lastScan = 0;
        this.setBodyColor(Color.black);
        this.setGunColor(Color.black);
        this.setScanColor(Color.black);
        this.setRadarColor(Color.white);
        this.setBulletColor(Color.red);
        Rectangle2D.Double fieldRectangle = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        tries = 0.0;
        while (!fieldRectangle.contains(robotDestination = iRobot.project(hostileLocation, hostileAbsoluteBearing + Math.PI + direction, hostileDistance * (1.2 - tries / 100.0))) && tries < 100.0) {
            tries += 1.0;
        }
        if (hits > 2 && (Math.random() < iRobot.bulletVelocity(hostileFirePower) / 0.5 / hostileDistance || tries > hostileDistance / iRobot.bulletVelocity(hostileFirePower) / 0.75)) {
            direction = -direction;
        }
        double angle = iRobot.absoluteBearing(wave.location, robotDestination) - this.getHeadingRadians();
        this.setAhead(Math.cos(angle) * 100.0);
        this.setTurnRightRadians(Math.tan(angle));
        hostileVelocity = e.getVelocity();
        int velocityIndex = (int)Math.abs(hostileVelocity / 5.0);
        if (hostileVelocity != 0.0) {
            bearingDirection = hostileVelocity * Math.sin(e.getHeadingRadians() - hostileAbsoluteBearing) > 0.0 ? 0.04375 : -0.04375;
        } else if (hostileVelocity == 0.0 && e.getEnergy() == 0.0) {
            this.setBodyColor(Color.red);
            this.setGunColor(Color.red);
            this.setRadarColor(Color.red);
            this.goTo(hostileLocation);
        }
        wave.bearingDirection = bearingDirection;
        int distanceIndex = (int)(hostileDistance / 160.0);
        wave.power = Math.min(e.getEnergy() / 4.0, distanceIndex > 1 ? 1.9 : 3.0);
        distanceIndex = (int)(hostileDistance / 160.0);
        wave.factors = aimFactors[distanceIndex][velocityIndex];
        wave.bearing = hostileAbsoluteBearing;
        int mostVisited = 16;
        int i = 33;
        do {
            if (wave.factors[--i] <= wave.factors[mostVisited]) continue;
            mostVisited = i;
        } while (i > 0);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(hostileAbsoluteBearing - this.getGunHeadingRadians() + wave.bearingDirection * (double)(mostVisited - 16))));
        if (e.getEnergy() != 0.0) {
            this.setFire(wave.power);
        }
        if (this.getEnergy() >= 0.0) {
            this.addCustomEvent(wave);
        }
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 200) {
            Color robotColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            Color gunColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            Color radarColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.setColors(robotColor, gunColor, radarColor);
            this.setTurnGunRight(Double.POSITIVE_INFINITY);
            this.setTurnLeft(Double.POSITIVE_INFINITY);
            this.execute();
            ++i;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (tries < 30.0) {
            ++hits;
        }
        hostileFirePower = e.getPower();
    }

    static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public void scanning() {
        ++this.lastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.lastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - hostileAbsoluteBearing));
            radarOffset += (double)this.sign(radarOffset) * 0.04;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    public int sign(double x) {
        if (x > 0.0) {
            return 1;
        }
        return -1;
    }

    private void goTo(Point2D destination) {
        Point2D.Double location = new Point2D.Double(this.getX(), this.getY());
        double distance = location.distance(destination);
        double angle = this.normalRelativeAngle(Math.toDegrees(iRobot.absoluteBearing(location, destination)) - this.getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        this.setTurnRight(angle);
        this.setAhead(distance);
    }

    private double normalRelativeAngle(double angle) {
        angle = Math.toRadians(angle);
        return Math.toDegrees(Math.atan2(Math.sin(angle), Math.cos(angle)));
    }

    class Wave
    extends Condition {
        double power;
        double bearing;
        double bearingDirection;
        double distance;
        Point2D location;
        int[] factors;

        Wave() {
        }

        public boolean test() {
            double d;
            this.distance += iRobot.bulletVelocity(this.power);
            if (d > this.location.distance(hostileLocation)) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(iRobot.absoluteBearing(this.location, hostileLocation) - this.bearing)) / this.bearingDirection + 16.0);
                    this.factors[n] = this.factors[n] + 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iRobot.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

