/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.Pray;
import cbot.cbot.gun.GunStrategy;
import cbot.cbot.gun.SectorStatisticGunStrategy;
import cbot.cbot.gun.VirtualBulletManager;
import robocode.Condition;

public class VirtualBullet
extends Condition {
    public static final int BULLET_HIT = 1;
    public static final int BULLET_ACTIVE = 0;
    public static final int BULLET_DEAD = -1;
    private CBot robot;
    private Bot master;
    private VirtualBulletManager manager;
    private Bot pray;
    private GunStrategy[] strategys;
    private Point firePoint;
    private double absFireBearing;
    private double[] angles;
    private double bulletVelocity;
    private long fireTime;

    public boolean test() {
        long travelTime = this.robot.getTime() - this.fireTime;
        double travelDistance = this.bulletVelocity * (double)travelTime;
        double prayDistance = this.firePoint.getDistance(this.pray.getCordinate());
        double diff = prayDistance - travelDistance;
        boolean bl = false;
        if (diff < 20.0 && diff > -20.0) {
            bl = true;
        }
        return bl;
    }

    public void updateHittingRates() {
        double hitAngle = CU.normalRelativeRadians(this.firePoint.getAngle(this.pray.getCordinate()) - this.absFireBearing);
        ((SectorStatisticGunStrategy)CBot.gun.sectorsStatisticGunStrategy).updateStatistics((Pray)this.pray, hitAngle);
        long now = this.robot.getTime();
        int i = 0;
        while (i < this.angles.length) {
            boolean hit = false;
            double fraction = 0.0;
            while (fraction < 1.05) {
                double travelDistance = this.bulletVelocity * ((double)(now - this.fireTime) - fraction);
                Point bulletPoint = Point.getNewPoint(this.firePoint, travelDistance, this.angles[i]);
                hit = bulletPoint.inArea(this.pray.getCordinate(), 20.0);
                if (hit) break;
                fraction += 0.1;
            }
            this.manager.addHit(i, hit);
            ++i;
        }
    }

    public VirtualBullet(Bot pray, VirtualBulletManager manager, CBot robot, GunStrategy[] strategys) {
        this.pray = pray;
        this.manager = manager;
        this.robot = robot;
        this.master = robot;
        this.strategys = strategys;
        this.absFireBearing = Math.toRadians(robot.getHeading() + pray.getBearing());
        this.firePoint = this.master.getCordinate();
        this.fireTime = robot.getTime();
        double pow = this.master.getFirePower(pray);
        this.bulletVelocity = CU.getBulletVelocity(pow);
        this.angles = new double[strategys.length];
        int i = 0;
        while (i < strategys.length) {
            double extraAngle = strategys[i].getBulletAngel(this.master, pray, pow);
            this.angles[i] = CU.normalRelativeRadians(extraAngle + this.absFireBearing);
            int n = i++;
            manager.totFired[n] = manager.totFired[n] + 1;
        }
        ((SectorStatisticGunStrategy)CBot.gun.sectorsStatisticGunStrategy).virtualBulletFired((Pray)pray);
    }
}

