/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.tactics.targeting.TargetingMethod;
import pedersen.tactics.targeting.TargetingStatistics;

public abstract class TargetingMethodBase
implements TargetingMethod {
    private final int persistenceId;
    private final TargetingStatistics real = new TargetingStatistics(this);
    private boolean isVirtual = false;

    public TargetingMethodBase(int newPersistenceId) {
        this.persistenceId = newPersistenceId;
    }

    public int getPersistenceId() {
        return this.persistenceId;
    }

    public TargetingStatistics getTargetingStatistics() {
        return this.real;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public TargetingMethod setVirtual() {
        this.isVirtual = true;
        return this;
    }

    public void onFire() {
    }

    public void debug() {
        Debug.debug(String.valueOf(this.getClass().getSimpleName()) + " " + this.real.getSummary());
    }

    public static int getBulletFlightTime(double distanceToTarget, double bulletVelocity) {
        return 1 + (int)(distanceToTarget / bulletVelocity);
    }

    public static double getBulletVelocity(double distanceToTarget, int bulletFlightTime) {
        return distanceToTarget / ((double)bulletFlightTime - 0.5);
    }

    public static boolean doesBulletIntersectTargetMidpoint(double distanceToTarget, double bulletVelocity, int timeToTarget) {
        return Constraints.isInRange(bulletVelocity * (double)(timeToTarget - 1), distanceToTarget, bulletVelocity * (double)timeToTarget);
    }
}

