/*
 * Decompiled with CFR 0.152.
 */
package xander.core;

import xander.core.AbstractXanderRobot;
import xander.core.Configuration;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.RobotStyle;
import xander.core.drive.DriveController;
import xander.core.gun.GunController;
import xander.core.radar.RadarController;
import xander.core.track.DriveStats;
import xander.core.track.GunStats;
import xander.core.track.OpponentGunWatcher;
import xander.core.track.SnapshotHistory;
import xander.core.track.WaveHistory;

public class Resources {
    private static long cumulativeTimeFromPreviousRounds;
    private static boolean roundActive;
    private static RadarController radarController;
    private static DriveController driveController;
    private static GunController gunController;
    private static OpponentGunWatcher opponentGunWatcher;
    private static RobotProxy robotProxy;
    private static RobotEvents robotEvents;
    private static GunStats gunStats;
    private static DriveStats driveStats;
    private static SnapshotHistory snapshotHistory;
    private static WaveHistory waveHistory;
    private static Configuration configuration;
    private static RobotStyle robotStyle;
    private static long winOrDeathTime;

    static {
        radarController = new RadarController();
        driveController = new DriveController();
        gunController = new GunController();
        robotProxy = new RobotProxy();
        robotEvents = new RobotEvents();
        configuration = new Configuration();
        robotStyle = new RobotStyle();
    }

    static void initialize(AbstractXanderRobot robot) {
        robotProxy.setRobot(robot);
        snapshotHistory = new SnapshotHistory(robot.getName(), robotProxy, configuration, robotEvents);
        opponentGunWatcher = new OpponentGunWatcher(snapshotHistory, configuration);
        waveHistory = new WaveHistory(gunController, opponentGunWatcher, robotEvents, robotProxy, snapshotHistory, configuration);
        gunStats = new GunStats(robotProxy, waveHistory, robotEvents, configuration);
        driveStats = new DriveStats(robotProxy, robotEvents, configuration);
    }

    static void beginRound(AbstractXanderRobot robot) {
        if (roundActive) {
            cumulativeTimeFromPreviousRounds += winOrDeathTime;
        }
        robotProxy.setRobot(robot);
        radarController.setRobot(robot);
        driveController.setRobot(robot);
        gunController.setRobot(robot);
        roundActive = true;
    }

    static void endRound() {
        if (roundActive) {
            if (Resources.robotProxy.robot != null) {
                cumulativeTimeFromPreviousRounds += robotProxy.getTime();
            }
            roundActive = false;
        }
    }

    static void onWinOrDeath() {
        if (Resources.robotProxy.robot != null) {
            winOrDeathTime = robotProxy.getTime();
        }
    }

    public static long getTime() {
        return Resources.robotProxy.robot == null ? 0L : robotProxy.getTime();
    }

    public static long getCumulativeTime() {
        if (Resources.robotProxy.robot == null) {
            return 0L;
        }
        if (roundActive) {
            return cumulativeTimeFromPreviousRounds + robotProxy.getTime();
        }
        return cumulativeTimeFromPreviousRounds;
    }

    public static RobotProxy getRobotProxy() {
        return robotProxy;
    }

    public static RobotEvents getRobotEvents() {
        return robotEvents;
    }

    public static SnapshotHistory getSnapshotHistory() {
        return snapshotHistory;
    }

    public static WaveHistory getWaveHistory() {
        return waveHistory;
    }

    public static GunStats getGunStats() {
        return gunStats;
    }

    public static DriveStats getDriveStats() {
        return driveStats;
    }

    static RadarController getRadarController() {
        return radarController;
    }

    static DriveController getDriveController() {
        return driveController;
    }

    static GunController getGunController() {
        return gunController;
    }

    static Configuration getConfiguration() {
        return configuration;
    }

    static RobotStyle getRobotStyle() {
        return robotStyle;
    }
}

