package kawigi.sbf.core.messages;
import java.io.*;
import java.awt.geom.*;

public class AllyUpdateMessage implements Serializable
{
	private String targetName, name;
	private double x, y;
	private boolean leader, droid, assassin;
	
	public AllyUpdateMessage(String name, String targetName, Point2D location, boolean leader, boolean droid, boolean assassin)
	{
		this.name = name;
		this.targetName = targetName;
		x = location.getX();
		y = location.getY();
		this.leader = leader;
		this.droid = droid;
		this.assassin = assassin;
	}
	
	public Point2D getLocation()
	{
		return new Point2D.Double(x, y);
	}
	
	public String getName()
	{
		return name;
	}
	
	public String getTarget()
	{
		return targetName;
	}
	
	public boolean isLeader()
	{
		return leader;
	}
	
	public boolean isDroid()
	{
		return droid;
	}
	
	public boolean isAssassin()
	{
		return assassin;
	}
}