package nat;

import java.awt.*;

import nat.move.BHMove;
import robocode.*;
import robocode.util.*;

public class BlackHole extends AdvancedRobot {
	
	public static final boolean ISTC = false;
	
	private BHMove move;
	private BHGun gun;

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.black, Color.black, Color.darkGray);

		move = new BHMove(this);
		gun = new BHGun(this);
		
		do {
			if (getRadarTurnRemaining() == 0)
				setTurnRadarRight(Double.POSITIVE_INFINITY);
			execute();
		} while (true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absBearing = e.getBearingRadians() + getHeadingRadians();

		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing
				- getRadarHeadingRadians()) * 2);
		if (!ISTC)
			move.onScannedRobot(e);
		gun.onScannedRobot(e);
	}
	
	public void onHitRobot(HitRobotEvent e) {
		move.onHitRobot(e);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		move.onBulletHit(e);
		gun.onBulletHit(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		move.onHitByBullet(e);
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		move.onBulletHitBullet(e);
	}
	
	public void onPaint(Graphics2D g) {
		move.onPaint(g);
		gun.onPaint(g);
	}
}
