package toz;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;

/**
 * Gnome - a tiny robot by TooZe
 */
public class Gnome extends AdvancedRobot
{
	//static double ScanWidth = 45;
	static double absoluteBearing;
	static double direction = 150;
	
	public void run() {
		setAdjustGunForRobotTurn(true);
		//setAdjustRadarForGunTurn(true);
		
		while(true) {
			// Radar
			setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			
			// Movement
			if(Math.random() > 0.93) { direction = -direction; }
			setAhead(direction);
			
			execute();
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		// Find position
		absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		
		// Radar (uses 24 byte)
		//ScanWidth = 2 * Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians());
		
		// Movement
		double a = absoluteBearing + .5*Math.PI; 
		int i = 0;
		while (!new Rectangle2D.Double( 22, 22, 756, 556 ).contains( getX() + Math.sin(a) * direction, getY() + Math.cos(a) * direction )) { 
			a -= direction / 1500; 
			i++;
		} 
		if (i > 9) { direction = -direction; }
		
		setTurnRightRadians(Utils.normalRelativeAngle(a - getHeadingRadians()));
		
		// Targeting
		//double u = a - actualHeading(e.getVelocity(), e.getHeadingRadians());
		double u = a - ((e.getVelocity() < 0) ? e.getHeadingRadians() + Math.PI : e.getHeadingRadians());
		//double changeBearing = Math.cos(u) * Math.abs(e.getVelocity());
		//absoluteBearing += Math.atan2(changeBearing, 14 + Math.sin(u));
		
		turnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing + Math.atan2(Math.cos(u) * Math.abs(e.getVelocity()), 14 + Math.sin(u)) - getGunHeadingRadians()));
		//turnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		
		setFire(2);
	}
	
	/*public double actualHeading(double vel, double head) {
		//return (vel < 0) ? head + Math.PI : head;
		if (vel < 0 ) {
			return head + Math.PI;
		}
		return head;
	}*/
}
