package jep.intelligence;
import java.awt.geom.Point2D;

import jep.Utils;
import robocode.*;

/**
 * Enemy - a class by (John Prideaux)
 */
public class Enemy
{
	private double bearing;
	private double bearingRadians;
	private double distance;
	private double energy;
	private double heading;
	private double headingRadians;
	private String name;
	private double velocity;
	private long lastScanned;
	private double turnRateRadians;
	private double x;
	private double y;
	
	public Enemy () {
	}
	
	public Enemy(ScannedRobotEvent e) {
		bearing = e.getBearing();
		bearingRadians = e.getBearingRadians();
		distance = e.getDistance();
		energy = e.getEnergy();
		heading = e.getHeading();
		headingRadians = e.getHeadingRadians();
		name = e.getName();
		velocity = e.getVelocity();
		lastScanned = e.getTime();
		turnRateRadians = 0;
		if (Utils.x > 0) {
			Point2D.Double enemyLoc = Utils.bearingAndDistanceToXY(Utils.x, Utils.y, Math.toDegrees(Utils.headingRadians), e.getBearing(), e.getDistance());
			x = enemyLoc.x;
			y = enemyLoc.y;
		}
	}
	/**
	 * @return double
	 */
	public double getBearing() {
		return bearing;
	}

	/**
	 * @return double
	 */
	public double getBearingRadians() {
		return bearingRadians;
	}

	/**
	 * @return double
	 */
	public double getDistance() {
		return distance;
	}

	/**
	 * @return double
	 */
	public double getEnergy() {
		return energy;
	}

	/**
	 * @return double
	 */
	public double getHeading() {
		return heading;
	}

	/**
	 * @return double
	 */
	public double getHeadingRadians() {
		return headingRadians;
	}

	/**
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return double
	 */
	public double getVelocity() {
		return velocity;
	}

	/**
	 * @return long
	 */
	public long getLastScanned() {
		return lastScanned;
	}

	/**
	 * @return
	 */
	public double getTurnRateRadians() {
		return turnRateRadians;
	}

	public void updateEnemy(ScannedRobotEvent e) {
		turnRateRadians = (e.getHeadingRadians() - headingRadians)/(e.getTime() - lastScanned);
		bearing = e.getBearing();
		bearingRadians = e.getBearingRadians();
		distance = e.getDistance();
		energy = e.getEnergy();
		heading = e.getHeading();
		headingRadians = e.getHeadingRadians();
		name = e.getName();
		velocity = e.getVelocity();
		lastScanned = e.getTime();		
		if (Utils.x > 0) {
			Point2D.Double enemyLoc = Utils.bearingAndDistanceToXY(Utils.x, Utils.y, Math.toDegrees(Utils.headingRadians), e.getBearing(), e.getDistance());
			x = enemyLoc.x;
			y = enemyLoc.y;
		}
	}
	/**
	 * @param d
	 */
	public void setEnergy(double d) {
		energy = d;
	}

	/**
	 * @return
	 */
	public double getX() {
		return x;
	}

	/**
	 * @return
	 */
	public double getY() {
		return y;
	}

}
