package ar.horizon.util;

import static ar.horizon.util.Util.*;
import static java.lang.Math.*;

import ar.horizon.stats.DCStatBufferParams;

/**
 * @author Aaron Rotenberg
 */
public abstract class FireRecordingBufferParams implements
		DCStatBufferParams<FireRecording> {
	private static final int DIMENSIONS = 7;

	public int getDimensions() {
		return DIMENSIONS;
	}

	public double[] getLocation(FireRecording hitRecording) {
		RobotRecording recording = hitRecording.getTargetRecording();

		double normalizedDistance =
				limit(0.0, recording.getEnemyDistance() / 500, 1.0);
		double normalizedVelocity =
				limit(0.0, abs(recording.getVelocity()) / MAX_VELOCITY, 1.0);
		double normalizedAcceleration =
				limit(0.0, abs(recording.getAcceleration()) / 2, 1.0);
		double normalizedLateralVelocity =
				limit(0.0, abs(recording.getLateralVelocity()) / MAX_VELOCITY,
						1.0);
		double normalizedTimeSinceAccel =
				limit(0.0, recording.getTimeSinceAcceleration() / 40, 1.0);
		double normalizedWallDistanceForward =
				limit(0.0, recording.getWallDistanceForward() / 2, 1.0);
		double normalizedWallDistanceBackward =
				limit(0.0, recording.getWallDistanceBackward() / 2, 1.0);

		double[] location = new double[DIMENSIONS];
		location[0] = normalizedDistance;
		location[1] = normalizedVelocity;
		location[2] = normalizedAcceleration;
		location[3] = normalizedLateralVelocity;
		location[4] = normalizedTimeSinceAccel;
		location[5] = normalizedWallDistanceForward;
		location[6] = normalizedWallDistanceBackward;
		return location;
	}

	public double getDistance(double[] location1, double[] location2) {
		double[] differences = new double[DIMENSIONS];
		for (int i = 0; i < DIMENSIONS; i++) {
			differences[i] = abs(location1[i] - location2[i]);
		}

		double distanceDifference = differences[0];
		double velocityDifference = differences[1];
		double accelerationDifference = differences[2];
		double lateralVelocityDifference = differences[3];
		double timeSinceAccelDifference = differences[4];
		double wallDistanceForwardDifference = differences[5];
		double wallDistanceBackwardDifference = differences[6];

		return getDistance(distanceDifference, velocityDifference,
				accelerationDifference, lateralVelocityDifference,
				timeSinceAccelDifference, wallDistanceForwardDifference,
				wallDistanceBackwardDifference);
	}

	protected abstract double getDistance(double distanceDifference,
			double velocityDifference, double accelerationDifference,
			double lateralVelocityDifference, double timeSinceAccelDifference,
			double wallDistanceForwardDifference,
			double wallDistanceBackwardDifference);

	public int getMaxClusterSize(int statBufferSize) {
		return (int) round(sqrt(statBufferSize));
	}
}
