package dam;

import robocode.*;
import dam.targetting.*;

import java.util.*;
import java.awt.geom.*;
import java.io.*;

import dam.util.*;

public class Target extends BasicTarget implements Serializable {
	private transient Vector bullets = new Vector();
	private int snapshots = 0;
	//private transient MasterBot bot;
	private double firePower = 0;
	private TargetModule tmodule;
	private double fearFactor = 500;
	private double score = 0;
	private double accuracy = 0;
	private double accuracyCount = 0;
	private boolean duelling = false;
	

	public Target(MasterBot r) {
		tmodule = new TargetModule(r, this);
	}


	public Target(ScannedRobotEvent e, MasterBot r) {
		this.name = e.getName();
		tmodule = new TargetModule(r, this);
		update(e, r);
	}

	/**
	 * This should only be called when deserializing from a file
	 */
	public void setBot(MasterBot m) {
		tmodule.setBot(m);
		bullets = new Vector();
	}
	
	public void addAccuracy(double val){ 
		accuracy += val; 
		accuracyCount++;
		
	}
	
	public double getAccuracy(){ 
		if(accuracyCount == 0) return 0;
		if(accuracy < 1) return 0;
		return (accuracy / accuracyCount);
	}
	
	public double getScore(){
		return score;
	}

	
	/**
	 * This is the power that this robot used when it last fired.
	 */
	public double getFirePower() {
		return firePower;
	}
	
	public void addScore(double val){ score += val; }


	public void addFearFactor(double fearFactorIncrement) {
		fearFactor += fearFactorIncrement;
	}
	
	public void setFearFactor(double ff){
		fearFactor = ff;
	}

	public TargettingStrategy getStrategy() {
		return tmodule.getStrategy();
	}

	public void update(ScannedRobotEvent e, AdvancedRobot r) {
		super.update(e, r);
		setHasFired(e, r);
		if (r.getTime() - lastScanTime > 20) {
			bullets.removeAllElements();
		}
		snapshots++;
		tmodule.update();
		duelling = (r.getOthers() < 2);
	}

	/**
	* The total number of times this target has been seen.
	*/
	public int getSnapshotCount() {
		return snapshots;
	}



	public double getDistance(Target t) {
		return BotMath.getRange(x, y, t.x, t.y);
	}

	/**
	* Note that this is not accurate. We need to improve this to
	* allow multiple bullet-dodging strategies.
	*/
	private void setHasFired(ScannedRobotEvent e, AdvancedRobot bot) {
		double energyChange = energy - e.getEnergy();
		if ((energyChange > 0)
			&& (energyChange <= 3)) { // naughty fellow tried to shoot me
			EnemyBullet b = new EnemyBullet(createTarget(bot), energyChange);
			firePower = energyChange;
			bullets.add(b);
			while (bullets.size() > 10)
				bullets.removeElementAt(0);
		}
	}

	public Vector getBullets() {
		return bullets;
	}

	/**
	* Tells you if this turn is when you should try to avoid his bullet
	*/
	public boolean shouldDodge(long gameTime) {
		Enumeration enum = bullets.elements();
		EnemyBullet b;
		boolean retval = false;
		while (enum.hasMoreElements()) {
			b = (EnemyBullet) enum.nextElement();
			if (b.getTime() + (b.getOriginalDistance() / 36) >= gameTime) {
				bullets.removeElement(b);
				retval = true;
				break;
			}
		}
		return retval;
	}

	
	
	public double getFearFactor(){
		return fearFactor;
	}

	/**
	* Sets the draw to -1 * fearFactor: repel for a target with plenty of energy. If the target
	* has less than 18 points energy (could be killed with a big fat bullet) sets the
	* draw to 30. Originally had it at 60, but this seemed to make him too eager to
	* fly into danger.
	*/
	public GridPoint getGridPoint() {
		double draw = fearFactor * -1;
		MasterBot bot = tmodule.getBot();
		if ((getEnergy() < 18)&&(bot.getEnergy() > 40)) // don't rush him unless you're strong
		{
			draw = 30;
		}
		return new GridPoint(x, y, draw);
	}

	

	public boolean nameEquals(String val) {
		return name.equals(val);
	}


	

	

}
