package hirataatsushi;



import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;



/**
 * Neo - a robot by Atsushi Hirata.
 */



/**
 * px̎舵́ARobocodẽftHg̗p
 * BȂ킿AYOxiOWAjBE
 * ivjɊpxB
 */



public class Neo extends AdvancedRobot
{
	//--------------------------------------------------
	/**
	 * ϐ錾
	 */
	//--------------------------------------------------
	private Hashtable		targets;		
	//SĂ̓Gĩf[^jnbVe[uɊi[܂B
	private NeosEnemy			target;
	//݂̕WII
	private final double	PI = Math.PI;	
	//̒萔BƁAptH[}X̂ȁEEE
	private double			firePower = 1;	
	//˂Ceɉ悤ƂĂGlM[		
	private int 			radius = 200;	
	//WI痣ׂ
	private int 			parcent = 20;	
	//WI痣ׂ̋e덷
	private int 			dirRadar = 1;	
	private int				radarDirection = 1;
	//[_[̉]
	private int				movementDirection = 1;		
	//is
	private double			previousEnergy;	
	//WI̒ÕGlM[
	Helper 					help = new Helper();	
	//pxϊAQ_ԋvZ
	private int				angleDivConst = 16;		
	//[_[ŃXLpx
	// WI͂PI/angleDivConst * 2 ̊pxXLB
	private Random			random = new Random();	
	//
	NeosEnemy currentTarget = new NeosEnemy();



	//-------------------------------------------------------
	/**
	 * run: Neo's default behavior
	 */
	//-------------------------------------------------------
	public void run() {

		out.println();
		out.println("public void run() called");
		out.println("   ...Now, System is Online...");

		out.println("   bot initialize");
		initVariables();	//ϐAIuWFNg̏
		initRobot();		//@̏
		out.println("   bot initialize done");

		out.println("   do radar full turn begin");
		doFullTurnScan();	//܂͑SʂXL
//		waitFor(new TurnCompleteCondition(this));
		out.println("   do radar full turn finished");
		
		while(true) {
			out.println("");
			out.println("");
			out.println("");
			out.println("   //**********************************************");
			out.println("   while(true) loop begin : GameTime > "+getTime());
			doScan();
			doMove();
			doFire();
			execute();
			out.println("   while(true) loop end   : GameTime > "+getTime());
			out.println("   //**********************************************");
			out.println("");
			out.println("");
			out.println("");
		}
	}



// ---------------------------------------------------------------------------
// Helper Methods
// ---------------------------------------------------------------------------

	/**
	 * private void initVariables() : variables initialize
	 */
	private void initVariables(){
		targets = new Hashtable();	//WIXgAbv
		target = new NeosEnemy();		//݂̕WI킷NX
									//̃CX^X𐶐
		//WI܂ł̋̒l傫Ȓlɏ邱ƂŁA
		//ŏ̕WIȉ̃\bhőIB
		target.distance = Double.POSITIVE_INFINITY;	
		out.println("      private void initVariables() called.");
	}





	/**
	 * private void initRobot() : bot initialize
	 */
	private void initRobot(){
		setColors(Color.black,Color.black,Color.black);
		//Qs̈Ӗ́A{bgACA[_[ꂼ̉]ƗƂƁB
		setAdjustGunForRobotTurn(true);
		//C̉]̓{bgij̉]ƗB
		setAdjustRadarForGunTurn(true);
		//[_[̉]̓{bgij̉]ƗB

		//[_]IƂɔCxg`
		addCustomEvent(new RadarTurnCompleteCondition(this) );
		out.println("      private void initRobot() called.");
	}





	/**
	 * private void doScan() : do Radar scan
	 */
	// SẴ[_[̓CxgR[hɈς˂ĂB
	private void doScan(){
	}






	/**
	 * private void doMove() : ړ
	 */
	private void doMove(){
		//WI͂邩H
			//
//		NeosEnemy currentTarget = getNearestTarget();
		if ( currentTarget.distance >= (radius ) ) {
			//Ƃ
			movementDirection = 1;
			//int serpentineMotion = (int)(getTime() % 2);	//֍s
			int serpentineMotion = random.nextInt(2);
			if (serpentineMotion == 0) serpentineMotion = -1;
			double theta = Math.asin(radius/currentTarget.distance) * serpentineMotion;
			goTo(radius * Math.sin(theta) + currentTarget.x ,
			     radius * Math.cos(theta) + currentTarget.y );
			out.println("         private void doMove() ---> target is far. serpentineMotion is "+serpentineMotion);
		}else{				
			//߂Ƃ
			//ȂɂȂB[_[ɂDodgeɂ䂾˂
			out.println("         private void doMove() ---> target is near.");
		}
			//Ȃ
		out.println("      private void doMove() called.");
	}




	/**
	 * private void doFire() : C
	 */
	private void doFire(){
		//WIƂ
		//WIƂ
		doGun();
		if (currentTarget.distance >= radius) {
			firePower = 1;
		} else {
			if (currentTarget.distance >= radius /2 ) {
				firePower = 2;
			} else {
				firePower = 3;
			}
		}
		if (currentTarget.name != null) fire(firePower);
		out.println("      private void doFire() called. Power is " + firePower);
	}



	/**
	 * void goTo(double x, double y) : W(xy)ɌēB
	 */
	void goTo(double x, double y) {
	    double dist = 20; 
	    double angle = help.getAbsBearingRadians(getX(),getY(),x,y);
	    double r = turnTo(angle);
	    setAhead(dist * r * movementDirection);
		out.println("      private void goTo( "+x+" , "+y+" ) called.");
	}



	/**
	 * double turnTo(double angle) : 	ƂĂցAʂ̖悤Ɍ
	 * 									ςBꂩ烍{bgsƂ
	 * 									֍sBpx̓WAŁB
	 * 									W(xy)ɌēB
	 */
	double turnTo(double angle) {
	    double ang;
    	int dir;
	    ang = help.normalizeBearingRadians(angle - getHeadingRadians() );
	    if (ang > (PI/2)) {
	        ang -= PI;
	        dir = -1;
	    }
	    else if (ang < -(PI/2)) {
	        ang += PI;
	        dir = -1;
	    }
	    else {
	        dir = 1;
	    }
	    setTurnRightRadians(ang);
		out.println("      private void turnTo( "+angle+" ) => "+dir+" called.");
		return dir;

	}


	/**
	 * double turnRadarTo(double angle) : 	
	 * 									ƂĂցAʂ̖悤Ɍ
	 * 									ςBꂩ烍{bgsƂ
	 * 									֍sBpx̓WAŁB
	 * 									W(xy)ɌēB
	 */
	double turnRadarTo(double angle) {
	    double ang;
    	int dir;
	    ang = help.normalizeBearingRadians( angle - getRadarHeadingRadians());
	    if (ang > (PI/2)) {
	        ang -= PI;
	        dir = -1;
	    }
	    else if (ang < -(PI/2)) {
	        ang += PI;
	        dir = -1;
	    }
	    else {
	        dir = 1;
	    }
	    setTurnRadarRightRadians(ang);
		out.println("      private void turnRadarTo() called.");
		return dir;
	}




	/**
	 * void doFullTurnScan() :	XLi[i[_[j]B
	 */

	void doFullTurnScan() {
		setTurnRadarRightRadians(2 * PI);
		out.println("      private void doFullTurnScan() called.");
	}

	
		
			
				
	/**
	 * void doGun() : 	EɏC邱ƁB
	 * 					C̓GƗ\։]B
	 */
	void doGun() {
		long time = getTime() 
					+ (int)Math.round(
						( help.getRange(getX(),getY(),target.x,target.y)
							 / 
						  ( 20 - ( 3 * firePower))
						)
					);
		/*
		@enemy classɔĂ钼Wݒ@ɊÂāA̖CɕKvȊpxقǖC炷B
		*/
		Point2D.Double p = currentTarget.guessPosition(time);
		double gunOffset =  Math.atan2( p.x - getX() , p.y - getY() ) - getGunHeadingRadians();
		setTurnGunRightRadians(help.normalizeBearingRadians(gunOffset));
	
		out.println("      private void doGun() called.");
	}
	
	
	public void sweep(){
		double	maxBearingAbs = 0,
				maxBearing = 0;
		int 	scannedBots = 0;
		Iterator targetIterator = targets.values().iterator();
		while(targetIterator.hasNext()){
			NeosEnemy tmp = (NeosEnemy)targetIterator.next();
			if ( tmp != null ){
				double bearing = help.normalizeBearingRadians( getHeadingRadians() 
					+ tmp.bearing - getRadarHeadingRadians() );
				if (Math.abs(bearing) > maxBearingAbs){
					maxBearingAbs = Math.abs(bearing);
					maxBearing=bearing;
				}
				scannedBots++;
			}
		}
		double radarTurn = Math.PI * radarDirection;
		if (scannedBots == getOthers())
			radarTurn = maxBearing + help.sign(maxBearing) * Math.PI/8;
		
		setTurnRadarRightRadians(radarTurn);
		radarDirection = (int)help.sign(radarTurn);
	}



	public NeosEnemy getNearestTarget(){
		double distance = Double.POSITIVE_INFINITY;
		Iterator iterator = targets.values().iterator();
		NeosEnemy current = new NeosEnemy();
		while(iterator.hasNext()){
			NeosEnemy tmp = (NeosEnemy)iterator.next();
			if ( tmp != null ){
				if ( distance > tmp.distance ) {
					distance = tmp.distance;
					current = tmp;
				} 
			}
		}
		return current;
	}



// -----------------------------------------------------------
// Event Codes
// -----------------------------------------------------------


	/**
	 * onRobotDeath(RobotDeathEvent e)
	 *
	 */
	public void onRobotDeath(RobotDeathEvent e) {
		targets.remove(e.getName());
	}

	/**
	 * onHitWall: When robot hits wall
	 */
	public void onHitWall(HitRobotEvent event) {
	}



	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		out.println("");
		out.println("   ****************************************************");
		out.println("   *** public void onScannedRobot(ScannedRobotEvent e) ");
		NeosEnemy en;
	
		if (targets.containsKey(e.getName())) {
			en = (NeosEnemy)targets.get(e.getName());
		} else {
			en = new NeosEnemy();
			targets.put(e.getName(),en);
		}
		currentTarget = getNearestTarget();
		//̍sœG{bĝpΊpœ
		double absbearing_rad = (getHeadingRadians()+e.getBearingRadians())%(2*PI);
		//̃ZNVŃ^[QbgɊւSĂ̏Zbg
		en.name = e.getName();
		out.println("   *** Target name is "+en.name);
		double h = help.normalizeBearingRadians(e.getHeadingRadians() - en.heading);
		h = h/(getTime() - en.ctime);
		en.changehead = h;
		en.x = getX()+Math.sin(absbearing_rad)*e.getDistance();		//WIXW𓾂
		en.y = getY()+Math.cos(absbearing_rad)*e.getDistance();		//WIYW𓾂
		en.bearing = e.getBearingRadians();
		en.heading = e.getHeadingRadians();
		en.ctime = getTime();				//̃XLsꂽQ[
		en.speed = e.getVelocity();
		en.distance = e.getDistance();	
		en.live = true;
		if ((en.distance < target.distance)||(target.live == false)) {
			target = en;			
		}
		
//		if (e.getDistance() < radius ){
			// Dodge code 
			double changeInEnergy = previousEnergy - e.getEnergy();
			if (changeInEnergy > 0 && changeInEnergy <= 3){
				out.println("   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
				out.println("   %%%       Target Fired!!!      %%%");
				out.println("   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
				//Dodge!
				movementDirection = -movementDirection;
				if (e.getDistance() < radius) {
					//Target is Near
					setTurnRightRadians(help.normalizeBearingRadians( PI/2 + e.getBearingRadians() ));
					setAhead((e.getDistance()/4+25) * movementDirection);
				}else{
					//Target is Far
				}
				out.println("   ***       movementDirection is "+movementDirection);
			}
//		}
		//Track the energy level

		previousEnergy = e.getEnergy();
				
		out.println("   *** public void onScannedRobot(ScannedRobotEvent e) called");
		out.println("   ****************************************************");
		out.println("");
	}



	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	out.println("+++ public void onHitByBullet(HitByBulletEvent e) called");
	}

	/**===========================================
	 * Custom Events
	 =============================================*/
	
	/**
	 * onCustomEvent(CustomEvent e)
	 */
	public void onCustomEvent(CustomEvent e){
		if (e.getCondition() instanceof
			RadarTurnCompleteCondition) sweep();	
	}
	

}




/**
 * Enemy : WIɊւ̕ێBړ̗\܂ŁB
 */
class NeosEnemy {
	/*
		āAŃANZbT[ƃ~[e[^[Ŏg
		ׂBiȂ킿AgetName\bhsetName\bhjǁAl
		͒Zˁi{bǵAȁjB
		EEẼNXĺA킴ƃtB[hJƂ킯B
		ANZbT\bhɂăR[h剻邱ƂAtB[h
		J邱ƂŃR[hTCYk邱Ƃ̂قD悵ĂƂB
	 */
	String name;				//{bg̖O
	public double 	bearing,	//WÎp
					heading,	//WǏĂ
					speed,		//WȊ
					x,			//W
					y,
					distance,	//WI܂ł̋
					changehead;	//WÏړψʁipxj
	public long ctime; 			//XLsꂽQ[
	public boolean live;		//G͐Ă邩H
	
	//ɂGW\						
	public Point2D.Double guessPosition(long when) {
		double diff = when - ctime;
		double newY = y + Math.cos(heading) * speed * diff;
		double newX = x + Math.sin(heading) * speed * diff;
		
		return new Point2D.Double(newX, newY);
	}
}

