package lucasslf.development;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

import lucasslf.utility.ScannedRobot;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import ags.utils.KdTree;
import ags.utils.KdTree.Entry;

public class DCGun {

	// Just to keep track of the waves we fired
	private static int WAVE_IDS = 0;

	public static KdTree<Double> gfTree = new KdTree.Manhattan<Double>(10,
			100000);
	public static KdTree<Double> gfMissTree = new KdTree.Manhattan<Double>(10,
			100000);

	private int moveTimes = 0;


	// Waves
	private List<Wave> waves = new ArrayList<Wave>();

	// Last status of the enemy
	private ScannedRobot lastScannedRobot = new ScannedRobot();

	private static Point2D targetPosition;
	private static double targetHeading;

	// The robot using the gun
	AdvancedRobot r;

	public DCGun(AdvancedRobot r) {
		super();
		this.r = r;
	}

	public void onBulletMissed(BulletMissedEvent e) {
		for (int i = 0; i < waves.size(); i++) {
			Wave wave = waves.get(i);
			if (wave.checkBulletMiss(e.getBullet())) {
				return;
			}
		}
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {

	}

	public void onBulletHit(BulletHitEvent e) {
		checkWavesForBullet(e.getBullet());

	}

	public void onHitByBullet(HitByBulletEvent e) {

	}

	public void onHitRobot(HitRobotEvent e) {

	}

	public void onPaint(Graphics2D g) {
		for (Wave wave : waves) {
			wave.draw(g);
		}
	}

	// 0 - Pr�ximo ao muro
	// 1 - Corner
	// 2 - Meio
	private int getWallSegmentFrom(Point2D position) {
		int retorno = 2;
		double x = position.getX();
		double y = position.getY();
		boolean nearVerticalWalls = (x < 50 || (r.getBattleFieldWidth() - x < 50));
		boolean nearHorizontalWalls = (y < 50 || (r.getBattleFieldHeight() - y < 50));

		if (nearHorizontalWalls && nearVerticalWalls) {
			return 1;
		}
		if (nearVerticalWalls || nearHorizontalWalls)
			return 0;

		return retorno;
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double enemyAbsoluteBearing = r.getHeadingRadians()
				+ e.getBearingRadians();
		double headingDifference = e.getHeading() - r.getHeading();

		double lateralVelocity = e.getVelocity()
				* Math.sin(e.getBearingRadians() - Math.PI);

		double deltaBearing = enemyAbsoluteBearing - lastScannedRobot.bearing;
		double advancingVelocity = e.getVelocity() * -1
				* Math.cos(headingDifference);

		int enemyDirection = 0;
		if (e.getVelocity() != 0) {
			if (Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing)
					* e.getVelocity() < 0)
				enemyDirection = -1;
			else
				enemyDirection = 1;
		}

		if (e.getVelocity() == 0)
			moveTimes = 0;
		else
			moveTimes++;

		// Power calculation from somewhere I don't remember now
		boolean rammer = e.getDistance() < 200;
		double power = rammer ? 3 : Math.min(1.9,
				Math.min(r.getEnergy() / 16.0, e.getEnergy() / 2.0));


		double ex = r.getX() + Math.sin(enemyAbsoluteBearing) * e.getDistance();
		double ey = r.getY() + Math.cos(enemyAbsoluteBearing) * e.getDistance();
		targetPosition = new Point2D.Double(ex, ey);
		targetHeading = e.getHeadingRadians();

		int delta = (int) (Math.round(5
				* e.getDistance()
				* (Math.abs(deltaBearing) - Math
						.abs(lastScannedRobot.deltaBearing))));
		int accel = 1;
		if (delta < 0) {
			accel = 0;
		} else if (delta > 0) {
			accel = 2;
		}

		double segHeadingDifferenceIndex = (headingDifference + 360) / 720;
		double segDistanceIndex = e.getDistance() / 1000 * 1.5;
		double segBulletPowerIndex = power / 3;
		double segLateralVelocity = (lateralVelocity + 8) / 16 * 1.2;
		double segEnemyVelocityIndex = (e.getVelocity() + 8) / 16 * 0.6;
		double segWallProximityIndex = getWallSegmentFrom(targetPosition);
		double segMoveTimesIndex = Math.min(9, moveTimes / 5) / 9 * 1.2;
		double segAdvancingVelocity = (advancingVelocity + 8) / 16 * 1.2;
		double segDeltaBearing = (deltaBearing + 4 * Math.PI) / 8 * Math.PI
				* 0.8;
		double segAccel = accel / 2;
		double[] location = { segHeadingDifferenceIndex, segDistanceIndex,
				segBulletPowerIndex, segAccel, segLateralVelocity,
				segEnemyVelocityIndex, segWallProximityIndex,
				segMoveTimesIndex, segAdvancingVelocity, segDeltaBearing };

		Wave wave = new Wave(new Point2D.Double(r.getX(), r.getY()),
				enemyAbsoluteBearing, power, enemyDirection, location);

		double[] angleOffsetAndGuessFactor = getFiringAngleAndUsedGuessFactor(
				location, e.getDistance(), wave.getMaxEscapeAngle(),
				enemyDirection, enemyAbsoluteBearing, r.getGunHeat() == 0);
		double angleOffset = angleOffsetAndGuessFactor[0];
		double factor = angleOffsetAndGuessFactor[1];

		wave.setUsedFactor(factor);
		double gunAdjust = Utils.normalRelativeAngle(enemyAbsoluteBearing
				- r.getGunHeadingRadians() + angleOffset);

		r.setTurnGunRightRadians(gunAdjust);

		if (r.getGunHeat() == 0) {
			wave.setBullet(r.setFireBullet(power));
		}
		waves.add(wave);
		r.addCustomEvent(wave);

		Rectangle2D enemyRect = new Rectangle2D.Double(targetPosition.getX()
				- r.getWidth() / 2, targetPosition.getY() - r.getHeight() / 2,
				r.getWidth(), r.getHeight());
		Area a = new Area(AffineTransform.getRotateInstance(
				-e.getHeadingRadians(), targetPosition.getX(),
				targetPosition.getY()).createTransformedShape(enemyRect));
		r.getGraphics().setColor(Color.yellow);
		r.getGraphics().draw(a);

		lastScannedRobot = new ScannedRobot();
		lastScannedRobot.energy = e.getEnergy();
		lastScannedRobot.name = e.getName();
		lastScannedRobot.bearing = enemyAbsoluteBearing;
		lastScannedRobot.time = e.getTime();
		lastScannedRobot.velocity = e.getVelocity();
		lastScannedRobot.position = targetPosition;
		lastScannedRobot.deltaBearing = deltaBearing;

	}

	private double[] getFiringAngleAndUsedGuessFactor(double[] location,
			double distanceToEnemy, double maxEscapeAngle, int enemyDirection,
			double enemyAbsBearing, boolean shouldDraw) {
		List<Entry<Double>> entries = gfTree.nearestNeighbor(location, 100,
				false);
		double botWidthAngle = Math.abs(36 / distanceToEnemy / 2);
		double bestDensity = 0;
		double bestAngle = 0;
		double bestFactor = 0;
		List<Double> list = new ArrayList<Double>();
		List<Double> candidateList = new ArrayList<Double>();
		if (entries.size() > 0) {
			// From DC Tutorial
			for (Entry<Double> entry : entries) {
				int density = 0;
				double angle = entry.value * maxEscapeAngle * enemyDirection;
				list.add(angle);
				for (Entry<Double> auxEntry : entries) {
					if (!entry.equals(auxEntry)) {
						double auxAngle = auxEntry.value * maxEscapeAngle
								* enemyDirection;
						double ux = (angle - auxAngle) / botWidthAngle;
						if (Math.abs(ux) <= 1) {
							density++;
						}
					}
				}
				if (density > bestDensity) {
					candidateList.add(angle);
					bestAngle = angle;
					bestDensity = density;
					bestFactor = entry.value;
				}
			}

		}

		if (shouldDraw) {
			Point2D botLocation = new Point2D.Double(r.getX(), r.getY());
			for (double drawAngle : list) {

				double shotAbsAngle = Utils.normalAbsoluteAngle(enemyAbsBearing
						+ drawAngle);

				Point2D point = lucasslf.utility.Utils.project(botLocation,
						shotAbsAngle, 400);
				Line2D shotLine = new Line2D.Double(botLocation, point);
				r.getGraphics().setColor(Color.WHITE);
				r.getGraphics().draw(shotLine);
			}
			for (double drawAngle : candidateList) {

				double shotAbsAngle = Utils.normalAbsoluteAngle(enemyAbsBearing
						+ drawAngle);

				Point2D point = lucasslf.utility.Utils.project(botLocation,
						shotAbsAngle, 400);
				Line2D shotLine = new Line2D.Double(botLocation, point);
				r.getGraphics().setColor(Color.BLUE);
				r.getGraphics().draw(shotLine);
			}
			double bestShotAbsAngle = Utils.normalAbsoluteAngle(enemyAbsBearing
					+ bestAngle);

			Point2D point = lucasslf.utility.Utils.project(botLocation,
					bestShotAbsAngle, 400);
			Line2D shotLine = new Line2D.Double(botLocation, point);
			r.getGraphics().setColor(Color.RED);
			r.getGraphics().draw(shotLine);
		}
		return new double[] { bestAngle, bestFactor };
	}

	private void checkWavesForBullet(Bullet b) {
		for (int i = 0; i < waves.size(); i++) {
			Wave wave = waves.get(i);
			if (wave.checkBullet(b)) {
				return;
			}
		}
	}

	class Wave extends Condition {

		private int id = WAVE_IDS++;
		private double bulletPower;
		private double distanceTraveled;
		private double initialAngle;
		private Bullet bullet;
		private Point2D initialPosition;
		private int enemyDirection;
		private double usedFactor;
		private double[] position;
		private boolean reachedEnemy = false;

		public Wave(Point2D initialPosition, double initialAngle,
				double bulletPower, int enemyDirection, double[] position) {
			super();
			this.initialPosition = initialPosition;
			this.initialAngle = initialAngle;
			this.bulletPower = bulletPower;
			this.enemyDirection = enemyDirection;
			this.position = position;

		}

		public void setUsedFactor(double usedFactor) {
			this.usedFactor = usedFactor;
		}

		public double getAngleFromFactor(double factor) {
			return factor * getMaxEscapeAngle();
		}

		public double getUsedFactor() {
			return usedFactor;
		}

		public void setBullet(Bullet bullet) {
			this.bullet = bullet;
		}

		public double getBulletSpeed() {
			return 20.0 - (bulletPower * 3.0);
		}

		private void updateTravel() {
			distanceTraveled += this.getBulletSpeed();
		}

		public boolean checkHit(Point2D enemyPosition) {
			if (initialPosition.distance(enemyPosition) <= distanceTraveled + 18) {
				
				Rectangle2D enemyRect = new Rectangle2D.Double(
						enemyPosition.getX() - r.getWidth() / 2,
						enemyPosition.getY() - r.getHeight() / 2, r.getWidth(),
						r.getHeight());
				Area a = new Area(AffineTransform.getRotateInstance(
						targetHeading, targetPosition.getX(),
						targetPosition.getY())
						.createTransformedShape(enemyRect));
				List<Point2D> intersectionPoints = new ArrayList<Point2D>();
				double minGuessFactor = 0;
				double maxGuessFactor = 0;
				int divisions = 111;
				double middle = (divisions - 1) / 2.0;
				Point2D lastPoint = null;
				boolean foundFirst = false;
				for (int i = 0; i < divisions; i++) {
					double guessFactor = (i - middle) / middle;

					Point2D point = lucasslf.utility.Utils.project(
							initialPosition,
							(guessFactor * getMaxEscapeAngle() + initialAngle),
							distanceTraveled);

					if (a.contains(point)) {
						if (intersectionPoints.size() == 0) {
							intersectionPoints.add(point);
							minGuessFactor = guessFactor;
							reachedEnemy = true;
							foundFirst = true;
						}
						lastPoint = point;
						maxGuessFactor = guessFactor;

					} else if (foundFirst) {
						intersectionPoints.add(lastPoint);
						break;
					}

				}
				if (intersectionPoints.size() > 1) {
					/*
					if (bullet != null) {
					Graphics2D g = r.getGraphics();
						Point2D minPoint = intersectionPoints.get(0);
						Point2D maxPoint = intersectionPoints.get(1);
						Ellipse2D e1 = new Ellipse2D.Double(
								minPoint.getX() - 2, minPoint.getY() - 5, 10,
								10);
						Ellipse2D e2 = new Ellipse2D.Double(
								maxPoint.getX() - 2, maxPoint.getY() - 5, 10,
								10);
						g.setColor(Color.MAGENTA);
						g.draw(e1);
						g.draw(e2);
					}*/
					gfTree.addPoint(this.position, minGuessFactor
							* enemyDirection);
					gfTree.addPoint(this.position, maxGuessFactor
							* enemyDirection);
					gfTree.addPoint(this.position,
							(minGuessFactor + maxGuessFactor) / 2
									* enemyDirection);
					gfTree.addPoint(this.position,
							(minGuessFactor + maxGuessFactor) / 4
									* enemyDirection);
					gfTree.addPoint(this.position,
							(minGuessFactor + maxGuessFactor) * 3 / 4
									* enemyDirection);

				} else if (reachedEnemy && bullet == null)
					return true;

			}
			return false;
		}

		/*
		 * public boolean checkHit(Point2D enemyPosition) { int intersectCode =
		 * PreciseUtils.intersects( (Point2D.Double) enemyPosition, w); if
		 * (intersectCode == PreciseUtils.INTERSECTION) { double[] range =
		 * PreciseUtils.getIntersectionRange( (Point2D.Double) enemyPosition,
		 * w);
		 * 
		 * double negativeGuessFactor = Utils.normalRelativeAngle(range[0] -
		 * initialAngle) enemyDirection;
		 * 
		 * double positiveGuessFactor = Utils.normalRelativeAngle(range[1] -
		 * initialAngle) enemyDirection; double minGuessFactor =
		 * negativeGuessFactor / getMaxEscapeAngle(); double maxGuessFactor =
		 * positiveGuessFactor / getMaxEscapeAngle(); Point2D minPoint =
		 * lucasslf.utility.Utils.project( initialPosition, (minGuessFactor *
		 * getMaxEscapeAngle() + initialAngle) enemyDirection,
		 * distanceTraveled);
		 * 
		 * Point2D maxPoint = lucasslf.utility.Utils.project( initialPosition,
		 * (maxGuessFactor * getMaxEscapeAngle() + initialAngle) enemyDirection,
		 * distanceTraveled);
		 * 
		 * if (bullet != null) { Graphics2D g = r.getGraphics();
		 * 
		 * g.setColor(Color.MAGENTA); Ellipse2D e1 = new
		 * Ellipse2D.Double(minPoint.getX() - 2, minPoint.getY() - 5, 10, 10);
		 * Ellipse2D e2 = new Ellipse2D.Double(maxPoint.getX() - 2,
		 * maxPoint.getY() - 5, 10, 10); g.draw(e1); g.draw(e2);
		 * 
		 * gfTree.addPoint(this.position, minGuessFactor);
		 * gfTree.addPoint(this.position, maxGuessFactor);
		 * gfTree.addPoint(this.position, (minGuessFactor + maxGuessFactor) /
		 * 2); }else{ gfTree.addPoint(this.position, (minGuessFactor +
		 * maxGuessFactor) / 2); }
		 * 
		 * } else if (intersectCode == PreciseUtils.PASSED) return true;
		 * 
		 * /* Rectangle2D enemyRect = new
		 * Rectangle2D.Double(enemyPosition.getX() - r.getWidth() / 2,
		 * enemyPosition.getY() - r.getHeight() / 2, r.getWidth(),
		 * r.getHeight()); /*Area a = new
		 * Area(AffineTransform.getRotateInstance(targetHeading,
		 * targetPosition.getX(), targetPosition.getY())
		 * .createTransformedShape(enemyRect)); //Graphics2D g =
		 * r.getGraphics(); int divisions = 555; double middle = (divisions - 1)
		 * / 2.0; // if (this.bullet == null){ // //
		 * initialPosition.distance(enemyPosition) <= distanceTraveled) { for
		 * (int i = 0; i < divisions; i++) { double guessFactor = (i - middle) /
		 * middle; Point2D point = lucasslf.utility.Utils.project(
		 * initialPosition, (guessFactor * getMaxEscapeAngle()+
		 * initialAngle)*enemyDirection, distanceTraveled); if
		 * (enemyRect.contains(point)) {
		 * 
		 * gfTree.addPoint(this.position, guessFactor); //Ellipse2D e = new
		 * Ellipse2D.Double(point.getX() - 5, // point.getY() - 5, 10, 10);
		 * //g.setColor(Color.MAGENTA); //g.draw(e); /*if (this.bullet != null)
		 * {
		 * 
		 * System.out.println("Intersecting " + this.id + " " + i+ " " +
		 * guessFactor); }
		 */

		/*
		 * double desiredDirection = lucasslf.utility.Utils
		 * .absoluteBearing(initialPosition, enemyPosition);
		 * 
		 * double angleOffset = Utils.normalRelativeAngle(desiredDirection -
		 * initialAngle); double guessFactor = Math.max(-1, Math.min(1,
		 * angleOffset / getMaxEscapeAngle())) enemyDirection;
		 * gfTree.addPoint(this.position, guessFactor);
		 */
		// }
		// return false;
		// }

		public boolean checkBullet(Bullet b) {
			if (bullet != null && bullet.equals(b)) {

				gfTree.addPoint(position, usedFactor);
				return true;
			}
			return false;
		}

		public int getId() {
			return id;
		}

		public double getMaxEscapeAngle() {
			return Math.asin(8 / getBulletSpeed());
		}

		public boolean checkBulletMiss(Bullet b) {
			if (bullet != null && bullet.equals(b)) {
				gfMissTree.addPoint(position, usedFactor);

				return true;
			}
			return false;
		}

		@Override
		public boolean test() {
			updateTravel();
			if (checkHit(targetPosition)) {
				r.removeCustomEvent(this);
				waves.remove(this);
				return false;
			}

			return false;
		}

		public void draw(Graphics2D g) {

			if (bullet != null) {
				// Draw wave
				double raio = this.distanceTraveled;
				double lado = raio * 2;
				double x = (initialPosition.getX() - raio);
				double y = (initialPosition.getY() - raio);
				double initialArcAngleDegrees = lucasslf.utility.Utils
						.toDegrees(initialAngle - getMaxEscapeAngle()) - 90;
				double arcAngleDegrees = lucasslf.utility.Utils
						.toDegrees(getMaxEscapeAngle() * 2 / 111);
				for (int i = 0; i < 111; i++) {
					Arc2D arc = new Arc2D.Double(x, y, lado, lado,
							initialArcAngleDegrees, arcAngleDegrees, Arc2D.OPEN);
					g.draw(arc);
					initialArcAngleDegrees += arcAngleDegrees;
				}
			}

		}

	}

}
