/***************************************************************************************
*  Robot:  nano.TimDog
*  Author: Liuyang
*  Create: 2003.01.20
*  Tips:   Melee and 1v1 atrocity dog.
*......................................................................................
*  v0.10 - 2003.01.20 - 243 - Create bot,moving like a clock.
*  v0.20 - 2003.01.24 - 245 - Random moving,TurnGun method update.
*  v0.30 - 2003.04.06 - 236 - Modify moving conditions.and firepower.
*  v0.31 - 2003.04.25 - 227 - Use epEnergy to set move conditions.
*  v0.32 - 2003.04.19 - 227 - Test gun param 17. melee batter and 1v1.
*  v0.33 - 2003.07.21 - 248 - Usage relativeOf() method and Modify Movement.
****************************************************************************************/
package timmit.nano;
import robocode.*;
import java.awt.Color;

public class TimDog extends AdvancedRobot{
	
	static int direction	= 1;
	static double epEnergy	= 100;
	
	public void run(){
		setColors(Color.green,Color.green,Color.white);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do{
			turnRadarRightRadians(1);
		}while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e){//---------- My dog found Shit------------//
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		
		//ROBOT TURN METHOD//
		setTurnRightRadians(relativeOf(e.getBearingRadians() + Math.PI/2) - Math.PI/4 * Math.random() * direction);
		
		//ROBOT MOVE METHOD//
		if(epEnergy != (epEnergy = e.getEnergy())){
			//moveTime = e.getDistance() / (17 + Math.random()*10);
			double dist = (e.getDistance() * Math.random() + 30) * (direction = Math.random() > 0.6 ? 1 : -1);
			if(e.getDistance() < 200){
				dist = -dist;
			}
			setAhead(dist);
		}
		
		//GUN TURN METHOD//
		setTurnGunRightRadians(relativeOf(absBearing - getGunHeadingRadians() + Math.asin(
								e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) / 17)));
		
		//SHOOT METHOD//
		//setFire(Math.min(450/e.getDistance(),getEnergy()/2));
		setFire(200 / Math.max(e.getDistance(),90) + 0.9);
		
		//RADAR TURN METHOD//
		setTurnRadarRightRadians(relativeOf(absBearing - getRadarHeadingRadians()) * 2);
		scan();
	}
	
	//HELPER METHOD//
	static double relativeOf(double r){return Math.atan2(Math.sin(r),Math.cos(r));}
}