package rc.yoda.plugin.guns;

import robocode.*;
import rc.yoda.utils.*;
import java.awt.geom.Point2D;

/** 
 * Linear - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Linear.java : v1.0 -- 2007/05/12
 */


/**
 * Linear a Gun that assumes the enemy will 
 * not change its velocity or heading and fires
 * at where it is expected to be
 *
 * @author Robert Codd
 * @version v1.0
 */
public class Linear extends Gun
{	
	/**
	 * The current angle this gun wants to shoot at
	 */
	private static double fireAngle = 0;
	
	/**
	 * The current bullet power this gun wants to shoot
	 */
	private static double bulletPower = 3;
	
	/**
	 * Class Constructor specifying the robot this 
	 * gun is virtually mounted on
	 */
	public Linear(AdvancedRobot robot) {
		super(robot);
	}

	/**
	 * Event method called by Robocode when this robot's scanner
	 * passes over another robot
	 * 
	 * @param ScannedRobotEvent information about the scanned robot
	 */	
	public void onScannedRobot(ScannedRobotEvent e) {
		Point2D.Double robotsLocation = new Point2D.Double(robot.getX(),robot.getY());
		
		double enemyBearing = robot.getHeadingRadians() + e.getBearingRadians(),
			enemyHeading = e.getHeadingRadians(),
			enemyVelocity = e.getVelocity();
		
		Point2D.Double enemyLocation = YUtils.project(robotsLocation, enemyBearing, e.getDistance()),
			futureLocation = (Point2D.Double)enemyLocation.clone();
		
		bulletPower = YUtils.limit(0.1, 600 / e.getDistance(), 3);
		
		int time = 0;
		while((time++) * Laws.getBulletSpeed(bulletPower) < robotsLocation.distance(futureLocation)){		
			futureLocation = YUtils.project(futureLocation, enemyHeading, enemyVelocity);
			futureLocation.x = YUtils.limit(18,futureLocation.x,782);
			futureLocation.y = YUtils.limit(18,futureLocation.y,582);
		}
	
		fireAngle = YUtils.absoluteBearing(robotsLocation,futureLocation) - YUtils.absoluteBearing(robotsLocation,enemyLocation);
	}

	/**
	 * Returns the power of the bullet this gun wants to 
	 * fire caculated in onScannedRobot
	 * 
	 * @return double power of the bullet this Gun wants to shoot
	 */
	public double getBulletPower() {
		return bulletPower;
	}

	/**
	 * Returns the angle to fire this gun wants to 
	 * fire caculated in onScannedRobot
	 * 
	 * @return double angle at which this Gun wants to shoot
	 */
	public double getFireAngle() {
		return fireAngle;
	}
}
