package cx.mini;
import robocode.*;
import java.awt.Color;
import java.util.Vector;
import java.awt.geom.Point2D;
import cx.utils.Wave;
/**
 *+++++++++++++++++++++++++++Author Info++++++++++++++++++++++++++
 *--
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 *--
 * For living,I fish out a cigaret,smoke and spit a circle smog...
 * Hi~,catch a cigaret!
 *++++++++++++++++++++++++++++++++Versions++++++++++++++++++++++++
 *--
 * 0.1:my first pattern analyse bot. 
 * 0.70:improved movement and pattern analyzer.
 * 0.76:improved pattern analyzer a little.
 * 0.77:Squeezed codesize to 1287.
  *--------------------version 0.78 2003.1.8--------------
 * 0.78:improved pattern analyzer a little.(codesize 1396)
 * Test many movement but at last back to old version's.
  *--------------------version 0.79 2003.1.14--------------
 * 0.79:improved pattern analyzer a little,added minDTW(enemy min distance to wall)
  *--------------------version 0.80 2003.1.15--------------
 * 0.80:added a property gunNeedTurn to judge if can turn compeletly.(codesize 1493)
  *--------------------version 0.90 2003.1.26--------------
 * 0.90:Changed movement mode.(codesize 1486)
  *--------------------version 1.01 2003.3.3--------------
 * 1.01:improved movement and aiming system a little.(codesize:1371)
 * pattern analyzer went to a new step.
 * so,shoot better than 0.90.
  *--------------------version 1.11 2003.3.12--------------
 * 1.11:replace a input for pattern(Wave) and changed match value count method.
 * pattern analyzer do a little better,and in this version if it find very good match value,
 * the pattern analyzer will breat.so if the enemy is very predictable,i will use very little time to analyse.
 * so,shoot better than 1.01.
 * movement based on enemy's bullet power.
  *--------------------version 1.12 2003.3.14--------------
 * 1.12:add a sentence to ram target if target's energy is very low.(codesize 1471)
 *--
  *--------------------version 1.13 3003.3.**--------------
 * 1.13:ram better
 *--
  *--------------------version 1.15 3003.3.31--------------
 * 1.15:add a strategy -- Anti-Ram
 * if Cigaret's energy it low,he does not fire,so...some rammer go to ram him
 * when the rammer is close,he start to escape ,when it is very close,he fire.(because very close so mostly hit it)
 * (codesize 1488)
 *--
  *--------------------version 1.16 3003.4.6--------------
 * 1.16:fixed a bug of ramming.(codesize 1491)
 *--
  *--------------------version 1.17 3003.4.15--------------
 * 1.17:tweaked movement a little.(codesize 1491)
 *--
  *--------------------version 1.19 3003.4.24--------------
 * 1.19:tweaked movement a little again.(codesize 1494)
 *--
  *--------------------version 1.20 3003.4.26--------------
 * 1.20:tweaked movement a little again.(codesize 1493)
 *--
  *--------------------version 1.23 3003.6.20--------------
 * 1.20:tweaked movement and squezzed a little again.(codesize 1430)
 *--
  *--------------------version 1.31 3003.7.13--------------
 * 1.31:tweaked movement again.(codesize 1476)
 *--
 *+++++++++++++++++++++++++++++++++future++++++++++++++++++++++++++++++++
 *--
 * future:well,what the better?!
 *--
 *+++++++++++++++++++++++++++++++++Open Source+++++++++++++++++++++++++++
 *--
 * This bot is open source. 
 * - Don't just copy-paste the code .
 * - Don't just copy-paste and then improve.(I don't want to fight modified versions of my own bot)
 * - Maybe some useful skill in this codes,if you use,Make your bot open source
 * - And preferably give credit.:)
 *
 * If you want to know more or suggest,
 * email me or post messages on www.robochina.org or www.robocoderepository's forums.
 * every messages will be pleasent.
 *--
 */
public class Cigaret extends AdvancedRobot
{
	private static Vector waves=new Vector();     //enemy's patterns
    private static double preDiffAngle;           //what radians the gun need turn
	private static double power=0;                //fire power
	private static double enemyEnergy;            //enemy's energy
	private static double lastEnemyBulletPower;   //enemy's last bullet's power
	private static long   enemyLastFireTime;      //the time when enemy last fire

	public void run( ) {
		setColors(Color.white,Color.white,new Color(140,15,16));
		setAdjustGunForRobotTurn(true);
	    setAdjustRadarForGunTurn(true);
		while(waves.size()>3500)	
			waves.remove(0);   //max size 3500
		do{
			turnRadarRightRadians(5);	
		}
		while(true);
	} 

    // -------------------- function for event handle ---------------
    public void onBulletHit(BulletHitEvent e){
		enemyEnergy=e.getEnergy();
	}
    public void onHitByBullet(HitByBulletEvent e){
		enemyEnergy+=e.getPower()*3d;
	}
    public void onHitRobot(HitRobotEvent e){
		enemyEnergy-=0.6d;
	}

   	public void onScannedRobot( ScannedRobotEvent e ) {
	    int i;
        long time=getTime();
		double moveAngle,L,disAngle,moveDistance,moveDirection,edistance,absBearing;
		Point2D.Double enemyPos,myPos,centerPos,nextP=null;
		enemyPos=nextPoint(myPos=new Point2D.Double(getX(),getY()),
			absBearing=robocode.util.Utils.normalRelativeAngle(e.getBearingRadians()+getHeadingRadians()),
            moveDistance=edistance=e.getDistance());
        centerPos=new Point2D.Double(getBattleFieldWidth()/2,getBattleFieldHeight()/2);
		// Radar turn grabed from David Alves.
		setTurnRadarRightRadians(Math.sin(absBearing - getRadarHeadingRadians()));

		//--------------movement---------------------
		double energyChange=enemyEnergy-e.getEnergy();
        enemyEnergy=e.getEnergy();
		if(Math.abs(energyChange-1.55)<1.46){
			lastEnemyBulletPower=energyChange;
			enemyLastFireTime=time;
		}
		boolean isRam=time-enemyLastFireTime>50;

		if(Math.abs(getDistanceRemaining())<53d || isRam){
            if(Math.abs(energyChange-1.55)<1.46  || edistance<200d){
				double xieAngle=Math.abs((absBearing+Math.PI*2)%(Math.PI/2d));
				boolean isCloseToCenter=myPos.distance(centerPos)<centerPos.distance(0d,0d)/2d;
				boolean isVerticle=xieAngle<Math.PI/8d || xieAngle>Math.PI*7d/8d || isCloseToCenter;
				disAngle=2d*Math.asin(4d/(20d-lastEnemyBulletPower*3d));
				if(isVerticle){
			    	disAngle=Math.asin(8d/(20d-lastEnemyBulletPower*3d));
				}
				disAngle+=25d/edistance;
				moveDistance=Math.max(170d,moveDistance);
				do{
		    		moveAngle=Math.random()*disAngle*2-disAngle;
					L=moveDistance;
		    		if(isVerticle){
    			    	L/=Math.cos(moveAngle);
		    		}
					moveDistance-=10d;
				}while(distanceToWall(nextP=nextPoint(enemyPos,absBearing+moveAngle,-L))<24d);
			}else if(getDistanceRemaining()==0d){
				//keep around enemy,keep enemy be 90 angle bearing me.
		        nextP=nextPoint(enemyPos,absBearing+0.000001d,-edistance);
	    	}
			if(isRam)
			   	nextP=enemyPos;
			if(nextP!=null){
                //thanks to David Alves and Dummy for this small code to find which direction is shortest to our next destination
		    	//Thanx DrLoco of this usage
	    		setAhead(
	    		 (
		    		( 
		    		moveAngle = robocode.util.Utils.normalRelativeAngle(
				                  Wave.getAngle( nextP,myPos) - getHeadingRadians() 
				                  ) 
		    		) == ( moveDistance = Math.atan( Math.tan( moveAngle ) ) 
					) ? 1 : - 1 ) * myPos.distance(nextP) );	//move towards point
		    setTurnRightRadians( moveDistance );
			}
		}
    	setMaxVelocity( Math.abs(getTurnRemaining()) > 45 ? 0d : 8d );

		//------------------------------patten analyser----------------------------------
        double firedPower,catchPower;
        catchPower=Math.min(3,enemyEnergy/5d);
		firedPower=0d;
		int wavesSize=waves.size();
		//use 200,200*11>2000,usually > battleFiledWidth and battleFiledHeight
		for(i=wavesSize-1;i>=0 && i>wavesSize-201;i--)
			((Wave)waves.elementAt(i)).test(enemyPos,time);
		if((power>0 && getEnergy()-power>1.0d && Math.abs(preDiffAngle)<0.35d || edistance<150d)
			&& (getEnergy()<enemyEnergy || enemyEnergy>2d || !isRam)){
		    if(setFireBullet(power)!=null){
			    firedPower=power;
			}
		}
        power=0;
        waves.add(new Wave(myPos,firedPower,time,absBearing,edistance,(firedPower=e.getVelocity())*Math.sin(e.getHeadingRadians()-absBearing),enemyPos.distance(centerPos)));
		preDiffAngle=0d;
		if(getGunHeat()<0.4d){
            //-------------find match wave---------------
	    	double matchValue=Double.POSITIVE_INFINITY;//very large
    		for(i=74;i<wavesSize;i++){
	    		double comVal,comValD;
    			Wave wave=(Wave)waves.elementAt(i);
				Wave tw=(Wave)waves.elementAt(wavesSize);
	    		if(wave.willHitDiffAngle<10D && Math.abs(wave.distance-tw.distance)<2d){//is a succeded wave
				    int j=0; 
					double div=0;
				    double diffAngle=wave.willHitDiffAngle;
		    	    comVal=comValD=Math.pow((power-wave.power)/9d,2);

					do{
						comVal+=Wave.getComVal(waves.elementAt(wavesSize-j),waves.elementAt(i-j),1d)/(div=div*2+1);
						comValD+=Wave.getComVal(waves.elementAt(wavesSize-j),waves.elementAt(i-j),-1d)/(div);
					}while((j+=6)<73);

					if(comValD<comVal){
                		comVal=comValD;
						diffAngle=-wave.willHitDiffAngle;
					}
					if(comVal<matchValue){
						//absBearing+diffAngle is enemy's furture bearing
						//matched wave's velocity is distance(not v)
                        enemyPos=nextPoint(myPos,absBearing+diffAngle,wave.velocity);
						if(distanceToWall(enemyPos)>=18){
			            	matchValue=comVal;
			        		preDiffAngle=diffAngle;
							power=catchPower;
						}
					}
	    		}
    		}
		}
        //turn gun
        setTurnGunLeftRadians(preDiffAngle=robocode.util.Utils.normalRelativeAngle(getGunHeadingRadians()-absBearing-preDiffAngle));
		scan();
    }
	public double distanceToWall(Point2D.Double p){
		return Math.min(Math.min(p.x,getBattleFieldWidth()-p.x),Math.min(p.y,getBattleFieldHeight()-p.y));
	}
	public static Point2D.Double nextPoint(Point2D.Double originPoint,double angle,double distance){
		return new Point2D.Double(originPoint.x+Math.sin(angle)*distance,originPoint.y+Math.cos(angle)*distance);
	}	
}
