package ntc.slippery;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.io.*;
import java.awt.Color;

public class TeamDroid2 extends TeamDroid implements Droid
{
	int droidsDead=0;
	int others;
	Rectangle2D.Double shootarea;
	
	public void run(){
		others=getOthers()-4;
		shootarea=new Rectangle2D.Double(0,getBattleFieldHeight()*0.45,getBattleFieldWidth()*0.65,getBattleFieldHeight()*0.65);		
		setAdjustGunForRobotTurn(true);
		setBulletColor(Color.CYAN);
		
		if(others<=2){ shootarea.setRect(0,0,getBattleFieldWidth(),getBattleFieldHeight()); }
		
		double angle=Utils.normalRelativeAngle(Math.atan2(0-getX(),getBattleFieldHeight()-getY())-getHeadingRadians());
		setTurnRightRadians(angle);
		while(!shootarea.contains(new Point2D.Double(getX(),getY()))){			
			setAhead(Double.POSITIVE_INFINITY);
			execute();
		}
		
		while(true){
			setAhead(80+Math.random()*120*dir);		
			setTurnRight(50+Math.random()*50*dir);
			dir*=-1;
			waitFor(new MoveCompleteCondition(this));			
		}	
	}
		
	public void onMessageReceived(MessageEvent e){
		if(e.getMessage() instanceof Point2D.Double){
			setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing(new Point2D.Double(getX(),getY()),(Point2D.Double)e.getMessage())-getGunHeadingRadians()));
			if(getGunTurnRemaining()<5 && shootarea.contains((Point2D.Double)e.getMessage())){
				if(e.getSender().equals("Leader1")){
					setFire(2);						
				}else{
					setFire(getEnergy()/5);
				}
				execute();
			}
		}else if(e.getMessage() instanceof String){
			if(((String)e.getMessage()).equals("alive")){
				try{
					sendMessage(e.getSender(),new String("yes"));
				}catch(IOException exc){}
			}
		}
	}	

	public void onRobotDeath(RobotDeathEvent e){
		if(!isTeammate(e.getName())){ others--; if(others<=2){ shootarea.setRect(0,0,getBattleFieldWidth(),getBattleFieldHeight()); } }
		if(e.getName().indexOf("TeamDroid")==-1 || others<=2){ return; }
		droidsDead++;
		if(droidsDead<2){
			if(e.getName().equals("TeamDroid1")){
				shootarea.setRect(0,0,getBattleFieldWidth()*0.65,getBattleFieldHeight());
			}else if(e.getName().equals("TeamDroid3")){
				shootarea.setRect(0,getBattleFieldHeight()*0.45,getBattleFieldWidth(),getBattleFieldHeight()*0.65);
			}
		}else{
			shootarea.setRect(0,0,getBattleFieldWidth(),getBattleFieldHeight());
		}		
	}
	
}
