package whind;
import robocode.*;
import java.awt.Color;
import java.util.*;
import java.awt.geom.*;
import java.awt.Graphics2D;
import robocode.util.*;
import java.util.Vector;

/**
 * Strength - a robot by Greywhind
 */
public class StrengthBee extends AdvancedRobot {
	////////////////// OFFENSIVE CODE //////////////////
	// for statistics
	static int bulletsFired = 0;
	int roundFired = 0;
	static int hits = 0;
	
	// for enemy tracking
	double eBearing;
	double prevVelocity;
	double currVelocity;
	Point2D.Double doublePrevPos;
	Point2D.Double prevPosition;
	Point2D.Double currPosition;
	double prevEnergy;
	double currEnergy;
	Rectangle2D.Double fieldRectangle;
	Vector allBullets = new Vector();
	double eGunHeat;
	int gotHit;
	int eRoundFired;
	double coolRate;
	String Tracking = "";
	double lastEnemyHeading;
	double plastEnemyHeading;
	int eDirection;
	
	// for vguns
	VGunBattery myVGuns;
	VBullet tB;
	double honprednow;
	double linprednow;
	double circprednow;
	double lasprednow;
	double pmprednow;
	double gfprednow;
	Integer fireMethod;
	double power;

	// for Laser Targeting
	static Object[] allHitOffsets = new Object[14];
	Vector segmentHitOffsets;
	Vector myBullets = new Vector();
	
	// for Pattern Matching
	static StringBuffer fullPattern = new StringBuffer();
	Vector lastFew = new Vector();
	static int MAX_SEARCHES = 20;
	static Vector arcLength = new Vector();
	static int historyIndex = 0;
	static int MAX_BUFFER_SIZE = 2000;
	double paramOne;
	double paramTwo;
	
	// for GF gun
	static int wavesHit = 0;
	List waves = new ArrayList();
	static int[][] stats = new int[14][31];       //31 is the number of unique guessfactors we're using
	double gfAngleOffset;	
	////////////////// END OFFENSIVE CODE //////////////////
	
	double enemyX;
	double enemyY;
	double absBearing;
	double eEnergy;
	double ePower;
	double eDist;
	double eHeading;
	
	static int skipped;
	
	// for targeting
	int timeSinceLastScan;
	boolean isMC = false;
	pez.rumble.pgun.Bee stinger;
	pez.rumble.utils.RobotPredictor robotPredictor = new pez.rumble.utils.RobotPredictor();
	
	// for movement
	double DISTANCE_WEIGHT = 0.01; // smaller numbers = less difference.
	static final double LINE_NUM_WEIGHT = 0.01; // larger numbers = less difference.
	double OLD_DISTANCE_WEIGHT = 0;
	int direction = 1;
	int numdirectswitch = 0;
	long timeOfLastSwitch = 0;
	static long maxTimeBetweenSwitches = 0;
	static final int DIRECT_SWITCH_MAX = 10;
	long timeOfLastDirChange = 0;
	double maxVelocity;
	EnemyWaveMgr mgr = new EnemyWaveMgr();
	int currentIndex = 15;
	int prevIndex = 15;
	int wantedIndex = 15;
	int absDir = 1;
	double myHeading;
	double myAccel;
	double myPrevVel;
	double deltaHeading;
	Point2D.Double[] possiblePoints;
	LineValPair[] avoidPoints;
	Random gen = new Random();
	int direct = 1;
	EnemyWave closestWave;
	EnemyWave[] allClosestWaves;
	LineValPair[][] allAvoidPts;
	boolean nearwall = false;
	double forward;
	double stop;
	double back;
	double prevEDist;
	boolean reverse;
	boolean switchok = true;
	int numTurns;
	int closestNumTurns;
	static double eBulletDamTotal;
	boolean ramMode = false;
	int ramDanger;
	double totalTurns;
	double ramAngleOffset;
	ScannedRobotEvent lastScannedRobot;
	static int lastKnownSegmentLevel = 0;
	static long segmentLevelSwitchTime = 0;
	
	// for movement prediction
	private double systemMaxTurnRate = Math.toRadians(10.0);
    private double systemMaxVelocity = 8.0;
    private double maxBraking = 2.0;
    private double maxAcceleration = 1.0;
    public double defaultMaxTurnRate = 10.0;
    public double defaultMaxVelocity = 8.0;
	
	long timeOfHit = 0;
	
	public void run() {
		if (getRoundNum() == 0) {
			eBulletDamTotal = 0;
		}
		
		setColors(Color.black,Color.blue,Color.black);
		System.out.println("Skipped Turns: " + skipped);
		
		//////////// OFFENSIVE CODE //////////////
		coolRate = getGunCoolingRate();
		setAdjustRadarForGunTurn(false);
		setAdjustRadarForRobotTurn(false);
		setAdjustGunForRobotTurn(true);
		
		myVGuns = new VGunBattery(getBattleFieldHeight(), getBattleFieldWidth());
		
		for (int i = 0; i < 14; i++) {
			allHitOffsets[i] = new Vector();
		}
		
		// all the things to do only the first round.
		if (getRoundNum() == 0) {
			for (int i = 0; i <= MAX_BUFFER_SIZE; i++) {
				arcLength.add(new Double(0));
			}
		}
		//////////// END OFFENSIVE CODE //////////////
		
		// targeting
		stinger = new pez.rumble.pgun.Bee(this, robotPredictor);
		
		while(true) {
			doScanner();
			
			/////////////////// OFFENSIVE CODE /////////////////
			if (eGunHeat > coolRate) {
				eGunHeat -= coolRate;
			} else {
				eGunHeat = 0;
			}
			/////////////////// END OFFENSIVE CODE /////////////////
			
			deltaHeading = getHeading() - myHeading;
			myHeading = getHeading();
			myAccel = getVelocity() - myPrevVel;
			myPrevVel = getVelocity();
			
			mgr.updateEnemyWaveMgr(getX(), getY(), getTime(), this, lastScannedRobot, myAccel, getBattleFieldHeight(), getBattleFieldWidth(), getTime() - timeOfLastSwitch, currentIndex);
			if (mgr.currInd != -1) {
				currentIndex = mgr.currInd;
				if (currentIndex != prevIndex) {
					absDir = currentIndex == prevIndex ? absDir : currentIndex > prevIndex ? 1 : -1;
				}
				prevIndex = currentIndex;
			}
			
			/*if (getTime() < 20 && eDist <= 50) {
				switchok = false;
			} else if (getTime() < 20) {
				switchok = true;
			}*/
			
			EnemyWave[] temp = mgr.getClosest();
			if (temp != null) {
				
				if (possiblePoints != null && mgr.hasPassed == true) {
					//out.println("------------------------");
					//out.println("X Diff: " + Math.abs(getX() - possiblePoints[direct + 1].getX()) + " Y Diff: " + Math.abs(getY() - possiblePoints[direct + 1].getY()));
					numdirectswitch = 0;
				}
				
				// for debugging graphics
				possiblePoints = new Point2D.Double[3];
				
				allAvoidPts = mgr.getAllBulletVectors();
				allClosestWaves = temp;
				
				forward = 0;
				stop = 0;
				back = 0;
				
				// for each wave...
				int a = 0;
				//for (int a = 0; a < allClosestWaves.length; a+= 3) { 
					avoidPoints = allAvoidPts[a];
					closestWave = allClosestWaves[a];
			
					Rectangle2D.Double field = new Rectangle2D.Double(16, 16, getBattleFieldWidth() - 32, getBattleFieldHeight() - 32);
						
					// initialize values for my position.
					int directnow = direction;
					double predX = getX();
					double predY = getY();
					double wantVel = 8;
					double currVel = getVelocity();
					double currHeading = myHeading;
					double bearing = Math.toDegrees(mgr.lastHitBearing);
					double wantedAngle = currHeading;
					// find number of turns left til' hit
					numTurns = (((int)closestWave.distance / (int)closestWave.getBulletSpeed()) - ((int)getTime() - (int)closestWave.fireTime) - 2);
					int remainderInDist = (int)closestWave.distance % (int)closestWave.getBulletSpeed();
					int maxNumTurns = numTurns;
					for (int i = remainderInDist; i >= -18; i++) {
						i -= closestWave.getBulletSpeed();
						maxNumTurns++;
					}
					
					if (mgr.hasPassed == true && a == 0) {
						//out.println("Bullet expected to hit at: " + (getTime() + numTurns));
					} else if (a == 0) {
						closestNumTurns = numTurns;
						//out.println("Turn " + getTime());
						//out.println("Bullet expected: " + (getTime() + numTurns) + " - " + (getTime() + maxNumTurns) + " (" + numTurns + " to " + maxNumTurns + " turns)");
					}
						
					if (numTurns == 0 && timeOfHit != 0) {
						timeOfHit = 0;
					}
					
					reverse = false;
						
					MovSimStat[] newPos = new MovSimStat[1];
					newPos[0] = new MovSimStat(predX, predY, currVel, Math.toRadians(currHeading), 0);
					for (int i = 0; i < numTurns; i++) {
						wantedAngle = getSmoothedAngle(mgr.lastHitBearing, newPos[0].h, newPos[0].x, newPos[0].y, 1);
						int dist = 100;
						if (Math.abs(wantedAngle) > Math.PI/2) {
							reverse = true;
        					wantedAngle = robocode.util.Utils.normalRelativeAngle(wantedAngle + Math.PI);
						}
						newPos = futurePos(1, newPos[0].x, newPos[0].y, newPos[0].v, 8.0, newPos[0].h, dist, wantedAngle, 10.0, getBattleFieldWidth(), getBattleFieldHeight());
						
						// update numTurns to acct. for moving closer or farther away
						double newDist = Point2D.distance(newPos[0].x, newPos[0].y, closestWave.startx, closestWave.starty);
						numTurns = (((int)newDist / (int)closestWave.getBulletSpeed()) - ((int)getTime() - (int)closestWave.fireTime) - 2);
					}
					Point2D.Double predPos = new Point2D.Double(newPos[0].x, newPos[0].y);
					
					Rectangle2D.Double robotPredict = new Rectangle2D.Double(predPos.getX() - (18 + (int)numTurns/6), predPos.getY() - (18 + (int)numTurns/6), 36 + (int)numTurns/3, 36 + (int)numTurns/3);
						
					// for debugging graphics
					if (possiblePoints[0] == null) {
						possiblePoints[0] = new Point2D.Double(predPos.getX(), predPos.getY());
					}
						
					// check to see how much danger i am in based on how
					// likely the bullet is to pass through my location.
					int numlines = 0;
					for (int i = 0; i < 31; i++) {
						if (robotPredict.intersectsLine(avoidPoints[i].line)) {
							forward += avoidPoints[i].val / ((a + LINE_NUM_WEIGHT) / LINE_NUM_WEIGHT);
							numlines++;
						}
					}
					forward += (Math.abs(eDist) - Math.abs(predPos.distance(enemyX, enemyY))) * DISTANCE_WEIGHT;
					forward += ((Math.abs(predPos.distance(enemyX, enemyY)) <= 200) && (Math.abs(eDist) - Math.abs(predPos.distance(enemyX, enemyY))) > 10) ? 10000 : 0;
								
					// now check stop
					field = new Rectangle2D.Double(16, 16, getBattleFieldWidth() - 32, getBattleFieldHeight() - 32);
						
					// initialize values for my position.
					directnow = direction;
					predX = getX();
					predY = getY();
					wantVel = 0;
					currVel = getVelocity();
					currHeading = myHeading;
					bearing = Math.toDegrees(mgr.lastHitBearing);
					wantedAngle = currHeading;
					// find number of turns left til' hit
					numTurns = (((int)closestWave.distance / (int)closestWave.getBulletSpeed()) - ((int)getTime() - (int)closestWave.fireTime) - 2);
					
					newPos = new MovSimStat[1];
					newPos[0] = new MovSimStat(predX, predY, currVel, Math.toRadians(currHeading), 0);
					for (int i = 0; i < numTurns; i++) {
						wantedAngle = getSmoothedAngle(mgr.lastHitBearing, newPos[0].h, newPos[0].x, newPos[0].y, 1);
						int dist = 0;
						if (Math.abs(wantedAngle) > Math.PI/2) {
        					wantedAngle = robocode.util.Utils.normalRelativeAngle(wantedAngle + Math.PI);
						}
						newPos = futurePos(1, newPos[0].x, newPos[0].y, newPos[0].v, 8.0, newPos[0].h, 0, wantedAngle, 10.0, getBattleFieldWidth(), getBattleFieldHeight());
					
						// update numTurns to acct. for moving closer or farther away
						double newDist = Point2D.distance(newPos[0].x, newPos[0].y, closestWave.startx, closestWave.starty);
						numTurns = (((int)newDist / (int)closestWave.getBulletSpeed()) - ((int)getTime() - (int)closestWave.fireTime) - 2);
					}
					predPos = new Point2D.Double(newPos[0].x, newPos[0].y);
					
					robotPredict = new Rectangle2D.Double(predPos.getX() - (18 + (int)numTurns/6), predPos.getY() - (18 + (int)numTurns/6), 36 + (int)numTurns/3, 36 + (int)numTurns/3);
						
					// for debugging graphics
					if (possiblePoints[1] == null) {
						possiblePoints[1] = new Point2D.Double(predPos.getX(), predPos.getY());
					}
						
					// check to see how much danger i am in based on how
					// likely the bullet is to pass through my pred location.
					numlines = 0;
					for (int i = 0; i < 31; i++) {
						if (robotPredict.intersectsLine(avoidPoints[i].line)) {
							stop += avoidPoints[i].val / ((a + LINE_NUM_WEIGHT) / LINE_NUM_WEIGHT);
							numlines++;
						}
					}
					stop += (Math.abs(eDist) - Math.abs(predPos.distance(enemyX, enemyY))) * DISTANCE_WEIGHT;
					stop += ((Math.abs(predPos.distance(enemyX, enemyY)) <= 200) && (Math.abs(eDist) - Math.abs(predPos.distance(enemyX, enemyY))) > 10) ? 10000 : 0;
					
					// now check backwards
					field = new Rectangle2D.Double(16, 16, getBattleFieldWidth() - 32, getBattleFieldHeight() - 32);
						
					// initialize values for my position.
					directnow = direction;
					predX = getX();
					predY = getY();
					wantVel = -8;
					currVel = getVelocity();
					currHeading = myHeading;
					bearing = Math.toDegrees(mgr.lastHitBearing);
					wantedAngle = currHeading;
					// find number of turns left til' hit
					numTurns = (((int)closestWave.distance / (int)closestWave.getBulletSpeed()) - ((int)getTime() - (int)closestWave.fireTime) - 2);
					
					newPos = new MovSimStat[1];
					newPos[0] = new MovSimStat(predX, predY, currVel, Math.toRadians(currHeading), 0);
					for (int i = 0; i < numTurns; i++) {
						wantedAngle = getSmoothedAngle(mgr.lastHitBearing, newPos[0].h, newPos[0].x, newPos[0].y, 1);
						int dist = -100;
						if (Math.abs(wantedAngle) > Math.PI/2) {
							reverse = true;
        					wantedAngle = robocode.util.Utils.normalRelativeAngle(wantedAngle + Math.PI);
						}
						newPos = futurePos(1, newPos[0].x, newPos[0].y, newPos[0].v, 8.0, newPos[0].h, -100.0, wantedAngle, 10.0, getBattleFieldWidth(), getBattleFieldHeight());
					
						// update numTurns to acct. for moving closer or farther away
						double newDist = Point2D.distance(newPos[0].x, newPos[0].y, closestWave.startx, closestWave.starty);
						numTurns = (((int)newDist / (int)closestWave.getBulletSpeed()) - ((int)getTime() - (int)closestWave.fireTime) - 2);
					}
					predPos = new Point2D.Double(newPos[0].x, newPos[0].y);
					
					robotPredict = new Rectangle2D.Double(predPos.getX() - (18 + (int)numTurns/6), predPos.getY() - (18 + (int)numTurns/6), 36 + (int)numTurns/3, 36 + (int)numTurns/3);
						
					// for debugging graphics
					if (possiblePoints[2] == null) {
						possiblePoints[2] = new Point2D.Double(predPos.getX(), predPos.getY());
					}
						
					// check to see how much danger i am in based on how
					// likely the bullet is to pass through my pred location.
					numlines = 0;
					for (int i = 0; i < 31; i++) {
						if (robotPredict.intersectsLine(avoidPoints[i].line)) {
							back += avoidPoints[i].val / ((a + LINE_NUM_WEIGHT) / LINE_NUM_WEIGHT);
							numlines++;
						}
					}
					back += (Math.abs(eDist) - Math.abs(predPos.distance(enemyX, enemyY))) * DISTANCE_WEIGHT;
					back += ((Math.abs(predPos.distance(enemyX, enemyY)) <= 200) && (Math.abs(eDist) - Math.abs(predPos.distance(enemyX, enemyY))) > 10) ? 10000 : 0;
				//}
				
				// choose direction based on danger.
				int pickedVelocity = (forward <= back) ? 1 : -1;
				pickedVelocity = (stop <= ((pickedVelocity == -1) ? back : forward)) ? 0 : pickedVelocity;
				
				mgr.hasPassed = false; // comment this line to only change once per bullet
				if (pickedVelocity != direct && numdirectswitch < DIRECT_SWITCH_MAX && switchok == true) {
					//if (mgr.hasPassed == true) {
						//mgr.hasPassed = false;
						direct = pickedVelocity;
						numdirectswitch++;
						//System.out.println("Time since last dir change: " + (getTime() - timeOfLastSwitch));
						if (getTime() - timeOfLastSwitch > maxTimeBetweenSwitches) {
							maxTimeBetweenSwitches = getTime() - timeOfLastSwitch;
						}
						timeOfLastSwitch = getTime();
					//}
				}
			}
			
			if (mgr.getClosest() == null) {
				direct = (eDist <= 200 ? 1:0);
			}
			
			//out.println("HEADING:" + (((eHeading-absBearing)/Math.PI) - Math.round((eHeading-absBearing)/Math.PI)));
			
			// As headingclosesness approaches 0, robot is more likely to be ramming.
			double headingcloseness = Math.abs(((eHeading-absBearing)/Math.PI) - Math.round((eHeading-absBearing)/Math.PI));
			if (eDist < 200 && eDist != 0 && eDist < prevEDist && headingcloseness < .1 && ramMode == false) {
				ramDanger += 1;
				if (ramDanger >= 10) {
					ramDanger = 0;
					ramMode = true;
					out.println("SETTING RAM MODE");
				}
			} else if (headingcloseness > .25 && ramMode == true) {
				ramDanger -= 10;
				if (ramDanger <= 0) {
					ramDanger = 0;
					ramMode = false;
					out.println("SETTING NORMAL MODE");
				}
			}
			
			if (ramMode == true) {
				setMaxVelocity(8);
				
				if (totalTurns % 20 == 0) {
					ramAngleOffset = (Math.PI/10) * (gen.nextInt(2) == 0 ? -1 : 1);
				}
				
				double turn = getSmoothedAngle(absBearing + Math.PI + ramAngleOffset, getHeadingRadians(), getX(), getY(), 1);
				setTurnRightRadians(turn);
				
				if (Math.abs(turn) > Math.PI/2) {
        			turn = robocode.util.Utils.normalRelativeAngle(turn + Math.PI);
					setAhead(-100);
				} else {
        			setAhead(100);
				}
			} else if (direct == 0) {
				setMaxVelocity(0);
			} else {
				setMaxVelocity(8);
				
				double bearing = (mgr.lastHitBearing == -1000) ? absBearing - Math.PI : mgr.lastHitBearing;
				double turn = getSmoothedAngle(bearing, getHeadingRadians(), getX(), getY(), reverse == true ? -direct : direct);
					
				if (Math.abs(turn) > Math.PI/2) {
        			turn = robocode.util.Utils.normalRelativeAngle(turn + Math.PI);
					setAhead(-100);
				} else {
        			setAhead(100);
				}
				
				setTurnRightRadians(turn);
			}
			
			timeSinceLastScan++;
			totalTurns++;
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// start movement code here.
		lastScannedRobot = e;
		timeSinceLastScan = 0;
		prevEDist = eDist;
		eDist = e.getDistance();
		eHeading = e.getHeadingRadians();
		absBearing = getHeadingRadians() + e.getBearingRadians();
		
        //find our enemy's location:
        enemyX = getX() + Math.sin(absBearing)*e.getDistance();
        enemyY = getY() + Math.cos(absBearing)*e.getDistance();
		
		mgr.getCurrentSegmentVal(this, e, myAccel, getBattleFieldHeight(), getBattleFieldWidth(), getTime() - timeOfLastSwitch, currentIndex, -1);
		
		if (e.getEnergy() < eEnergy && e.getEnergy() >= eEnergy - 3) {
			ePower = eEnergy - e.getEnergy();
			
			double theBearing = Math.atan2(getX() - enemyX, getY() - enemyY);
			mgr.addWave(e, this, ePower, e.getDistance(), theBearing, absBearing, enemyX, enemyY, getTime(), getHeadingRadians(), getVelocity(), myAccel, getBattleFieldWidth(), getBattleFieldHeight(), getTime() - timeOfLastSwitch, true);
			mgr.addWave(e, this, ePower, e.getDistance(), theBearing, absBearing, enemyX, enemyY, getTime() + 1, getHeadingRadians(), getVelocity(), myAccel, getBattleFieldWidth(), getBattleFieldHeight(), getTime() - timeOfLastSwitch, true);
			/*out.print("|");
			for (int i = 0; i < 31; i++) {
				out.print((int)mgr.smoothedVisits(i) + "|");
			}
			out.println("");*/
		} else {
			double ePower = 3;
			double theBearing = Math.atan2(getX() - enemyX, getY() - enemyY); 
			mgr.addWave(e, this, ePower, e.getDistance(), theBearing, absBearing, enemyX, enemyY, getTime(), getHeadingRadians(), getVelocity(), myAccel, getBattleFieldWidth(), getBattleFieldHeight(), getTime() - timeOfLastSwitch, false);
		}
		
		eEnergy = e.getEnergy();
		// end of movement code.
		
		// firing
		if (!isMC) {
			//////////////////// OFFENSIVE CODE //////////////////////
			if (Tracking.equals("")) {
				Tracking = e.getName();
				//out.println("Tracking " + Tracking);
			}
			if(e.getName().equals(Tracking)) {
				timeSinceLastScan = 0;
				absBearing = getHeadingRadians() + e.getBearingRadians();
				enemyX = getX() + e.getDistance() * Math.sin(absBearing);
	        	enemyY = getY() + e.getDistance() * Math.cos(absBearing);
				eDist = e.getDistance();
	
				prevVelocity = currVelocity;
				currVelocity = e.getVelocity();
			
				doublePrevPos = prevPosition;
				prevPosition = currPosition;
				currPosition = new Point2D.Double(enemyX, enemyY);
			
				prevEnergy = currEnergy;
				currEnergy = e.getEnergy();
				
				if (ramMode == false) {
					power = Math.min(1.99, e.getEnergy()/4);
				} else {
					power = Math.min(3, e.getEnergy()/4);
				}
				
				/* // update values for dynamic distancing
					distValues[(int)eDist/(1400/(DISTBINS-1))] += ePrevEnergy - e.getEnergy();
					distValues[(int)eDist/(1400/(DISTBINS-1))] -= myPrevEnergy - getEnergy();
					double currBestVal = 0;
					for (int i = 0; i < DISTBINS; i++) {
						if (distValues[i] > currBestVal) {
							currBestVal = distValues[i];
							bestDistBin = i;
						}
					}
	                ePrevEnergy = e.getEnergy();
					myPrevEnergy = getEnergy();*/
				
				// keep laser targeting info up to date
				updateLaserTargeting(e, power);
				updatePMTargeting(e, power);
				updateGFTargeting(e);
				
				// update VGun predictions
				honprednow = returnHeadOn(e);
				linprednow = returnLinear(e, absBearing, enemyX, enemyY);
				circprednow = returnCircular(e);
				lasprednow = returnLaser(e);
				pmprednow = returnPattern(e, power);
				gfprednow = returnGuessFactor();
				
				//out.println("Pos: " + currPosition + " Vel: " + currVelocity + " Energy: " + currEnergy);
				if (doublePrevPos != null) {
					if (prevEnergy - currEnergy <= 3 && prevEnergy - currEnergy > 0) {
						//out.println("Enemy Fired.");
						eRoundFired++;
						eGunHeat = 1 + ((prevEnergy-currEnergy) / 5);
						allBullets.add(new EBullet(doublePrevPos.getX(), doublePrevPos.getY(), getX(), getY(), doublePrevPos.distance(new Point2D.Double(getX(), getY())), prevEnergy - currEnergy));
					}
				}
				//setTurnLeft(90 - e.getBearing());
				eBearing = e.getBearing();
				double iHit = (double)hits/(double)roundFired;
				
	            //don't try to figure out the direction they're moving if they're not moving, just use the direction we had before
	            if (e.getVelocity() != 0) {
	                if (Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity() < 0)
	                    eDirection = -1;
	                else
	                    eDirection = 1;
				}
	
				if (roundFired > 0) {
	            	myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow, gfprednow);
					tB = (VBullet)myVGuns.checkBullets(e, enemyX, enemyY, getTime(), e.getDistance());
					if (tB != null) {
						//out.println("enemyX: " + enemyX + " startX: " + tB.startx + " current time: " + getTime() + " fire time: " + tB.fireTime);
						double desiredDirection = Math.atan2(enemyX-tB.startx, enemyY-tB.starty);
	             		double angleOffset = Math.toDegrees(robocode.util.Utils.normalRelativeAngle(desiredDirection));
						/*
						out.println("Hit: " + (int)angleOffset + " H= " + myVGuns.gunValues[0] + " Li= " + myVGuns.gunValues[1] + " C= " + myVGuns.gunValues[2] + " La= " + myVGuns.gunValues[3] + " PM= " + myVGuns.gunValues[4] + " GF= " + myVGuns.gunValues[5]);
						out.println("Circular at " + (int)myVGuns.cPredictedAngle + " hit at " +(int)angleOffset);
						out.println("HeadOn at " + (int)myVGuns.hPredictedAngle + " hit at " + (int)angleOffset);
						out.println("Linear at " + (int)myVGuns.lPredictedAngle + " hit at " + (int)angleOffset);
						out.println("Laser at " + (int)myVGuns.laPredictedAngle + " hit at " + (int)angleOffset);
						out.println("Pattern at " + (int)myVGuns.pmPredictedAngle + " hit at " + (int)angleOffset);
						out.println("GF at " + (int)myVGuns.gfPredictedAngle + " hit at " + (int)angleOffset);
						*/
					}
				}
				//if (getEnergy() < 20 && iHit * 100 < 8 && e.getEnergy() > 30) {
				//} else {
					if (e.getDistance() < 100) {
						fireHeadOn(e);
						fireMethod = new Integer(3);
					} else {
						if (bulletsFired < 30) {
							chooseRandom(e);
						} else {
							if (roundFired > 0) {
								//if (iHit * 100 < 5) {
								//	chooseRandom(e);
								//} else {
									chooseOnMerit(e);
								//}
							} else {
								chooseOnMerit(e);
							}
						}
					}
					
					if (getGunHeat() <= 0) {
						// energy management
						if (getEnergy() <= power) {
							if (getEnergy() == .1) {
							} else {
								//myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow);
								power = getEnergy() - .1;
								bulletsFired++;
								roundFired++;
								setFire(power);
							}
						} else if (getEnergy() > 16 && getEnergy() - 3 < 16 && power == 1.99) {
							//myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow);
							power = 1;
							bulletsFired++;
							roundFired++;
							setFire(power);
						} else {
							//myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow);
							bulletsFired++;
							roundFired++;
							setFire(power);
						}
					}
					lastEnemyHeading=e.getHeadingRadians();
					plastEnemyHeading=e.getHeadingRadians();
				//}
			}					
			//////////////////// END OFFENSIVE CODE //////////////////////		
			
			/////// FOR BEE GUN
	    	stinger.onScannedRobot(e);
		}
	}

	public void onPaint(Graphics2D g) {
		if (possiblePoints != null) {
			if (direct == 1) {
				g.setColor(Color.green);
			} else {
				g.setColor(Color.red);
			}
			g.drawRect((int)(possiblePoints[0].getX()) - 18, (int)(possiblePoints[0].getY()) - 18, 36,36);
			if (direct == 0) {
				g.setColor(Color.green);
			} else {
				g.setColor(Color.orange);
			}
			g.drawRect((int)(possiblePoints[1].getX()) - 18, (int)(possiblePoints[1].getY()) - 18, 36,36);
			if (direct == -1) {
				g.setColor(Color.green);
			} else {
				g.setColor(Color.red);
			}
			g.drawRect((int)(possiblePoints[2].getX()) - 18, (int)(possiblePoints[2].getY()) - 18, 36,36);
			
			g.setColor(Color.white);
			g.drawString("" + (int)forward, (int)(possiblePoints[0].getX()), (int)(possiblePoints[0].getY()));
			g.drawString("" + (int)stop, (int)(possiblePoints[1].getX()), (int)(possiblePoints[1].getY()));
			g.drawString("" + (int)back, (int)(possiblePoints[2].getX()), (int)(possiblePoints[2].getY()));
			
			g.setColor(Color.red);
			/*for (int i = 0; i < allClosestWaves.length; i+= 2) {
				if (allClosestWaves[i] != null) {
					int diameter = 2 * (int)((getTime()-(allClosestWaves[i].fireTime) + 1)*allClosestWaves[i].getBulletSpeed());
					g.drawOval((int)allClosestWaves[i].startx - diameter/2, 600 - (int)allClosestWaves[i].starty - diameter/2, diameter, diameter);
				}
			}*/
			int round = getRoundNum();
			for (int i = 0; i < allClosestWaves.length; i+= 2) {
				if (allClosestWaves[i] != null) {
					double maxValue = mgr.getBestIndexVal(allClosestWaves[i].returnSegment);
					for (int a = 0; a < 31; a++) {
						double currVal = ((allAvoidPts[i][a].val)/maxValue * 25);
						//double currVal = ((allClosestWaves[i].returnSegment[a])/maxValue * 25);
						int distsofar = 2 * (int)((getTime()-(allClosestWaves[i].fireTime) + 1)*allClosestWaves[i].getBulletSpeed());
						double guessfactor = (double)(a-15)/(15);
						double angleOffset = allClosestWaves[i].direction*guessfactor*allClosestWaves[i].maxEscapeAngle();
		
						double bulX = allClosestWaves[i].startx + distsofar/2 * Math.sin(allClosestWaves[i].startBearing + angleOffset);
						double bulY = allClosestWaves[i].starty + distsofar/2 * Math.cos(allClosestWaves[i].startBearing + angleOffset);
						
						if (i == 0) {
							g.drawRect(a*20, 0, 10, (int)currVal * 2);
						}
					
						g.drawOval((int)(bulX - currVal/2), (int)(bulY - currVal/2), (int)currVal, (int)currVal);
					} 
				}
			}
		}
	}
	
	public void onBulletHit(BulletHitEvent e) {
		// FOR BEE GUN
		stinger.onBulletHit(e);
		///////////////////// OFFENSIVE CODE ///////////////////////
		hits++;
		///////////////////// END OFFENSIVE CODE ///////////////////////
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//mgr.onHitByBullet(this, lastScannedRobot, myAccel, getBattleFieldHeight(), getBattleFieldWidth(), getTime() - timeOfLastSwitch, currentIndex, -1);
		mgr.onHitByBullet(this, allClosestWaves[0], currentIndex);
		//mgr.allStats[currentIndex] = mgr.getBestIndexVal() + 1; 
		timeOfHit = getTime();
		eBulletDamTotal += (4 * e.getPower()) + (2 * Math.max(e.getPower() - 1, 0));
		//out.println("Hit at: " + getTime());
	}
	
	public void onHitWall(HitWallEvent e) {
		direction *= -1;
		timeOfLastDirChange = getTime();
	}

	public void onHitRobot(HitRobotEvent e) {
		if (ramMode == false) {
			ramMode = true;
			ramDanger=100;
			out.println("SETTING RAM MODE");
		}
	}
	
	public double getSmoothedAngle(double aBearing, double heading, double x, double y, double direction) {
		double goalDirection = aBearing-Math.PI/2*direction;
		Rectangle2D fieldRect = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		int timesthrough = 0;
		while (!fieldRect.contains(x+Math.sin(goalDirection)*120, y+Math.cos(goalDirection)*120)) {
        	goalDirection += direction*.2;  //turn a little toward my enemy and try again
			if (++timesthrough > 1000) {
				//out.println("problem.");
				break;
			}
		}
		
		double turn = robocode.util.Utils.normalRelativeAngle(goalDirection-heading);
		
		return turn;
	}
	
	public void onWin(WinEvent e) {
		System.out.println("My MC Rating: " + (100 - (eBulletDamTotal/(getRoundNum() + 1))));
		System.out.println("Max time between switches: " + maxTimeBetweenSwitches);
		if (mgr.segmentationLevel != lastKnownSegmentLevel) {
			lastKnownSegmentLevel = mgr.segmentationLevel;
			segmentLevelSwitchTime = getRoundNum() + 1;
		}
		System.out.println("Using segmentation level " + mgr.segmentationLevel + " since round " + segmentLevelSwitchTime);
		// FOR BEE GUN
		stinger.roundOver();
	}
	
	public void onDeath(DeathEvent e) {
		System.out.println("My MC Rating: " + (100 - (eBulletDamTotal/(getRoundNum() + 1))));
		System.out.println("Max time between switches: " + maxTimeBetweenSwitches);
		if (mgr.segmentationLevel != lastKnownSegmentLevel) {
			lastKnownSegmentLevel = mgr.segmentationLevel;
			segmentLevelSwitchTime = getRoundNum() + 1;
		}
		System.out.println("Using segmentation level " + mgr.segmentationLevel + " since round " + segmentLevelSwitchTime);
		// FOR BEE GUN
		stinger.roundOver();
	}
	
	/////////////////// OFFENSIVE CODE ///////////////////
	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName().equals(Tracking)) {
			Tracking = "";
		}
	}
	/////////////////// END OFFENSIVE CODE ///////////////////
	
	public void onSkippedTurn(SkippedTurnEvent e) {
		System.out.println("Skipped turn! time = " + getTime());
		skipped++;
    }

	public void setTurnRightRadians(double turn) {
		super.setTurnRightRadians(turn);
		//robotPredictor.setTurnRightRadians(turn);
    }

    public void setAhead(double d) {
		super.setAhead(d);
		//robotPredictor.setAhead(d);
    }

    public void setMaxVelocity(double v) {
		super.setMaxVelocity(v);
		//robotPredictor.setMaxVelocity(v);
    }
		public MovSimStat[] futurePos(int steps, double x, double y, double velocity, double maxVelocity, double heading, double distanceRemaining, double angleToTurn, double maxTurnRate, double battleFieldW, double battleFieldH) {
                //maxTurnRate in degrees
                MovSimStat[] pos = new MovSimStat[steps];
                double acceleration = 0;
                boolean slowingDown = false;
                double moveDirection;
        
                maxTurnRate = Math.toRadians(maxTurnRate);
                if (distanceRemaining == 0) moveDirection = 0; else if (distanceRemaining < 0.0) moveDirection = -1; else moveDirection = 1;
                
                //heading, accel, velocity, distance
                for (int i=0; i<steps; i++) {
                        //heading
                        double lastHeading = heading;
                        double turnRate = Math.min(maxTurnRate, ((0.4 + 0.6 * (1.0 - (Math.abs(velocity) / systemMaxVelocity))) * systemMaxTurnRate));
                        if (angleToTurn > 0.0) {
                        if (angleToTurn < turnRate) { heading += angleToTurn; angleToTurn = 0.0; } 
                                else { heading += turnRate; angleToTurn -= turnRate; }
                        } else if (angleToTurn < 0.0) {
                        if (angleToTurn > -turnRate) { heading += angleToTurn; angleToTurn = 0.0; } 
                                else { heading -= turnRate;     angleToTurn += turnRate; }
                        }
                        heading = Utils.normalAbsoluteAngle(heading);
                        //movement
                        if (distanceRemaining != 0.0 || velocity != 0.0) { 
                                //lastX = x; lastY = y;
                                if (!slowingDown && moveDirection == 0) {
                                        slowingDown = true;
                                        if (velocity > 0.0) moveDirection = 1;
                                        else if (velocity < 0.0) moveDirection = -1;
                                        else moveDirection = 0;
                            }
                            double desiredDistanceRemaining = distanceRemaining;
                        if (slowingDown) {
                                        if (moveDirection == 1 && distanceRemaining < 0.0) desiredDistanceRemaining = 0.0;
                                        else if (moveDirection == -1 && distanceRemaining > 1.0) desiredDistanceRemaining = 0.0;
                            }
                        double slowDownVelocity = (double) (int) (maxBraking / 2.0 * ((Math.sqrt(4.0 * Math.abs(desiredDistanceRemaining)+ 1.0)) - 1.0));
                        if (moveDirection == -1) slowDownVelocity = -slowDownVelocity;
                        if (!slowingDown) {
                                        if (moveDirection == 1) {
                                        if (velocity < 0.0) acceleration = maxBraking;
                                        else acceleration = maxAcceleration;
                                        if (velocity + acceleration > slowDownVelocity) slowingDown = true;
                                        } else if (moveDirection == -1) {
                                        if (velocity > 0.0) acceleration = -maxBraking;
                                        else acceleration = -maxAcceleration;
                                        if (velocity + acceleration < slowDownVelocity) slowingDown = true;
                                        }
                            }
                        if (slowingDown) {
                                        if (distanceRemaining != 0.0 && Math.abs(velocity) <= maxBraking && Math.abs(distanceRemaining) <= maxBraking) slowDownVelocity = distanceRemaining;
                                        double perfectAccel = slowDownVelocity - velocity;
                                        if (perfectAccel > maxBraking) perfectAccel = maxBraking;
                                        else if (perfectAccel < -maxBraking) perfectAccel = -maxBraking;
                                        acceleration = perfectAccel;
                        }
                            if (velocity > maxVelocity || velocity < -maxVelocity) acceleration = 0.0;
                        velocity += acceleration;
                            if (velocity > maxVelocity) velocity -= Math.min(maxBraking, velocity - maxVelocity);
                        if (velocity < -maxVelocity) velocity += Math.min(maxBraking, -velocity - maxVelocity);
                        double dx = velocity * Math.sin(heading); double dy = velocity * Math.cos(heading);
                            x += dx; y += dy;
                            //boolean updateBounds = false;
                        //if (dx != 0.0 || dy != 0.0) updateBounds = true;
                            if (slowingDown && velocity == 0.0) { distanceRemaining = 0.0; moveDirection = 0; slowingDown = false; acceleration = 0.0; }
                            //if (updateBounds) updateBoundingBox();
                        distanceRemaining -= velocity;
                                if (x<18 || y<18 || x>battleFieldW-18 || y>battleFieldH-18) {
                                        distanceRemaining = 0;
                                        angleToTurn = 0;
                                        velocity = 0;
                                        moveDirection = 0;
                                        x = Math.max(18,Math.min(battleFieldW-18,x));
                                        y = Math.max(18,Math.min(battleFieldH-18,y));
                                }
                        }
                        //add position
                        pos[i] = new MovSimStat(x,y,velocity,heading,Utils.normalRelativeAngle(heading-lastHeading));
                }
                return pos;             
        }

	public void doScanner() {
	    timeSinceLastScan++;
	    double radarOffset = Double.POSITIVE_INFINITY;
	    if(timeSinceLastScan < 4) {
	        radarOffset = robocode.util.Utils.normalRelativeAngle(getRadarHeadingRadians() - absBearing);
	        radarOffset += sign(radarOffset) * 0.15;
	    }
	    setTurnRadarLeftRadians(radarOffset);
	}

	int sign(double v) {
	    return v > 0 ? 1 : -1;
	}

	//////////////////////////////////// OFFENSIVE CODE //////////////////////////////////
	public void fireLinear(ScannedRobotEvent e, double absBearing, double enemyX, double enemyY) {
				double bulletPower = power;
				/*Math.min(3.0,getEnergy())*/
                double myX = getX();
                double myY = getY();
                double enemyHeading = e.getHeadingRadians();
                double enemyVelocity = e.getVelocity();
                
                
                double deltaTime = 0;
                double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
                double predictedX = enemyX, predictedY = enemyY;
                while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){          
                        predictedX += Math.sin(enemyHeading) * enemyVelocity;   
                        predictedY += Math.cos(enemyHeading) * enemyVelocity;
                        if(     predictedX < 18.0 
                                || predictedY < 18.0
                                || predictedX > battleFieldWidth - 18.0
                                || predictedY > battleFieldHeight - 18.0){
                                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);     
                                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                                break;
                        }
                }
                double theta = robocode.util.Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
                setTurnGunRightRadians(normalRelativeAngle(theta - getGunHeadingRadians()));
	}
	
	public void fireHeadOn(ScannedRobotEvent e) {
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
	}
	
	public void fireCircular(ScannedRobotEvent e) {
				double w=e.getHeadingRadians()-plastEnemyHeading;
                plastEnemyHeading=e.getHeadingRadians();
                double absbearing=e.getBearingRadians()+getHeadingRadians();
                double eX=e.getDistance()*Math.sin(absbearing);
                double eY=e.getDistance()*Math.cos(absbearing);
				double speed = 20-power*3;
				/*(Math.min(3.0, e.getEnergy()/4))*/
                double db=0;
                double ww=lastEnemyHeading;
                do
                {
                        db+=speed;
                        double dx=e.getVelocity()*Math.sin(ww);
                        double dy=e.getVelocity()*Math.cos(ww);
                        ww+=w;
                        eX+=dx;
                        eY+=dy;
                }while (db< Point2D.distance(0,0,eX,eY));

                setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - getGunHeadingRadians())));
	}
	
	public void fireLaser(ScannedRobotEvent e) {
		if (segmentHitOffsets.size() > 0) {
			if (getGunHeat() <= getGunCoolingRate()) {
				Double objFireAtOffset = (Double)segmentHitOffsets.get(gen.nextInt(segmentHitOffsets.size()));
				double fireAtOffset = objFireAtOffset.doubleValue();
				fireAtOffset *= eDirection;
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+fireAtOffset));
				//out.println("Would fire at: " + fireAtOffset);
			}
		} else {
			fireLinear(e, absBearing, enemyX, enemyY);
		}
	}
	
	public void firePattern(ScannedRobotEvent e) {
		setTurnGunRightRadians(Math.asin(Math.sin((paramOne - paramTwo) / e.getDistance() + absBearing - getGunHeadingRadians())));
	}
	
	public void fireGuessFactor() {
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+gfAngleOffset));
	}
	
	public void chooseOnMerit(ScannedRobotEvent e) {
		/*int fireType = myVGuns.returnBestGun();
		if (fireType == 1) {
			//out.println("Fired Linear.");
			fireLinear(e, absBearing, enemyX, enemyY);
			fireMethod = new Integer(0);
		} else if (fireType == 0) {
			//out.println("Fired Head On.");
			fireHeadOn(e);
			fireMethod = new Integer(1);
		} else if (fireType == 2) {
			//out.println("Fired Circular.");
			fireCircular(e);
			fireMethod = new Integer(2);
		} else if (fireType == 3) {
			//out.println("Fired Laser.");
			fireLaser(e);
			fireMethod = new Integer(3);
		} else if (fireType == 4) {
			//out.println("Fired Pattern Matching.");
			firePattern(e);
			fireMethod = new Integer(4);
		} else if (fireType == 5) {
			fireGuessFactor();
			fireMethod = new Integer(5);
		}*/
		//out.println("Best value: " + fireType);
	}
	
	public void chooseRandom(ScannedRobotEvent e) {
				int fireType = gen.nextInt(3);
				if (fireType == 0) {
					fireLinear(e, absBearing, enemyX, enemyY);
					fireMethod = new Integer(0);
				} else if (fireType == 1) {
					fireHeadOn(e);
					fireMethod = new Integer(1);
				} else {
					fireCircular(e);
					fireMethod = new Integer(2);
				}
	}

	public double returnLinear(ScannedRobotEvent e, double absBearing, double enemyX, double enemyY) {
				double bulletPower = power;
                double myX = getX();
                double myY = getY();
                double enemyHeading = e.getHeadingRadians();
                double enemyVelocity = e.getVelocity();
                
                
                double deltaTime = 0;
                double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
                double predictedX = enemyX, predictedY = enemyY;
                while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){          
                        predictedX += Math.sin(enemyHeading) * enemyVelocity;   
                        predictedY += Math.cos(enemyHeading) * enemyVelocity;
                        if(     predictedX < 18.0 
                                || predictedY < 18.0
                                || predictedX > battleFieldWidth - 18.0
                                || predictedY > battleFieldHeight - 18.0){
                                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);     
                                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                                break;
                        }
                }
                double theta = robocode.util.Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
                return Math.toDegrees(robocode.util.Utils.normalRelativeAngle(theta));
	}
	
	public double returnHeadOn(ScannedRobotEvent e) {
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		return Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing));
	}
	
	public double returnCircular(ScannedRobotEvent e) {
		double w=e.getHeadingRadians()-lastEnemyHeading;
        lastEnemyHeading=e.getHeadingRadians();
        double absbearing=e.getBearingRadians()+getHeadingRadians();
        double eX=e.getDistance()*Math.sin(absbearing);
        double eY=e.getDistance()*Math.cos(absbearing);
		double speed = 20-power*3;
        double db=0;
        double ww=lastEnemyHeading;
        do
        {
            db+=speed;
            double dx=e.getVelocity()*Math.sin(ww);
            double dy=e.getVelocity()*Math.cos(ww);
            ww+=w;
            eX+=dx;
            eY+=dy;
        }while (db< Point2D.distance(0,0,eX,eY));
        if (getY() > enemyY) {
			if (getX() > enemyX) {
            	return Math.toDegrees(Math.acos(Math.cos(Math.atan2(eX, eY)))) * -1;
			} else {
				return Math.toDegrees(Math.acos(Math.cos(Math.atan2(eX, eY))));
			}
		} else {
			return Math.toDegrees(Math.asin(Math.sin(Math.atan2(eX, eY))));
		}
	}
	
	public double returnLaser(ScannedRobotEvent e) {
		if (segmentHitOffsets != null) {
			if (segmentHitOffsets.size() > 0) {
				Double objFireAtOffset = (Double)segmentHitOffsets.get(gen.nextInt(segmentHitOffsets.size()));
				double fireAtOffset = objFireAtOffset.doubleValue();
				fireAtOffset *= eDirection;
				return Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing+fireAtOffset));
				//out.println("Would fire at: " + fireAtOffset);
			} else {
				return returnHeadOn(e);
			}
		} else {
			return returnHeadOn(e);
		}
	}
		
	public double returnPattern(ScannedRobotEvent e, double power) {
		double pmprednow = 0;
		if (getY() < enemyY) {
			pmprednow = Math.toDegrees(Math.asin(Math.sin((paramOne - paramTwo) / eDist + absBearing)));
		} else {
			if (getX() > enemyX) {
				pmprednow = Math.toDegrees(Math.acos(Math.cos((paramOne - paramTwo) / eDist + absBearing)) * -1);
			} else {
				pmprednow = Math.toDegrees(Math.acos(Math.cos((paramOne - paramTwo) / eDist + absBearing)));
			}
		}

		if (Math.abs(pmprednow - Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing))) > Math.toDegrees(Math.asin(8 / (20 - 3 * power)))) {
			return returnLinear(e, absBearing, enemyX, enemyY);
		} else {
			return pmprednow;
		}
	}
	
	public double returnGuessFactor() {
		return(Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing+gfAngleOffset)));
	}
	
	public void updateLaserTargeting(ScannedRobotEvent e, double power) {
		//don't try to figure out the direction they're moving if they're not moving, just use the direction we had before
        if (e.getVelocity() != 0)
            if (Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity() < 0)
                 eDirection = -1;
            else
                 eDirection = 1;
		
		segmentHitOffsets = (Vector)allHitOffsets[(int)e.getDistance()/100];
		//out.println(segmentHitOffsets.toString());
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		
		LaserBullet newBullet = new LaserBullet(getX(), getY(), headOnBearing, power, getTime(), eDirection, segmentHitOffsets);
		
		myBullets.add(newBullet);
		
		for (int i=0; i<myBullets.size(); i++) {
            LaserBullet currentWave = (LaserBullet)myBullets.get(i);

            if (currentWave.checkHit(enemyX, enemyY, getTime())) {
                myBullets.remove(currentWave);
                i--;
            }
        }
	}
	
	public void updatePMTargeting(ScannedRobotEvent e, double power) {
		// pattern matcher - idea (and a little bit of the code) from Moebius.
		Double relVel = new Double(e.getVelocity() * Math.sin(e.getHeadingRadians() + absBearing));
		lastFew.insertElementAt(relVel, 0);
		double reldblVel = relVel.doubleValue();
		Double temp = (Double)arcLength.get(historyIndex++);
		double prevArcLength = temp.doubleValue();
		arcLength.add(historyIndex, new Double(prevArcLength + reldblVel));
		if (lastFew.size() > MAX_SEARCHES) {
			lastFew.setSize(MAX_SEARCHES);
		}
		
		int index = -1;
		
		if (lastFew.size() < MAX_SEARCHES) {
		} else {
			int tries = 0;
			StringBuffer search = new StringBuffer();
			
			if(fullPattern.length() > 0) {
				while(index == -1) {
					if (tries < MAX_SEARCHES) {
						search.setLength(0);
						for (int i = 0; i < MAX_SEARCHES - tries; i++) {
							Double currentVal = (Double)lastFew.get(i);
							double doubVal = currentVal.doubleValue();
							search.append((char)doubVal);
						}
						index = fullPattern.lastIndexOf(search.toString());
					} else {
						break;
					}
					tries++;
				}
			}
			if (index != -1) {
				index += MAX_SEARCHES - (tries - 1);
				int timeToHit = (int)Math.abs(e.getDistance()/(20 - 3 * power));
				//timeToHit += 2;
				if (index + timeToHit >= arcLength.size()) {
					index += arcLength.size() - index - timeToHit - 1;
				}
				Double convert = (Double)arcLength.get(index + timeToHit);
				paramOne = convert.doubleValue();
				convert = (Double)arcLength.get(index);
				paramTwo = convert.doubleValue();
			}

			//out.println(index + " with " + (tries - 1) + " searches.");
		}
		//out.println(reldblVel);
		fullPattern.append((char)reldblVel);
		
		// clean up if too large
		if (historyIndex == MAX_BUFFER_SIZE - 1) {
			fullPattern.delete(0, 1);
			arcLength.removeElementAt(0);
			historyIndex = MAX_BUFFER_SIZE - 2;
		} else {
			arcLength.removeElementAt(arcLength.size() - 1);
		}
		//out.println(lastFew.toString());	}
	}
	
	public void updateGFTargeting(ScannedRobotEvent e) {
		//process waves
                for (int i=0; i<waves.size(); i++)
                {
                        WaveBullet currentWave = (WaveBullet)waves.get(i);
                        if (currentWave.checkHit(enemyX, enemyY, getTime()))
                        {
								//out.println("The Index Is: " + currentWave.index);
                                waves.remove(currentWave);
                                i--;
								wavesHit++;
                        }
                }
                
                
                int[] currentStats = stats[(int)(e.getDistance()/100)];
                WaveBullet newWave = new WaveBullet(getX(), getY(), absBearing, power, eDirection, getTime(), currentStats);
				
				int bestindex = 15;     //initialize it to be in the middle, guessfactor 0.
                for (int i=0; i<31; i++) {
						//out.println("I= " + i + "Its Value: " + currentStats[i]);
                        if (currentStats[bestindex] < currentStats[i]) {
                                bestindex = i;
						}
				}
				
				//out.println("E Velocity: " + e.getVelocity());

				if (wavesHit < 50 || e.getVelocity() == 0 || e.getDistance() < 100) {
                	bestindex = 15;
				}

                //this should do the opposite of the math in the WaveBullet:
                double guessfactor = (double)(bestindex-(currentStats.length-1)/2)/((currentStats.length-1)/2);
				gfAngleOffset = eDirection*guessfactor*newWave.maxEscapeAngle();
				//out.println("angleOffset = " + (int)gfAngleOffset);
				
               	waves.add(newWave);
	}

	private double normalRelativeAngle(double angle) {
        double relativeAngle = angle % 360;
        if (relativeAngle <= -180)
            return 180 + (relativeAngle % 180);
        else if (relativeAngle > 180)
            return -180 + (relativeAngle % 180);
        else
            return relativeAngle;
    }
	//////////////////////////////////// END OFFENSIVE CODE //////////////////////////////////
}