package whind;
import robocode.*;
import java.awt.geom.*;
import java.awt.Color;

public class TwintelligenceTwo extends TeamRobot {
	
	// enemy data
	String myTarget = null;
	
	String robotName1;
	double enemy1X;
	double enemy1Y;
	double absBearing1;
	double e1Energy;
	double e1Power;
	double e1Dist;
	double e1Heading;
	
	String robotName2;
	double enemy2X;
	double enemy2Y;
	double absBearing2;
	double e2Energy;
	double e2Power;
	double e2Dist;
	double e2Heading;
	
	// for radar
	int radarDirection = 1;
	int scannedRobots;
	int enemiesRemaining = 2;
	
	// for movement
	Rectangle2D.Double fieldRectangle;
	Point2D.Double goToHere;
	Point2D.Double location;
	double x;
	double y;
	
	/**
	 * run: TwintelligenceOne's default behavior
	 */
	public void run() {
		setColors(Color.red, Color.black, Color.gray);
		
		fieldRectangle = new Rectangle2D.Double(0, 0, getBattleFieldWidth(), getBattleFieldHeight());
		
		while(true) {
			setTurnRadarRight(Double.POSITIVE_INFINITY * radarDirection);
			
			if (getGunTurnRemaining() < 20 && myTarget != null) {
				setFire(3);
			}
			
			location = new Point2D.Double(getX(), getY());
			
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if (myTarget == null && !isTeammate(e.getName())) {
			myTarget = e.getName();
		}
		
		if (!isTeammate(e.getName())) {
			scannedRobots++;
			
			if (robotName1 == null) {
				robotName1 = e.getName();
			} else {
				if (robotName2 == null) {
					robotName2 = e.getName();
				}
			}
		}
		
		if (scannedRobots == enemiesRemaining) {
			// start movement code here.
			scannedRobots = 0;
			radarDirection *= -1;
		}
		
		if (e.getName() == robotName1) {
			//prevE1Dist = e1Dist;
			e1Dist = e.getDistance();
			absBearing1 = getHeadingRadians() + e.getBearingRadians();
		
        	//find our enemy's location:
        	enemy1X = getX() + Math.sin(absBearing1)*e.getDistance();
        	enemy1Y = getY() + Math.cos(absBearing1)*e.getDistance();
			
			if (myTarget == robotName1) {
				// movement code here.
				doMove(e);
				
				// firing code here.
				doFire(e);
			}
		}
		
		if (e.getName() == robotName2) {
			//prevE2Dist = e2Dist;
			e2Dist = e.getDistance();
			absBearing2 = getHeadingRadians() + e.getBearingRadians();
		
        	//find our enemy's location:
        	enemy2X = getX() + Math.sin(absBearing2)*e.getDistance();
        	enemy2Y = getY() + Math.cos(absBearing2)*e.getDistance();

			if (myTarget == robotName2) {
				// movement code here.
				doMove(e);
				
				// firing code here.
				doFire(e);
			}
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		if (!isTeammate(e.getName())) {
			enemiesRemaining--;
			myTarget = null;
		}
	}
	
	public void doMove(ScannedRobotEvent e) {
		if (myTarget != null && robotName1 != null && robotName2 != null && enemiesRemaining == 2) {
			double distance = Point2D.distance(enemy2X, enemy2Y, enemy1X, enemy1Y) + 100;
			
			if (myTarget == robotName1) {
				double lineBearing = absoluteBearing(new Point2D.Double(enemy2X, enemy2Y), new Point2D.Double(enemy1X, enemy1Y));
				x = enemy2X + Math.sin(Math.toRadians(lineBearing))*distance;
        		y = enemy2Y + Math.cos(Math.toRadians(lineBearing))*distance;
			} else {
				double lineBearing = absoluteBearing(new Point2D.Double(enemy2X, enemy2Y), new Point2D.Double(enemy1X, enemy1Y));
				x = enemy1X + Math.sin(Math.toRadians(lineBearing))*distance;
        		y = enemy1Y + Math.cos(Math.toRadians(lineBearing))*distance;
			}
			
			goToHere = new Point2D.Double(x, y);
			
			translateInsideField(goToHere, 50);
			goTo(goToHere);
		} else {
			setTurnLeft(90 - e.getBearing());
			setAhead(100 * (getTime()%100 - 50));
		}
	}
	
	public void doFire(ScannedRobotEvent e) {
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
	}
	
	public void onMessageReceived(MessageEvent e) {
		String message = (String)e.getMessage();
		if (message == myTarget) {
			if (myTarget == robotName1) {
				myTarget = robotName2;
			} else {
				myTarget = robotName1;
			}
		}
	}
	
	private void goTo(Point2D point) {
        double distance = location.distance(point);
        double angle = normalRelativeAngle(absoluteBearing(location, point) - getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            if (angle > 0.0) {
                angle -= 180.0;
            }
            else {
                angle += 180.0;
            }
        }
        setTurnRight(angle);
        setAhead(distance);
    }

	private double normalRelativeAngle(double angle) {
        double relativeAngle = angle % 360;
        if (relativeAngle <= -180)
            return 180 + (relativeAngle % 180);
        else if (relativeAngle > 180)
            return -180 + (relativeAngle % 180);
        else
            return relativeAngle;
    }

	private void translateInsideField(Point2D point, double margin) {
        double X = Math.max(margin, Math.min(fieldRectangle.getWidth() - margin, point.getX()));
        double Y = Math.max(margin, Math.min(fieldRectangle.getHeight() - margin, point.getY()));
        point.setLocation(X, Y);
    }

	private double absoluteBearing(Point2D source, Point2D target) {
         return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }
}
		