package jam;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*
;import java.util.*;
import java.util.zip.*;
import java.io.*;
import jam.utils.jUtil;

/**
* 	Narcissus

    A self-graphing tool for robocode.
    See http://robowiki.net/perl/robowiki?Narcissus
*/
public class Narcissus
{
    static final double WALL_FACTOR = .8;
    static final int GF_ZERO = 15;
    static final int GF_ONE = 2*GF_ZERO;
    static final int PREDICT_WIDTH = 4;

    // wall approach, acceleration, lateral velocity, bullet flight time, guessfactors
    double[][][][] guessFactors = new double[3][3][7][GF_ONE + 1];
    double[][][][] hitFactors = new double[3][3][7][GF_ONE + 1];
    Rectangle2D.Double BF;
    double lastEnemyFireTime = 30;
    double lastEnemyVelocity;
    boolean enemyHasFired;
    double bearingDirection = 1;
    double enemyEnergy;
    double myEnergy;
    double enemyFirePower;
    double lastVelocity;
    double velocity;
    double lateralVelocity;
    double heading;
    Point2D.Double enemyLocation = new Point2D.Double();
    Point2D.Double myLocation = new Point2D.Double();
    WaveStore waves = new WaveStore();
    double myBearing;
    double time;
    double enemyDistance;
    AdvancedRobot me;
    String enemyName;
    boolean collectData = true;
    boolean onlyOnFire = false;
    double defaultBulletPower = 0;
    double hits, goodHits;
    int lastHitGF = 0;
    public double enemyShotCount = 0, enemyFoundCount = 0, enemyHitCount = 0, headOnCount = 0;


    public Narcissus(){
        for (int i = 0; i < 3; i++)
            for (int j = 0; j < 3; j++)
                for (int k = 0; k < 7; k++)
                    hitFactors[i][j][k][GF_ZERO] = .05;
    }

    public void newRound(AdvancedRobot me){
        this.me = me;

        BF = new Rectangle2D.Double(18, 18, me.getBattleFieldWidth() - 36, me.getBattleFieldHeight() - 36);

        enemyFirePower = defaultBulletPower;
        waves.newRound();


    }

    public void setCollectData(boolean b){
        collectData = b;
    }

    public void setDefaultFirePower(double dbp){

        defaultBulletPower = dbp;
    }

    public void setOnlyOnFire(boolean b){

        onlyOnFire = b;
    }
    boolean isHeadOn(){
        return headOnCount/enemyFoundCount > .7;
    }
    public double getGoodHitRate(){
        return goodHits/enemyFoundCount;
    }
    public double getEnemyHitRate(){
        return enemyHitCount/enemyShotCount;
    }

    private EnemyWave createWave() {

        EnemyWave w = new EnemyWave();
        w.bulletVelocity = jUtil.bulletVelocity(enemyFirePower);
        w.fireLocation = enemyLocation;
        w.fireTime = time;
        w.targetLocation = myLocation;
        w.bearingDirection = bearingDirection;

        int bftIndex = Math.min(6, (int)(enemyDistance/w.bulletVelocity/10));

        int accelIndex = (int)Math.round(Math.abs(velocity) - Math.abs(lastVelocity));
        if (accelIndex != 0)
            accelIndex = (accelIndex < 0)? 2 : 1;
        int latVelIndex = (int)(Math.abs(lateralVelocity)/3);

        w.waveGFs = guessFactors[accelIndex][latVelIndex][bftIndex];
        w.waveHFs = hitFactors[accelIndex][latVelIndex][bftIndex];
        w.accelIndex = accelIndex;
        w.distanceIndex = bftIndex;
        w.latVelIndex = latVelIndex;
        int bestGF = GF_ZERO;
        int bestHF = GF_ZERO;
        for (int i = 1; i <= GF_ONE; i++){
            if (w.waveGFs[i] > w.waveGFs[bestGF])
                bestGF = i;
            if (w.waveHFs[i] > w.waveHFs[bestHF])
                bestHF = i;
        }
        w.predictedHF = bestHF;
        w.predictedGF = bestGF;

        return w;

    }

    public void onScannedRobot(ScannedRobotEvent e){

        boolean enemyFired = false;

        double eDrop = enemyEnergy - e.getEnergy();
        if (eDrop > 0 && eDrop <= 3){
            enemyFirePower = eDrop;
            enemyFired = true;
            enemyShotCount++;
            lastEnemyFireTime = time;
        }

        if (enemyFirePower > 0 && collectData && me.getEnergy() > 0 && (!onlyOnFire || enemyFired))
            waves.add(createWave(), enemyFired);

        /* ------ Data setup ------ */
        synchState();
        double enemyAbsoluteBearing = me.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = jUtil.projectMotion(myLocation, enemyAbsoluteBearing, enemyDistance);
        myBearing = jUtil.absoluteBearing(enemyLocation, myLocation);
        enemyEnergy = e.getEnergy();
        lateralVelocity = velocity*Math.sin(heading - myBearing);
        if (lateralVelocity != 0)
            bearingDirection = lateralVelocity > 0 ? 1 : -1;

        /* ------ Wave update ------- */
        waves.update(myLocation, time);

    }
    public void synchState(){
        if (time == me.getTime()) return;
        myEnergy = me.getEnergy();
        myLocation = new Point2D.Double(me.getX(), me.getY());
        lastVelocity = velocity;
        velocity = me.getVelocity();
        time = me.getTime();
        heading = me.getHeadingRadians();
    }

    public void doMovement(){

        synchState();

        EnemyWave nextWave = waves.getNearestBullet(myLocation, time);
        double circleDir = bearingDirection;

        if (nextWave == null){
            //return 1;
            Point2D.Double p1 = getReferencePoint(myLocation, enemyLocation, bearingDirection);
            Point2D.Double p2 = getReferencePoint(myLocation, enemyLocation, -bearingDirection);
            if( Math.abs(jUtil.angleBetween(myLocation, enemyLocation, p1)) >=  Math.abs(jUtil.angleBetween(myLocation, enemyLocation, p2)) ^ (enemyEnergy < 5))
                circleDir = bearingDirection;
            else
                circleDir = -bearingDirection;


        } else {

            double valFwd = findImpacts(myLocation, bearingDirection, velocity, time, heading);
            double valBack = findImpacts(myLocation, -bearingDirection, velocity, time, heading);

            circleDir =  valFwd > valBack ? -bearingDirection : bearingDirection;

        }

        Point2D.Double newDestination = getReferencePoint(myLocation, getOrbitCentre(), circleDir);
        double theta;

        theta = jUtil.absoluteBearing(myLocation, newDestination) - me.getHeadingRadians();
        me.setAhead(Math.cos(theta)*100);
        me.setTurnRightRadians(Math.tan(theta));

        //*cough*
        me.setMaxVelocity(8);
        if (me.getNumRounds() - me.getRoundNum()+1 < 2 && enemyHitCount == 0 && enemyFirePower < 1)
            me.setMaxVelocity(0);


    }

    public double findImpacts(Point2D.Double start,  double circleDir,  double cVel, double cTime, double cHeading){
    EnemyWave nextWave =  waves.getNearestBullet(start, cTime);
    if (nextWave == null) return 0;

        Point2D.Double nextPoint = new Point2D.Double(start.x, start.y);
        Point2D.Double ref;

        double val = 0;
        double maxVel = 8;
        boolean exCond = false;
        double remain;
        //while ((nextWave = waves.getNearestBullet(nextPoint, cTime)) != null){
            do {

                ref = getReferencePoint(nextPoint, nextWave.fireLocation, circleDir);

                if (Math.abs(Utils.normalRelativeAngle(jUtil.absoluteBearing(nextPoint, ref) - cHeading)) > Math.PI/2){
                    cHeading = Utils.normalRelativeAngle(cHeading+Math.PI);
                    cVel = -cVel;
                }

                double maxTurn = Math.toRadians(10 - .75*Math.abs(cVel));
                double turn = Math.tan(Utils.normalRelativeAngle(jUtil.absoluteBearing(nextPoint, ref) - cHeading));
                turn = jUtil.bindToRange(turn, -maxTurn, maxTurn);

                if (cVel < 0)
                    cVel = Math.min(cVel+2, 0);
                else
                    cVel = Math.min(Math.max(maxVel, cVel-2), cVel+1);
                //distance += cVel;
                cHeading = Utils.normalRelativeAngle(cHeading + turn);
                nextPoint = jUtil.projectMotion(nextPoint, cHeading, cVel);

            } while ( nextWave.distanceFromPoint(cTime++, nextPoint) < -18);

            if (getGoodHitRate() > .55){
                int gf;
                gf = nextWave.predictedHF;
                if (isHeadOn())
                    gf = GF_ZERO;

                double i = Math.abs(gf - nextWave.getGF(nextPoint));
                if (i <  Math.ceil(GF_ONE*(Math.atan(18/nextPoint.distance(nextWave.fireLocation))/Math.asin(8D/nextWave.bulletVelocity))))
                    i /= 4d;
                else if (!BF.contains(nextPoint))
                    i = .4;
                else if (Math.abs(jUtil.absoluteBearing(nextPoint, enemyLocation) - cHeading) < Math.PI/3.5)
                    i /= 2d;
                val += 1/i/Math.pow(Math.abs(nextWave.distanceFromPoint(time, myLocation)/nextWave.bulletVelocity), .3);
            } else{
                val += nextWave.getValueOf(nextPoint)/Math.pow(Math.abs(nextWave.distanceFromPoint(time, myLocation)/nextWave.bulletVelocity), 0.5);
           // }

        }
        return val + Math.min(findImpacts(nextPoint,  circleDir,  cVel, cTime, cHeading), findImpacts(nextPoint,  -circleDir,  cVel, cTime, cHeading));
    }
        public Point2D.Double getReferencePoint(Point2D.Double start, Point2D.Double orbitCentre, double circleDir, double angle){

        double distDelta = 0.1 + Math.PI/2 + angle;
        Point2D.Double newDestination;
        while (!BF.contains(newDestination = jUtil.projectMotion(start, jUtil.absoluteBearing(start, orbitCentre) - circleDir*(distDelta-=0.1), 170)));

        return newDestination;

    }
    public Point2D.Double getReferencePoint(Point2D.Double start, Point2D.Double orbitCentre, double circleDir){
        double bestDist = 525;
        double closeAngle = -.1;
        /*
        if (enemyEnergy < 5 && myEnergy > 20){
            bestDist = 130;
            closeAngle = -.5;
        }*/
        double angle = (orbitCentre.distance(start) > bestDist  ? closeAngle : .5);

        return getReferencePoint(start, orbitCentre, circleDir, angle);

    }

    public boolean inDanger(){
        return waves.numAliveBullets(myLocation, time) > 0;

    }

    public Point2D.Double getOrbitCentre(){
        EnemyWave e = waves.getNearestBullet(myLocation, time);
        if (e == null)
            return enemyLocation;
        return e.fireLocation;
    }

    public void bulletUpdate(Bullet b){

        enemyFoundCount++;
        Point2D.Double impact = new Point2D.Double(b.getX(), b.getY());

        double bestDistance = Double.POSITIVE_INFINITY;
        double hitTime = me.getTime();
        EnemyWave closestWave = waves.getClosestBullet(impact, hitTime);
        if (closestWave == null) return;
        int hitGF = closestWave.getGF(impact);
        if (closestWave.willHitGF(hitGF))
            goodHits++;
        if (Math.abs(hitGF - GF_ONE/2) < Narcissus.PREDICT_WIDTH)
            headOnCount++;

        lastHitGF = hitGF;
        closestWave.updateHitFactor(impact);
    }
    public void onBulletHitBullet(BulletHitBulletEvent e){

        bulletUpdate(e.getHitBullet());
     }

    public void onHitByBullet(HitByBulletEvent e){
        enemyEnergy += 3*e.getBullet().getPower();
        enemyHitCount++;
        bulletUpdate(e.getBullet());
     }
    public void onBulletHit(BulletHitEvent event){
        Bullet b = event.getBullet();
        double power = b.getPower();
        enemyEnergy -= 4*power + Math.max(2*power - 1, 0);

    }

    static int toGF(double angle){
        return (int)Math.round((angle + 1D)*GF_ZERO);
    }

    /* I'm not really using a crib-sheet here,
        but bytes take sufficiently less space
        than doubles that it's good enough.
    */
    public void saveData(String enemyName){
        byte[][][][] crib = new byte[3][3][7][GF_ONE+1];
        for (int j = 0; j < 3; j++)
        for (int k = 0; k < 3; k++)
            for (int l = 0; l < 7; l++)
                for (int m = 0; m <= GF_ONE; m++)
                    crib[j][k][l][m] = (byte)(255*hitFactors[j][k][l][m]);
        jUtil.saveObject(crib, me.getDataFile(enemyName+".narc"));
    }

    public void restoreData(String enemyName){
        Object o = jUtil.restoreObject(me.getDataFile(enemyName+".narc"));
        byte[][][][] crib;
        try {
            crib = (byte[][][][])o;
            for (int j = 0; j < 3; j++)
            for (int k = 0; k < 3; k++)
                for (int l = 0; l < 7; l++)
                for (int m = 0; m <= GF_ONE; m++)
                    hitFactors[j][k][l][m] = ((double)crib[j][k][l][m])/255/3;
        }	catch (Exception e){}
    }



}


class EnemyWave {

    double bulletVelocity;
    Point2D.Double fireLocation;
    double fireTime;
    Point2D.Double targetLocation;
    double bearingDirection;
    double[] waveGFs;
    double[] waveHFs;

    int predictedGF;
    int predictedHF;
    int accelIndex, distanceIndex, latVelIndex;

    public boolean willHitGF(int gf){
        return Math.abs(predictedHF - gf) < Narcissus.PREDICT_WIDTH;
    }
    public double distanceFromPoint(double atTime, Point2D.Double loc){
        return bulletVelocity*(atTime - fireTime) - fireLocation.distance(loc);
    }

    public double getDistance(Point2D.Double loc){
        return fireLocation.distance(loc);
    }

    public void updateHitFactor(Point2D.Double loc){
        int gf = getGF(loc);

        if (gf >= 1 && gf <= Narcissus.GF_ONE)
            for (int i = 1; i <= Narcissus.GF_ONE; i++)
                waveHFs[i] = jUtil.rollingAverage(10, waveHFs[i], i == gf ? 1 : 0);
    }

    public double getValueOf(int gf){
        double val = 0;

        for (int i = 1; i <= Narcissus.GF_ONE; i++)
            val += (waveHFs[i] + waveGFs[i]/10D )/Math.pow(Math.abs(gf - i) + 1, .5);

        return val;
    }
    public double getValueOf(Point2D.Double target){
        double val = 0;

        int gf = getGF(target);
        return getValueOf(gf);
    }
    public int getGF(Point2D.Double location){

        double angle = bearingDirection*Utils.normalRelativeAngle(jUtil.absoluteBearing(fireLocation, location) - jUtil.absoluteBearing(fireLocation, targetLocation));
        angle /= jUtil.maxEscapeAngle(bulletVelocity);
        int gf = Narcissus.toGF(angle);
        return gf;
    }

    public boolean test(double time, Point2D.Double location){

        if (bulletVelocity*(time - fireTime) >= (fireLocation.distance(location)-18)){
            int gf = getGF(location);
            if (gf >= 1 && gf <= Narcissus.GF_ONE){
                for (int i = 1; i <= Narcissus.GF_ONE ; i++)
                    waveGFs[i] = jUtil.rollingAverage(waveGFs[0], waveGFs[i], gf == i ? 1 : 0);
                waveGFs[0]++; //GF -1 is the num of updates in the segment
            }
            return true;
        }
        return false;
    }

}

class WaveStore{

    Vector enemyWaves = new Vector(10);
    Vector enemyBullets = new Vector(10);

    public void newRound(){

        enemyWaves.clear();
        enemyBullets.clear();
    }
    public void add(EnemyWave w, boolean fired){

        enemyWaves.add(w);
        if (fired)
            enemyBullets.add(w);
    }

    public EnemyWave getClosestBullet(Point2D.Double impact, double hitTime){

        EnemyWave closestWave = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        for (Enumeration en = enemyBullets.elements(); en.hasMoreElements();) {
            EnemyWave w	= (EnemyWave)en.nextElement();
            if (Math.abs(w.distanceFromPoint(hitTime, impact)) < bestDistance){
                bestDistance = w.distanceFromPoint(hitTime, impact);
                closestWave = w;
            }
        }
        return closestWave;
    }

    public EnemyWave getNearestBullet(Point2D.Double loc, double t){

        double bestVal = Double.NEGATIVE_INFINITY;
        if (enemyBullets.size() == 0)
                return null;

        EnemyWave nextWave = null;
        for (Enumeration en = enemyBullets.elements(); en.hasMoreElements();){
            EnemyWave w = (EnemyWave)en.nextElement();
            double d = w.distanceFromPoint(t, loc);
            if (d < -18 && d > bestVal) {
                bestVal = d;
                nextWave = w;
            }
        }

        return nextWave;
    }

    public int numAliveBullets(Point2D.Double loc, double t){
        if (loc == null) return 0;
        int num = 0;
        for (Enumeration en = enemyBullets.elements(); en.hasMoreElements();){
            EnemyWave w = (EnemyWave)en.nextElement();
                if (w.distanceFromPoint(t, loc) < 0)
                    num++;
        }
        return num;
    }

    public void update(Point2D.Double myLocation, double time){
        for (Iterator it = enemyWaves.iterator(); it.hasNext();) {
            EnemyWave w	= (EnemyWave)it.next();
            if (w.test(time, myLocation))
                it.remove();
        }

        for (Iterator it = enemyBullets.iterator(); it.hasNext();) {
            EnemyWave w	= (EnemyWave)it.next();
            if (w.distanceFromPoint(time, myLocation) > 40)
                it.remove();
        }
    }
}
