package dsekercioglu.mega.wfGun.precise;

import dsekercioglu.mega.wfGun.GunUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WallSmoothingMEACalculator {

    final double BF_WIDTH;
    final double BF_HEIGHT;
    final double ORIENTATION;
    final Rectangle2D.Double B_FIELD;

    private Point2D.Double[] escapePositions = new Point2D.Double[2];
    private double[] escapeAngles = new double[2];

    public WallSmoothingMEACalculator(double battleFieldWidth, double battleFieldHeight, double orientation) {
        BF_WIDTH = battleFieldWidth;
        BF_HEIGHT = battleFieldHeight;
        ORIENTATION = orientation;
        B_FIELD = new Rectangle2D.Double(17.9, 17.9, battleFieldWidth - 35.8, battleFieldHeight - 35.8);
    }

    public void calculateEscapeAngle(Point2D.Double robotLocation, Point2D.Double orbitLocation, double bulletSpeed) {
        for (int i = -1; i <= 1; i += 2) {
            double absoluteBearing = GunUtils.absoluteBearing(orbitLocation, robotLocation);
            double moveAngle = absoluteBearing + Math.PI / 2;
            Point2D.Double interception = intercept(orbitLocation, bulletSpeed, robotLocation, moveAngle, 8 * i);
            while (!B_FIELD.contains(interception)) {
                moveAngle += ORIENTATION * i;
                interception = intercept(orbitLocation, bulletSpeed, robotLocation, moveAngle, 8 * i);
            }
            int index = (i + 1) / 2;
            escapePositions[index] = interception;
            escapeAngles[index] = GunUtils.absoluteBearing(orbitLocation, interception);
        }
    }

    public void calculateEscapeAngle(Point2D.Double robotLocation, Point2D.Double orbitLocation, double bulletDistanceTraveled, double bulletSpeed) {
        double distance = orbitLocation.distance(robotLocation);
        calculateEscapeAngle(robotLocation, orbitLocation, distance / ((distance - bulletDistanceTraveled) / bulletSpeed));
    }

    public Point2D.Double getEscapePosition(int direction) {
        return escapePositions[(direction + 1) / 2];
    }

    public double getEscapeAngle(int direction) {
        return escapeAngles[(direction + 1) / 2];
    }

    /**
     *
     * @param fireAngle Fire angle must not be bearing offset
     * @return
     */
    public double limitAngle(double fireAngle) {
        double counterClockwiseEA = escapeAngles[0] - fireAngle;
        double clockwiseEA = escapeAngles[1] - fireAngle;
        if (Math.sin(clockwiseEA) < 0) {
            return clockwiseEA + fireAngle;
        }
        if (Math.sin(counterClockwiseEA) > 0) {
            return counterClockwiseEA + fireAngle;
        }
        return fireAngle;
    }

    //CREDIT: Chase-san
    static Point2D.Double intercept(Point2D pos, double vel, Point2D tPos, double tHeading, double tVel) {
        double tVelX = Math.sin(tHeading) * tVel;
        double tVelY = Math.cos(tHeading) * tVel;
        double relX = tPos.getX() - pos.getX();
        double relY = tPos.getY() - pos.getY();
        double b = relX * tVelX + relY * tVelY;
        double a = vel * vel - tVel * tVel;
        b = (b + Math.sqrt(b * b + a * (relX * relX + relY * relY))) / a;
        return new Point2D.Double(tVelX * b + tPos.getX(), tVelY * b + tPos.getY());
    }

}
