/*
 * Decompiled with CFR 0.152.
 */
package jcz.linio;

import ags.utils.KdTree;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jcz.linio.util.BufSet;
import jcz.linio.util.Constants;
import jcz.linio.util.EnemyWave;
import jcz.linio.util.GunWave;
import jcz.linio.util.LUtils;
import jcz.linio.util.PreciseUtils;
import jcz.linio.util.Prediction;
import jcz.linio.util.RobotState;
import jcz.linio.util.STCoord;
import jcz.linio.util.Scan;
import jcz.linio.util.StoreScan;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.util.Utils;

public class Linio
extends AdvancedRobot
implements Constants {
    public static double[] surfStats = new double[101];
    public static Point2D.Double myLoc;
    public static Point2D.Double enemyLoc;
    public static Point2D.Double nextMLoc;
    public static Point2D.Double nxtELoc;
    public double dir = 1.0;
    public static ArrayList statBufs;
    public static ArrayList flatBufs;
    public static ArrayList ftBuffers;
    public static ArrayList<Double> dists;
    public static ArrayList<Double> latVels;
    public static ArrayList<Double> eLatVels;
    public static ArrayList<Integer> advVels;
    public static ArrayList<Integer> eAdvVels;
    public static ArrayList<EnemyWave> enemyWaves;
    public static ArrayList<Integer> surfDirs;
    public static ArrayList<EnemyWave> ftWaves;
    public static ArrayList<Double> surfAbsBearings;
    public static ArrayList<Point2D.Double> enemyLocs;
    static ArrayList<GunWave> waveList;
    static ArrayList<GunWave> removeList;
    public static double firePower;
    public static double latDir;
    public static double oppEnergy;
    public static Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;
    public ArrayList targets;
    public Point2D.Double lastPoint;
    public long lastScanTime = 0L;
    public double enemyGH;
    public double imgGH;
    public static double bestDist;
    public ScannedRobotEvent lastScan;
    public boolean firstScan = true;
    public static double currentGF;
    public static boolean flattener;
    public EnemyWave[] pw = new EnemyWave[3];
    public long time;
    public long moveTime;
    public long gunTime;
    public boolean painting = false;
    ArrayList firstPointsPainting;
    ArrayList nextPointsPainting;
    public double eLastDir = 1.0;
    public double eLastVel = 0.0;
    public double eLastHeading = 0.0;
    int timeSinceDirChange = 0;
    int timeSinceDecel = 0;
    int timeSinceAccel = 0;
    private ArrayList<Point2D.Double> predPoints;
    public double nextAbsBearing;
    public StoreScan lastStoreScan;
    public boolean surfStatsChanged;
    private ArrayList flattenerBuffers = new ArrayList();
    static KdTree<Float> bulletPowerTree;
    public static int bulletsHit;
    public static int bulletsMissed;

    static {
        statBufs = new ArrayList();
        flatBufs = new ArrayList();
        ftBuffers = new ArrayList();
        firePower = 2.0;
        oppEnergy = 100.0;
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        WALL_STICK = 160.0;
        bestDist = 500.0;
        currentGF = 0.0;
        flattener = true;
        bulletPowerTree = new KdTree.SqrEuclid<Float>(3, new Integer(1000));
        bulletsHit = 0;
        bulletsMissed = 0;
    }

    public long getTime() {
        return this.time;
    }

    public void run() {
        flattener = true;
        if (this.getRoundNum() == 0) {
            statBufs = BufSet.getStatBuffers();
            this.flattenerBuffers = BufSet.getFlattenerBuffers();
            ftBuffers = BufSet.getFlattenerTickBuffers();
            BufSet.SingleBuffer sb = new BufSet.SingleBuffer();
            sb.bins = new int[7];
            BufSet.StatBuffer stb = (BufSet.StatBuffer)statBufs.get(0);
            stb.stats[0][0][0][0][0][0][0][0][0] = sb;
            sb.bins[0] = 50;
            sb.binsUsed = 1;
            sb.weight = stb._weight;
            sb.rollingDepth = stb.rollingDepth;
        }
        this.setColors(Color.BLACK, Color.GRAY, Color.WHITE);
        latDir = 1.0;
        latVels = new ArrayList();
        eLatVels = new ArrayList();
        dists = new ArrayList();
        enemyWaves = new ArrayList();
        surfDirs = new ArrayList();
        surfAbsBearings = new ArrayList();
        advVels = new ArrayList();
        eAdvVels = new ArrayList();
        ftWaves = new ArrayList();
        enemyLocs = new ArrayList();
        waveList = new ArrayList();
        removeList = new ArrayList();
        this.targets = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0 && this.getOthers() > 0) {
                if (this.getTime() > 9L) {
                    System.out.println("Lost radar lock");
                }
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            if (this.lastScanTime + 1L < this.getTime() || this.getOthers() == 0) {
                this.time = super.getTime();
                myLoc = LUtils.project(new Point2D.Double(this.getX(), this.getY()), this.getHeadingRadians(), this.getVelocity());
                enemyLoc = LUtils.project(new Point2D.Double(this.getX(), this.getY()), this.getHeadingRadians(), this.getVelocity());
                this.updateWaves();
                this.doSurfing();
            }
            this.time = super.getTime();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        long stime = -System.nanoTime();
        try {
            boolean gunFinishedTurning;
            long finalTime;
            double finalVel;
            double finalHeading;
            Point2D.Double finalPoint;
            Prediction p;
            myLoc = new Point2D.Double(this.getX(), this.getY());
            this.lastScan = e;
            this.lastScanTime = this.getTime();
            if (surfDirs.size() == 0) {
                this.enemyGH = this.imgGH = this.getGunHeat();
            }
            double latVel = this.getVelocity() * Math.sin(e.getBearingRadians());
            double advVel = -this.getVelocity() * Math.cos(e.getBearingRadians());
            double absBearing = e.getBearingRadians() + this.getHeadingRadians();
            if (latVel > 0.0) {
                latDir = 1.0;
            } else if (latVel < 0.0) {
                latDir = -1.0;
            }
            surfDirs.add(0, (int)latDir);
            surfAbsBearings.add(0, absBearing + Math.PI);
            latVels.add(0, Math.abs(latVel));
            advVels.add(0, (int)Math.round(advVel));
            dists.add(0, e.getDistance());
            this.enemyGH = Math.max(0.0, this.enemyGH - this.getGunCoolingRate());
            this.imgGH = Math.max(this.enemyGH, this.imgGH - this.getGunCoolingRate());
            enemyLoc = LUtils.project(myLoc, absBearing, e.getDistance());
            nxtELoc = LUtils.project(enemyLoc, e.getHeadingRadians(), e.getVelocity());
            double bulletPower = oppEnergy - e.getEnergy();
            this.addWave(bulletPower);
            this.addImgWave();
            this.addFTWave();
            oppEnergy = e.getEnergy();
            enemyLoc = LUtils.project(myLoc, absBearing, e.getDistance());
            this.updateWaves();
            this.doSurfing();
            this.moveTime = stime + System.nanoTime();
            stime = -System.nanoTime();
            if (this.pw[2] != null && this.pw[2].safestST != null && this.pw[2].safestST.prediction != null) {
                p = this.pw[2].safestST.prediction;
                finalPoint = p.endPoint;
                finalHeading = p.finalHeading;
                finalVel = p.finalVel;
                finalTime = p.time - this.getTime();
            } else if (this.pw[1] != null && this.pw[1].safestST != null && this.pw[1].safestST.prediction != null) {
                p = this.pw[1].safestST.prediction;
                finalPoint = p.endPoint;
                finalHeading = p.finalHeading;
                finalVel = p.finalVel;
                finalTime = p.time - this.getTime();
            } else if (this.pw[0] != null && this.pw[0].safestST != null && this.pw[0].safestST.prediction != null) {
                p = this.pw[0].safestST.prediction;
                finalPoint = p.endPoint;
                finalHeading = p.finalHeading;
                finalVel = p.finalVel;
                finalTime = p.time - this.getTime();
            } else {
                finalPoint = myLoc;
                finalHeading = this.getHeadingRadians();
                finalVel = this.getVelocity();
                finalTime = 0L;
            }
            enemyLocs.add(enemyLoc);
            double base = 1.95;
            try {
                if ((double)(bulletsHit / bulletsMissed) > 0.3333333333333333) {
                    base = 2.95;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            double minBP = 0.15;
            double eEneBP = e.getEnergy() / 4.0;
            double enegyBP = this.getEnergy() / 40.0;
            firePower = e.getDistance() < 150.0 ? 2.95 : Math.max(minBP, Math.ceil(10.0 * (0.05 + Math.min(eEneBP, Math.min(enegyBP, base)))) / 10.0 - 0.05);
            double eVel = e.getVelocity();
            double offset = Utils.normalRelativeAngle((double)(e.getHeadingRadians() - absBearing));
            double eLatVel = eVel * Math.sin(e.getBearingRadians());
            double eAdvVel = -eVel * Math.cos(e.getBearingRadians());
            double eDir = Math.signum(eLatVel);
            if (eDir == 0.0) {
                eDir = this.eLastDir;
            }
            this.eLastDir = eDir;
            double eAcc = 1.0;
            if (Math.abs(eVel) > Math.abs(this.eLastVel)) {
                eAcc = 2.0;
            } else if (Math.abs(eVel) < Math.abs(this.eLastVel)) {
                eAcc = 0.0;
            }
            this.timeSinceDirChange = eDir == this.eLastDir ? ++this.timeSinceDirChange : 0;
            this.timeSinceDecel = eAcc == 0.0 ? 0 : ++this.timeSinceDecel;
            this.timeSinceAccel = eAcc == 2.0 ? 0 : ++this.timeSinceAccel;
            eLatVels.add(0, eLatVel);
            double dl10 = enemyLoc.distance(enemyLocs.get(Math.min(10, enemyLocs.size() - 1)));
            double dl20 = enemyLoc.distance(enemyLocs.get(Math.min(20, enemyLocs.size() - 1)));
            double dl30 = enemyLoc.distance(enemyLocs.get(Math.min(30, enemyLocs.size() - 1)));
            double maxEscAngle = LUtils.maxEscAngle(LUtils.bulletVelocity(firePower));
            double ETA = e.getDistance() / LUtils.bulletVelocity(firePower);
            this.predPoints = new ArrayList(6);
            double[] MEAs = PreciseUtils.getPreciseMEAs(enemyLoc, e.getHeadingRadians(), eVel, myLoc, firePower, eDir, this.predPoints);
            double fwdWall = MEAs[0] / maxEscAngle;
            double revWall = MEAs[1] / maxEscAngle;
            Point2D.Double centre = new Point2D.Double((Linio.enemyLoc.x + Linio.myLoc.x) * 0.5, (Linio.enemyLoc.y + Linio.myLoc.y) * 0.5);
            Point2D.Double mirror = new Point2D.Double(2.0 * centre.x - finalPoint.x, 2.0 * centre.y - finalPoint.y);
            double mirrorBearing = LUtils.absoluteBearing(myLoc, mirror);
            double mirrorOffset = Utils.normalRelativeAngle((double)(mirrorBearing - absBearing)) * eDir;
            RobotState rs = new RobotState();
            rs.dir = eDir;
            rs.latVel = eLatVel;
            rs.advVel = eAdvVel;
            rs.vel = e.getVelocity();
            rs.deltaHeading = Utils.normalRelativeAngle((double)(e.getHeadingRadians() - this.eLastHeading));
            rs.heading = e.getHeadingRadians();
            rs.offset = offset;
            rs.dist = e.getDistance();
            rs.timeSinceDirChange = this.timeSinceDirChange;
            rs.acc = eAcc;
            rs.timeSinceDecel = this.timeSinceDecel;
            rs.timeSinceAccel = this.timeSinceAccel;
            rs.distLast30 = Math.abs(dl30);
            rs.distLast20 = Math.abs(dl20);
            rs.distLast10 = Math.abs(dl10);
            rs.fwdWall = fwdWall;
            rs.revWall = revWall;
            rs.location = myLoc;
            rs.enemyLocation = enemyLoc;
            rs.time = this.getTime();
            rs.firstScan = this.firstScan;
            rs.currentGF = currentGF;
            rs.mirrorOffset = mirrorOffset;
            rs.ETA = ETA;
            rs.MEA_pos = MEAs[1];
            rs.MEA_neg = MEAs[0];
            double myVel = this.getVelocity();
            double maxTurn = 0.17453292519943295 - 0.01308996938995747 * Math.abs(myVel);
            double turn = LUtils.limit(-maxTurn, this.getTurnRemainingRadians(), maxTurn);
            double heading = this.getHeadingRadians() + turn;
            double distRem = this.getDistanceRemaining();
            if (myVel < 0.0) {
                myVel = -myVel;
                heading += Math.PI;
                distRem = -distRem;
            }
            double nextVel = myVel >= 0.0 && distRem > LUtils.decelDistance(Math.abs(myVel)) ? LUtils.limit(0.0, Math.abs(myVel) + 1.0, 8.0) : (distRem < LUtils.decelDistance(Math.abs(myVel)) ? LUtils.limit(-1.9999999, Math.abs(myVel) - 2.0, 6.0) : Math.abs(this.getVelocity()));
            nextMLoc = LUtils.project(myLoc, heading, myVel);
            this.nextAbsBearing = LUtils.absoluteBearing(nextMLoc, enemyLoc);
            GunWave wave = new GunWave(this);
            wave.gunLoc = nextMLoc;
            GunWave.targLoc = enemyLoc;
            wave.latDir = eDir;
            wave.bulletPower = firePower;
            wave.setSegmentations(rs);
            wave.bearing = this.nextAbsBearing;
            wave.bulletFired = false;
            if (this.lastStoreScan == null) {
                this.lastStoreScan = wave.storeScan;
            }
            wave.storeScan.prev = this.lastStoreScan;
            this.lastStoreScan = wave.storeScan;
            boolean gunAimed = false;
            boolean bl = gunFinishedTurning = this.getGunTurnRemainingRadians() == 0.0;
            if (this.getEnergy() > wave.bulletPower && maxEscAngle / 0.17453292519943295 + 0.99 > this.getGunHeat() / this.getGunCoolingRate() && e.getEnergy() > 0.0) {
                double mostVisitedOffset = wave.mostVisitedBearingOffset();
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getGunHeadingRadians() + mostVisitedOffset)));
                if (Math.abs(this.getGunTurnRemainingRadians()) < Math.abs(18.0 / e.getDistance())) {
                    gunAimed = true;
                }
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.nextAbsBearing - this.getGunHeadingRadians() + mostVisitedOffset)));
            } else {
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())));
            }
            boolean dataExists = GunWave.heapTree.size() > 0;
            Bullet b = null;
            if (this.getEnergy() > wave.bulletPower) {
                if (gunFinishedTurning && dataExists) {
                    b = this.setFireBullet(wave.bulletPower);
                }
                waveList.add(0, wave);
                if (b != null) {
                    GunWave w = waveList.get(1);
                    w.bulletFired = true;
                    w.bullet = b;
                }
            }
            Iterator<GunWave> it = waveList.iterator();
            while (it.hasNext()) {
                if (!it.next().test()) continue;
                it.remove();
            }
            this.eLastVel = eVel;
            this.eLastHeading = e.getHeadingRadians();
            this.firstScan = false;
            this.gunTime = stime + System.nanoTime();
            double radTurn = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians()));
            radTurn += Math.signum(radTurn) * 0.2181661564992912 / 2.0;
            this.setTurnRadarRightRadians(radTurn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                PrintStream out = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(e.getName())));
                ex.printStackTrace(out);
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addImgWave() {
        if (this.enemyGH <= this.getGunCoolingRate() && this.imgGH <= this.getGunCoolingRate()) {
            float lastLatVel;
            List<KdTree.Entry<Float>> cl = bulletPowerTree.nearestNeighbor(new double[]{this.getEnergy() / 200.0, oppEnergy / 200.0, dists.get(0) / 1200.0}, Math.min((int)Math.ceil(Math.sqrt(bulletPowerTree.size())), 20), false);
            float[] bpBins = new float[999];
            for (KdTree.Entry<Float> p : cl) {
                double weight = 1.0 / (p.distance + 1.0E-15);
                int index = Math.round(((Float)p.value).floatValue() * (float)bpBins.length / 3.0f);
                int i = 0;
                while (i < bpBins.length) {
                    int n = i;
                    bpBins[n] = (float)((double)bpBins[n] + weight / (double)(LUtils.sqr(index - i) / 9 + 1));
                    ++i;
                }
            }
            int maxIndex = 66;
            int i = 0;
            while (i < bpBins.length) {
                if (bpBins[i] > bpBins[maxIndex]) {
                    maxIndex = i;
                }
                ++i;
            }
            double bulletPower = (double)maxIndex * 3.0 / (double)bpBins.length;
            this.imgGH = 1.0 + bulletPower / 5.0 - this.getGunCoolingRate();
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime();
            ew.vel = LUtils.bulletVelocity(bulletPower);
            ew.dist = -ew.vel;
            ew.dir = surfDirs.get(0);
            ew.angle = surfAbsBearings.get(0);
            ew.fireLoc = nxtELoc;
            ew.imaginary = true;
            float prevLatVel = lastLatVel = (float)latVels.get(0).doubleValue();
            try {
                prevLatVel = (float)latVels.get(1).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            float accel = lastLatVel - prevLatVel;
            float dist = (float)dists.get(0).doubleValue();
            float advVel = advVels.get(0).intValue();
            float ETA = (float)((double)dist / ew.vel);
            float tsdirchange = 0.0f;
            int i2 = 1;
            while (i2 < surfDirs.size() - 2) {
                if (surfDirs.get(i2 - 1).intValue() != surfDirs.get(i2).intValue()) break;
                tsdirchange += 1.0f;
                ++i2;
            }
            float tsvchange = 0.0f;
            int i3 = 1;
            while (i3 < latVels.size() - 2) {
                if (!(latVels.get(i3 - 1) <= latVels.get(i3) + 0.4)) break;
                tsvchange += 1.0f;
                ++i3;
            }
            float dl10 = 0.0f;
            int i4 = 0;
            while (i4 < Math.min(10, latVels.size() - 2)) {
                dl10 += (float)(latVels.get(i4) * (double)surfDirs.get(i4).intValue());
                ++i4;
            }
            dl10 = Math.abs(dl10) * 1.25f;
            double MEA = LUtils.maxEscAngle(ew.vel);
            float forwardWall = (float)(this.wallDistance(enemyLoc, dist, ew.angle, ew.dir) / MEA);
            float reverseWall = (float)(this.wallDistance(enemyLoc, dist, ew.angle, -ew.dir) / MEA);
            ew.indices = BufSet.getIndexes(lastLatVel, advVel, ETA, tsdirchange /= ETA, accel, tsvchange /= ETA, dl10, forwardWall, reverseWall);
            ew.allStats = BufSet.getStats(statBufs, ew.indices);
            if (flattener) {
                ew.flattenerStats = BufSet.getStats(this.flattenerBuffers, ew.indices);
                ew.ftStats = BufSet.getStats(ftBuffers, ew.indices);
            }
            Scan s = new Scan();
            s.latVel = LUtils.limit(0.0, lastLatVel / 8.0f, 1.0);
            s.advVel = LUtils.limit(0.0, advVel / 8.0f, 1.0);
            s.dist = LUtils.limit(0.0, ETA / 109.09091f, 1.0);
            s.fwdWall = LUtils.limit(0.0, forwardWall, 1.0);
            s.revWall = LUtils.limit(0.0, reverseWall, 1.0);
            s.lastVel = LUtils.limit(0.0, prevLatVel / 8.0f, 1.0);
            s.accel = (accel + 2.0f) / 3.0f;
            s.tsDecel = LUtils.limit(0.0, tsvchange / ETA, 1.0);
            s.tsdc = LUtils.limit(0.0, tsdirchange / ETA, 1.0);
            s.distLast20 = LUtils.limit(0.0, dl10 / 100.0f, 1.0);
            ew.scan = s;
            this.surfStatsChanged = true;
            enemyWaves.add(ew);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        if (this.enemyGH < this.getGunCoolingRate() && this.getOthers() == 0) {
            double bulletPower = 2.0;
            if (enemyWaves != null && enemyWaves.size() > 0) {
                bulletPower = (20.0 - Linio.enemyWaves.get((int)0).vel) / 3.0;
            }
            bulletPower = Math.min(bulletPower, oppEnergy);
            this.addWave(bulletPower);
        } else {
            oppEnergy -= Math.min(oppEnergy, damage);
        }
        ++bulletsHit;
        for (GunWave w : waveList) {
            if (w.bullet == null || e.getBullet() != w.bullet) continue;
            double normAngle = Utils.normalRelativeAngle((double)(w.bullet.getHeadingRadians() - w.bearing)) * w.latDir;
            double GF = normAngle / w.MEA_norm;
            w.logASBuffer(GF, -3.0);
        }
    }

    public void addFTWave() {
        float lastLV;
        int i;
        if (!flattener || surfDirs.size() < 4) {
            return;
        }
        List<KdTree.Entry<Float>> cl = bulletPowerTree.nearestNeighbor(new double[]{this.getEnergy() / 200.0, oppEnergy / 200.0, dists.get(0) / 1200.0}, Math.min((int)Math.ceil(Math.sqrt(bulletPowerTree.size())), 20), false);
        float[] bpBins = new float[999];
        for (KdTree.Entry<Float> p : cl) {
            double weight = 1.0 / (p.distance + 1.0E-15);
            int index = Math.round(((Float)p.value).floatValue() * (float)bpBins.length / 3.0f);
            i = 0;
            while (i < bpBins.length) {
                int n = i;
                bpBins[n] = (float)((double)bpBins[n] + weight / (double)(LUtils.sqr(index - i) / 9 + 1));
                ++i;
            }
        }
        int maxIndex = 66;
        int i2 = 0;
        while (i2 < bpBins.length) {
            if (bpBins[i2] > bpBins[maxIndex]) {
                maxIndex = i2;
            }
            ++i2;
        }
        double power = (double)maxIndex * 3.0 / (double)bpBins.length;
        EnemyWave imgWave = null;
        i = 0;
        while (i < enemyWaves.size()) {
            EnemyWave ew = enemyWaves.get(i);
            if (ew.imaginary && ew.fireTime == this.getTime() - 2L) {
                imgWave = enemyWaves.remove(i--);
            }
            ++i;
        }
        EnemyWave ew = new EnemyWave();
        ew.fireTime = this.getTime() - 2L;
        ew.dist = ew.vel = LUtils.bulletVelocity(power);
        ew.dir = surfDirs.get(2);
        ew.angle = surfAbsBearings.get(2);
        ew.fireLoc = (Point2D.Double)enemyLoc.clone();
        float prevLV = lastLV = (float)latVels.get(2).doubleValue();
        try {
            prevLV = (float)latVels.get(3).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        float acc = lastLV - prevLV;
        float dist = (float)dists.get(2).doubleValue();
        float advVel = advVels.get(2).intValue();
        float ETA = (float)((double)dist / ew.vel);
        float tsdc = 0.0f;
        int i3 = 3;
        while (i3 < surfDirs.size()) {
            if (surfDirs.get(i3 - 1).intValue() != surfDirs.get(i3).intValue()) break;
            tsdc += 1.0f;
            ++i3;
        }
        float tsvc = 0.0f;
        int i4 = 3;
        while (i4 < latVels.size()) {
            if (!(latVels.get(i4 - 1) <= latVels.get(i4) + 0.4)) break;
            tsvc += 1.0f;
            ++i4;
        }
        float dl10 = 0.0f;
        int i5 = 2;
        while (i5 < Math.min(10, latVels.size())) {
            dl10 += (float)(latVels.get(i5) * (double)surfDirs.get(i5).intValue());
            ++i5;
        }
        dl10 = Math.abs(dl10) * 1.25f;
        double MEA = LUtils.maxEscAngle(ew.vel);
        float fwdWall = (float)(this.wallDistance(enemyLoc, dist, ew.angle, ew.dir) / MEA);
        float revWall = (float)(this.wallDistance(enemyLoc, dist, ew.angle, -ew.dir) / MEA);
        ew.indices = BufSet.getIndexes(lastLV, advVel, ETA, tsdc /= ETA, acc, tsvc /= ETA, dl10, fwdWall, revWall);
        ew.ftStats = BufSet.getStats(ftBuffers, ew.indices);
        Scan s = new Scan();
        s.latVel = LUtils.limit(0.0, lastLV / 8.0f, 1.0);
        s.advVel = LUtils.limit(0.0, advVel / 8.0f, 1.0);
        s.dist = LUtils.limit(0.0, ETA / 109.09091f, 1.0);
        s.fwdWall = LUtils.limit(0.0, fwdWall, 1.0);
        s.revWall = LUtils.limit(0.0, revWall, 1.0);
        s.lastVel = LUtils.limit(0.0, prevLV / 8.0f, 1.0);
        s.accel = (acc + 2.0f) / 3.0f;
        s.tsDecel = LUtils.limit(0.0, tsvc / ETA, 1.0);
        s.tsdc = LUtils.limit(0.0, tsdc / ETA, 1.0);
        s.distLast20 = LUtils.limit(0.0, dl10 / 100.0f, 1.0);
        ew.scan = s;
        ftWaves.add(ew);
    }

    public void addWave(double power) {
        if (power < 3.01 && power > 0.099 && surfDirs.size() > 2) {
            float lastLV;
            this.imgGH = this.enemyGH = 1.0 + power / 5.0 - this.getGunCoolingRate();
            bulletPowerTree.addPoint(new double[]{this.getEnergy() / 100.0, (oppEnergy + power) / 100.0, dists.get(2) / 1200.0}, Float.valueOf((float)power));
            EnemyWave imgWave = null;
            int i = 0;
            while (i < enemyWaves.size()) {
                EnemyWave ew = enemyWaves.get(i);
                if (ew.imaginary && ew.fireTime == this.getTime() - 2L) {
                    imgWave = enemyWaves.remove(i--);
                }
                ++i;
            }
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 2L;
            ew.dist = ew.vel = LUtils.bulletVelocity(power);
            ew.dir = surfDirs.get(2);
            ew.angle = surfAbsBearings.get(2);
            ew.fireLoc = (Point2D.Double)enemyLoc.clone();
            float prevLV = lastLV = (float)latVels.get(2).doubleValue();
            try {
                prevLV = (float)latVels.get(3).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            float acc = lastLV - prevLV;
            float dist = (float)dists.get(2).doubleValue();
            float advVel = advVels.get(2).intValue();
            float ETA = (float)((double)dist / ew.vel);
            float tsdc = 0.0f;
            int i2 = 3;
            while (i2 < surfDirs.size()) {
                if (surfDirs.get(i2 - 1).intValue() != surfDirs.get(i2).intValue()) break;
                tsdc += 1.0f;
                ++i2;
            }
            float tsvc = 0.0f;
            int i3 = 3;
            while (i3 < latVels.size()) {
                if (!(latVels.get(i3 - 1) <= latVels.get(i3) + 0.4)) break;
                tsvc += 1.0f;
                ++i3;
            }
            float dl10 = 0.0f;
            int i4 = 2;
            while (i4 < Math.min(10, latVels.size())) {
                dl10 += (float)(latVels.get(i4) * (double)surfDirs.get(i4).intValue());
                ++i4;
            }
            dl10 = Math.abs(dl10) * 1.25f;
            double MEA = LUtils.maxEscAngle(ew.vel);
            float fwdWall = (float)(this.wallDistance(enemyLoc, dist, ew.angle, ew.dir) / MEA);
            float revWall = (float)(this.wallDistance(enemyLoc, dist, ew.angle, -ew.dir) / MEA);
            ew.indices = BufSet.getIndexes(lastLV, advVel, ETA, tsdc /= ETA, acc, tsvc /= ETA, dl10, fwdWall, revWall);
            if (imgWave != null && Math.abs(ew.vel - this.imgGH) < 0.5) {
                boolean bl = true;
            }
            if (ew.allStats == null) {
                ew.allStats = BufSet.getStats(statBufs, ew.indices);
                if (flattener) {
                    ew.flattenerStats = BufSet.getStats(this.flattenerBuffers, ew.indices);
                    ew.ftStats = BufSet.getStats(ftBuffers, ew.indices);
                }
                Scan s = new Scan();
                s.latVel = LUtils.limit(0.0, lastLV / 8.0f, 1.0);
                s.advVel = LUtils.limit(0.0, advVel / 8.0f, 1.0);
                s.dist = LUtils.limit(0.0, ETA / 109.09091f, 1.0);
                s.fwdWall = LUtils.limit(0.0, fwdWall, 1.0);
                s.revWall = LUtils.limit(0.0, revWall, 1.0);
                s.lastVel = LUtils.limit(0.0, prevLV / 8.0f, 1.0);
                s.accel = (acc + 2.0f) / 3.0f;
                s.tsDecel = LUtils.limit(0.0, tsvc / ETA, 1.0);
                s.tsdc = LUtils.limit(0.0, tsdc / ETA, 1.0);
                s.distLast20 = LUtils.limit(0.0, dl10 / 100.0f, 1.0);
                ew.scan = s;
            }
            this.surfStatsChanged = true;
            enemyWaves.add(ew);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!enemyWaves.isEmpty()) {
            Bullet bullet = e.getBullet();
            Point2D.Double hitBulletLoc = new Point2D.Double(bullet.getX(), bullet.getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < enemyWaves.size()) {
                EnemyWave ew = enemyWaves.get(x);
                if (Math.abs(ew.dist - myLoc.distance(ew.fireLoc)) < 50.0 && Math.abs(LUtils.bulletVelocity(e.getBullet().getPower()) - ew.vel) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLoc);
                enemyWaves.remove(enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void updateWaves() {
        double dfc;
        EnemyWave ew;
        int x;
        if (this.getOthers() == 0) {
            x = 0;
            while (x < enemyWaves.size()) {
                ew = enemyWaves.get(x);
                ew.imaginary = false;
                ++x;
            }
        }
        x = 0;
        while (x < enemyWaves.size()) {
            ew = enemyWaves.get(x);
            ew.dist = (double)(this.getTime() - ew.fireTime) * ew.vel;
            dfc = myLoc.distance(ew.fireLoc);
            if (ew.imaginary && ew.dist > myLoc.distance(ew.fireLoc) + 50.0) {
                enemyWaves.remove(x);
                --x;
            } else {
                if (ew.dist > dfc - ew.vel && !ew.flattener) {
                    if (flattener && this.getOthers() > 0) {
                        this.logFlattener(ew, myLoc);
                    }
                    ew.flattener = true;
                    double botWidth = 2.0 * Math.atan(25.0 / (ew.dist - 18.0));
                    double hitChance = botWidth / LUtils.maxEscAngle(ew.vel);
                    ew.bestBins = null;
                }
                if (ew.dist > dfc + 50.0) {
                    enemyWaves.remove(x);
                    --x;
                }
            }
            ++x;
        }
        x = 0;
        while (x < ftWaves.size() && flattener) {
            ew = ftWaves.get(x);
            ew.dist = (double)(this.getTime() - ew.fireTime) * ew.vel;
            dfc = myLoc.distance(ew.fireLoc);
            if (ew.dist > dfc - ew.vel && flattener && this.getOthers() > 0) {
                this.logTickFlattener(ew, myLoc);
                ftWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("SKIPPED TURN AT " + e.getTime());
        System.out.println("move time:" + this.moveTime);
        System.out.println("gun time:" + this.gunTime);
    }

    public void logTickFlattener(EnemyWave ew, Point2D.Double targetLocation) {
        if (ew.ftStats == null || this.getOthers() == 0) {
            return;
        }
        int index = Linio.getFactorIndex(ew, targetLocation);
        int i = 0;
        int k = ew.ftStats.size();
        while (i < k) {
            BufSet.SingleBuffer sb = (BufSet.SingleBuffer)ew.ftStats.get(i);
            if (sb.bins == null) {
                sb.rollingDepth *= 10.0f;
                sb.bins = new int[(int)Math.ceil(sb.rollingDepth * 2.0f) + 1];
                sb.hits = -1;
            }
            if (sb.binsUsed < sb.bins.length) {
                ++sb.binsUsed;
            }
            sb.hits = (sb.hits + 1) % sb.bins.length;
            sb.bins[sb.hits] = index;
            ++i;
        }
    }

    public void logFlattener(EnemyWave ew, Point2D.Double targetLocation) {
        if (ew.flattenerStats == null || this.getOthers() == 0) {
            return;
        }
        int index = Linio.getFactorIndex(ew, targetLocation);
        int i = 0;
        int k = ew.flattenerStats.size();
        while (i < k) {
            BufSet.SingleBuffer sb = (BufSet.SingleBuffer)ew.flattenerStats.get(i);
            if (sb.bins == null) {
                sb.bins = new int[(int)Math.ceil(sb.rollingDepth * 2.0f) + 1];
                sb.hits = -1;
            }
            if (sb.binsUsed < sb.bins.length) {
                ++sb.binsUsed;
            }
            sb.hits = (sb.hits + 1) % sb.bins.length;
            sb.bins[sb.hits] = index;
            ++i;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = Double.POSITIVE_INFINITY;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < enemyWaves.size()) {
            EnemyWave ew = enemyWaves.get(x);
            double distance = myLoc.distance(ew.fireLoc) - ew.dist;
            if (distance > ew.vel && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLoc) {
        double offset = LUtils.absoluteBearing(ew.fireLoc, targetLoc) - ew.angle;
        double factor = Utils.normalRelativeAngle((double)offset) / LUtils.maxEscAngle(ew.vel) * (double)ew.dir;
        return (int)LUtils.limit(0.0, factor * 50.0 + 50.0, 100.0);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLoc) {
        int index = Linio.getFactorIndex(ew, targetLoc);
        int x = 0;
        while (x < 101) {
            int n = x;
            surfStats[n] = surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public Point2D.Double predictPosition(EnemyWave wave, int dir) {
        Point2D.Double predPos = (Point2D.Double)myLoc.clone();
        double predVel = this.getVelocity();
        double predHead = this.getHeadingRadians();
        int c = 0;
        boolean intercepted = false;
        do {
            double mvAngle = this.wallSmoothing(predPos, LUtils.absoluteBearing(wave.fireLoc, predPos) + (double)dir * 1.5707963267948966, dir) - predHead;
            double mvDir = 1.0;
            if (Math.cos(mvAngle) < 0.0) {
                mvAngle += Math.PI;
                mvDir = -1.0;
            }
            mvAngle = Utils.normalRelativeAngle((double)mvAngle);
            double maxTurn = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predVel));
            predHead = Utils.normalRelativeAngle((double)(predHead + LUtils.limit(-maxTurn, mvAngle, maxTurn)));
            predVel += predVel * mvDir < 0.0 ? 2.0 * mvDir : mvDir;
            predVel = LUtils.limit(-8.0, predVel, 8.0);
            predPos = LUtils.project(predPos, predHead, predVel);
            ++c;
            if (!(predPos.distance(wave.fireLoc) < wave.dist + (double)c * wave.vel + wave.vel)) continue;
            intercepted = true;
        } while (!intercepted && c < 500);
        return predPos;
    }

    public void doSurfing() {
        this.pw[0] = this.getClosestSurfableWave();
        boolean surf = false;
        if (this.pw[0] != null) {
            enemyWaves.remove(this.pw[0]);
            this.pw[1] = this.getClosestSurfableWave();
            if (this.pw[1] != null) {
                enemyWaves.remove(this.pw[1]);
                this.pw[2] = this.getClosestSurfableWave();
                enemyWaves.add(this.pw[1]);
            }
            enemyWaves.add(this.pw[0]);
            STCoord best = this.getBestPoint(this.pw[0], this.pw[1], this.pw[2]);
            if (best != null && best.place != null) {
                surf = true;
                this.moveTo(best, this.pw[0]);
                this.dir = -latDir;
            } else {
                this.pw[1] = null;
                this.pw[0] = null;
            }
        } else {
            this.pw[1] = null;
        }
        if (!surf) {
            double revGoAngle;
            Point2D.Double revEndPoint;
            double goAngle;
            Point2D.Double endPoint;
            double revOffset;
            double distance = enemyLoc.distanceSq(myLoc);
            double absBearing = LUtils.absoluteBearing(myLoc, enemyLoc);
            double headingRadians = this.getHeadingRadians();
            double stick = LUtils.limit(121.0, distance, 160.0);
            double offset = revOffset = Math.max(1.0681975511965975, 2.5707963267948966 - LUtils.limit(0.2, distance / 160000.0, 1.2));
            int count = 50;
            while (!_fieldRect.contains(endPoint = LUtils.project(myLoc, goAngle = absBearing + this.dir * (offset -= 0.02), stick)) && count-- > 0) {
            }
            count = 50;
            while (!_fieldRect.contains(revEndPoint = LUtils.project(myLoc, revGoAngle = absBearing - this.dir * (revOffset -= 0.02), stick)) && count-- > 0) {
            }
            if (offset < revOffset) {
                this.dir = -this.dir;
                goAngle = revGoAngle;
            }
            this.setAhead(50.0 * Math.cos(goAngle -= headingRadians));
            this.setTurnRightRadians(Math.tan(goAngle));
        }
    }

    public void moveTo(STCoord point, EnemyWave wave) {
        Point2D.Double place;
        this.lastPoint = place = point.place;
        double distance = myLoc.distance(place);
        double dir = 1.0;
        double angle = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myLoc, place) - this.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            dir = -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        if (-1.0 < distance && distance < 1.0) {
            angle = 0.0;
        }
        if (flattener && point.prediction != null && point.prediction.distRemaining == 0.0) {
            double myVel = this.getVelocity();
            double heading = this.getHeadingRadians();
            if (myVel < 0.0) {
                myVel = -myVel;
                heading += Math.PI;
            }
            double maxTurn = 0.17453292519943295 - 0.01308996938995747 * myVel;
            double nextVel = LUtils.limit(0.0, myVel - 2.0, 6.0);
            Point2D.Double nextLocation = LUtils.project(myLoc, heading += LUtils.limit(-maxTurn, angle, maxTurn), nextVel);
            Prediction stillOption = Linio.futureStatus(nextLocation, point.place, nextVel, heading, this.getTime() + 1L, wave);
            if (stillOption.distRemaining == 0.0) {
                distance = 0.0;
                angle = 0.0;
            }
        }
        this.setTurnRightRadians(angle);
        this.setAhead(distance * dir);
    }

    public static void heightNormalize(float[] bins) {
        float max = 0.0f;
        int i = 1;
        while (i < bins.length) {
            if (bins[i] > max) {
                max = bins[i];
            }
            ++i;
        }
        if (max != 0.0f) {
            max = 1.0f / max;
            i = 1;
            while (i < bins.length) {
                int n = i++;
                bins[n] = bins[n] * max;
            }
        }
    }

    public static void areaNormalize(float[] bins) {
        float total = 0.0f;
        int i = 1;
        while (i < bins.length) {
            total += bins[i];
            ++i;
        }
        if ((total = 1.0f / total) != 0.0f) {
            i = 1;
            while (i < bins.length) {
                int n = i++;
                bins[n] = bins[n] * total;
            }
        }
    }

    public float getAverageDanger(float[] bins, int index, int botBinWidth) {
        botBinWidth = (int)LUtils.limit(2.0, botBinWidth, 100.0);
        float totalDanger = 0.0f;
        int minIndex = Math.max(1, index - botBinWidth / 2);
        int maxIndex = Math.min(100, index + botBinWidth / 2) + 1;
        int i = minIndex;
        while (i < maxIndex) {
            totalDanger += bins[i];
            ++i;
        }
        return totalDanger / (float)(maxIndex - minIndex);
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = Linio.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return surfStats[index];
    }

    public double wallSmoothing(Point2D.Double botLoc, double angle, double direction) {
        while (!_fieldRect.contains(LUtils.project(botLoc, angle, WALL_STICK))) {
            angle += direction * 0.05;
        }
        return angle;
    }

    public double wallDistance(Point2D.Double sourceLoc, double eDist, double eAngle, int oDir) {
        return Math.min(Math.min(Math.min(this.distanceWest(581.0 - sourceLoc.getY(), eDist, eAngle - 1.5707963267948966, oDir), this.distanceWest(781.0 - sourceLoc.getX(), eDist, eAngle + Math.PI, oDir)), this.distanceWest(sourceLoc.getY() - 19.0, eDist, eAngle + 1.5707963267948966, oDir)), this.distanceWest(sourceLoc.getX() - 19.0, eDist, eAngle, oDir));
    }

    public double distanceWest(double toWall, double eDist, double eAngle, int oDir) {
        if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
        }
        double wallAngle = Math.acos((double)(-oDir) * toWall / eDist) + (double)oDir * 1.5707963267948966;
        return Utils.normalAbsoluteAngle((double)((double)oDir * (wallAngle - eAngle)));
    }

    static float power(float k, int n) {
        float end = 1.0f;
        int i = 0;
        while (i < n) {
            end *= k;
            ++i;
        }
        return end;
    }

    public void getBins(EnemyWave wave) {
        int i;
        wave.bestBins = new float[101];
        int i2 = 0;
        int k = wave.allStats.size();
        while (i2 < k) {
            BufSet.SingleBuffer sb = (BufSet.SingleBuffer)wave.allStats.get(i2);
            if (sb.bins != null && sb.binsUsed != 0) {
                float roll = 1.0f - 1.0f / (sb.rollingDepth + 1.0f);
                float multFactor = (float)sb.binsUsed * (flattener ? sb.weight : (1.0f - roll) / (roll - Linio.power(roll, sb.binsUsed + 1)));
                int j = sb.hits;
                while (j >= 0) {
                    int n = sb.bins[j];
                    wave.bestBins[n] = wave.bestBins[n] + multFactor;
                    multFactor *= roll;
                    --j;
                }
                if (sb.binsUsed == sb.bins.length) {
                    j = sb.binsUsed - 1;
                    while (j > sb.hits) {
                        int n = sb.bins[j];
                        wave.bestBins[n] = wave.bestBins[n] + multFactor;
                        multFactor *= roll;
                        --j;
                    }
                }
            }
            ++i2;
        }
        Linio.heightNormalize(wave.bestBins);
        if (flattener && wave.flattenerStats != null) {
            float[] flattenerBins = new float[101];
            i = 0;
            int k2 = wave.flattenerStats.size();
            while (i < k2) {
                BufSet.SingleBuffer sb = (BufSet.SingleBuffer)wave.flattenerStats.get(i);
                if (sb.bins != null && sb.binsUsed != 0) {
                    float roll = 1.0f - 1.0f / (sb.rollingDepth + 1.0f);
                    float multFactor = (float)sb.binsUsed * sb.weight;
                    int j = sb.hits;
                    while (j >= 0) {
                        int n = sb.bins[j];
                        flattenerBins[n] = flattenerBins[n] + multFactor;
                        multFactor *= roll;
                        --j;
                    }
                    if (sb.binsUsed == sb.bins.length) {
                        j = sb.binsUsed - 1;
                        while (j > sb.hits) {
                            int n = sb.bins[j];
                            flattenerBins[n] = flattenerBins[n] + multFactor;
                            multFactor *= roll;
                            --j;
                        }
                    }
                }
                ++i;
            }
            Linio.heightNormalize(flattenerBins);
            float[] flattenerTickBins = new float[101];
            int i3 = 0;
            int k3 = wave.ftStats.size();
            while (i3 < k3) {
                BufSet.SingleBuffer sb = (BufSet.SingleBuffer)wave.ftStats.get(i3);
                if (sb.bins != null && sb.binsUsed != 0) {
                    float roll = 1.0f - 1.0f / (sb.rollingDepth + 1.0f);
                    float multFactor = (float)sb.binsUsed * sb.weight;
                    int j = sb.hits;
                    while (j >= 0) {
                        int n = sb.bins[j];
                        flattenerTickBins[n] = flattenerTickBins[n] + multFactor;
                        multFactor *= roll;
                        --j;
                    }
                    if (sb.binsUsed == sb.bins.length) {
                        j = sb.binsUsed - 1;
                        while (j > sb.hits) {
                            int n = sb.bins[j];
                            flattenerTickBins[n] = flattenerTickBins[n] + multFactor;
                            multFactor *= roll;
                            --j;
                        }
                    }
                }
                ++i3;
            }
            Linio.heightNormalize(flattenerTickBins);
            i3 = 1;
            while (i3 < 101) {
                wave.bestBins[i3] = (wave.bestBins[i3] * 2.0f + flattenerBins[i3] + flattenerTickBins[i3]) * 0.25f;
                ++i3;
            }
        }
        float[] profile = new float[202];
        i = 201;
        while (i > -1) {
            profile[i] = (float)(1.0 / (LUtils.sqr((float)(101 - i) * 0.333333f) + 1.0));
            --i;
        }
        int width = 50;
        float[] smoothBins = new float[101];
        int i4 = 100;
        while (i4 > -1) {
            if ((double)wave.bestBins[i4] != 0.0) {
                int j = 100;
                while (j > -1) {
                    int n = j;
                    smoothBins[n] = smoothBins[n] + wave.bestBins[i4] * profile[j - i4 + 101];
                    --j;
                }
            }
            --i4;
        }
        wave.bestBins = smoothBins;
    }

    public ArrayList predictPositions(EnemyWave surfWave, double direction) {
        Point2D.Double predictedPosition = new Point2D.Double(this.getX(), this.getY());
        ArrayList<STCoord> positions = new ArrayList<STCoord>();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        Point2D.Double eLoc = enemyLoc;
        int counter = 0;
        boolean intercepted = false;
        do {
            eLoc = LUtils.project(eLoc, this.lastScan.getHeadingRadians(), this.lastScan.getVelocity());
            double absBearing = LUtils.absoluteBearing(eLoc, predictedPosition);
            double prefOffset = 0.5707963267948966 + LUtils.limit(50.0, eLoc.distance(predictedPosition), 650.0) / 650.0;
            double moveAngle = this.wallSmoothing(predictedPosition, absBearing + direction * prefOffset, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.17453292519943295 - 0.01308996938995747 * Math.abs(predictedVelocity);
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + LUtils.limit(-maxTurning, moveAngle, maxTurning)));
            double velAddition = predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = LUtils.limit(-8.0, predictedVelocity + velAddition, 8.0);
            predictedPosition = LUtils.project(predictedPosition, predictedHeading, predictedVelocity);
            STCoord pt = new STCoord();
            pt.place = predictedPosition;
            pt.time = (long)((surfWave.fireLoc.distance(pt.place) - surfWave.dist - surfWave.vel) / surfWave.vel) + this.getTime();
            positions.add(pt);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLoc) + surfWave.vel * 5.0 < surfWave.dist + (double)counter * surfWave.vel)) continue;
            intercepted = true;
        } while ((!intercepted || counter < 10) && counter < 90);
        return positions;
    }

    public float getWaveWeight(EnemyWave wave) {
        double bp = (20.0 - wave.vel) / 3.0;
        return (float)(bp * 4.0 + Math.max(0.0, bp - 1.0) * 2.0);
    }

    public float getDanger(EnemyWave wave, STCoord pt) {
        if (!_fieldRect.contains(pt.place)) {
            return Float.POSITIVE_INFINITY;
        }
        Point2D.Double startPlace = pt.prediction != null ? pt.prediction.endPoint : pt.place;
        int index = Linio.getFactorIndex(wave, startPlace);
        double botWidthAtEnd = 40.0 / (wave.fireLoc.distance(startPlace) - 34.0);
        double inv_binWidth = 50.0 / LUtils.maxEscAngle(wave.vel);
        int botBinWidthAtEnd = (int)Math.round(botWidthAtEnd * inv_binWidth);
        float thisDanger = this.getAverageDanger(wave.bestBins, index, botBinWidthAtEnd);
        thisDanger = (float)((double)thisDanger * (botWidthAtEnd * botWidthAtEnd));
        double waveCenterDistHere = wave.fireLoc.distance(startPlace);
        thisDanger = (float)((double)thisDanger / Math.cbrt(Math.min(enemyLoc.distance(startPlace) - 34.0, waveCenterDistHere)));
        float tta = (float)((wave.fireLoc.distance(startPlace) - wave.dist) / wave.vel);
        float relevance = tta * tta - 200.0f * tta + 10000.0f;
        return (float)((double)(thisDanger * relevance) * wave.weight);
    }

    public ArrayList getPredictions(EnemyWave wave, ArrayList points, Prediction start) {
        long moveTime;
        STCoord guessPT;
        int max = points.size();
        int min = -1;
        ArrayList<STCoord> likelyPoints = new ArrayList<STCoord>(max - min + 1);
        double waveDist = wave.vel * (double)(start.time - wave.fireTime);
        while (--max > 0) {
            guessPT = (STCoord)points.get(max);
            moveTime = (long)((wave.fireLoc.distance(guessPT.place) - waveDist - wave.vel) / wave.vel);
            if ((double)(moveTime * 8L - 44L) < guessPT.place.distance(start.endPoint)) break;
        }
        while (++min < max) {
            guessPT = (STCoord)points.get(min);
            moveTime = (long)((wave.fireLoc.distance(guessPT.place) - waveDist - wave.vel) / wave.vel);
            if ((double)(moveTime * 8L - 44L) < guessPT.place.distance(start.endPoint)) break;
        }
        while (max > 0) {
            guessPT = (STCoord)points.get(max);
            Prediction futureStatus = Linio.futureStatus(start.endPoint, guessPT.place, start.finalVel, start.finalHeading, start.time, wave);
            guessPT = Linio.clone(guessPT);
            guessPT.time = futureStatus.time;
            guessPT.prediction = futureStatus;
            likelyPoints.add(guessPT);
            if (futureStatus.distRemaining < 44.0) break;
            max -= 2;
        }
        while (min < max) {
            guessPT = (STCoord)points.get(min);
            Prediction futureStatus = Linio.futureStatus(start.endPoint, guessPT.place, start.finalVel, start.finalHeading, start.time, wave);
            guessPT = Linio.clone(guessPT);
            guessPT.time = futureStatus.time;
            guessPT.prediction = futureStatus;
            likelyPoints.add(guessPT);
            if (futureStatus.distRemaining < 44.0) break;
            min += 2;
        }
        int maxStop = max - 1;
        while (maxStop > min) {
            STCoord guessPT2 = (STCoord)points.get(maxStop);
            Prediction futureStatus = Linio.futureStatus(start.endPoint, guessPT2.place, start.finalVel, start.finalHeading, start.time, wave);
            guessPT2 = Linio.clone(guessPT2);
            guessPT2.time = futureStatus.time;
            guessPT2.prediction = futureStatus;
            likelyPoints.add(guessPT2);
            if (guessPT2.prediction.finalVel == 0.0 && guessPT2.prediction.distRemaining == 0.0) break;
            --maxStop;
        }
        int minStop = min + 1;
        while (minStop < maxStop) {
            STCoord guessPT3 = (STCoord)points.get(minStop);
            Prediction futureStatus = Linio.futureStatus(start.endPoint, guessPT3.place, start.finalVel, start.finalHeading, start.time, wave);
            guessPT3 = Linio.clone(guessPT3);
            guessPT3.time = futureStatus.time;
            guessPT3.prediction = futureStatus;
            likelyPoints.add(guessPT3);
            if (guessPT3.prediction.finalVel == 0.0 && guessPT3.prediction.distRemaining == 0.0) break;
            ++minStop;
        }
        int i = minStop;
        while (i <= maxStop) {
            STCoord guessPT4 = (STCoord)points.get(i);
            guessPT4.prediction = null;
            likelyPoints.add(Linio.clone(guessPT4));
            ++i;
        }
        return likelyPoints;
    }

    public static Prediction futureStatusXY(Point2D.Double fromLocation, Point2D.Double toLocation, double initialVelocity, double initialHeading, long currentTime, EnemyWave wave) {
        double bearing = LUtils.absoluteBearing(fromLocation, toLocation);
        double velocity = initialVelocity;
        double distanceRemaining = fromLocation.distance(toLocation);
        long time = currentTime + 1L - wave.fireTime;
        double heading = initialHeading;
        Point2D.Double endPoint = (Point2D.Double)fromLocation.clone();
        int counter = 91;
        double sinVal = 0.0;
        double cosVal = 0.0;
        boolean inline = false;
        do {
            if (!inline) {
                double maxTurn = 0.17453292519943295 - 0.01308996938995747 * Math.abs(velocity);
                bearing = LUtils.absoluteBearing(endPoint, toLocation);
                double offset = Utils.normalRelativeAngle((double)(bearing - heading));
                if (-1.5707963267948966 > offset || offset > 1.5707963267948966) {
                    offset = Utils.normalRelativeAngle((double)(offset + Math.PI));
                    velocity = -velocity;
                    heading += Math.PI;
                }
                offset = LUtils.limit(-maxTurn, offset, maxTurn);
                sinVal = Math.sin(heading += offset);
                cosVal = Math.cos(heading);
                if (-1.0E-4 < offset && offset < 1.0E-4) {
                    inline = true;
                }
            }
            velocity = velocity >= 0.0 && distanceRemaining >= LUtils.decelDistance(velocity) ? Math.min(velocity + 1.0, 8.0) : LUtils.limit(-1.9999999999, Math.abs(velocity) - Math.min(Math.max(Math.abs(velocity), distanceRemaining), 2.0), 6.0) * (double)(velocity < 0.0 ? -1 : 1);
            endPoint.x += sinVal * velocity;
            endPoint.y += cosVal * velocity;
            if (endPoint.x < 19.0 || endPoint.x > 781.0 || endPoint.y < 19.0 || endPoint.y > 581.0) {
                velocity = 0.0;
                endPoint.x -= sinVal * velocity;
                endPoint.y -= cosVal * velocity;
            }
            if (velocity > distanceRemaining) {
                inline = false;
            }
            if (inline) {
                distanceRemaining -= velocity;
                continue;
            }
            distanceRemaining = endPoint.distance(toLocation);
        } while (endPoint.distanceSq(wave.fireLoc) > LUtils.sqr(wave.vel * (double)(++time)) && --counter != 0);
        if (counter == 0) {
            System.out.println("PREVENTED PREDICTION FREEZE!!");
        }
        time = (long)(-0.5 + endPoint.distance(wave.fireLoc) / wave.vel) + wave.fireTime;
        Prediction status = new Prediction();
        status.distRemaining = distanceRemaining;
        status.endPoint = endPoint;
        status.finalVel = velocity;
        status.finalHeading = Utils.normalAbsoluteAngle((double)heading);
        status.time = time;
        return status;
    }

    public static final Prediction futureStatus(Point2D.Double fromLocation, Point2D.Double toLocation, double initialVelocity, double initialHeading, long currentTime, EnemyWave wave) {
        Prediction pred = Linio.futureStatusXY(fromLocation, toLocation, initialVelocity, initialHeading, currentTime, wave);
        return pred;
    }

    static STCoord clone(STCoord pt) {
        STCoord p = new STCoord();
        p.prediction = pt.prediction;
        p.place = pt.place;
        p.time = pt.time;
        p.danger = pt.danger;
        return p;
    }

    public STCoord getBestPoint(EnemyWave surfWave, EnemyWave nextWave, EnemyWave nnWave) {
        int i;
        ArrayList reverse;
        if (surfWave.bestBins == null) {
            this.getBins(surfWave);
            this.surfStatsChanged = true;
        }
        if (nextWave != null && nextWave.bestBins == null) {
            this.getBins(nextWave);
            this.surfStatsChanged = true;
        }
        if (nnWave != null && nnWave.bestBins == null) {
            this.getBins(nnWave);
        }
        if (nextWave != null && (nextWave.possPoints == null || this.surfStatsChanged)) {
            nextWave.possPoints = this.predictPositions(nextWave, 1.0);
            reverse = this.predictPositions(nextWave, -1.0);
            nextWave.possPoints.ensureCapacity(reverse.size() + nextWave.possPoints.size());
            i = 0;
            while (i < reverse.size()) {
                nextWave.possPoints.add(0, (STCoord)reverse.get(i));
                ++i;
            }
            i = 0;
            while (i < nextWave.possPoints.size()) {
                STCoord pt = nextWave.possPoints.get(i);
                pt.danger = this.getDanger(nextWave, pt);
                ++i;
            }
            nextWave.weight = this.getWaveWeight(nextWave);
            this.surfStatsChanged = true;
        }
        if (nnWave != null && (nnWave.possPoints == null || this.surfStatsChanged)) {
            nnWave.possPoints = this.predictPositions(nnWave, 1.0);
            reverse = this.predictPositions(nnWave, -1.0);
            nnWave.possPoints.ensureCapacity(reverse.size() + nnWave.possPoints.size());
            i = 0;
            while (i < reverse.size()) {
                nnWave.possPoints.add(0, (STCoord)reverse.get(i));
                ++i;
            }
        }
        if (surfWave.safePoints == null || surfWave.safestST == null || this.surfStatsChanged) {
            STCoord pt;
            surfWave.weight = this.getWaveWeight(surfWave);
            double vel = this.getVelocity();
            if (surfWave.safePoints == null || this.surfStatsChanged) {
                surfWave.safePoints = this.predictPositions(surfWave, latDir);
                ArrayList reversePoints = this.predictPositions(surfWave, -latDir);
                surfWave.safePoints.ensureCapacity(reversePoints.size() + surfWave.safePoints.size());
                int i2 = 0;
                while (i2 < reversePoints.size()) {
                    surfWave.safePoints.add(0, reversePoints.get(i2));
                    ++i2;
                }
            }
            Prediction now = new Prediction();
            now.finalHeading = this.getHeadingRadians();
            now.finalVel = this.getVelocity();
            now.distRemaining = this.getDistanceRemaining();
            now.time = this.getTime();
            now.endPoint = myLoc;
            if (now.distRemaining < 0.0) {
                now.finalVel = -now.finalVel;
                now.distRemaining = -now.distRemaining;
                now.finalHeading = Utils.normalAbsoluteAngle((double)(now.finalHeading + Math.PI));
            }
            ArrayList points = this.getPredictions(surfWave, surfWave.safePoints, now);
            ArrayList bestNextPoints = null;
            float minDanger = Float.POSITIVE_INFINITY;
            int i3 = 0;
            int k = points.size();
            while (i3 < k) {
                pt = (STCoord)points.get(i3);
                pt.danger = this.getDanger(surfWave, pt);
                if (pt.danger < minDanger) {
                    surfWave.safestST = pt;
                    minDanger = pt.danger;
                }
                ++i3;
            }
            if (nextWave != null) {
                minDanger = Float.POSITIVE_INFINITY;
                Collections.sort(points);
                i3 = 0;
                k = points.size();
                while (i3 < k) {
                    pt = (STCoord)points.get(i3);
                    if (pt.danger >= minDanger) break;
                    if (pt.prediction == null) {
                        pt.prediction = Linio.futureStatus(myLoc, pt.place, now.finalVel, now.finalHeading, now.time, surfWave);
                    }
                    float minSecondDanger = Float.POSITIVE_INFINITY;
                    ArrayList nextPoints = this.getPredictions(nextWave, nextWave.possPoints, pt.prediction);
                    STCoord safePt = null;
                    int j = 0;
                    int l = nextPoints.size();
                    while (j < l) {
                        STCoord nextPt = (STCoord)nextPoints.get(j);
                        if (nextPt.prediction == null) {
                            if (nextPt.danger < minSecondDanger) {
                                minSecondDanger = nextPt.danger;
                                safePt = nextPt;
                            }
                        } else {
                            float d = this.getDanger(nextWave, nextPt);
                            if (d < minSecondDanger) {
                                minSecondDanger = d;
                                safePt = nextPt;
                            }
                        }
                        ++j;
                    }
                    if (nextPoints.size() > 0) {
                        pt.danger += minSecondDanger;
                    }
                    if (pt.danger < minDanger) {
                        surfWave.safestST = pt;
                        nextWave.safestST = safePt;
                        minDanger = pt.danger;
                        bestNextPoints = nextPoints;
                    }
                    ++i3;
                }
                if (nextWave != null && nextWave.safestST != null && nextWave.safestST.prediction == null) {
                    nextWave.safestST.prediction = Linio.futureStatus(surfWave.safestST.place, nextWave.safestST.place, surfWave.safestST.prediction.finalVel, surfWave.safestST.prediction.finalHeading, surfWave.safestST.time, nextWave);
                }
                if (nnWave != null && nnWave.safestST != null && nnWave.safestST.prediction != null && nextWave != null && nextWave.safestST != null && nextWave.safestST.prediction != null && nnWave.possPoints != null && nnWave.possPoints.size() > 0) {
                    ArrayList nextPoints = this.getPredictions(nnWave, nnWave.possPoints, nextWave.safestST.prediction);
                    STCoord safePt = null;
                    float minnnDanger = Float.POSITIVE_INFINITY;
                    int j = 0;
                    int l = nextPoints.size();
                    while (j < l) {
                        STCoord nextPt = (STCoord)nextPoints.get(j);
                        float d = this.getDanger(nnWave, nextPt);
                        if (d < minnnDanger) {
                            minnnDanger = d;
                            safePt = nextPt;
                        }
                        ++j;
                    }
                    nnWave.safestST = safePt;
                    if (safePt != null && safePt.prediction == null) {
                        safePt.prediction = Linio.futureStatus(nextWave.safestST.place, safePt.place, nextWave.safestST.prediction.finalVel, nextWave.safestST.prediction.finalHeading, nextWave.safestST.time, nnWave);
                    }
                }
            }
            this.surfStatsChanged = false;
            if (this.painting) {
                this.firstPointsPainting = points;
                this.nextPointsPainting = bestNextPoints;
            }
        }
        return surfWave.safestST;
    }

    public void setBackAsFront(double angle) {
        LUtils.setBackAsFront(this, angle);
    }

    public EnemyWave getCollisionWave(Point2D.Double point, double bulletPower) {
        int x = 0;
        while (x < enemyWaves.size()) {
            EnemyWave ew = enemyWaves.get(x);
            double dist = ew.dist - point.distance(ew.fireLoc);
            if (Math.abs(dist - 10.0) < 50.0 && Math.abs(LUtils.bulletVelocity(bulletPower) - ew.vel) < 0.01) {
                return ew;
            }
            ++x;
        }
        return null;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            hitWave = this.getCollisionWave(hitBulletLocation, e.getHitBullet().getPower());
            if (hitWave != null) {
                if (hitWave.dist > hitWave.vel * 2.0) {
                    this.logHit(hitWave, hitBulletLocation);
                }
                hitWave.bulGone = true;
            } else {
                System.out.println("ERROR: DETECTED BULLET ON NONEXISTANT WAVE!");
            }
        } else {
            System.out.println("ERROR: DETECTED BULLET WITHOUT WAVES!");
        }
        for (GunWave w : waveList) {
            if (w.bullet == null || e.getBullet() != w.bullet) continue;
            double normAngle = Utils.normalRelativeAngle((double)(w.bullet.getHeadingRadians() - w.bearing)) * w.latDir;
            double GF = normAngle / w.MEA_norm;
            w.logASBuffer(GF, -3.0);
            w.bullet = null;
            w.bulletFired = false;
        }
    }

    public void onPaint(Graphics2D g) {
        STCoord pt;
        Point2D.Double center;
        this.painting = true;
        g.setColor(Color.red);
        int i = 0;
        while (i < enemyWaves.size()) {
            g.setColor(Color.red);
            EnemyWave w = enemyWaves.get(i);
            int radius = (int)w.dist;
            center = w.fireLoc;
            if ((double)(radius - 40) < center.distance(myLoc)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
                if (w.bestBins != null) {
                    double MEA = LUtils.maxEscAngle(w.vel);
                    int j = 0;
                    while (j < 101) {
                        double thisDanger = w.bestBins[j];
                        g.setColor(Color.blue);
                        if (thisDanger > 0.1) {
                            g.setColor(Color.green);
                        }
                        if (thisDanger > 0.3) {
                            g.setColor(Color.yellow);
                        }
                        if (thisDanger > 0.6) {
                            g.setColor(Color.orange);
                        }
                        if (thisDanger > 0.9) {
                            g.setColor(Color.red);
                        }
                        Point2D.Double p1 = LUtils.project(center, w.angle + (double)w.dir * (0.5 + (double)j - 50.0) / 50.0 * MEA, radius);
                        Point2D.Double p2 = LUtils.project(center, w.angle + (double)w.dir * ((double)j - 0.5 - 50.0) / 50.0 * MEA, radius);
                        g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
                        ++j;
                    }
                }
                if (w.imaginary) {
                    g.setColor(Color.white);
                    g.drawString("imaginary wave in air", 100, 35);
                    g.drawString("velocity: " + w.vel, 100, 25);
                    g.drawString("traveled distance: " + w.dist, 100, 15);
                }
            }
            ++i;
        }
        g.setColor(Color.white);
        g.drawString("enemy gunheat: " + this.enemyGH, 300, 15);
        g.drawString("imaginary enemy gunheat" + this.imgGH, 300, 5);
        g.drawRect((int)Linio.myLoc.x - 18, (int)Linio.myLoc.y - 18, 36, 36);
        if (this.firstPointsPainting != null) {
            i = 0;
            while (i < this.firstPointsPainting.size()) {
                g.setColor(Color.green);
                pt = (STCoord)this.firstPointsPainting.get(i);
                Point2D.Double goToTarget = pt.place;
                if (pt.prediction != null) {
                    goToTarget = pt.prediction.endPoint;
                    if (pt.prediction.debug) {
                        g.setColor(Color.red);
                    }
                }
                g.drawOval((int)goToTarget.x - 2, (int)goToTarget.y - 2, 4, 4);
                ++i;
            }
        }
        if (this.lastPoint != null) {
            g.setColor(Color.orange);
            g.drawOval((int)this.lastPoint.x - 3, (int)this.lastPoint.y - 3, 6, 6);
            g.drawOval((int)this.lastPoint.x - 4, (int)this.lastPoint.y - 4, 8, 8);
        }
        if (this.pw[1] != null && this.pw[1].possSafeST != null) {
            g.setColor(Color.white);
            g.drawOval((int)this.pw[1].possSafeST.place.x - 3, (int)this.pw[1].possSafeST.place.y - 3, 6, 6);
        }
        if (this.nextPointsPainting != null) {
            g.setColor(Color.pink);
            i = 0;
            while (i < this.nextPointsPainting.size()) {
                pt = (STCoord)this.nextPointsPainting.get(i);
                Point2D.Double goToTarget = pt.prediction == null ? pt.place : pt.prediction.endPoint;
                g.drawOval((int)goToTarget.x - 2, (int)goToTarget.y - 2, 4, 4);
                ++i;
            }
        }
        i = 0;
        int j = waveList.size();
        while (i < j) {
            GunWave w = waveList.get(i);
            if (i == 0) {
                g.setColor(Color.green);
                Point2D.Double nmea = LUtils.project(w.gunLoc, w.bearing - w.latDir * w.MEA_neg, 1000.0);
                g.drawLine((int)w.gunLoc.x, (int)w.gunLoc.y, (int)nmea.x, (int)nmea.y);
                g.setColor(Color.red);
                Point2D.Double pmea = LUtils.project(w.gunLoc, w.bearing + w.latDir * w.MEA_pos, 1000.0);
                g.drawLine((int)w.gunLoc.x, (int)w.gunLoc.y, (int)pmea.x, (int)pmea.y);
                g.setColor(Color.red);
                if (this.predPoints != null) {
                    int k = 0;
                    while (k < this.predPoints.size()) {
                        Point2D.Double p = this.predPoints.get(k);
                        g.drawOval((int)(p.x - 2.0), (int)(p.y - 2.0), 4, 4);
                        ++k;
                    }
                }
            }
            if (w.bulletFired) {
                center = w.gunLoc;
                double radius = (double)(GunWave.currentTime - w.fireTime) * LUtils.bulletVelocity(w.bulletPower);
                g.setColor(Color.red);
                g.drawOval((int)(w.gunLoc.x - radius), (int)(w.gunLoc.y - radius), (int)(radius * 2.0), (int)(radius * 2.0));
                double lastRadius = radius - LUtils.bulletVelocity(w.bulletPower);
                g.setColor(Color.green);
                g.drawOval((int)(w.gunLoc.x - lastRadius), (int)(w.gunLoc.y - lastRadius), (int)(lastRadius * 2.0), (int)(lastRadius * 2.0));
                g.setColor(Color.gray);
                double ASAngle = w.ASOffset + w.bearing;
                Point2D.Double ASLoc = LUtils.project(w.gunLoc, ASAngle, radius);
                g.drawLine((int)w.gunLoc.x, (int)w.gunLoc.y, (int)ASLoc.x, (int)ASLoc.y);
                g.setColor(Color.orange);
                double mainGunAngle = w.DCOffset + w.bearing;
                Point2D.Double mgLoc = LUtils.project(w.gunLoc, mainGunAngle, radius);
                g.drawLine((int)w.gunLoc.x, (int)w.gunLoc.y, (int)mgLoc.x, (int)mgLoc.y);
                g.setColor(Color.cyan);
                if (GunWave.paintPoints.size() > 1) {
                    Point2D.Double p = (Point2D.Double)GunWave.paintPoints.get(0);
                    int x = 1;
                    while (x < GunWave.paintPoints.size()) {
                        Point2D.Double pp = (Point2D.Double)GunWave.paintPoints.get(x);
                        g.drawLine((int)p.x, (int)p.y, (int)pp.x, (int)pp.y);
                        p = pp;
                        ++x;
                    }
                }
                if (w.intersecting) {
                    g.setColor(Color.white);
                    double angle1 = w.storeScan.range.min;
                    angle1 = angle1 > 0.0 ? angle1 * w.MEA_pos * w.latDir + w.bearing : angle1 * w.MEA_neg * w.latDir + w.bearing;
                    double angle2 = w.storeScan.range.max;
                    angle2 = angle2 > 0.0 ? angle2 * w.MEA_pos * w.latDir + w.bearing : angle2 * w.MEA_neg * w.latDir + w.bearing;
                    Point2D.Double p1 = LUtils.project(w.gunLoc, angle1, radius);
                    Point2D.Double p2 = LUtils.project(w.gunLoc, angle2, radius);
                    g.drawLine((int)w.gunLoc.x, (int)w.gunLoc.y, (int)p1.x, (int)p1.y);
                    g.drawLine((int)w.gunLoc.x, (int)w.gunLoc.y, (int)p2.x, (int)p2.y);
                }
            }
            ++i;
        }
        if (enemyLocs.size() > 0) {
            g.setColor(Color.white);
            Point2D.Double enemyLocation = enemyLocs.get(0);
            g.drawRect((int)enemyLocation.x - 18, (int)enemyLocation.y - 18, 36, 36);
        }
    }
}

