/*
 * Decompiled with CFR 0.152.
 */
package jekl.navigation;

import java.util.Hashtable;
import jekl.Jekyl;
import jekl.navigation.movement.AntiGravityMovement;
import jekl.navigation.movement.Movement;
import jekl.navigation.movement.OrbitMovement;
import jekl.util.Constants;
import robocode.AdvancedRobot;

public class MovementManager
implements Constants {
    protected Hashtable movementMethods;
    protected Movement m;
    protected AdvancedRobot ar;

    public MovementManager(Jekyl _ar) {
        this.ar = _ar;
        this.movementMethods = new Hashtable();
        this.movementMethods.put("AntiGravMove", new AntiGravityMovement(_ar));
        this.movementMethods.put("CircularMove", new OrbitMovement(_ar));
    }

    public void doMovement() {
        this.m = this.getMovementMethod();
        if (this.ar.getOthers() > 0) {
            this.m.doMovement();
        }
    }

    private Movement getMovementMethod() {
        if (this.ar.getOthers() > 1) {
            return (Movement)this.movementMethods.get("AntiGravMove");
        }
        return (Movement)this.movementMethods.get("CircularMove");
    }

    private Movement getMovementMethod(String movementMethod) {
        return (Movement)this.movementMethods.get(movementMethod);
    }

    public void notifyOfHit() {
        ((Movement)this.movementMethods.get("CircularMove")).notifyOfHit();
    }
}

