/*
 * Decompiled with CFR 0.152.
 */
package ghent.common;

import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Direction {
    NORTH(0.0),
    NORTH_EAST(45.0),
    EAST(90.0),
    SOUTH_EAST(135.0),
    SOUTH(180.0),
    SOUTH_WEST(225.0),
    WEST(270.0),
    NORTH_WEST(315.0);

    private double degree;

    private Direction(double degree) {
        this.degree = degree;
    }

    public boolean lookAt(double angle, double delta) {
        angle = Utils.normalAbsoluteAngleDegrees((double)angle);
        delta = Utils.normalAbsoluteAngleDegrees((double)delta);
        double angleMin = this.degree - delta;
        double angleMax = this.degree + delta;
        if (angleMin < 0.0 && angleMax > 0.0) {
            if (angle >= 0.0 && angle <= angleMax) {
                return true;
            }
            return angle >= (angleMin += 360.0) && angle <= 360.0;
        }
        return angle >= angleMin && angle <= angleMax;
    }

    public static Direction getApproximate(double degree) {
        degree %= 360.0;
        for (Direction d : Direction.values()) {
            if (!d.lookAt(degree, 22.5)) continue;
            return d;
        }
        return null;
    }

    public boolean similarTo(Direction d) {
        if (this == d) {
            return true;
        }
        switch (d) {
            case NORTH: {
                return this == NORTH_EAST || this == NORTH_WEST;
            }
            case NORTH_EAST: {
                return this == NORTH || this == EAST;
            }
            case EAST: {
                return this == NORTH_EAST || this == SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return this == SOUTH || this == EAST;
            }
            case SOUTH: {
                return this == SOUTH_EAST || this == SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return this == SOUTH || this == WEST;
            }
            case WEST: {
                return this == NORTH_WEST || this == SOUTH_WEST;
            }
            case NORTH_WEST: {
                return this == NORTH || this == WEST;
            }
        }
        return false;
    }
}

