/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.layer.AbstractUpstreamLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.InternalLayer;
import dmonner.xlbp.layer.UpstreamLayer;
import java.util.Arrays;

public abstract class AbstractFanInLayer
extends AbstractUpstreamLayer
implements InternalLayer {
    private static final long serialVersionUID = 1L;
    protected UpstreamLayer[] upstream = new UpstreamLayer[0];
    protected int nUpstream = 0;
    protected int[] myIndexInUpstream = new int[0];

    public AbstractFanInLayer(AbstractFanInLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public AbstractFanInLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void addUpstream(UpstreamComponent upstream) {
        int index = this.nUpstream++;
        this.setUpstreamCapacity(this.nUpstream);
        this.upstream[index] = upstream.asUpstreamLayer();
        this.connectUpstream(index);
        this.myIndexInUpstream[index] = upstream.indexOfDownstream(this);
    }

    @Override
    public DownstreamLayer asDownstreamLayer() {
        return this;
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.myIndexInUpstream = new int[this.nUpstream];
            for (int i = 0; i < this.nUpstream; ++i) {
                UpstreamLayer upstream = this.upstream[i];
                int index = upstream.indexOfDownstream(this);
                if (index < 0) {
                    throw new IllegalStateException(this.name + " is not in " + upstream.getName() + " layer's list of connected downstream layers.");
                }
                if (upstream.size() != this.size()) {
                    throw new IllegalStateException("Incompatible sizes between " + this.name + " (" + this.size() + ") and " + upstream.getName() + " (" + upstream.size() + ").");
                }
                this.myIndexInUpstream[i] = index;
            }
            this.built = true;
        }
    }

    @Override
    public boolean connectedUpstream(UpstreamComponent upstream) {
        return this.indexOfUpstream(upstream) >= 0;
    }

    protected void connectUpstream(int index) {
        UpstreamLayer upstream = this.upstream[index];
        if (!upstream.connectedDownstream(this)) {
            upstream.addDownstream(this);
        }
    }

    @Override
    public abstract AbstractFanInLayer copy(NetworkCopier var1);

    @Override
    public AbstractFanInLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof AbstractFanInLayer) {
            AbstractFanInLayer that = (AbstractFanInLayer)comp;
            this.upstream = new UpstreamLayer[that.upstream.length];
            this.myIndexInUpstream = new int[that.myIndexInUpstream.length];
            this.nUpstream = that.nUpstream;
            for (int i = 0; i < that.upstream.length; ++i) {
                this.upstream[i] = copier.getCopyIfExists(that.upstream[i]);
                this.myIndexInUpstream[i] = that.myIndexInUpstream[i];
            }
        }
    }

    protected void disconnectUpstream(UpstreamComponent upstream) {
        int index = upstream.indexOfDownstream(this);
        if (index >= 0) {
            upstream.removeDownstream(index);
        }
    }

    @Override
    public int getIndexInUpstream() {
        return this.getIndexInUpstream(0);
    }

    @Override
    public int getIndexInUpstream(int index) {
        return this.myIndexInUpstream[index];
    }

    @Override
    public UpstreamComponent getUpstream() {
        return this.getUpstream(0);
    }

    @Override
    public UpstreamComponent getUpstream(int upstreamIndex) {
        return this.upstream[upstreamIndex];
    }

    @Override
    public int indexOfUpstream(UpstreamComponent upstream) {
        for (int i = 0; i < this.nUpstream; ++i) {
            if (this.upstream[i] != upstream) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int nUpstream() {
        return this.nUpstream;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        if (this.downstream == null) {
            throw new IllegalStateException(this.name + " is missing a downstream layer.");
        }
        if (this.nUpstream == 0) {
            throw new IllegalStateException(this.name + " is missing an upstream layer.");
        }
        if (this.nUpstream == 1) {
            DownstreamLayer downstream = this.downstream;
            UpstreamLayer upstream = this.upstream[0];
            downstream.removeUpstream(this);
            upstream.removeDownstream(this);
            downstream.addUpstream(upstream);
            return false;
        }
        return true;
    }

    @Override
    public void removeUpstream(int index) {
        UpstreamLayer old = this.upstream[index];
        for (int i = index + 1; i < this.nUpstream; ++i) {
            this.upstream[i - 1] = this.upstream[i];
        }
        --this.nUpstream;
        this.setUpstreamCapacity(this.nUpstream);
        this.disconnectUpstream(old);
    }

    @Override
    public void removeUpstream(UpstreamComponent upstream) {
        this.removeUpstream(this.indexOfUpstream(upstream));
    }

    protected void setUpstreamCapacity(int capacity) {
        this.upstream = Arrays.copyOf(this.upstream, capacity);
        this.myIndexInUpstream = Arrays.copyOf(this.myIndexInUpstream, capacity);
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showConnectivity()) {
            sb.indent();
            sb.append("Upstream: [");
            sb.append(this.upstream[0].getName());
            for (int i = 1; i < this.nUpstream; ++i) {
                sb.append(", ");
                sb.append(this.upstream[i].getName());
            }
            sb.append("]");
            sb.appendln();
        }
        sb.popIndent();
    }
}

