/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.SetStat;

public abstract class Optimizer {
    public static Optimizer defaultOptimizer = Optimizer.get(Type.SSE);

    public static Optimizer get(Type type) {
        if (type == Type.BIT_ACCURACY) {
            return new Optimizer(){

                @Override
                public boolean betterThan(SetStat newest, SetStat best) {
                    if (newest == null) {
                        return false;
                    }
                    if (best == null) {
                        return true;
                    }
                    return newest.getTargetStats().getBits().getAccuracy() >= best.getTargetStats().getBits().getAccuracy();
                }
            };
        }
        if (type == Type.TARGET_ACCURACY) {
            return new Optimizer(){

                @Override
                public boolean betterThan(SetStat newest, SetStat best) {
                    if (newest == null) {
                        return false;
                    }
                    if (best == null) {
                        return true;
                    }
                    return newest.getTargetStats().getCorrect().getFraction() >= best.getTargetStats().getCorrect().getFraction();
                }
            };
        }
        if (type == Type.TRIAL_ACCURACY) {
            return new Optimizer(){

                @Override
                public boolean betterThan(SetStat newest, SetStat best) {
                    if (newest == null) {
                        return false;
                    }
                    if (best == null) {
                        return true;
                    }
                    return newest.getTrialStats().getFraction() >= best.getTrialStats().getFraction();
                }
            };
        }
        if (type == Type.STEP_ACCURACY) {
            return new Optimizer(){

                @Override
                public boolean betterThan(SetStat newest, SetStat best) {
                    if (newest == null) {
                        return false;
                    }
                    if (best == null) {
                        return true;
                    }
                    return newest.getStepStats().getFraction() >= best.getStepStats().getFraction();
                }
            };
        }
        if (type == Type.SSE) {
            return new Optimizer(){

                @Override
                public boolean betterThan(SetStat newest, SetStat best) {
                    if (newest == null) {
                        return false;
                    }
                    if (best == null) {
                        return true;
                    }
                    return newest.getTargetStats().getError().getSSE() <= best.getTargetStats().getError().getSSE();
                }
            };
        }
        throw new IllegalStateException("Unhandled Type: " + (Object)((Object)type));
    }

    public abstract boolean betterThan(SetStat var1, SetStat var2);

    public static enum Type {
        BIT_ACCURACY,
        TARGET_ACCURACY,
        TRIAL_ACCURACY,
        STEP_ACCURACY,
        SSE;

    }
}

