/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.INotifiable;
import execution.Message;
import execution.MessageRouter;
import execution.TeamRouter$$Lambda$1;
import execution.TeamRouter$$Lambda$2;
import java.io.IOException;
import java.io.Serializable;
import robocode.MessageEvent;
import robocode.robotinterfaces.ITeamEvents;
import robocode.robotinterfaces.peer.ITeamRobotPeer;
import sim.Battle;
import sim.Data;

public class TeamRouter
implements INotifiable,
ITeamEvents {
    private ITeamRobotPeer _teamPeer;
    private MessageRouter _router;

    public TeamRouter(ITeamRobotPeer teamPeer, MessageRouter router) {
        this._teamPeer = teamPeer;
        this._router = router;
    }

    @Override
    public void Initialize(MessageRouter router) {
        String[] teamNames = this._teamPeer.getTeammates();
        if (teamNames != null && teamNames.length > 0) {
            router.Subscribe(Message.Kind.BattleStarted, TeamRouter$$Lambda$1.lambdaFactory$(this));
            router.Subscribe(Message.Kind.ScannedEnemy, TeamRouter$$Lambda$2.lambdaFactory$(this));
        }
    }

    private final void OnBattleStarted(Message message) {
        String[] teamNames = this._teamPeer.getTeammates();
        if (teamNames != null && teamNames.length > 0) {
            Data.Battle.Type = Battle.BattleType.Team;
            for (String name : teamNames) {
                Data.Robots.Ally(name);
            }
        }
    }

    public void onMessageReceived(MessageEvent arg0) {
        Serializable raw = arg0.getMessage();
        if (raw instanceof Message) {
            Message message = (Message)raw;
            message.setRouter(this._router);
            this._router.Send(message);
        } else {
            System.out.println("WARNING: recieved a message, but was not a Message type");
        }
    }

    private final void SendMessage(Message message) {
        try {
            message.setRouter(null);
            this._teamPeer.broadcastMessage((Serializable)message);
            message.setRouter(this._router);
        }
        catch (IOException e) {
            System.out.println("WARNING: exception caught sending team message of type " + (Object)((Object)message.type));
        }
    }

    static /* synthetic */ void access$lambda$0(TeamRouter teamRouter, Message message) {
        teamRouter.OnBattleStarted(message);
    }

    static /* synthetic */ void access$lambda$1(TeamRouter teamRouter, Message message) {
        teamRouter.SendMessage(message);
    }
}

