/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.TurnAngle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class EFDUtils {
    public static double normaliseAngle(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double getRange(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double h = Math.sqrt(x * x + y * y);
        return h;
    }

    public static Point2D.Double projectPoint(Point2D.Double origin, double angle, double distance) {
        return new Point2D.Double(origin.x + distance * Math.sin(angle), origin.y + distance * Math.cos(angle));
    }

    public static double absoluteAngle(Point2D.Double origin, Point2D.Double target) {
        return EFDUtils.normaliseAngle(Math.atan2(target.x - origin.x, target.y - origin.y));
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double maxHeadingChange(double velocity) {
        return (10.0 - 0.75 * Math.abs(velocity)) * (Math.PI / 180);
    }

    public static void drawDot(Graphics g, Point2D.Double dotPosition, Color color) {
        Color oldColor = g.getColor();
        g.setColor(color);
        g.fillOval((int)dotPosition.x - 2, (int)dotPosition.y - 2, 4, 4);
        g.setColor(oldColor);
    }

    public static int getFactorIndex(double offsetAngle, double bulletSpeed, int BINS) {
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / EFDUtils.maxEscapeAngle(bulletSpeed);
        return (int)EFDUtils.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public static int getFactorIndex(double currentAngle, double targetAngle, double bulletSpeed, int BINS) {
        double offsetAngle = targetAngle - currentAngle;
        return EFDUtils.getFactorIndex(offsetAngle, bulletSpeed, BINS);
    }

    public static double cornerDistance(Point2D.Double position, AdvancedEFD r) {
        return Math.sqrt(Math.pow(Math.min(position.x, r.getBattleFieldWidth() - position.x) - 17.0, 2.0) + Math.pow(Math.min(position.y, r.getBattleFieldHeight() - position.y) - 17.0, 2.0));
    }

    public static TurnAngle turnToAngle(double angle, double heading) {
        double d;
        double d2;
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle < heading) {
            angle += Math.PI * 2;
        }
        if (angle - heading < 0.001) {
            return new TurnAngle(0.0, 1, false);
        }
        if (Math.abs(angle - heading - Math.PI) < 0.001) {
            return new TurnAngle(0.0, 1, true);
        }
        TurnAngle retAngle = new TurnAngle(0.0, 1, false);
        double turnAngle = Math.PI * 2 - (angle - heading);
        if (d2 <= 1.5707963267948966) {
            retAngle = new TurnAngle(turnAngle, 1, false);
        }
        turnAngle = turnAngle > Math.PI ? (turnAngle -= Math.PI) : (turnAngle += Math.PI);
        if (turnAngle <= 1.5707963267948966) {
            retAngle = new TurnAngle(turnAngle, 1, true);
        }
        turnAngle = angle - heading;
        if (d <= 1.5707963267948966) {
            retAngle = new TurnAngle(turnAngle, -1, false);
        }
        turnAngle = turnAngle > Math.PI ? (turnAngle -= Math.PI) : (turnAngle += Math.PI);
        if (turnAngle <= 1.5707963267948966) {
            retAngle = new TurnAngle(turnAngle, -1, true);
        }
        return retAngle;
    }
}

