/*
 * Decompiled with CFR 0.152.
 */
package xander.core.math;

import xander.core.Resources;

public class RCPhysics {
    public static final double MAX_SPEED = 8.0;
    public static final double MAX_TURN_RATE = 10.0;
    public static final double MAX_FIRE_POWER = 3.0;
    public static final double MIN_FIRE_POWER = 0.1;
    public static final double ROBOT_WIDTH = 40.0;
    public static final double ROBOT_HALF_WIDTH = 20.0;
    public static final double ACCELERATION_RATE = 1.0;
    public static final double DECELERATION_RATE = -2.0;
    public static final double MIN_BULLET_VELOCITY = RCPhysics.getBulletVelocity(3.0);
    public static final double MAX_BULLET_VELOCITY = RCPhysics.getBulletVelocity(0.1);
    public static final double MIN_EFFECTIVE_HIT_RATIO = 3.0 / (RCPhysics.getEnergyRegained(3.0) + RCPhysics.getBulletDamage(3.0));

    public static double getEffectiveHitRatio(double power) {
        return power / (RCPhysics.getEnergyRegained(power) + RCPhysics.getBulletDamage(power));
    }

    public static double getBulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double getBulletPower(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static double getMaxTurnRate(double velocity) {
        return 10.0 - 0.75 * Math.abs(velocity);
    }

    public static double getBulletDamage(double power) {
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        return damage;
    }

    public static double getWallHitDamage(double velocity) {
        return Math.max(0.0, Math.abs(velocity) * 0.5 - 1.0);
    }

    public static double getEnergyRegained(double power) {
        return 3.0 * power;
    }

    public static double getFirePowerToKill(double energy) {
        double firePower = energy / 4.0;
        if (firePower > 1.0) {
            firePower = (energy + 2.0) / 6.0;
        }
        return firePower + 0.1;
    }

    public static double getGunHeatGenerated(double power) {
        return 1.0 + power / 5.0;
    }

    public static int getTimeUntilGunCool() {
        double timeToCool = Resources.getRobotProxy().getGunHeat() / Resources.getRobotProxy().getGunCoolingRate();
        return (int)Math.round(Math.ceil(timeToCool));
    }

    public static int getTimeUntilGunCool(double power) {
        double timeToCool = RCPhysics.getGunHeatGenerated(power) / Resources.getRobotProxy().getGunCoolingRate();
        return (int)Math.round(Math.ceil(timeToCool));
    }

    public static double getEnergyRate(double hitRatio, double averagePower, double gunCoolingRate) {
        return (hitRatio * RCPhysics.getEnergyRegained(averagePower) - averagePower) / (averagePower / gunCoolingRate);
    }

    public static boolean isSteadySpeed(double v0, double v1) {
        return Math.abs(v1 - v0) < 0.05;
    }

    public static boolean isAcceleration(double v0, double v1) {
        return !RCPhysics.isSteadySpeed(v0, v1) && Math.abs(v1) > Math.abs(v0);
    }

    public static boolean isDeceleration(double v0, double v1) {
        return !RCPhysics.isSteadySpeed(v0, v1) && Math.abs(v1) < Math.abs(v0);
    }
}

