/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.AbstractMovementClass;
import TNT.Coordinate;
import TNT.Recon;
import TNT.ReconCollection;
import TNT.TNT;
import TNT.TNTMath;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import robocode.HitRobotEvent;

class MultiMovementStrategy
extends AbstractMovementClass {
    public void move() {
        List closestEnemies = this.determineClosestEnemies();
        this.m_owner.setMaxVelocity(8.0);
        if (closestEnemies.size() == 0) {
            if (this.m_owner.getDistanceRemaining() == 0.0) {
                this.m_owner.reverseDirection();
                if (TNT.random.nextBoolean()) {
                    this.m_owner.setTurnRightRadians(Math.PI * 8);
                    this.m_owner.setAhead(300.0);
                } else {
                    this.m_owner.setTurnLeftRadians(Math.PI * 6);
                    this.m_owner.setAhead(300.0);
                }
            }
        } else {
            this.headToCoordinate(this.determineBestCoord(closestEnemies));
        }
    }

    private final void headToCoordinate(Coordinate in_coordinate) {
        in_coordinate.setX(in_coordinate.getX() + this.m_owner.getX());
        in_coordinate.setY(in_coordinate.getY() + this.m_owner.getY());
        TNTMath.turnToXYCoord(in_coordinate, this.m_owner);
        this.m_owner.setAhead(100.0);
    }

    private final List determineClosestEnemies() {
        Enumeration allEnemys = TNT.m_scannedInformation.elements();
        ArrayList<Recon> out_allEnemies = new ArrayList<Recon>();
        ReconCollection currentInformation = null;
        while (allEnemys.hasMoreElements()) {
            currentInformation = (ReconCollection)allEnemys.nextElement();
            if (!currentInformation.isCurrent()) continue;
            out_allEnemies.add(currentInformation.get(0));
        }
        return out_allEnemies;
    }

    private final Coordinate determineBestCoord(List in_allEnemies) {
        Coordinate out_coordinate = new Coordinate();
        int numberOfEnemies = in_allEnemies.size();
        Recon currentEnemy = null;
        out_coordinate.setX(250.0 / this.m_owner.getX() + out_coordinate.getX());
        out_coordinate.setX(-250.0 / (TNT.FIELD_WIDTH - this.m_owner.getX()) + out_coordinate.getX());
        out_coordinate.setY(250.0 / this.m_owner.getY() + out_coordinate.getY());
        out_coordinate.setY(-250.0 / (TNT.FIELD_HEIGHT - this.m_owner.getY()) + out_coordinate.getY());
        int iCounter = 0;
        while (iCounter < numberOfEnemies) {
            currentEnemy = (Recon)in_allEnemies.get(iCounter);
            out_coordinate.setX(250.0 / currentEnemy.getDistance() * Math.sin(currentEnemy.getBearing() + this.m_owner.getHeadingRadians() + Math.PI) + out_coordinate.getX());
            out_coordinate.setY(250.0 / currentEnemy.getDistance() * Math.cos(currentEnemy.getBearing() + this.m_owner.getHeadingRadians() + Math.PI) + out_coordinate.getY());
            ++iCounter;
        }
        return out_coordinate;
    }

    public void gotCollision(HitRobotEvent event) {
    }

    public boolean shouldUseStrategy() {
        return this.m_owner.getOthers() > 1;
    }

    public boolean overrideWallCheck() {
        return true;
    }

    public boolean expiredStrategy() {
        return !this.shouldUseStrategy();
    }

    public MultiMovementStrategy(TNT in_owner) {
        super(in_owner);
    }
}

