/*
 * Decompiled with CFR 0.152.
 */
package syl.movement;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.movement.MovementStrategy;
import syl.movement.gravity.EnemyGravity;
import syl.movement.gravity.GravityMovementFeature;
import syl.movement.gravity.GravityPoint;
import syl.movement.gravity.RepellantCorner;
import syl.movement.gravity.StrafeGravity;
import syl.movement.gravity.WallGravity;
import syl.util.Coordinate;

public class GravityMovementStrategy
extends MovementStrategy {
    private Hashtable gravityPoints = new Hashtable();
    private Vector features = new Vector();
    private static final double MOVEMENT_DISTANCE = 50.0;

    public GravityMovementStrategy(BaseRobot robot) {
        super(robot);
    }

    public void initialize() {
        GravityMovementFeature feature = new WallGravity(this.getRobot(), this);
        feature = new EnemyGravity(this.getRobot(), this);
        feature = new StrafeGravity(this.getRobot(), this);
        feature = new RepellantCorner(this.getRobot(), this);
    }

    public void cleanUp() {
    }

    public void doMovement(Enemy enemy) {
        this.updateGravityPoints();
        MovementStrategy.goTo(this.getRobot(), this.getTargetCoordinate(), 8.0);
    }

    protected void updateGravityPoints() {
        int i = 0;
        while (i < this.features.size()) {
            ((GravityMovementFeature)this.features.get(i)).updateGravityPoints(this.getRobot());
            ++i;
        }
    }

    protected Coordinate getTargetCoordinate() {
        double xForce = 0.0;
        double yForce = 0.0;
        Coordinate coordinate = this.getRobot().getCoordinate();
        Enumeration enumeration = this.gravityPoints.elements();
        while (enumeration.hasMoreElements()) {
            GravityPoint gravityPoint = (GravityPoint)enumeration.nextElement();
            xForce += gravityPoint.getXForce(coordinate);
            yForce += gravityPoint.getYForce(coordinate);
        }
        Coordinate targetCoordinate = new Coordinate(this.getRobot().getX() + xForce, this.getRobot().getY() + yForce);
        return targetCoordinate;
    }

    public double getForce(Coordinate coordinate) {
        double xForce = 0.0;
        double yForce = 0.0;
        Enumeration enumeration = this.gravityPoints.elements();
        while (enumeration.hasMoreElements()) {
            GravityPoint gravityPoint = (GravityPoint)enumeration.nextElement();
            xForce += gravityPoint.getXForce(coordinate);
            yForce += gravityPoint.getYForce(coordinate);
        }
        return xForce + yForce;
    }

    public void addFeature(GravityMovementFeature feature) {
        this.features.add(feature);
    }

    public void removeFeature(GravityMovementFeature feature) {
        this.features.remove(feature);
    }

    public boolean containsGravityPoint(Object key) {
        return this.gravityPoints.containsKey(key);
    }

    public GravityPoint getGravityPoint(Object key) {
        return (GravityPoint)this.gravityPoints.get(key);
    }

    public void putGravityPoint(Object key, GravityPoint gravPoint) {
        this.gravityPoints.put(key, gravPoint);
    }

    public void removeGravityPoint(Object key) {
        this.gravityPoints.remove(key);
    }
}

