/*
 * Decompiled with CFR 0.152.
 */
package syl.movement.gravity;

import syl.core.BaseRobot;
import syl.movement.GravityMovementStrategy;
import syl.movement.gravity.GravityMovementFeature;
import syl.movement.gravity.GravityPoint;
import syl.util.Coordinate;

public class WallGravity
extends GravityMovementFeature {
    private GravityMovementStrategy strategy;
    public static final String NORTHERN_POINT = "northernPoint";
    public static final String EASTERN_POINT = "easternPoint";
    public static final String SOUTHERN_POINT = "southernPoint";
    public static final String WESTERN_POINT = "westernPoint";
    private double WALL_POWER = -4000.0;
    private double WALL_RANGE = 2.5;

    public WallGravity(BaseRobot robot, GravityMovementStrategy strategy) {
        this.strategy = strategy;
        strategy.addFeature(this);
        this.initializeGravityPoints(robot, strategy);
    }

    private void initializeGravityPoints(BaseRobot robot, GravityMovementStrategy strategy) {
        GravityPoint northernWallPoint = new GravityPoint(new Coordinate(robot.getX(), robot.getBattleFieldHeight()), this.WALL_POWER, this.WALL_RANGE);
        GravityPoint easternWallPoint = new GravityPoint(new Coordinate(robot.getBattleFieldWidth(), robot.getY()), this.WALL_POWER, this.WALL_RANGE);
        GravityPoint southernWallPoint = new GravityPoint(new Coordinate(robot.getX(), 0.0), this.WALL_POWER, this.WALL_RANGE);
        GravityPoint westernWallPoint = new GravityPoint(new Coordinate(0.0, robot.getY()), this.WALL_POWER, this.WALL_RANGE);
        strategy.putGravityPoint(NORTHERN_POINT, northernWallPoint);
        strategy.putGravityPoint(EASTERN_POINT, easternWallPoint);
        strategy.putGravityPoint(SOUTHERN_POINT, southernWallPoint);
        strategy.putGravityPoint(WESTERN_POINT, westernWallPoint);
    }

    public void updateGravityPoints(BaseRobot robot) {
        this.strategy.getGravityPoint(NORTHERN_POINT).setX(robot.getX());
        this.strategy.getGravityPoint(EASTERN_POINT).setY(robot.getY());
        this.strategy.getGravityPoint(SOUTHERN_POINT).setX(robot.getX());
        this.strategy.getGravityPoint(WESTERN_POINT).setY(robot.getY());
    }
}

