/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import xander.core.gun.Aim;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.gun.GunSelector;
import xander.core.gun.VirtualHitRatioGunSelector;
import xander.core.track.Snapshot;

public class GunArray
implements Gun {
    private Gun[] guns;
    private int activeGunIndex;
    private boolean fireVirtualBullets = true;
    private GunSelector gunSelector;

    public GunArray(GunSelector gunSelector, Gun ... guns) {
        this.gunSelector = gunSelector;
        this.guns = guns;
    }

    public GunArray(Gun ... guns) {
        this(new VirtualHitRatioGunSelector(), guns);
    }

    public GunArray(Gun[] guns, double[] gunBiases) {
        this.gunSelector = new VirtualHitRatioGunSelector();
        this.guns = guns;
        int i = 0;
        while (i < guns.length) {
            ((VirtualHitRatioGunSelector)this.gunSelector).addBias(guns[i], gunBiases[i]);
            ++i;
        }
    }

    public boolean isFireVirtualBullets() {
        return this.fireVirtualBullets;
    }

    public void setFireVirtualBullets(boolean fireVirtualBullets) {
        this.fireVirtualBullets = fireVirtualBullets;
    }

    @Override
    public String getName() {
        return this.guns[this.activeGunIndex].getName();
    }

    @Override
    public void onRoundBegin() {
        Gun[] gunArray = this.guns;
        int n = this.guns.length;
        int n2 = 0;
        while (n2 < n) {
            Gun gun = gunArray[n2];
            gun.onRoundBegin();
            ++n2;
        }
    }

    @Override
    public boolean fireAt(Snapshot target, Snapshot myself, GunController gunController) {
        this.activeGunIndex = this.gunSelector.selectGun(this.guns, target);
        boolean bulletFired = this.guns[this.activeGunIndex].fireAt(target, myself, gunController);
        if (bulletFired && this.fireVirtualBullets) {
            int i = 0;
            while (i < this.guns.length) {
                Aim aim;
                if (i != this.activeGunIndex && this.guns[i].canFireAt(target) && (aim = this.guns[i].getAim(target, myself)) != null) {
                    gunController.setFireVirtualBullet(this.guns[i], aim.getHeading(), aim.getFirePower(), myself, target);
                }
                ++i;
            }
        }
        return bulletFired;
    }

    @Override
    public Aim getAim(Snapshot target, Snapshot myself) {
        return this.guns[this.activeGunIndex].getAim(target, myself);
    }

    @Override
    public boolean canFireAt(Snapshot target) {
        return this.guns[this.activeGunIndex].canFireAt(target);
    }
}

