/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.segment;

import java.awt.geom.Rectangle2D;
import xander.core.Resources;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.gfws.segment.AbstractSegmenter;

public class WallStickSegmenter
extends AbstractSegmenter {
    private boolean forwardDirection;
    private Rectangle2D.Double battleFieldSize;

    public WallStickSegmenter(int numSegments, double minDistanceToWall, double maxDistanceToWall, boolean forwardDirection) {
        super(numSegments, minDistanceToWall, maxDistanceToWall);
        this.forwardDirection = forwardDirection;
        this.battleFieldSize = Resources.getRobotProxy().getBattleFieldSize();
    }

    @Override
    public String getName() {
        return "Wall Stick Segmenter";
    }

    @Override
    public double getSegmentValue(Wave wave) {
        Snapshot snapshot = wave.getInitialDefenderSnapshot();
        double heading = snapshot.getHeadingRoboDegrees();
        if (snapshot.getVelocity() < 0.0) {
            heading = RCMath.normalizeDegrees(heading + 180.0);
        }
        double stickHeading = this.forwardDirection ? heading : RCMath.normalizeDegrees(heading + 180.0);
        double distanceToWall = RCMath.getDistanceToIntersect(snapshot.getX(), snapshot.getY(), stickHeading, this.battleFieldSize);
        return distanceToWall;
    }

    @Override
    protected String getDescriptionForRange(int segmentIndex, double rangeStart, double rangeStop) {
        String rangeStartDesc = segmentIndex == 0 ? "0" : Logger.format(rangeStart);
        String rangeStopDesc = segmentIndex == this.getNumSegments() - 1 ? String.valueOf(Logger.format(rangeStop)) + " or greater" : Logger.format(rangeStop);
        return "Distance to wall " + rangeStartDesc + " to " + rangeStopDesc;
    }
}

