/*
 * Decompiled with CFR 0.152.
 */
package pulsar.targeting;

import java.awt.geom.Point2D;
import pulsar.PulsarMax;
import pulsar.gf.GFUtil;
import pulsar.gf.Segmentation;
import pulsar.targeting.Targeting;
import pulsar.util.DynMultiDimArray;
import pulsar.util.RobotData;
import pulsar.util.Util;

public class GuessFactorTargeting
extends Targeting {
    private Segmentation[] segmentation;
    private int[] segmentationSizes;
    private int complexity;
    public static final String NAME = "Guess Factor";
    private String instanceName = null;
    private String[] segmentationNames = new String[0];

    protected GuessFactorTargeting() {
    }

    public GuessFactorTargeting(Segmentation[] segmentation) {
        this.segmentation = segmentation;
        this.segmentationSizes = new int[segmentation.length];
        this.segmentationNames = new String[segmentation.length];
        int i = 0;
        while (i < this.segmentationNames.length) {
            this.segmentationNames[i] = segmentation[i].getName();
            this.segmentationSizes[i] = segmentation[i].getNoSegments();
            ++i;
        }
        int mul = 1;
        int j = 0;
        while (j < this.segmentationSizes.length - 1) {
            mul *= this.segmentationSizes[j];
            ++j;
        }
        this.complexity = mul;
        this.instanceName = NAME + DynMultiDimArray.arrayToString(this.segmentationNames);
    }

    public Segmentation[] getSegmentation() {
        return this.segmentation;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public String getName() {
        return this.instanceName;
    }

    public int[] getSegmentationSizes() {
        return this.segmentationSizes;
    }

    public String[] getSegmentationNames() {
        return this.segmentationNames;
    }

    public double[] target(double firePower, RobotData target) {
        int bestIndex = this.getBestIndex(firePower, target);
        double guessfactor = GFUtil.getGuessFactor(bestIndex, 27);
        double angleOffset = target.getDirectionRelativeTo(PulsarMax.robotStats, 0) * guessfactor * Util.maxEscapeAngle(firePower);
        Point2D.Double origin = Util.linearPredict(PulsarMax.robotStats.getValue(PulsarMax.robotStats.x), PulsarMax.robotStats.getValue(PulsarMax.robotStats.y), PulsarMax.robotStats.getValue(PulsarMax.robotStats.heading), PulsarMax.robotStats.getValue(PulsarMax.robotStats.velocity), 1);
        Point2D.Double enemyLoc = Util.linearPredict(target.getValue(target.x), target.getValue(target.y), target.getValue(target.heading), target.getValue(target.velocity), 1);
        double absBearingAhead = Util.absbearing(origin, enemyLoc);
        origin = Util.linearPredict(PulsarMax.robotStats.getValue(PulsarMax.robotStats.x), PulsarMax.robotStats.getValue(PulsarMax.robotStats.y), PulsarMax.robotStats.getValue(PulsarMax.robotStats.heading), PulsarMax.robotStats.getValue(PulsarMax.robotStats.velocity), 2);
        enemyLoc = Util.linearPredict(target.getValue(target.x), target.getValue(target.y), target.getValue(target.heading), target.getValue(target.velocity), 2);
        double absBearingAhead2 = Util.absbearing(origin, enemyLoc);
        double[] angles = new double[]{Util.normalizeRelativeAngle(PulsarMax.robotStats.getAbsBearingTo(target, 0) + angleOffset), Util.normalizeRelativeAngle(absBearingAhead + angleOffset), Util.normalizeRelativeAngle(absBearingAhead2 + angleOffset)};
        return angles;
    }
}

