/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Profiling;

import java.util.HashMap;

class ProfileTreeNode {
    String Name;
    long MinTimeInFunction = Long.MAX_VALUE;
    long MaxTimeInFunction = Long.MIN_VALUE;
    long TotalTimeInFunction;
    long Visits;
    HashMap<String, ProfileTreeNode> Children = new HashMap();
    private ProfileTreeNode _parent;
    private long _scopeStartTimestamp;

    ProfileTreeNode(String name) {
        this.Name = name;
        this._parent = null;
    }

    ProfileTreeNode(String name, ProfileTreeNode parent) {
        this.Name = name;
        this._parent = parent;
    }

    ProfileTreeNode StartSubScope(String name) {
        ProfileTreeNode child = this.Children.get(name);
        if (child == null) {
            child = new ProfileTreeNode(name, this);
            this.Children.put(name, child);
        }
        child.EnterScope();
        return child;
    }

    ProfileTreeNode EndScope() {
        this.LeaveScope();
        return this._parent;
    }

    private void EnterScope() {
        this._scopeStartTimestamp = System.nanoTime();
    }

    private void LeaveScope() {
        long timeInFunction = System.nanoTime() - this._scopeStartTimestamp;
        this.TotalTimeInFunction += timeInFunction;
        this.MaxTimeInFunction = Math.max(this.MaxTimeInFunction, timeInFunction);
        this.MinTimeInFunction = Math.min(this.MinTimeInFunction, timeInFunction);
        ++this.Visits;
    }
}

