/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Waves;

import java.util.ArrayList;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Targeting.ITargeting;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Waves.IWaveEventHandler;
import rdt.AgentSmith.Waves.WaveData;
import rdt.AgentSmith.Waves.WaveDebug;
import rdt.AgentSmith.Waves.WaveManagerBase;

public class FriendlyWaveManager
extends WaveManagerBase {
    private final ITargeting _targeting;

    public FriendlyWaveManager(IRobot robot, ITargeting targeting) {
        super(robot, 100);
        this._targeting = targeting;
        new WaveDebug(robot, this);
    }

    @Override
    public void Update() {
        ArrayList<WaveData> activeWaves = this.GetActiveWaves();
        int numActiveWaves = activeWaves.size();
        for (int index = 0; index < numActiveWaves; ++index) {
            WaveData activeWave = activeWaves.get(index);
            this.CheckAndRegisterWavePassingTargets(activeWave);
        }
        super.Update();
    }

    private void CheckAndRegisterWavePassingTargets(WaveData waveData) {
        long currentTick = this._robot.getTime();
        double distanceFromOrigin = waveData.GetDistanceForTick(currentTick);
        double distanceFromOriginSq = distanceFromOrigin * distanceFromOrigin;
        ArrayList<Target> targets = this._targeting.GetTargets();
        int numTargets = targets.size();
        for (int targetIndex = 0; targetIndex < numTargets; ++targetIndex) {
            double dY;
            double dX;
            double distanceFromWaveOriginToTargetSq;
            RobotSnapshot snapshot;
            Target target = targets.get(targetIndex);
            if (!target.Valid || waveData.HasPassedTarget(target) || (snapshot = target.RobotHistory.GetSnapshotForTick(currentTick)) == null || !(distanceFromOriginSq > (distanceFromWaveOriginToTargetSq = (dX = waveData.OriginX - snapshot.LocationX) * dX + (dY = waveData.OriginY - snapshot.LocationY) * dY))) continue;
            waveData.RegisterPassedTarget(target);
            for (int listenerIndex = 0; listenerIndex < this._eventHandlers.size(); ++listenerIndex) {
                ((IWaveEventHandler)this._eventHandlers.get(listenerIndex)).OnWavePassed(waveData, target);
            }
        }
    }
}

