/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.FireSnapshot;
import mue.Gun;
import mue.Position;
import mue.RobotData;
import mue.Util;
import robocode.AdvancedRobot;

abstract class GunBase
implements Gun {
    protected static final double[] STOP_DISTANCE = new double[]{0.0, 0.0, 0.0, 1.0, 2.0, 4.0, 6.0, 9.0, 12.0, 16.0};
    private AdvancedRobot robot;
    private String name;

    public GunBase(AdvancedRobot advancedRobot, String string) {
        this.robot = advancedRobot;
        this.name = string;
    }

    public double getFireAngle(RobotData robotData, double d) {
        if (robotData == null || robotData.isEmpty()) {
            Util.addWarning("No target data available for: " + robotData == null ? "null" : robotData.getName());
        }
        Position position = this.getNextPosition(this.robot);
        return this.getFireAngle(position, robotData, d, this.robot.getTime());
    }

    public void onScan(RobotData robotData) {
    }

    public void onScanWave(String string, FireSnapshot fireSnapshot, double d, double d2, boolean bl) {
    }

    public final String getName() {
        return this.name;
    }

    protected abstract double getFireAngle(Position var1, RobotData var2, double var3, long var5);

    protected final Position getNextPosition(AdvancedRobot advancedRobot) {
        double d;
        double d2 = advancedRobot.getTurnRemaining();
        if (d2 > 10.0 - (d = 0.75 * Math.abs(advancedRobot.getVelocity()))) {
            d2 = 10.0 - d;
        }
        if (d2 < -10.0 + d) {
            d2 = -10.0 + d;
        }
        d2 += advancedRobot.getHeading();
        int n = (int)Math.round(advancedRobot.getVelocity());
        int n2 = (int)Math.round(advancedRobot.getDistanceRemaining());
        if (n < 0) {
            d2 += 180.0;
            n2 = -n2;
            n = -n;
        }
        if (n > 1 && (double)(n2 - (n - 1)) < STOP_DISTANCE[n - 1]) {
            n -= 2;
        } else if (n > 0 && (double)(n2 - n) < STOP_DISTANCE[n]) {
            --n;
        } else if (n < 8 && (double)(n2 - (n + 1)) >= STOP_DISTANCE[n + 1]) {
            ++n;
        }
        double d3 = advancedRobot.getX() + Math.sin(Math.toRadians(d2)) * (double)n;
        double d4 = advancedRobot.getY() + Math.cos(Math.toRadians(d2)) * (double)n;
        return new Position(d3, d4);
    }

    protected final boolean isInsideField(double d, double d2) {
        return d >= 18.0 && d <= this.robot.getBattleFieldWidth() - 18.0 && d2 >= 18.0 && d2 <= this.robot.getBattleFieldHeight() - 18.0;
    }

    protected final double getBattleFieldWidth() {
        return this.robot.getBattleFieldWidth();
    }

    protected final double getBattleFieldHeight() {
        return this.robot.getBattleFieldHeight();
    }
}

