/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import mue.BulletData;
import mue.EnemyWaveListener;
import mue.Knowledge;
import mue.MovementBase;
import mue.Position;
import mue.RealHitStatistic;
import mue.RobotData;
import mue.Util;
import robocode.AdvancedRobot;
import robocode.Bullet;

class WaveSurfingMovement
extends MovementBase
implements EnemyWaveListener {
    private static final int GUESS_BUCKETS = 23;
    protected static final int[] LOW_VELOCITY_BUCKETS = new int[]{2, 4, 6};
    protected static final int[] VELOCITY_BUCKETS = new int[]{1, 3, 5, 7};
    protected static final double[] DISTANCE_BUCKETS = new double[]{250.0, 600.0};
    protected static final double[] WALL_BUCKETS = new double[]{0.35};
    protected static final double[] REVERSE_WALL_BUCKETS = new double[0];
    protected static final double[] STOP_DISTANCE = new double[]{0.0, 0.0, 0.0, 1.0, 2.0, 4.0, 6.0, 9.0, 12.0, 16.0};
    private static final int METHOD_BESTGUESSFACTOR = 0;
    private static final int METHOD_DIRECTIONDANGER = 1;
    private static final int DIRECTION_CLOCKWISE = 1;
    private static final int DIRECTION_COUNTERCLOCKWISE = 2;
    private static final int DISTCONTROL_KEEPING = 0;
    private static final int DISTCONTROL_CLOSINGIN = 1;
    private static final int DISTCONTROL_BACKINGAWAY = 2;
    private static final long ACTIVITY_THRESHOLD = 5L;
    protected static final int HITS_TO_LIVE_WITH = 5;
    private static ConfigurationHandler configurationHandler = new ConfigurationHandler();
    private static int hitsToLiveWith = 5;
    private String opponent = null;
    private double minDistance = 0.0;
    private double maxDistance = this.getBattleFieldWidth() + this.getBattleFieldHeight();
    private int direction = 1;
    private BulletData incomingBullet = null;
    private BulletData fictiveBullet = null;
    private double bulletAngle;
    private Position center = null;
    private int distanceControl = 0;
    private long lastActivityTime = 0L;
    private long consecutiveActivityTicks = 0L;
    private static float[][] lowSegmentedGuessFactors;
    private static float[][][][][][] guessFactors;
    private static int[][][][][] guessFactorCount;

    public WaveSurfingMovement(AdvancedRobot advancedRobot, Knowledge knowledge) {
        super(advancedRobot, knowledge);
        if (guessFactors == null) {
            lowSegmentedGuessFactors = new float[LOW_VELOCITY_BUCKETS.length + 1][47];
            guessFactors = new float[VELOCITY_BUCKETS.length + 1][3][DISTANCE_BUCKETS.length + 1][WALL_BUCKETS.length + 1][REVERSE_WALL_BUCKETS.length + 1][47];
            guessFactorCount = new int[VELOCITY_BUCKETS.length + 1][3][DISTANCE_BUCKETS.length + 1][WALL_BUCKETS.length + 1][REVERSE_WALL_BUCKETS.length + 1];
            for (int i = 0; i <= LOW_VELOCITY_BUCKETS.length; ++i) {
                this.applyGuessFactor(0.0, lowSegmentedGuessFactors[i], configurationHandler.getRollingFactor());
            }
        }
    }

    public void setOpponent(String string) {
        this.opponent = string;
    }

    public void setMinDistance(double d) {
        this.minDistance = d;
    }

    public void setMaxDistance(double d) {
        this.maxDistance = d;
    }

    public void reset() {
        this.incomingBullet = null;
    }

    private int getWallIndex(double d, double d2, int n, double d3, double d4, double d5, double d6, double[] dArray) {
        double d7;
        double d8;
        int n2;
        double d9 = Util.directionRadians(d4, d5, d, d2);
        double d10 = Util.distance(d4, d5, d, d2);
        double d11 = Math.asin(8.0 / (20.0 - 3.0 * d6));
        if (Util.relativeAngle(Math.toDegrees(d9) + 90.0, d3) > 90.0) {
            d11 *= -1.0;
        }
        if (n < 0) {
            d11 *= -1.0;
        }
        for (n2 = 0; n2 < dArray.length && this.isInsideField(d8 = d4 + Math.sin(d9 + d11 * dArray[n2]) * d10, d7 = d5 + Math.cos(d9 + d11 * dArray[n2]) * d10); ++n2) {
        }
        return n2;
    }

    public boolean adapt(Bullet bullet, long l, boolean bl) {
        BulletData bulletData = this.getKnowledge().getBullet(bullet, l);
        if (bulletData == null) {
            return false;
        }
        if (this.incomingBullet == bulletData) {
            this.incomingBullet = null;
        }
        double d = bulletData.getGuessFactor(bullet.getHeading());
        int n = Util.findSegmentationIndex(LOW_VELOCITY_BUCKETS, Math.abs(bulletData.getRobotVelocity()));
        int n2 = Util.findSegmentationIndex(VELOCITY_BUCKETS, Math.abs(bulletData.getRobotVelocity()));
        int n3 = Util.findSegmentationIndex(DISTANCE_BUCKETS, bulletData.getDistance());
        int n4 = this.getWallIndex(bulletData.getRobotX(), bulletData.getRobotY(), bulletData.getRobotVelocity(), bulletData.getRobotHeading(), bulletData.getOriginX(), bulletData.getOriginY(), bulletData.getPower(), WALL_BUCKETS);
        int n5 = this.getWallIndex(bulletData.getRobotX(), bulletData.getRobotY(), bulletData.getRobotVelocity(), bulletData.getRobotHeading(), bulletData.getOriginX(), bulletData.getOriginY(), bulletData.getPower(), REVERSE_WALL_BUCKETS);
        int[] nArray = guessFactorCount[n2][bulletData.getRobotAcceleration() + 1][n3][n4];
        int n6 = n5;
        nArray[n6] = nArray[n6] + 1;
        this.applyGuessFactor(d, guessFactors[n2][bulletData.getRobotAcceleration() + 1][n3][n4][n5], configurationHandler.getRollingFactor());
        this.applyGuessFactor(d, lowSegmentedGuessFactors[n], configurationHandler.getRollingFactor());
        if (n4 < WALL_BUCKETS.length) {
            this.applyGuessFactor(d, guessFactors[n2][bulletData.getRobotAcceleration() + 1][n3][n4 + 1][n5], configurationHandler.getReducedRollingFactor());
        }
        if (n2 > 0 && Math.abs(bulletData.getRobotVelocity()) - VELOCITY_BUCKETS[n2 - 1] <= 1) {
            this.applyGuessFactor(d, guessFactors[n2 - 1][bulletData.getRobotAcceleration() + 1][n3][n4][n5], configurationHandler.getReducedRollingFactor());
        }
        if (n2 < VELOCITY_BUCKETS.length && VELOCITY_BUCKETS[n2] - Math.abs(bulletData.getRobotVelocity()) < 1) {
            this.applyGuessFactor(d, guessFactors[n2 + 1][bulletData.getRobotAcceleration() + 1][n3][n4][n5], configurationHandler.getReducedRollingFactor());
        }
        if (bl) {
            if (hitsToLiveWith > 0) {
                --hitsToLiveWith;
            } else if (this.consecutiveActivityTicks >= 5L && l - this.lastActivityTime < 3L) {
                configurationHandler.addHit((int)Math.round(bulletData.getDistance()), bulletData.getPower(), l - bulletData.getTime());
            }
        }
        return true;
    }

    public boolean move() {
        int n;
        double d;
        double d2;
        if (this.opponent == null) {
            return false;
        }
        RobotData robotData = this.getKnowledge().getRobotData(this.opponent);
        if (robotData == null) {
            return false;
        }
        BulletData bulletData = this.getKnowledge().nearestBullet();
        if (bulletData == null) {
            this.incomingBullet = null;
            if (this.fictiveBullet != null && this.fictiveBullet.getSpeed() * (double)(this.getTime() - this.fictiveBullet.getTime()) > this.distanceTo(this.fictiveBullet.getOriginX(), this.fictiveBullet.getOriginY())) {
                this.fictiveBullet = null;
            }
            if (this.fictiveBullet == null) {
                this.fictiveBullet = new BulletData(robotData.getName(), robotData.getX(), robotData.getY(), robotData.getAverageFirePower(), false, this.getKnowledge().getOldX(), this.getKnowledge().getOldY(), this.getKnowledge().getOldHeading(), this.getKnowledge().getOldVelocity(), this.getKnowledge().getOldAcceleration(), this.getTime() - 1L);
                this.center = null;
            }
            if (this.center == null) {
                this.center = new Position(this.fictiveBullet.getOriginX(), this.fictiveBullet.getOriginY());
                d2 = this.reachableGuessFactor(this.fictiveBullet, 2);
                d = this.reachableGuessFactor(this.fictiveBullet, 1);
                n = this.getWallIndex(this.fictiveBullet.getRobotX(), this.fictiveBullet.getRobotY(), this.fictiveBullet.getRobotVelocity(), this.fictiveBullet.getRobotHeading(), this.fictiveBullet.getOriginX(), this.fictiveBullet.getOriginY(), this.fictiveBullet.getPower(), WALL_BUCKETS);
                int n2 = this.getWallIndex(this.fictiveBullet.getRobotX(), this.fictiveBullet.getRobotY(), this.fictiveBullet.getRobotVelocity(), this.fictiveBullet.getRobotHeading(), this.fictiveBullet.getOriginX(), this.fictiveBullet.getOriginY(), this.fictiveBullet.getPower(), REVERSE_WALL_BUCKETS);
                this.bulletAngle = this.getWorstGuessFactor(this.fictiveBullet.getRobotVelocity(), this.fictiveBullet.getRobotAcceleration(), this.fictiveBullet.getDistance(), n, n2, d2, d);
                this.bulletAngle = this.fictiveBullet.getHeading(this.bulletAngle) + 180.0;
            }
        } else if (configurationHandler.getSurfMethod() == 0) {
            if (this.incomingBullet != bulletData || this.center == null) {
                this.incomingBullet = bulletData;
                this.center = new Position(bulletData.getOriginX(), bulletData.getOriginY());
                d2 = this.reachableGuessFactor(this.incomingBullet, 2);
                d = this.reachableGuessFactor(this.incomingBullet, 1);
                n = this.getWallIndex(this.incomingBullet.getRobotX(), this.incomingBullet.getRobotY(), this.incomingBullet.getRobotVelocity(), this.incomingBullet.getRobotHeading(), this.incomingBullet.getOriginX(), this.incomingBullet.getOriginY(), this.incomingBullet.getPower(), WALL_BUCKETS);
                int n3 = this.getWallIndex(this.incomingBullet.getRobotX(), this.incomingBullet.getRobotY(), this.incomingBullet.getRobotVelocity(), this.incomingBullet.getRobotHeading(), this.incomingBullet.getOriginX(), this.incomingBullet.getOriginY(), this.incomingBullet.getPower(), REVERSE_WALL_BUCKETS);
                this.bulletAngle = this.getBestGuessFactor(this.incomingBullet.getRobotVelocity(), this.incomingBullet.getRobotAcceleration(), this.incomingBullet.getDistance(), n, n3, d2, d);
                this.bulletAngle = this.incomingBullet.getHeading(this.bulletAngle) + 180.0;
            }
        } else {
            this.center = robotData.guessPosition();
            if (this.incomingBullet != bulletData) {
                this.incomingBullet = bulletData;
            }
            if ((d2 = this.evaluateDanger(this.center.getX(), this.center.getY(), 1)) < 0.96 * (d = this.evaluateDanger(this.center.getX(), this.center.getY(), 2))) {
                this.direction = 1;
            } else if (d < 0.96 * d2) {
                this.direction = 2;
            }
        }
        d2 = this.getVelocity() < 0.0 ? this.getHeading() - 180.0 : this.getHeading();
        d = 0.0;
        if (this.incomingBullet == null) {
            if (robotData.getDistance() < 160.0) {
                this.center = robotData.guessPosition();
                this.fictiveBullet = null;
                d = this.direction == 1 ? 90.0 : -90.0;
            } else {
                d = Util.direction(this.getX(), this.getY(), this.center.getX(), this.center.getY());
                this.direction = (d = Util.relativeAngle(d, this.bulletAngle)) >= 0.0 ? 1 : 2;
            }
        } else if (configurationHandler.getSurfMethod() == 0) {
            d = Util.direction(this.getX(), this.getY(), this.center.getX(), this.center.getY());
            this.direction = (d = Util.relativeAngle(d, this.bulletAngle)) >= 0.0 ? 1 : 2;
        } else {
            d = this.direction == 1 ? 90.0 : -90.0;
        }
        d2 = this.nextHeading(this.getX(), this.getY(), d2, Math.abs(this.getVelocity()), this.center.getX(), this.center.getY(), d);
        double d3 = this.nextDistance(this.getX(), this.getY(), d2, this.center.getX(), this.center.getY(), d);
        double d4 = Util.relativeAngle(this.getHeading(), d2);
        double d5 = Util.relativeAngle(this.getHeading(), d2 + 180.0);
        if (Math.abs(d4) <= Math.abs(d5)) {
            this.setTurn(d2);
            this.setAhead(d3);
        } else {
            this.setTurn(d2 + 180.0);
            this.setBack(d3);
        }
        long l = this.getTime();
        if (this.lastActivityTime == l - 1L) {
            ++this.consecutiveActivityTicks;
        } else if (this.lastActivityTime < l - 2L) {
            this.consecutiveActivityTicks = 1L;
        }
        this.lastActivityTime = l;
        return true;
    }

    private final void applyGuessFactor(double d, float[] fArray, float f) {
        int n = Util.confine((int)Math.round(d * 23.0 + 23.0), 0, 46);
        for (int i = 0; i <= 46; ++i) {
            int n2 = i;
            fArray[n2] = fArray[n2] * (1.0f - f);
            int n3 = i;
            fArray[n3] = fArray[n3] + f / (float)(0.1 * (double)(n - i) * (double)(n - i) + 1.0);
        }
    }

    private final double getWorstGuessFactor(int n, int n2, double d, int n3, int n4, double d2, double d3) {
        int n5;
        int n6;
        int n7 = Util.confine((int)Math.round(23.0 * d2 + 23.0), 0, 46);
        if (n7 > (n6 = Util.confine((int)Math.round(23.0 * d3 + 23.0), 0, 46))) {
            n5 = n7;
            n7 = n6;
            n6 = n5;
        }
        n5 = Util.findSegmentationIndex(LOW_VELOCITY_BUCKETS, Math.abs(n));
        int n8 = Util.findSegmentationIndex(VELOCITY_BUCKETS, Math.abs(n));
        int n9 = Util.findSegmentationIndex(DISTANCE_BUCKETS, d);
        int n10 = n6;
        double d4 = this.getGuessFactor(n5, n8, n2 + 1, n9, n3, n4, n10);
        for (int i = n6 - 1; i >= n7; --i) {
            double d5 = this.getGuessFactor(n5, n8, n2 + 1, n9, n3, n4, i);
            if (!(d5 > d4)) continue;
            n10 = i;
            d4 = d5;
        }
        return (double)(n10 - 23) / 23.0;
    }

    private final double getBestGuessFactor(int n, int n2, double d, int n3, int n4, double d2, double d3) {
        int n5;
        int n6;
        int n7 = Util.confine((int)Math.round(23.0 * d2 + 23.0), 0, 46);
        if (n7 > (n6 = Util.confine((int)Math.round(23.0 * d3 + 23.0), 0, 46))) {
            n5 = n7;
            n7 = n6;
            n6 = n5;
        }
        n5 = Util.findSegmentationIndex(LOW_VELOCITY_BUCKETS, Math.abs(n));
        int n8 = Util.findSegmentationIndex(VELOCITY_BUCKETS, Math.abs(n));
        int n9 = Util.findSegmentationIndex(DISTANCE_BUCKETS, d);
        int n10 = n6;
        double d4 = this.getGuessFactor(n5, n8, n2 + 1, n9, n3, n4, n10);
        for (int i = n6 - 1; i >= n7; --i) {
            double d5 = this.getGuessFactor(n5, n8, n2 + 1, n9, n3, n4, i);
            if (!(d5 < d4)) continue;
            n10 = i;
            d4 = d5;
        }
        return (double)(n10 - 23) / 23.0;
    }

    private final double reachableGuessFactor(BulletData bulletData, int n) {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getVelocity() < 0.0 ? this.getHeading() - 180.0 : this.getHeading();
        int n2 = (int)Math.abs(Math.round(this.getVelocity()));
        double d4 = n == 1 ? 90.0 : -90.0;
        int n3 = this.distanceControl;
        for (double d5 = bulletData.getSpeed() * (double)(this.getTime() - bulletData.getTime()) + 20.0; d5 < Util.distance(bulletData.getOriginX(), bulletData.getOriginY(), d, d2); d5 += bulletData.getSpeed()) {
            double d6 = this.nextHeading(d, d2, d3, n2, bulletData.getOriginX(), bulletData.getOriginY(), d4);
            double d7 = this.nextDistance(d, d2, d6, bulletData.getOriginX(), bulletData.getOriginY(), d4);
            if (Math.abs(Util.relativeAngle(d3, d6)) > 90.0) {
                n2 *= -1;
            }
            if (n2 < -1) {
                n2 += 2;
            } else if (n2 < 0) {
                ++n2;
            } else if (n2 > 1 && d7 - (double)(n2 - 1) < STOP_DISTANCE[n2 - 1]) {
                n2 -= 2;
            } else if (n2 > 0 && d7 - (double)n2 < STOP_DISTANCE[n2]) {
                --n2;
            } else if (n2 < 8 && d7 - (double)(n2 + 1) >= STOP_DISTANCE[n2 + 1]) {
                ++n2;
            }
            d3 = d6;
            d += Math.sin(Math.toRadians(d3)) * (double)n2;
            d2 += Math.cos(Math.toRadians(d3)) * (double)n2;
        }
        this.distanceControl = n3;
        return bulletData.getGuessFactor(d, d2);
    }

    private final double evaluateDanger(double d, double d2, int n) {
        List list = this.getKnowledge().activeBullets();
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getVelocity() < 0.0 ? this.getHeading() - 180.0 : this.getHeading();
        int n2 = (int)Math.abs(Math.round(this.getVelocity()));
        double d6 = n == 1 ? 90.0 : -90.0;
        long l = this.getTime();
        long l2 = 0L;
        double d7 = 0.0;
        int n3 = this.distanceControl;
        BulletData bulletData = this.incomingBullet;
        while (bulletData != null) {
            double d8 = bulletData.getSpeed() * (double)(l - bulletData.getTime());
            double d9 = 0.0;
            if (l2 == 0L && !configurationHandler.isAdvancedMode() && d8 >= Util.distance(bulletData.getOriginX(), bulletData.getOriginY(), d3, d4) - 20.0) {
                d9 = 20.0;
            }
            while (d8 < Util.distance(bulletData.getOriginX(), bulletData.getOriginY(), d3, d4) + d9) {
                double d10 = this.nextHeading(d3, d4, d5, n2, d, d2, d6);
                double d11 = this.nextDistance(d3, d4, d10, d, d2, d6);
                if (Math.abs(Util.relativeAngle(d5, d10)) > 90.0) {
                    n2 *= -1;
                }
                if (n2 < -1) {
                    n2 += 2;
                } else if (n2 < 0) {
                    ++n2;
                } else if (n2 > 1 && d11 - (double)(n2 - 1) < STOP_DISTANCE[n2 - 1]) {
                    n2 -= 2;
                } else if (n2 > 0 && d11 - (double)n2 < STOP_DISTANCE[n2]) {
                    --n2;
                } else if (n2 < 8 && d11 - (double)(n2 + 1) >= STOP_DISTANCE[n2 + 1]) {
                    ++n2;
                }
                d5 = d10;
                d3 += Math.sin(Math.toRadians(d5)) * (double)n2;
                d4 += Math.cos(Math.toRadians(d5)) * (double)n2;
                d8 += bulletData.getSpeed();
                ++l;
            }
            if (l2 == 0L) {
                l2 = l;
            }
            int n4 = Util.findSegmentationIndex(LOW_VELOCITY_BUCKETS, Math.abs(bulletData.getRobotVelocity()));
            int n5 = Util.findSegmentationIndex(VELOCITY_BUCKETS, Math.abs(bulletData.getRobotVelocity()));
            int n6 = Util.findSegmentationIndex(DISTANCE_BUCKETS, bulletData.getDistance());
            int n7 = this.getWallIndex(bulletData.getRobotX(), bulletData.getRobotY(), bulletData.getRobotVelocity(), bulletData.getRobotHeading(), bulletData.getOriginX(), bulletData.getOriginY(), bulletData.getPower(), WALL_BUCKETS);
            int n8 = this.getWallIndex(bulletData.getRobotX(), bulletData.getRobotY(), bulletData.getRobotVelocity(), bulletData.getRobotHeading(), bulletData.getOriginX(), bulletData.getOriginY(), bulletData.getPower(), REVERSE_WALL_BUCKETS);
            double d12 = this.getGuessFactor(n4, n5, bulletData.getRobotAcceleration() + 1, n6, n7, n8, (int)(bulletData.getGuessFactor(d3, d4) * 23.0 + 23.0)) * Util.getBulletDamage(bulletData.getPower());
            d12 = l == l2 ? (d12 *= 10.0) : (l - l2 < 9L ? (d12 *= 8.7 - 0.7 * (double)(l - l2)) : (d12 *= 2.5));
            d7 += d12;
            list.remove(bulletData);
            bulletData = this.nearestBullet(list, d3, d4, l);
        }
        this.distanceControl = n3;
        return d7;
    }

    private final BulletData nearestBullet(List list, double d, double d2, long l) {
        BulletData bulletData = null;
        Iterator iterator = list.iterator();
        long l2 = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            long l3;
            BulletData bulletData2 = (BulletData)iterator.next();
            double d3 = Util.distance(d, d2, bulletData2.getOriginX(), bulletData2.getOriginY());
            if (bulletData2.getSpeed() * (double)(l - bulletData2.getTime()) + 20.0 > d3 || (l3 = (long)Math.floor(d3 / bulletData2.getSpeed()) - (l - bulletData2.getTime())) >= l2) continue;
            l2 = l3;
            bulletData = bulletData2;
        }
        return bulletData;
    }

    private double nextHeading(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Util.direction(d, d2, d5, d6);
        double d9 = Util.distance(d, d2, d5, d6);
        double d10 = 90.0;
        double d11 = this.maxDistance - this.minDistance;
        if (this.distanceControl == 1 && d9 > this.maxDistance - 0.2 * d11 || d9 > this.maxDistance) {
            d10 = this.incomingBullet == null ? 70.0 : 80.0;
            this.distanceControl = 1;
        } else if (this.distanceControl == 2 && d9 < this.minDistance + 0.2 * d11 || d9 < this.minDistance) {
            d10 = this.incomingBullet == null ? 110.0 : 100.0;
            this.distanceControl = 2;
        } else {
            this.distanceControl = 0;
        }
        boolean bl = d7 >= 0.0;
        double d12 = bl ? Util.relativeAngle(0.0, d8 - d10) : Util.relativeAngle(0.0, d8 + d10);
        double d13 = d12;
        if (this.xDistanceToWall(d, d12) < 120.0) {
            if (d12 < 0.0) {
                d12 = bl ? 0.0 : 180.0;
                if (Math.abs(Util.relativeAngle(d8, d12)) < 40.0) {
                    d12 = d13;
                }
            } else {
                d12 = bl ? 180.0 : 0.0;
                if (Math.abs(Util.relativeAngle(d8, d12)) < 40.0) {
                    d12 = d13;
                }
            }
        }
        d13 = d12;
        if (this.yDistanceToWall(d2, d12) < 120.0) {
            if (d12 < -90.0 || d12 > 90.0) {
                d12 = bl ? -90.0 : 90.0;
                if (Math.abs(Util.relativeAngle(d8, d12)) < 40.0) {
                    d12 = d13;
                }
            } else {
                d12 = bl ? 90.0 : -90.0;
                if (Math.abs(Util.relativeAngle(d8, d12)) < 40.0) {
                    d12 = d13;
                }
            }
            if (d12 != d13) {
                d13 = d12;
                if (this.xDistanceToWall(d, d12) < 120.0) {
                    if (d12 < 0.0) {
                        if (Math.abs(Util.relativeAngle(d8, d12)) < 40.0) {
                            d12 = d13;
                        }
                    } else {
                        d12 = bl ? 180.0 : 0.0;
                        if (Math.abs(Util.relativeAngle(d8, d12)) < 40.0) {
                            d12 = d13;
                        }
                    }
                }
            }
        }
        double d14 = Util.relativeAngle(d3, d12);
        double d15 = Util.relativeAngle(d3 + 180.0, d12);
        if (Math.abs(d14) <= Math.abs(d15)) {
            if (d14 > 10.0 - 0.75 * d4) {
                d14 = 10.0 - 0.75 * d4;
            }
            if (d14 < -10.0 + 0.75 * d4) {
                d14 = -10.0 + 0.75 * d4;
            }
            return d3 + d14;
        }
        if (d15 > 10.0 - 0.75 * d4) {
            d15 = 10.0 - 0.75 * d4;
        }
        if (d15 < -10.0 + 0.75 * d4) {
            d15 = -10.0 + 0.75 * d4;
        }
        return d3 + 180.0 + d15;
    }

    private double nextDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.min(21.0, Math.min(this.xDistanceToWall(d, d3), this.yDistanceToWall(d2, d3)));
        double d8 = Math.abs(Math.toRadians(d6)) * Util.distance(d, d2, d4, d5);
        return Math.min(d7 - 1.0, d8);
    }

    private final double getGuessFactor(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        double d = 1.0 / (1.0 + 0.5 * (double)guessFactorCount[n2][n3][n4][n5][n6]);
        return (double)lowSegmentedGuessFactors[n][n7] * d + (double)guessFactors[n2][n3][n4][n5][n6][n7] * (1.0 - d);
    }

    public void onEnemyWave(long l, double d, double d2, double d3, double d4, double d5, int n, int n2, double d6, boolean bl) {
        if (bl) {
            int n3 = (int)Math.round(Util.distance(d, d2, d3, d4));
            if ((double)configurationHandler.getMinorRollingFactor() > 0.001) {
                int n4 = Util.findSegmentationIndex(LOW_VELOCITY_BUCKETS, Math.abs(n));
                int n5 = Util.findSegmentationIndex(VELOCITY_BUCKETS, Math.abs(n));
                int n6 = Util.findSegmentationIndex(DISTANCE_BUCKETS, Util.distance(d, d2, d3, d4));
                double d7 = Util.direction(d, d2, d3, d4);
                double d8 = Util.direction(d, d2, this.getX(), this.getY());
                double d9 = Math.toDegrees(Math.asin(8.0 / (20.0 - 3.0 * d6)));
                double d10 = Util.confine(Util.relativeAngle(d7, d8) / d9, -1.0, 1.0);
                if (Math.abs(Util.relativeAngle(d5, d7 + 90.0)) > 90.0) {
                    d10 *= -1.0;
                }
                if (n < 0) {
                    d10 *= -1.0;
                }
                int n7 = this.getWallIndex(d3, d4, n, d5, d, d2, d6, WALL_BUCKETS);
                int n8 = this.getWallIndex(d3, d4, n, d5, d, d2, d6, REVERSE_WALL_BUCKETS);
                this.applyGuessFactor(d10, guessFactors[n5][n2 + 1][n6][n7][n8], configurationHandler.getMinorRollingFactor());
                this.applyGuessFactor(d10, lowSegmentedGuessFactors[n4], configurationHandler.getMinorRollingFactor());
            }
            if (this.consecutiveActivityTicks >= 5L && l - this.lastActivityTime < 3L) {
                configurationHandler.recordWave(n3, d6, this.getTime() - l);
            }
        }
    }

    public String evaluation() {
        StringBuffer stringBuffer = new StringBuffer("wave surfing movement evaluation: \n");
        stringBuffer.append(configurationHandler.evaluation());
        return stringBuffer.toString();
    }

    public List applyResults(List list) {
        return configurationHandler.applyResults(list);
    }

    static {
        guessFactors = null;
        guessFactorCount = null;
    }

    private static class ConfigurationHandler {
        protected static final float METADATA_ROLLING_FACTOR = 0.05f;
        protected static final int ADVANCED_BULLETCOUNT = 200;
        protected static final float ADVANCED_HIT_RATIO = 0.105f;
        protected static final float INITIAL_SWITCH_HIT_RATIO = 0.3f;
        protected static final float SWITCH_HIT_RATIO = 0.27f;
        protected static final int MIN_TRAVELTIME = 8;
        protected static final int[] DISTANCE_BUCKETS = new int[0];
        private int surfMethod = 1;
        private int switchCount = 0;
        private float rollingFactor = 0.25f;
        private float minorRollingFactor = 0.0f;
        private float hitRatio = 0.0f;
        private boolean advancedMode = false;
        private int advancedBullets = 0;
        private RealHitStatistic[] hitStatistics;
        private RealHitStatistic currentHitStatistic;
        private RealHitStatistic overallHitStatistic = new RealHitStatistic(DISTANCE_BUCKETS);

        public ConfigurationHandler() {
            this.hitStatistics = new RealHitStatistic[7];
            for (int i = 0; i < this.hitStatistics.length; ++i) {
                this.hitStatistics[i] = new RealHitStatistic(DISTANCE_BUCKETS);
            }
            this.currentHitStatistic = this.hitStatistics[0];
        }

        public void addHit(int n, double d, long l) {
            this.currentHitStatistic.addHit(n, d);
            if (l >= 8L) {
                this.hitRatio = 0.95f * this.hitRatio + 0.05f;
                this.overallHitStatistic.addHit(n, d);
                if (!this.advancedMode && this.overallHitStatistic.hitRatio() > 0.105f) {
                    this.advancedMode = true;
                    if (this.switchCount == 0) {
                        this.switchConfiguration();
                    }
                }
                if (this.switchCount == 0 && this.hitRatio > 0.3f || this.switchCount > 0 && this.hitRatio > 0.27f) {
                    this.switchConfiguration();
                }
            }
        }

        public void recordWave(int n, double d, long l) {
            this.hitRatio *= 0.96666664f;
            this.currentHitStatistic.addShot(n, d);
            if (this.advancedMode) {
                ++this.advancedBullets;
            }
            if (l >= 8L) {
                this.overallHitStatistic.addShot(n, d);
            }
        }

        public void switchConfiguration() {
            switch (this.switchCount % 6) {
                case 0: {
                    this.minorRollingFactor = this.rollingFactor / 10.0f;
                    this.surfMethod = 0;
                    break;
                }
                case 1: {
                    this.minorRollingFactor = this.rollingFactor / 7.0f;
                    this.surfMethod = 1;
                    break;
                }
                case 2: {
                    this.minorRollingFactor = this.rollingFactor / 7.0f;
                    this.surfMethod = 0;
                    break;
                }
                case 3: {
                    this.minorRollingFactor = this.rollingFactor / 15.0f;
                    this.surfMethod = 1;
                    break;
                }
                case 4: {
                    this.minorRollingFactor = this.rollingFactor / 15.0f;
                    this.surfMethod = 0;
                    break;
                }
                case 5: {
                    this.minorRollingFactor = this.rollingFactor / 10.0f;
                    this.surfMethod = 1;
                }
            }
            this.currentHitStatistic = this.hitStatistics[this.switchCount % 6 + 1];
            ++this.switchCount;
            this.hitRatio = 0.0f;
        }

        public final boolean isAdvancedMode() {
            return this.advancedMode;
        }

        public final int getSurfMethod() {
            return this.surfMethod;
        }

        public final float getRollingFactor() {
            return this.rollingFactor;
        }

        public final float getMinorRollingFactor() {
            return this.minorRollingFactor;
        }

        public final float getReducedRollingFactor() {
            return 0.6f * this.rollingFactor;
        }

        public String evaluation() {
            int n;
            String[] stringArray = new String[]{"dd_0  ", "bgf_10", "dd_7  ", "bgf_7 ", "dd_15 ", "bgf_15", "dd_10 "};
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  switches between surfing methods: ").append(this.switchCount).append("\n");
            int n2 = 0;
            for (n = 0; n < this.hitStatistics.length; ++n) {
                n2 += this.hitStatistics[n].shots();
            }
            if (n2 > 0) {
                for (n = 0; n < this.hitStatistics.length; ++n) {
                    int n3 = Math.round((float)(100 * this.hitStatistics[n].shots()) / (float)n2);
                    stringBuffer.append("  ").append(stringArray[n]).append(": ");
                    stringBuffer.append("[").append(n3).append("% activity] ");
                    stringBuffer.append(this.hitStatistics[n].hitRatio()).append(" (").append(this.hitStatistics[n].hits()).append(" / ").append(this.hitStatistics[n].shots()).append(")\n");
                }
                n = Math.round((float)(100 * this.advancedBullets) / (float)n2);
                stringBuffer.append("  advanced : ").append(n).append("% active: (").append(this.advancedBullets).append(" of ").append(n2).append(" bullets)\n");
            }
            return stringBuffer.toString();
        }

        public List applyResults(List list) {
            int n;
            int n2;
            int[] nArray = new int[this.hitStatistics.length];
            int[] nArray2 = new int[this.hitStatistics.length];
            int n3 = 0;
            int n4 = 0;
            String[] stringArray = new String[]{"dd_0", "bgf_10", "dd_7", "bgf_7", "dd_15", "bgf_15", "dd_10"};
            if (list != null) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    int n5;
                    StringTokenizer stringTokenizer = new StringTokenizer((String)list.get(n2));
                    String string = stringTokenizer.nextToken().trim();
                    if ("advanced".equals(string)) {
                        stringTokenizer.nextToken();
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    for (n5 = 0; n5 < stringArray.length && !string.equals(stringArray[n5]); ++n5) {
                    }
                    if (n5 == stringArray.length) {
                        Util.addWarning("Encountered unknown wave surfing mode " + string);
                        continue;
                    }
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    nArray[n5] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray2[n5] = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
            for (n2 = 0; n2 < this.hitStatistics.length; ++n2) {
                int n6 = n2;
                nArray[n6] = nArray[n6] + this.hitStatistics[n2].hits();
                int n7 = n2;
                nArray2[n7] = nArray2[n7] + this.hitStatistics[n2].shots();
                n4 += nArray2[n2];
            }
            n3 += this.advancedBullets;
            ArrayList<String> arrayList = new ArrayList<String>(this.hitStatistics.length);
            for (n = 0; n < this.hitStatistics.length; ++n) {
                int n8 = (int)Math.round((double)(100 * nArray2[n]) / (double)n4);
                float f = 0.0f;
                if (nArray2[n] > 0) {
                    f = (float)nArray[n] / (float)nArray2[n];
                }
                String string = stringArray[n];
                while (string.length() < 6) {
                    string = string + " ";
                }
                arrayList.add(string + "    " + n8 + "% " + f + " " + nArray[n] + " " + nArray2[n]);
            }
            n = (int)Math.round((double)(100 * n3) / (double)n4);
            arrayList.add("advanced  " + n + "% " + n3 + " " + n4);
            return arrayList;
        }
    }
}

