/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.utils;

import robocode.Rules;

public class BulletPowerUtils {
    public static double getPowerToCauseDamage(double damage) {
        if (damage <= 4.0) {
            return damage / 4.0;
        }
        return 1.0 + (damage - 4.0) / 6.0;
    }

    public static int getNumberOfBulletsNeededToDestroy(double remainingEnergy) {
        return (int)Math.ceil(remainingEnergy / Rules.getBulletDamage((double)3.0));
    }

    public static double getAverageBulletPowerToDestroy(double remainingEnergy) {
        int shots = BulletPowerUtils.getNumberOfBulletsNeededToDestroy(remainingEnergy);
        if (shots > 0) {
            return BulletPowerUtils.getPowerToCauseDamage(remainingEnergy / (double)shots);
        }
        return 0.01;
    }

    public static double getPowerToTravelAtSpeed(double speed) {
        return (20.0 - speed) / 3.0;
    }
}

